#include "lib.h"
/*
 * rand, srand : random number generators for the 80960.
 *
 * Andy Wilson , 1-Nov-89.
 *
 */

static long __seed = 1L;

int rand()
{
  struct {
    unsigned long lo;
    unsigned long hi;} dword;
  unsigned long mult=1566083941, q;

  /* Computes pseudo-random number modulo 2**31-1
   * (which is a prime number and thus has nice properties).
   * First computes 64-bit result of seed*multiplier.
   * Then finds (result mod 2**31-1) by observing that
   * result = q*(2**31-1) + r   (where r is the value we want, and)
   * result = q*2**31 + r - q
   * low order 31 bits of result = r - q
   * r = low order 31 bits + q
   * (see Knuth, Vol. 2, sec. 3.2.1.3)
   */

  asm volatile ("emul	%2,%1,%0" : "=dG" (dword)   : "d" (__seed),
		                                      "d" (mult));
  asm volatile ("chkbit	31,%0"    :                 : "d" (dword.lo));
  asm volatile ("addc	%1,%1,%0" : "=d" (q)        : "d" (dword.hi));
  __seed = (q + dword.lo) & 0x7fffffffL;
  return((int) __seed);
}

void srand(val)
unsigned val;	
{
	__seed = val;
}
