#
# setjmp/longjmp for GNU cc
#
# Assumes we don't have to save g14 (constant 0) and g15 (which
# will be reset when we return) but restores all other
# global registers and local registers r3..r15.
# 
# Andy Wilson, 28-Sep-89.
#
	.text
	.align 4
	.globl _setjmp
	
_setjmp:
	st	pfp,60(g0)	# save my pfp in g15 slot
	st	g1,4(g0)	# save g1
	stl	g2,8(g0)	# g2..g3
	stq	g4,16(g0)	# g4..g7
	stq	g8,32(g0)	# g8..g11
	stl	g12,48(g0)	# g12..g13
	flushreg
	ldconst	0x3f,r3
	andnot	r3,pfp,r3	# r3 = pfp & ~0x3f
	ld	8(r3),r4	# r4 = saved rip
	st	r4,0(g0)	# save rip in "g0" slot
	
	# now save local registers
	ld	12(r3),r4
	st	r4,64+12(g0)
	ldq	16(r3),r4
	stq	r4,64+16(g0)
	ldq	32(r3),r4
	stq	r4,64+32(g0)
	ldq	48(r3),r4
	stq	r4,64+48(r4)

	ldconst	0,g0		# return 0
	ret

# longjmp:
#   g0 - address of saved environment
#   g1 - code to return
	.align	4
	.globl	_longjmp
_longjmp:
	ld	60(g0),pfp	# pfp = saved frame pointer
	ldconst	0x3f,g2
	andnot	g2,pfp,g3	# g3 = pfp & ~0x3f
				# (addr. of frame to which we return)
	flushreg
	ld	0(g0),g2	# g2 = saved rip
	st	g2,8(g3)	# save in frame
	ld	64+12(g0),g2	# pick up saved r3
	st	g2,64+12(g3)	# save in frame
	ldq	64+16(g0),g4	# save r4..r7
	stq	g4,64+16(g3)
	ldq	64+32(g0),g4	# save r8..r11
	stq	g4,64+32(g3)
	ldq	64+48(g0),g4	# save r12..r15
	stq	g4,64+48(g3)
	ldl	48(g0),g12	# now global registers g12..g13
	ldq	32(g0),g8	# g8..g11
	ldq	16(g0),g4	# g4..g7
	ldl	8(g0),g2	# g2..g3
	ld	4(g0),r3
	mov	g1,g0		# set return value
	cmpibne	0,g0,ahead	# (not allowed to be 0 this time)
	mov	1,g0
ahead:
	mov	r3,g1		# restore g1
	ret
