/*			s e t v b u f
 *
 * Set the type of buffering to be used on this stream. This
 * must be called before any read or write has been done on
 * the stream. It is legal to make a stream unbuffered and
 * then at some subsequent time, make it buffered.
 *
 * Input streams cannot be line buffered. Attempts to do so
 * will make them fully buffered instead.
 *
 * Patchlevel 1.0
 *
 * Edit History:
 */

#include "stdiolib.h"

/*LINTLIBRARY*/

int setvbuf(fp, buf, type, size)

FILE *fp;				/* stream */
char *buf;				/* buffer */
int type;				/* type of buffering */
unsigned size;				/* size of buffer */

{
#ifdef __STDC__
  void *malloc(unsigned int);			/* memory allocator */
#else
  void *malloc();			/* memory allocator */
#endif

  if (TESTFLAG(fp, _IONBF))
    fp->_base = NULL;

  if (fp->_base != NULL)
    return EOF;

  CLEARFLAG(fp, (_IOFBF | _IONBF | _IOLBF));

  if (type == _IOFBF || type == _IOLBF) {
    if (size == 0)
      return EOF;

    if (buf == NULL) {
      if ((buf = (char *) malloc(size)) == NULL)
        return EOF;
      else
	SETFLAG(fp, _IOMYBUF);
    }

    fp->_base   = (unsigned char *) buf;
    fp->_bufsiz = size;

    if (TESTFLAG(fp, _IOREAD))
      type = _IOFBF;
  }
  else if (type == _IONBF) {
    fp->_base = &fp->_buf;
    fp->_bufsiz = sizeof(fp->_buf);
  }
  else
    return EOF;

  SETFLAG(fp, type);
  INITBUFFER(fp);
  return 0;
}
