/* Dummy ranlib program for GNU.  All it does is
   `ar rs LIBRARY' for each library specified.  */

/*   MODIFIED BY CHRIS BENENATI, FOR INTEL CORPORATION, 4/89  */


/* The makefile generates a -D switch to define AR_PROG
   as the location of the GNU AR program.  */

char *prog = AR_PROG;

#ifdef I80960

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "env.h"

extern char *getenv();
extern char *malloc();

/******************************************************************************
 * exists:
 *	Creates a full pathname by concatenating up to three name components
 *	onto a specified base name; optionally looks up the base name as a
 *	runtime environment variable;  and checks to see if the file or
 *	directory specified by the pathname actually exists.
 *
 *	Returns:  the full pathname if it exists, NULL otherwise.
 *		(returned pathname is in malloc'd memory and must be freed
 *		by caller).
 *****************************************************************************/
char *
exists( base, c1, c2, c3, env )
    char *base;		/* Base directory of path */
    char *c1, *c2, *c3;	/* Components (subdirectories and/or file name) to be
			 *	appended onto the base directory name.  One or
			 *	more may be omitted by passing NULL pointers.
			 */
    int env;		/* If 1, '*base' is the name of an environment variable
			 *	to be examined for the base directory name;
			 *	otherwise, '*base' is the actual base directory
			 *	name.
			 */
{
	struct stat buf;	/* For call to 'stat' -- never examined */
	char *path;		/* Pointer to full pathname (malloc'd memory) */
	int len;		/* Length of full pathname (incl. terminator) */

	if ( env ){
		base = getenv( base );
		if ( base == NULL ){
			return NULL;
		}
	}

	len = strlen(base) + 4;
			/* +4 for terminator and "/" before each component */
	if ( c1 != NULL ){
		len += strlen(c1);
	}
	if ( c2 != NULL ){
		len += strlen(c2);
	}
	if ( c3 != NULL ){
		len += strlen(c3);
	}

	path = malloc( len );

	strcpy( path, base );
	if ( c1 != NULL ){
		strcat( path, "/" );
		strcat( path, c1 );
	}
	if ( c2 != NULL ){
		strcat( path, "/" );
		strcat( path, c2 );
	}
	if ( c3 != NULL ){
		strcat( path, "/" );
		strcat( path, c3 );
	}

	if ( stat(path,&buf) != 0 ){
		free( path );
		path = NULL;
	}
	return path;
}
#endif


main (argc, argv)
     int argc;
     char **argv;
{
  int i;

#ifdef I80960
  char *p;	/* Pointer to full pathname of sx utility	*/
  char msg[200];	/* Build error message here			*/


  if ( (argc > 1 ) && !strcmp(argv[1],"-v960") ){
	extern char gran960_ver[];
	puts( gran960_ver );
	exit(0);
  }

  /* Make sure the librarian is findable.
   * Look in $G960BIN, $G960BASE/bin, and DEFAULT_BASE/bin/HOST/bin, where
   *	DEFAULT_BASE is defined in env.h, and
   *	HOST must be defined on the compiler invocation line.
   */
  if ( ((p = exists("G960BIN",AR_PROG,NULL,NULL,1)) == NULL)
  && ((p = exists("G960BASE","bin",AR_PROG, NULL,1)) == NULL)
  && ((p = exists(DEFAULT_BASE,HOST,"bin",AR_PROG,0)) == NULL)
  ){
	fprintf( stderr, "Can't find '%s' download utility\n", AR_PROG );
	fprintf( stderr, "Check G960BIN & G960BASE environment variables\n" );
	exit(1);
  }
#endif

  for (i = 1; i < argc; i++)
    {
      int pid = fork ();
      if (pid == 0)
	{
#ifdef I80960
	  execlp(p, p, "rs", argv[i], 0);
#else
	  execl (prog, prog, "rs", argv[i], 0);
#endif
	  perror (prog);
	  exit (1);
	}
      wait (0);
    }
  exit (0);
}
