/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.NavDrv;
import com.netscape.javascript.qa.drivers.TestCase;
import com.netscape.javascript.qa.drivers.TestDriver;
import com.netscape.javascript.qa.drivers.TestEnvironment;
import com.netscape.javascript.qa.drivers.TestFile;
import com.netscape.javascript.qa.drivers.TestSuite;
import java.applet.Applet;
import netscape.javascript.JSObject;

public class NavEnv
implements TestEnvironment {
    TestFile file;
    TestSuite suite;
    NavDrv driver;
    private JSObject result;
    JSObject opener;
    JSObject testcases;
    JSObject location;
    boolean evaluatedSuccessfully = false;
    JSObject window;
    private String WINDOW_NAME;

    public NavEnv(TestFile testFile, TestSuite testSuite, NavDrv navDrv) {
        this.file = testFile;
        this.suite = testSuite;
        this.driver = navDrv;
        this.opener = JSObject.getWindow((Applet)navDrv);
        this.window = null;
        this.WINDOW_NAME = "js" + this.getRandomWindowName();
    }

    public void close() {
        this.opener.eval(String.valueOf(this.WINDOW_NAME) + ".close()");
        this.opener.eval("delete " + this.WINDOW_NAME);
    }

    public Object createContext() {
        System.out.println("opening window");
        this.opener.eval(String.valueOf(this.WINDOW_NAME) + " = window.open( '', '" + this.WINDOW_NAME + "' )");
        this.window = (JSObject)this.opener.getMember(this.WINDOW_NAME);
        return this.window;
    }

    public Object executeTestFile() {
        System.out.println("executeTestFile()");
        try {
            this.location = (JSObject)this.window.getMember("location");
            System.out.println(this.file.name);
            String string = String.valueOf(this.driver.HTTP_PATH) + this.suite.name + "/" + this.file.name;
            this.location.setMember("href", String.valueOf(this.driver.HTTP_PATH) + this.suite.name + "/" + this.file.name);
            this.evaluatedSuccessfully = this.waitForCompletion();
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.file.name) + " failed with exception: " + exception);
            this.file.exception = exception.toString();
            if (this.file.name.endsWith("-n.js")) {
                this.file.passed = true;
                this.evaluatedSuccessfully = true;
            }
            this.file.passed = false;
            this.suite.passed = false;
            this.evaluatedSuccessfully = false;
        }
        return null;
    }

    public String getRandomWindowName() {
        return Integer.toString(new Double(Math.random() * 100000.0).intValue());
    }

    public synchronized boolean parseResult() {
        block9: {
            try {
                JSObject jSObject = (JSObject)this.window.getMember("testcases");
                this.file.totalCases = ((Number)jSObject.getMember("length")).intValue();
                System.out.println("testcases.length is " + this.file.totalCases);
                int n = 0;
                while (n < this.file.totalCases) {
                    JSObject jSObject2 = (JSObject)jSObject.getSlot(n);
                    TestCase testCase = new TestCase(jSObject2.getMember("passed") == null ? "null" : jSObject2.getMember("passed").toString(), jSObject2.getMember("name") == null ? "null " : jSObject2.getMember("name").toString(), jSObject2.getMember("description") == null ? "null " : jSObject2.getMember("description").toString(), jSObject2.getMember("expect") == null ? "null " : jSObject2.getMember("expect").toString(), jSObject2.getMember("actual") == null ? "null " : jSObject2.getMember("actual").toString(), jSObject2.getMember("reason") == null ? "null " : jSObject2.getMember("reason").toString());
                    this.file.caseVector.addElement(testCase);
                    if (testCase.passed.equals("false")) {
                        if (this.file.name.endsWith("-n.js")) {
                            this.file.passed = true;
                        } else {
                            this.file.passed = false;
                            this.suite.passed = false;
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.file.exception = exception.toString();
                if (this.file.name.endsWith("-n.html")) {
                    this.file.passed = true;
                }
                this.file.passed = false;
                this.suite.passed = false;
            }
            if (this.file.passed) break block9;
            try {
                this.file.bugnumber = this.window.getMember("BUGNUMBER").toString();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public synchronized void runTest() {
        int n = 0;
        System.out.println(this.file.name);
        try {
            this.createContext();
            this.file.startTime = TestDriver.getCurrentTime();
            System.out.println(n++);
            this.executeTestFile();
            System.out.println(n++);
            if (this.evaluatedSuccessfully) {
                System.out.println(n++);
                this.parseResult();
                System.out.println(n++);
            }
            this.file.endTime = TestDriver.getCurrentTime();
        }
        catch (Exception exception) {
            this.suite.passed = false;
            this.file.passed = false;
            this.file.exception = "file failed with exception: " + exception;
        }
    }

    public boolean waitForCompletion() {
        int n = 0;
        if (!this.window.getMember("completed").toString().equals("true")) {
            while (!this.window.getMember("completed").toString().equals("true")) {
                try {
                    if (n > 20) {
                        this.file.passed = false;
                        this.file.exception = String.valueOf(this.file.exception) + "test failed to complete";
                        System.out.println("test failed to complete");
                        return false;
                    }
                    System.out.println(".");
                    this.driver.sleep(1000);
                    ++n;
                }
                catch (Exception exception) {
                    System.out.println("sleep failed:  " + exception);
                    return false;
                }
            }
        }
        return true;
    }
}

