/****************************************************************************
 *
 * Class:   AttributeList and AttrListTable and UserListTbl
 * Author:  Mark Roseman
 * 
 * Maintain a list of attribute / value pairs.  Also tables of these lists,
 * indexed by an integer parameter.  The UserListTbl provides a table of
 * these tables, useful for storing tables of users for each conference.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 10/02/92 MR        initial version
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __attrlist_h
#define __attrlist_h

#include <OS/list.h>
#include <OS/table.h>

/*
** an attribute / value pair
*/

class AVPair {
public:
  AVPair(const char* at, const char* vl);
  ~AVPair();
  char* attr;
  char* val;
};

/*
** a list of AVpairs
*/

declarePtrList(AVPairList,AVPair);

class AttributeList {
public:
  AttributeList();
  ~AttributeList();
  void attribute(const char* attr, const char* val);
  void remove_attribute(const char* attr);
  boolean find_attribute(const char* attr, char* value);
  static AttributeList* read(const char*);
  void write(char*);
  AVPairList* list();
protected:
  long find(const char* attr);
  AVPairList* list_;
};


/*
** tables of these lists
*/

declareTable(AttrLstTbl, int, AttributeList*) 

class AttrListTable : public AttrLstTbl {
public:
  AttrListTable(int x=30);
  void write(char*);
  static AttrListTable* read(const char*, const char*, int); 
};

declareTable(UserListTbl, int, AttrListTable*)

#endif


