/***************************************************************************
 *
 * Class:  ConnAction
 * Author: Mark Roseman
 *
 * An action whose execute function takes a string parameter as well as a
 * connection object.  This is primarily used for "info" messages, where
 * the connection is in a connection list *without* its id number; the info
 * message passes the id number, which must be then assigned to the connection
 * object.  (Without passing the connection, the callback routine would have
 * no idea what object the information referred to).
 * 
 * This code is based on ...iv/src/include/InterViews/action.h in the 
 * InterViews distribution.
 *
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/29/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __connaction_h
#define __connaction_h

#include <InterViews/resource.h>


class ConnAction : public Resource {
protected:
    ConnAction() {};
    virtual ~ConnAction() {};
public:
    virtual void execute(char *, class Connection*) = 0;
};



#if defined(__STDC__) || defined(__ANSI_CPP__)
#define __ConnActionCallback(T) T##_ConnActionCallback
#define ConnActionCallback(T) __ConnActionCallback(T)
#define __ConnActionMemberFunction(T) T##_ConnActionMemberFunction
#define ConnActionMemberFunction(T) __ConnActionMemberFunction(T)
#else
#define __ConnActionCallback(T) T/**/_ConnActionCallback
#define ConnActionCallback(T) __ConnActionCallback(T)
#define __ConnActionMemberFunction(T) T/**/_ConnActionMemberFunction
#define ConnActionMemberFunction(T) __ConnActionMemberFunction(T)
#endif

#define declareConnActionCallback(T) \
typedef void T::ConnActionMemberFunction(T)(char *, class Connection*); \
class ConnActionCallback(T) : public ConnAction { \
public: \
    ConnActionCallback(T)(T*, ConnActionMemberFunction(T)*); \
\
    virtual void execute(char *, class Connection*); \
private: \
    T* obj_; \
    ConnActionMemberFunction(T)* func_; \
};

#define implementConnActionCallback(T) \
ConnActionCallback(T)::ConnActionCallback(T)(T* obj, ConnActionMemberFunction(T)* func) { \
    obj_ = obj; \
    func_ = func; \
} \
\
void ConnActionCallback(T)::execute(char *s, class Connection* c) { (obj_->*func_)(s,c); }


#endif
