/***************************************************************************
 *
 * Class:  GroupSession
 * Author: Mark Roseman
 * 
 * Provide a Session object specifically for GroupKit conferences.  The 
 * main duties here are setting up some default parameters, parsing some
 * GroupKit specific command line options, and making it easier to 
 * instantiate some GroupKit objects such as a Conference.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 09/20/92 MR        initial version
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __groupsession_h
#define __groupsession_h

#include <InterViews/session.h>

class GroupSession : public Session {
public:
  GroupSession( const char*, int& argc, char**argv,
	        const OptionDesc* = nil, const PropertyData* = nil);
  class Conference* conference();

  static const char* host_name();

private:
  OptionDesc* AugmentOpts(const OptionDesc*);
  PropertyData* AugmentProps(const PropertyData*);
  static char host_name_[256];
};

#endif
