/**************************************************************************
 * 
 * Brainstorming example
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include "bstormglyph.h"
#include <gk-ui/strbrowser.h>
#include <IV-look/field.h>
#include <gk/straction.h>
#include <OS/string.h>
#include <gk/conference.h>
#include <gk/infoconn.h>
#include <gk/reader.h>
#include <gk/groupkit.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>
#include <gk/msgsender.h>
#include <InterViews/style.h>

declareActionCallback(BrainStorm);
implementActionCallback(BrainStorm);

declareStrActionCallback(BrainStorm);
implementStrActionCallback(BrainStorm);

declareFieldEditorCallback(BrainStorm);
implementFieldEditorCallback(BrainStorm);

/**************************************************************************
 * 
 * Construct a glyph for brainstorming, a browser on top of a field editor.
 * Ideas are typed in the field editor and appear in the browser.
 *
 **************************************************************************/
BrainStorm::BrainStorm(Style* style, Conference* conf) : 
         ConferenceGlyph(nil, style, conf) 
{
  long width, height;
  WidgetKit& kit = *WidgetKit::instance();
  LayoutKit& layout = *LayoutKit::instance();
  brwsr_ = new StringBrowser( &kit, nil, nil );
  fld_ = new FieldEditor( "", &kit, style, new FieldEditorCallback(BrainStorm)
			 (this, &BrainStorm::field_callback, nil ));
  style->find_attribute( "width", width );
  style->find_attribute( "height", height );
  body(
       kit.inset_frame(
         layout.margin(
	   layout.vbox(
	     layout.hbox(
	       kit.inset_frame(
		 layout.margin(
		   layout.fixed_span(brwsr_, (int)width, (int)height)
		   ,1.0
		 )
	       ),
	       layout.hglue(4.0),
               kit.vscroll_bar(brwsr_->adjustable())
	     ),
	     layout.vglue(10.0),
	     fld_,
	     layout.vglue(5.0),
             layout.hbox( 
               layout.hglue(),
			 kit.default_button("Enter", 
					    new ActionCallback(BrainStorm)
					    (this, &BrainStorm::idea))
             )
	   )
	   ,10
	 )
       )
     );
  append_input_handler( fld_ );
  conf->connections()->callbacks()->insert( IDEA, 
					   new StrActionCallback(BrainStorm)
					   (this, &BrainStorm::new_idea));
}


/**************************************************************************
 * 
 * callback for the field editor
 *
 **************************************************************************/

void BrainStorm::field_callback(FieldEditor*) {
    idea();
}


/**************************************************************************
 * 
 * user typed an idea, append it to the browser, and send to other users
 *
 **************************************************************************/

void BrainStorm::idea() {
  brwsr_->Append( fld_->text()->string());
  conf_->connections()->toAll(new StrMsgSender( IDEA, 
					       (char*)fld_->text()->string()));
  fld_->field("");
}


/**************************************************************************
 * 
 * we've received an idea from another user, add it to the browser
 *
 **************************************************************************/
void BrainStorm::new_idea(char *s) {
  brwsr_->Append( s );
}

