/**************************************************************************
 * 
 * Multi-user deck flip glyph.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


#include "deckflip.h"
#include <IV-look/kit.h>
#include <InterViews/layout.h>
#include <InterViews/style.h>
#include <stdio.h>
#include <stdlib.h>
#include <gk/conference.h>
#include <InterViews/action.h>
#include <InterViews/patch.h>
#include <gk/straction.h>
#include <gk/infoconn.h>
#include <gk/reader.h>
#include <gk/msgsender.h>

declareActionCallback(DeckFlip)
implementActionCallback(DeckFlip)

declareStrActionCallback(DeckFlip)
implementStrActionCallback(DeckFlip)


#define DEMOCALLBACK  200

/**************************************************************************
 * 
 * construct the glyph, set up callbacks, etc.
 *
 **************************************************************************/

DeckFlip::DeckFlip(Style* style, Conference* conf) : 
        ConferenceGlyph(nil, style, conf) 
{
  WidgetKit& kit = *WidgetKit::instance();
  const LayoutKit& layout = *LayoutKit::instance();

  deck_ = layout.deck();
  deck_->append(kit.label("Hi mom!"));
  deck_->append(kit.label("Big Bird"));
  deck_->append(kit.label("Oscar"));
  deck_->flip_to(0);
  patch_ = new Patch(deck_);
  body(
    kit.inset_frame(
      layout.margin(
	layout.vbox(
	  patch_,
	  layout.vglue(5.0),
	  layout.hbox(
	    kit.push_button("Next", new ActionCallback(DeckFlip)
                   (this, &DeckFlip::next)),
	    layout.hglue(10.0),
	    kit.push_button("Previous", new ActionCallback(DeckFlip)
                   (this, &DeckFlip::prev))
	  ),
	),
	10.0
      )
    )
  );
  conf->connections()->callbacks()->insert( DEMOCALLBACK, 
           new StrActionCallback(DeckFlip)(this, &DeckFlip::remoteFlip));
}

/**************************************************************************
 * 
 * callbacks when user presses previous or next buttons
 *
 **************************************************************************/

void DeckFlip::prev() {
  GlyphIndex cur = deck_->card() - 1;
  flip( cur == -1 ? deck_->count() - 1 : cur );
}

void DeckFlip::next() {
  GlyphIndex cur = deck_->card() + 1;
  flip ( cur == deck_->count() ? 0 : cur );
}

/**************************************************************************
 * 
 * call real_flip to change the glyph and also tell other users
 *
 **************************************************************************/

void DeckFlip::flip(GlyphIndex cur) {
  char s[10];
  real_flip(cur);
  sprintf(s, "%d", cur);
  conference()->connections()->toAll( new StrMsgSender( DEMOCALLBACK, s) );
}

/**************************************************************************
 * 
 * change glyph to appropriate card
 *
 **************************************************************************/

void DeckFlip::real_flip(GlyphIndex cur) {
  deck_->flip_to(cur);
  patch_->redraw();
}

/**************************************************************************
 * 
 * remote user changed the card
 *
 **************************************************************************/

void DeckFlip::remoteFlip(char* s) {
  int which;
  sscanf(s, "%d", &which);
  real_flip(which);
}
