/**************************************************************************
 * 
 * Monitor the users in the conference.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include "usermon.h"
#include <InterViews/patch.h>
#include <gk/attrlist.h>
#include <gk/conference.h>
#include <gk-ui/strbrowser.h>
#include <gk-ui/noeditfield.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>
#include <InterViews/action.h>
#include <gk-ui/labscrlst.h>
#include <OS/table.h>
#include <stdio.h>

declareActionCallback(UserMonitor)
implementActionCallback(UserMonitor)

declareTable(IntTable, int, int)
implementTable(IntTable, int, int)

/**************************************************************************
 * 
 * Create a user monitor, consisting of a list of users, and underneath
 * that a list holding the attributes for the selected user, as well as
 * a static text field holding messages
 *
 **************************************************************************/

UserMonitor::UserMonitor(WidgetKit* kit, Conference* conf) : 
          ConferenceGlyph(nil, kit->style(), conf) 
{
  users_ = new StringBrowser(kit, nil, new ActionCallback(UserMonitor)
			     (this, &UserMonitor::selectUser));
  info_ = new StringBrowser(kit, nil, nil);
  msg_ = new NoEditField(" ", kit );
  LayoutKit& layout = *LayoutKit::instance();
  patch_ = new Patch(
    kit->inset_frame(
      layout.margin(
        layout.vbox(
          msg_,
	  new LabelledScrollList( kit, " ", users_, 200, 100),
          new LabelledScrollList( kit, " ", info_, 200, 100)
        )
      , 10.0)
    )
  );
  body(patch_);
  attrs_ = new AttrListTable(20);
  lines_ = new IntTable(20);
  conf->monitors()->append(this);
}


/**************************************************************************
 * 
 * A user has been selected - display their attributes in the lower browser
 *
 **************************************************************************/

void UserMonitor::selectUser() {
  AttributeList* al;
  int id;
  char s[100];
  info_->Clear();
  if( users_->selected() >= 0) 
    if (lines_->find( id, users_->selected() )) 
      if (attrs_->find(al, id)) 
	for (ListItr(AVPairList) i(*al->list()); i.more(); i.next()) {
	  sprintf(s, "%s: %s", i.cur()->attr, i.cur()->val);
	  info_->Append(s);
	}
  patch_->redraw();
}


/**************************************************************************
 * 
 * a new users has joined, stick their name in the users browser, and
 * place a message in the static text field
 *
 **************************************************************************/

void UserMonitor::newUser( AttributeList* al ) {  
  char id[80], name[80], s[80];
  al->find_attribute( "usernum", id );
  al->find_attribute( "username", name );
  users_->Append( name );
  lines_->insert( users_->Count() - 1, atoi(id) );
  attrs_->insert( atoi(id), al );
  sprintf(s, "%s has entered.", name);
  msg_->field(s);
  patch_->redraw();
}


/**************************************************************************
 * 
 * a user is leaving, remove them from the users browser and place a message
 * in the static text field.  have to muck with the table so that every
 * user who was below the removed one gets moved up a line
 *
 **************************************************************************/

void UserMonitor::userLeaving( int id ) { 
  char s[80], name[80];
  AttributeList* al;
  int line;
  IntTable* tbl;
  
  for (TableIterator(IntTable) j(*lines_); j.more(); j.next())
    if (j.cur_value() == id) 
      line = j.cur_key();
  fprintf(stderr, "line is %d\n", line);
  tbl = new IntTable(20);
  for (TableIterator(IntTable) i(*lines_); i.more(); i.next())
    if (i.cur_key() > line) 
      tbl->insert( i.cur_key()-1, i.cur_value());
    else if (i.cur_key() < line)
      tbl->insert( i.cur_key(), i.cur_value());
  delete lines_;
  lines_ = tbl;
  users_->remove( line );
  
  if( attrs_->find( al, id )) {
    al->find_attribute( "username", name );
    sprintf( s, "%s has left.", name );
    msg_->field(s);
    attrs_->remove( id );
  }
  patch_->redraw();
}







