/**************************************************************************
 * 
 * Monitor the users in the conference.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __usermon_h
#define __usermon_h

#include <gk/confmonitor.h>
#include <gk/confglyph.h>

class UserMonitor : public ConferenceMonitor, public ConferenceGlyph {
public:
  UserMonitor( class WidgetKit*, class Conference* );
  virtual void newUser(class AttributeList*);
  virtual void userLeaving(int id);
protected:
  void selectUser();
  class StringBrowser* users_;
  class NoEditField* msg_;
  class Patch* patch_;
  class StringBrowser* info_;
  class AttrListTable* attrs_;
  class IntTable* lines_;
};


#endif
