/****************************************************************************
 * 
 * Class:  Slave Registrar Client main program
 * Author: Mark Roseman
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/22/92 MR        initial version
 * 08/14/92 MR        changed to use XDefaults for registrar path
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk/groupsession.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <stdio.h>
#include "slaverc.h"
#include <gk-reg/coordinator.h>
#include <IV-look/kit.h>
#include <OS/string.h>

static OptionDesc options[] = {
  { "host=", "*RegistrarHost", OptionValueAfter },
  { "port=", "*RegistrarPort", OptionValueAfter },
  { nil }
};


int main(int argc, char** argv) {
  Session* session = new GroupSession("Startup", argc, argv, options, nil);
  String* host = new String();
  long port;
  if( ( session->style()->find_attribute("RegistrarHost", *host)) &&
      ( session->style()->find_attribute("RegistrarPort", port))) {
    Coordinator* coord = new Coordinator(session->style());
    SlaveRegClient* rc = new SlaveRegClient(host->string(), (int)port, coord);
    coord->rc_ = rc;
    session->run();
  } else {
    fprintf(stderr, "%s: Could not locate the Registrar.\n", argv[0]);
    fprintf(stderr, "Check the RegistrarHost and RegistrarPort resources.\n");
  }
  delete session;
  return 0;
}

