/****************************************************************************
 *
 * Class:  Registrar implementation
 * Author: Mark Roseman
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 09/17/92 MR        added callback for reader connection close
 * 09/20/92 MR        changed to work on specific port, and not register peer
 * 
 ****************************************************************************/

#include "registrar.h"
#include <Dispatch/rpcstream.h>
#include <gk/msgsender.h>
#include <gk/straction.h>
#include <gk/rpcaction.h>
#include <gk/groupkit.h>
#include <gk/reader.h>     // for ReaderCallbackTable
#include <gk/connection.h>
#include <stdio.h>
#include <string.h>

declareStrActionCallback(Registrar);
implementStrActionCallback(Registrar);

declareRpcActionCallback(Registrar);
implementRpcActionCallback(Registrar);



/****************************************************************************
 *
 * Constructor.
 *
 ****************************************************************************/


Registrar::Registrar(int port) : RpcPeer("/dev/null", port)
{
  startListening();
  connlist_ = new ConnectionList();

  connlist_->callbacks()->insert( NEWCONF, new StrActionCallback(Registrar)
				 (this, &Registrar::new_conference));
  connlist_->callbacks()->insert( DELCONF, new StrActionCallback(Registrar)
				 (this, &Registrar::delete_conference));
  connlist_->callbacks()->insert( DISPCONF, new StrActionCallback(Registrar)
				 (this, &Registrar::disp_conference));
  connlist_->callbacks()->insert( ADDUSER, new StrActionCallback(Registrar)
				 (this, &Registrar::add_user));
  connlist_->callbacks()->insert( DELUSER, new StrActionCallback(Registrar)
				 (this, &Registrar::delete_user));
  connlist_->callbacks()->insert( DISPUSER, new StrActionCallback(Registrar)
				 (this, &Registrar::display_users));

  conference_tbl_ = new AttrListTable(30);
  users_tbl_ = new UserListTbl(30);
  lastID_ = 1;
}


/****************************************************************************
 * 
 * Destructor.  Delete the connection list (which also involves freeing
 * all its elements) and also the conference list (which should free its
 * own space).
 *
 ****************************************************************************/

Registrar::~Registrar() {
  delete connlist_;
  delete conference_tbl_;
  delete users_tbl_;
}


/****************************************************************************
 *
 * A registrar client has just connected up to us.  Create a new
 * connection in the list for it.
 *
 ****************************************************************************/

void Registrar::createReaderAndWriter(int fd) {
  Connection* conn = connlist_->add(fd);
  conn->reader()->closeCallback( new RpcActionCallback(Registrar)(this, &Registrar::closeCallback));
}

/****************************************************************************
 * 
 * A client has asked to create a new conference
 *
 ****************************************************************************/

void Registrar::new_conference(char *s) {
  char id[80];
  AttributeList* a = AttributeList::read(s);
  sprintf(id, "%d", lastID_); a->attribute("confnum", id);
  conference_tbl_->insert( lastID_, a);
  users_tbl_->insert( lastID_++, new AttrListTable(20) );
}

/****************************************************************************
 *
 * A client has asked to delete a conference
 *
 ****************************************************************************/

void Registrar::delete_conference(char *s) {
  AttributeList a = *AttributeList::read(s);  char t[80];
  if(a.find_attribute("confnum", t)) {
    conference_tbl_->remove(atoi(t));
    users_tbl_->remove(atoi(t));
  }
}

/****************************************************************************
 * 
 * Display a list of the conferences
 *
 ****************************************************************************/

void Registrar::disp_conference(char *) {
  char lst[16000];
  conference_tbl_->write(lst);
  connlist_->toAll( new StrMsgSender(CONFLIST, lst) );
}

/****************************************************************************
 *
 * Add a user to a conference
 *
 ****************************************************************************/

void Registrar::add_user(char *s) {
  AttributeList* a = AttributeList::read(s);
  AttrListTable *b;
  char t[80], id[80];
  sprintf(id, "%d", lastID_);
  a->attribute("usernum", id);
  if(a->find_attribute("confnum", t)) 
    if (users_tbl_->find( b, atoi(t))) 
      b->insert(lastID_++, a);
}


/****************************************************************************
 * 
 * Delete a user from a conference
 *
 ****************************************************************************/

void Registrar::delete_user(char *s) {
  AttributeList a = *AttributeList::read(s);
  AttrListTable* b;
  char t[80];
  if(a.find_attribute("confnum", t))
    if (users_tbl_->find(b, atoi(t)))
      if(a.find_attribute("usernum", t))
	b->remove(atoi(t));
}


/****************************************************************************
 *
 * Display all the users in a conference
 *
 ****************************************************************************/

void Registrar::display_users(char *s) {
  char lst[16000];
  AttributeList a = *AttributeList::read(s);
  AttrListTable* b;
  char t[80];
  if(a.find_attribute("confnum", t)) {
    users_tbl_->find(b, atoi(t));
    b->write(lst);
    if(strlen(lst) == 0)           // if no users still must transmit confnum
      sprintf(lst, "confnum=%s:usernum=-1", t);
    connlist_->toAll( new StrMsgSender(USERLIST, lst));
  }
}

/****************************************************************************
 *
 * One of the registrar clients has died
 *
 ****************************************************************************/

void Registrar::closeCallback(class CallbackRpcReader* r, int /* fd */) {
  long index = 0;
  for (ListItr(ConnList) i(*connlist_->list()); i.more(); i.next()) {
    Connection* conn = i.cur();
    if (conn->reader() == r) {
      connlist_->list()->remove( index );
      break;
    }
    index++;
  }
}




