/****************************************************************************
 *
 * Class:  LabelledScrollList implementation
 * Author: Mark Roseman
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 08/14/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk-ui/labscrlst.h>
#include <IV-look/fbrowser.h>
#include <InterViews/layout.h>
#include <IV-look/kit.h>

LabelledScrollList::LabelledScrollList(WidgetKit* kit, char *label, 
				       FileBrowser* browser,
				       int width, int height) 
{
  LayoutKit& layout = *LayoutKit::instance();
  body(
    layout.vbox(
      kit->label(label),
      layout.vglue(5.0),
      layout.hbox(
	layout.vcenter(
	  kit->inset_frame(
	    layout.margin(
	      layout.natural_span(browser, width, height), 
	      1.0
	    )
	  ),
	  1.0
	),
	layout.hspace(4.0),
	kit->vscroll_bar(browser->adjustable())
      )
    )
  );
}

