/**************************************************************************
 * 
 * File:   open_pty.c
 * Author: Dan Freedman / Mark Roseman
 *
 * Pty routines used by the Shell class.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 *
 **************************************************************************/


/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


/* Program to run other programs connected to a pseudo-tty, and provide */
/* file descriptors so that your program can interact with it.          */

/* Dan Freedman, Dept of Computer Science, University of Calgary, Calgary, */
/*               Alberta, Canada.                                          */
/*                                                                         */
/*               E-mail to ...!ihnp4!alberta!calgary!freedman              */
/*               or        freedman@calgary.CDN                            */
/*                                                                         */
/*               Phone (403) 220-7299, or 220-5901                         */

// modified by Mark Roseman roseman@cpsc.ucalgary.ca December 1991
// updated for C++ syntax, declarations, etc. -- main program removed

#include <stdio.h>
#include <strings.h>
#include <sys/time.h>
#include <sys/termios.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <ctype.h>
#include <osfcn.h>

/* Global Variables */

static int  pty_master;
static char pty_slave_filename[50], pty_master_filename[50];
struct termios oldterm = {  /* initialized structure for the pty */
    (BRKINT|IGNPAR|ISTRIP|ICRNL|IXON|IMAXBEL),  /* c_iflags */
    (OPOST|ONLCR|TABDLY),                       /* c_oflags */
    (B9600|CS7|CREAD|PARENB),                   /* c_cflags */
    (ISIG|ICANON|ECHO|ECHOE|ECHOK|ECHOCTL|ECHOKE), /* c_lflags */
    '\0',                                       /* c_line */
    CINTR, CQUIT, CERASE, CKILL, CEOF, CEOL, CEOL2, CSWTCH,      /* c_cc */
    CSTART, CSTOP, CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};


struct termios theterm = {  /* initialized structure for the pty */
    (ISTRIP|ICRNL|IXON|IMAXBEL),  /* c_iflags */
    (OPOST|ONLCR|TABDLY),                       /* c_oflags */
    '\0',                   /* c_cflags */
    (ISIG|ICANON|ECHO|ECHOE|ECHOK|ECHOCTL|ECHOKE), /* c_lflags */
    '\0',                                       /* c_line */
    CINTR, CQUIT, CERASE, CKILL, CEOF, CEOL, CEOL2, CSWTCH,      /* c_cc */
    CSTART, CSTOP, CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};


/* Function prototypes */
int open_pty_channel (char *command, FILE **in_file, FILE **out_file);
set_up_pty_and_tty();
spawn_process(char *command);

extern "C" {
  int tcsetattr(int,int,struct termios *);
  int tcgetattr(int,struct termios *);
};

int open_pty_channel (char *command, FILE **in_file, FILE **out_file) {

/* This routine accepts 3 args:  a command to run, and pointers to 2 *FILE's.
   The command is run connected to a pseudo-tty, and the *FILE's are set to
   point to the pseudo-tty so that your program can read/write from it.  If
   you want plain fildes instead of FILE's, you should be able to figure
   out what to modify.                                                      */

    int childpid;
    static struct termios term;

    if (!set_up_pty_and_tty()) return 0;

//    ioctl(pty_master, TCGETS, &term);
//    term.c_lflag |= ECHO;
//    term.c_cc[VEOL] = '\n';
//    ioctl(pty_master, TCSETS, &theterm);


    if ((childpid = spawn_process(command)) < 1)  {
	close (pty_master);
	return 0;
	}

    *in_file  = fdopen (pty_master, "r");
    *out_file = fdopen (dup (pty_master), "w");

    return childpid;
    }
    
    

set_up_pty_and_tty() {

   int finished;
   char prefix, number;
   char *pty_prefix_ptr, *pty_num_ptr;
   char filename[256];
   
   strcpy (filename, "/dev/pty");
   pty_prefix_ptr = &filename[8];
   pty_num_ptr    = &filename[9];
   filename[10]   = '\0';
   
   
   finished = 0;
   for (prefix = 'p'; (prefix <= 's') && !finished; ++prefix) {
       *pty_prefix_ptr = prefix;
       for (number = '1'; (number <= 'f') && !finished; 
                                   number = (number == '9') ? 'a' : ++number){
           *pty_num_ptr = number;
	   pty_master = open (filename, O_RDWR, 0700);
	   if (pty_master >= 0) {
	       strcpy (pty_master_filename, filename);
	       strcpy (pty_slave_filename,  filename);
	       pty_slave_filename[5] = 't';
	       finished = 1;
	       }
	   }
       }
   if (!finished)
       return 0;
   else
       return 1;
   }


spawn_process(char *command) {
    char cmd[1024];
    int subprocess_id, tty, pty_slave;
    struct sgttyb pty_sgttyb;

    ioctl (pty_master, TIOCGETP, &pty_sgttyb);

    if (!(subprocess_id = fork())) { /* if child */
	tty = open ("/dev/tty", O_RDWR, 0700);
	ioctl (tty, TIOCNOTTY, 0);
	close (tty);

	ioctl (pty_master, TIOCSPGRP, getpid());

	close (0);
	close (1);
	close (2);

	pty_slave = open (pty_slave_filename, O_RDWR, 700);
	dup (0);
	dup (0);
	close (pty_master);
	ioctl (pty_slave, TIOCSETP, &pty_sgttyb);

	tcsetattr(pty_slave, TCSANOW, &theterm);

	strcpy (cmd, "exec ");
	strcat (cmd, command);
	system (cmd);
	exit (-1); /* just in case exec fails. */
	}
    return subprocess_id;
    }


