/***************************************************************************
 *
 * Class:  ConferenceGlyph implementation
 * Author: Mark Roseman
 *
 * A glyph (actually an ActiveHandler) which contains a pointer to its
 * associated conference object.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 06/08/92 MR        initial version
 *
 ***************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk/confglyph.h>

#include <InterViews/glyph.h>
#include <InterViews/style.h>
#include <gk/conference.h>


/****************************************************************************
 *
 * Constructor.  
 *
 ****************************************************************************/

ConferenceGlyph::ConferenceGlyph(Glyph* g, Style* s, Conference* c) : 
        ActiveHandler(g,s), conf_(c) { }


/****************************************************************************
 *
 * Wrapper to return the conference object.
 *
 ****************************************************************************/

class Conference* ConferenceGlyph::conference(void) { return conf_; }

