/*
** new_faxrc:
**
**	Builds a default .faxrc file for the user named.  The file 
**	/usr/xpressfax/.default_server is used to extract the server 
**	and/or server password information entered from the installation
**	script.
**
** Copyright (C) 1992 by 
** John Uhley and XpressWare
** PO BOX 51118 
** Pasadena, California 
** 818 793 8613
**	
**
*/
#define DIR_MODE 01700
#define DEFAULT_SERVER_FILE "/usr/xpressfax/.default-server"

/*
** Include files 
**
*/
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <errno.h>
#include "xpressfax_symbols.h"

static void strip_space();
static int get_default_server();
static char default_server[BUFSIZ];
static char default_server_password[BUFSIZ];

/*
**  main: The main entry point to create the .faxrc file
**
*/
main(argc, argv)
	int argc;
	char **argv;
{
	char buf[BUFSIZ];
	struct passwd *pwd;
	pwd = (struct passwd *)getpwuid(getuid());
	switch (argc) {
		case 1:
			new_faxrc();
			exit(0);
		case 2:
			if (strcmp(argv[1], "-f")==0) {
				sprintf(buf,"%s/.faxrc", pwd->pw_dir);
				unlink(buf);
				new_faxrc();
				exit(0);
			}
			/* fall through */
		default:
			fprintf(stderr,"usage: %s [-f]\n",argv[0]);
			exit(1);
	}
}

/*
** new_faxrc:
**	Generate a faxrc file and the default subdirectories and/or files
**	if one does not already exist for this user
**
*/
new_faxrc()
{
	FILE *fp;
	char *str;
	char buf[BUFSIZ];
	struct passwd *pwd;
	struct stat statb;
	pwd = (struct passwd *)getpwuid(getuid());

	if (!get_default_server()) 
		exit(1);
	sprintf(buf,"%s/.faxrc", pwd->pw_dir);
	fp = fopen(buf, "r");
	if (fp != NULL){
		fclose(fp);
		exit(0);;
	}
	fp = fopen(buf, "w");
	if (fp == NULL) {
		perror("Cannot create a default .faxrc file!\n");
		exit(1);
	}
	str = (char *)index(pwd->pw_gecos, ',');
	if (str != NULL)
		*str = NULL;
	str = (char *)getenv("XPRESSFAX_HOME");
	if (str == NULL)
		str = "/usr/xpressfax";
	fprintf(fp, "%s:\t%s\n", XPRESSFAX_HOME_SYMBOL, str);
	fprintf(fp, "%s:\t%s\n", AUTHOR_SYMBOL, pwd->pw_gecos);
	fprintf(fp, "%s:\tServer\n", BANNER_TYPE_SYMBOL);
	fprintf(fp, "%s:\tAddresses\n", FORWARD_SORT_SYMBOL);
	fprintf(fp, "%s:\t%s/doc\n", HELP_SYMBOL, str);
	fprintf(fp, "%s:\tLocal\n", LIST_FROM_SYMBOL);
	fprintf(fp, "%s:\tName\n", LIST_SORT_SYMBOL);
	fprintf(fp, "%s:\tNames\n", LIST_TYPE_SYMBOL);
	fprintf(fp, "%s:\t%s/faxbox/data/listbook\n", LISTBOOK_SYMBOL, 
		pwd->pw_dir);
	if( gethostname(buf, sizeof(buf)) == 0){ 
		fprintf(fp, "%s:\t%s@%s\n", NOTIFY_SUCCESS_SYMBOL, 
			pwd->pw_name, buf);
		fprintf(fp, "%s:\t%s@%s\n", USERLOG_SYMBOL, 
			pwd->pw_name, buf);
	}
	else {
		fprintf(fp, "%s:\t%s\n", NOTIFY_SUCCESS_SYMBOL, pwd->pw_name);
		fprintf(fp, "%s:\t%s\n", USERLOG_SYMBOL, pwd->pw_name);
	}
	fprintf(fp, "%s:\tLocal\n", PHONE_FROM_SYMBOL);
	fprintf(fp, "%s:\tName\n", PHONE_SORT_SYMBOL);
	fprintf(fp, "%s:\tNames\n", PHONE_TYPE_SYMBOL);
	fprintf(fp, "%s:\t%s/faxbox/data/faxbook\n", PHONEBOOK_SYMBOL, pwd->pw_dir);
	fprintf(fp, "%s:\tps\n", PRINTER_NAME_SYMBOL);
	fprintf(fp, "%s:\tYes\n", PRINTER_AUTO_RECV);
	fprintf(fp, "%s:\tAddresses\n", REGISTER_SORT_SYMBOL);
	fprintf(fp, "%s:\tYes\n", TRANSMIT_QUERY_SYMBOL);
	fprintf(fp, "%s:\tYes\n", TRANSMIT_MEMO_SYMBOL);
	fprintf(fp, "%s:\t3\n", TRANSMIT_RETRY_SYMBOL);
	fprintf(fp, "%s:\t10\n", RETRY_DELAY_SYMBOL);
	if (default_server != NULL && *default_server != NULL)
		fprintf(fp, "%s:\t%s\n", SERVER_SYMBOL, default_server);
	else
		fprintf(fp, "%s:\tlocalhost\n", SERVER_SYMBOL);
	if (default_server_password != NULL && *default_server_password) 
		fprintf(fp, "%s:\t%s\n", SERVER_PASSWORD_SYMBOL, 
			default_server_password);
	else
		fprintf(fp, "%s:\t\n", SERVER_PASSWORD_SYMBOL);
	fprintf(fp, "%s:\t%s/faxbox\n", FAXMAIL_SPOOL_SYMBOL, pwd->pw_dir);
	fprintf(fp, "%s:\tServer\n", TRANSMIT_FROM_SYMBOL);
	fprintf(fp, "%s:\tOrgs\n", TRANSMIT_SORT_SYMBOL);
	fprintf(fp, "%s:\tAny\n", TRANSMIT_TIME_SYMBOL);
	fprintf(fp, "%s:\tLists\n", TRANSMIT_TYPE_SYMBOL);
	fprintf(fp, "%s:\tmodem1\n", TRANSMIT_MODEM_SYMBOL);
	fprintf(fp, "%s:\tRead\n", FAXMAIL_FILTER_SYMBOL);
	fprintf(fp, "%s:\tMulti\n", FAXMAIL_PICK_SYMBOL);
	fprintf(fp, "%s:\tNo\n", FAXMAIL_SCRIPT_SYMBOL);
	fprintf(fp, "%s:\tDate\n", FAXMAIL_SORT_SYMBOL);
	fprintf(fp, "%s:\tYes\n", FAXMAIL_ALLOWTEXT_SYMBOL);
	fprintf(fp, "%s:\tYes\n", TRANSMIT_QUERY_SYMBOL);
	fprintf(fp, "%s:\t9x15\n", EDIT_DEFAULT_FONT);
	fprintf(fp, "%s:\t%s/faxbox/tmp\n", TMP_SYMBOL, pwd->pw_dir);
	fprintf(fp, "%s:\t%s/faxbox/data/fontbook\n", 
				FONTBOOK_SYMBOL, pwd->pw_dir);
	fprintf(fp, "%s:\t\n", FAXMAIL_SCRIPTNAME_SYMBOL);
	fclose(fp);


	sprintf(buf, "%s/faxbox", pwd->pw_dir);
	mkdir(buf, DIR_MODE);


	sprintf(buf, "%s/faxbox/tmp", pwd->pw_dir);
	mkdir(buf, DIR_MODE);

	sprintf(buf, "%s/faxbox/data", pwd->pw_dir);
	mkdir(buf, DIR_MODE);

	sprintf(buf, "%s/faxbox/data/faxbook", pwd->pw_dir);
	if (stat(buf, &statb) != 0) {
		if (errno == ENOENT) {
			fp = fopen(buf, "w");
			if (fp != NULL) {
				fprintf(fp, 
			"00000\tXpressWare\tXpressware\t818 584 1048\n");
				fclose(fp);
			}
		} else {
			fprintf(stderr,"Possible error creating %s\n", buf);
		}
	}

	sprintf(buf, "%s/faxbox/data/listbook", pwd->pw_dir);
	if (stat(buf, &statb) != 0) {
		if (errno == ENOENT) {
			fp = fopen(buf, "w");
			if (fp != NULL) {
				fprintf(fp, "00000\tExample List\n");
				fprintf(fp, "\t00000\tXpressWare\tXpressware\t818 584 1048\n");
				fprintf(fp, "\t00000\tGNP Computers\tGNP Computers\t818 577 4263\n");
				fprintf(fp, "\n");
				fclose(fp);
			}
		} else {
			fprintf(stderr,"Possible error creating %s\n", buf);
		}
	}
}

/*
** get_default_server
**
**	Try to read the file /usr/xpressfax/.default-server to acquire default
**	server and server password information.  If this file is not readable
**	or does not exist do not continue.
*/
static int
get_default_server()
{
	FILE *fp;
	char buf[BUFSIZ];
	char *str;
	str = (char *)getenv("XPRESSFAX_HOME");
	if (str == NULL)
		sprintf(buf,"/usr/xpressfax/.default-server");
	else 
		sprintf(buf,"%s/.default-server", str);
	fp = fopen(buf, "r");
	if (fp == NULL) {
		printf("Unable to open %s to read default server.  Aborting...\n",
			buf);
		return(0);
	}
	bzero(default_server, sizeof(default_server));
	bzero(default_server_password, sizeof(default_server_password));
	while (fgets(buf, sizeof(buf), fp) != NULL){
		if (strncmp(buf, "server=", 7) == 0){
			strcpy(default_server, buf+8);
			strip_space(default_server);
		}
		if (strncmp(buf, "passwd=", 7) == 0){
			strcpy(default_server_password, buf+8);
			strip_space(default_server_password);
		}
	}
	fclose(fp);
	if (*default_server == NULL)  {
		printf("No default server defined in %s.\n",
			DEFAULT_SERVER_FILE);
		printf("The line \"server= <hostname>\" must exist in this file\n");
		printf("Will use \"localhost\" for the time being.  Edit your .faxrc file if this is\nincorrect.\n\n");
		strcpy(default_server, "localhost");
		*default_server_password = NULL;
		return(1);
	}
	return(1);
}

/*
** strip_space
**	Remove spaces from the end of a string
**
*/
static void
strip_space(str)
	char *str;
{
	char *ptr;
	ptr = (char *)rindex(str, '\n');
	if (ptr != NULL)
		*ptr = NULL;
}
