;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The Garnet User Interface Development Environment
;;; Copyright (c) 1989, 1990 Carnegie Mellon University
;;; All rights reserved.  The CMU software License Agreement specifies
;;; the terms and conditions for use and redistribution.
;;;
;;; If you want to use this code or anything developed as part of the
;;; Garnet project, please contact Brad Myers (Brad.Myers@CS.CMU.EDU).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; This file loads all the garnet modules.
;;; 
;;; ** To prevent certain parts from being loader, first set
;;;      user::load-XX-p to NIL.
;;; ** To get some of the parts which are not loaded by default to be loaded,
;;;    set user::load-XX-p to T.
;;; ** If you are a non-CMU user, set Your-Garnet-Pathname to be your local
;;;    Garnet directory, and set Your-CLX-Pathname to be your local CLX
;;;    directory.
;;; ** To override where something is loaded from, set Garnet-xx-PathName
;;;    before loading this file and/or Garnet-xx-src
;;;
;;; The controlling variables are:
;;; 
;;;      load-clx-p          (Default: NIL  => clx not loaded)
;;;      load-kr-p           (Default: T  => kr loaded)
;;;      load-opal-p         (Default: T  => opal loaded)
;;;      load-inter-p        (Default: T  => interactors loaded)
;;;      load-aggregadgets-p (Default: T  => aggregadgets loaded)
;;;      load-aggregraphs-p  (Default: NIL => aggregraphs *NOT* loaded)
;;;      load-gadgets-p      (Default: NIL  => gadgets *NOT* loaded)
;;;      load-debug-p        (Default: T  => debugging tools loaded)
;;;      load-demos-p        (Default: NIL  => demos *NOT* loaded)
;;;      load-gilt-p         (Default: NIL  => gilt *NOT* loaded)
;;;      load-lapidary-p     (Default: NIL  => lapidary *NOT* loaded)
;;;
;;; The first part of this file lists the file names where the various
;;; parts of Garnet come from.  This will need to be modified for each new
;;; installation of Garnet.
;;;
;;; To override any particular file name place, it is only necessary to
;;; assign the variable name Garnet-XX-Pathname before this file is loaded
;;; (since they are defined here using defvar, the old name will stay in
;;; affect).
;;;



#|
============================================================
Change log:
	 4/25/91 Ed Pervin - Official release of version 1.4; alpha
				directory changed back to test.  No longer
				support :cmu-lucid3.1 and :cmu-lucid4.0
	 4/19/91 Ed Pervin - Added lispworks to switches	 
	 4/15/91 Ed Pervin - Changed (make-packages **) to
			   (unless (find-package **) (make-package **))
	 4/3/91 Ed Pervin - Changed :sparc-test4.0 --> :sparc-test and
				added :pmax-test.
	 3/21/91 Ed Pervin - Release 1.4; test directory changed to alpha.
         3/7/91 Andrew Mickish - added aggregraphs
	 3/7/91 Brad Myers - made new motif-gilt-loader, and also garnet-load
	 3/1/91 Ed Pervin - added :sparc-test for version compiled in Allegro 4.0
         2/27/91 Dilip D'Souza - added everything with #+allegro-v4.0 switches
	 2/25/91 Ed Pervin - pushed :garnet on *features* list.
         1/24/91 Andrew Mickish - Added Gilt
         1/2/90 Andrew Mickish - Added :rt-test and :sparc-test options.
         11/29/90 Brad Myers - Added :cmu-sparc option.
	 10/5/90 Ed Pervin - New variables Your-Garnet-Pathname and ; 
			Your-CLX-Pathname which determine all the
			:external pathnames.
	 8/9/90 Ed Pervin - Release 1.3
	 8/7/90 Ed Pervin - rbd --> ecp
	 7/25/90 Ed Pervin - Added *dont-load-modules-twice*
			    amickish --> preddy
	 4/2/90 Ed Pervin - Call xlib:load-clx in Lucid explicitly.
	 3/19/90 Ed Pervin - Got rid of Garnet-Font-Pathname
	 2/14/90 Ed Pervin - Added color screen option
	 1/4/90 Ed Pervin - Added :external option and version number
         12/19/89 Ed Pervin - Now loads CLX.
         12/13/89 Ed Pervin - Added :cmu-allegro option.
         12/5/89 Brad Myers - Fixed so works with garnet-compiler
         10/30/89 Brad Myers - New file structure and src directories,
				Change dont-load-xx to load-xxx-p
         10/17/89 Brad Myers - Added debug
         8/18/89 Brad Myers - Added Toolkit
         6/7/89 Brad Myers - Created
============================================================
|#

;; The function provide is no longer part of common lisp and so was
;; removed from the lisp package in the most recent release of
;; LispWorks (version 2.1 onwards). This will retrieve its definition.
#+lispworks (setf (symbol-function 'lisp::provide)
                  (symbol-function 'system::provide))
#+lispworks (export 'provide 'lisp)

#+allegro-v4.0
(setf excl::*cltl1-in-package-compatibility-p* t)
#+allegro-v4.0
(setf comp:*cltl1-compile-file-toplevel-compatibility-p* t)

(in-package "USER" :use '("LISP"))

#+(or allegro-v4.0 lispworks)
(progn
  (unless (find-package "KR")
	  (make-package "KR" :use '("LISP" "CLTL1")))
  (unless (find-package "KR-DEBUG")
	  (make-package "KR-DEBUG" :use '("LISP" "CLTL1")))
  (unless (find-package "OPAL")
	  (make-package "OPAL" :use '("LISP" "KR" "CLTL1")))
  (unless (find-package "GARNET-GADGETS")
	  (make-package "GARNET-GADGETS" :use '("LISP" "CLTL1")))
  (unless (find-package "GARNET-DEBUG")
	  (make-package "GARNET-DEBUG" :use '("OPAL" "KR" "LISP" "CLTL1")))
  (unless (find-package "INTERACTORS")
	  (make-package "INTERACTORS" :use '("KR" "LISP" "CLTL1"))))

(defparameter Garnet-Version-Number "1.4")
(push :GARNET *features*)
(push :GARNET-V1.4 *features*)

;; 0 is primary screen (black and white on Sun)
;; 1 is secondary screen (color on Sun)
(defparameter Garnet-Screen-Number 0)

;;; Garnet-Version controls where the files are loaded from/
;;; Because this is a defvar, if Garnet-Version is set before this file is
;;; loaded, its original value will be used.

(defvar Garnet-Version :sparc-test)
	;; options are:
	;;	:test for the testing version
        ;;      :rt-test for the testing version compiled for the RT
        ;;      :sparc-test for the testing version compiled for the Sparc Station
	;;	:cmu for the released version for CMU CommonLisp
        ;;      :cmu-sparc for released version for Allegro on a Sparc Station
	;;	:cmu-pmax for releaseved version compiled for the PMax
	;;	:external for all other non-CMU versions


(format T "** Garnet Version being loaded is ~s~%" Garnet-Version)

;;; *dont-load-modules-twice* tells whether to re-load modules
;;; if a user loads garnet-loader.lisp a second time.
(defparameter *dont-load-modules-twice* t)

;;; load-XX-p control whether the various parts are loaded or not
;;; Because these use defvar, if they are set before this file is
;;; loaded, their original value will be used.

(defvar load-clx-p #+(or cmu allegro-v4.0) NIL #-(or cmu allegro-v4.0) T)
(defvar load-kr-p T)
(defvar load-opal-p T)
(defvar load-inter-p T)
(defvar load-aggregadgets-p T)
(defvar load-aggregraphs-p NIL)
(defvar load-debug-p T)
(defvar load-gadgets-p NIL)
(defvar load-demos-p NIL)
(defvar load-lapidary-p T)
(defvar load-gilt-p NIL)

;;; Insert your pathname of Garnet into Your-Garnet-Pathname and where
;;; your CLX comes from into Your-CLX-pathname.  For example:
;;; (defvar Your-CLX-Pathname "/usr/local/lisp/clx/")
;;; (defvar Your-Garnet-Pathname "/usr/your-name/garnet/")
;;; All the :external pathnames will depend on these two pathnames.

(defvar Your-CLX-Pathname "<your clx pathname>")       ;;; SET THIS
(defvar Your-Garnet-Pathname "<your garnet pathname>") ;;; SET THIS

(defvar CLX-PathName
  (case Garnet-Version
    (:external Your-CLX-Pathname)
    (:sparc-test "/usr/misc/.allegro/lib/code/")
    (:cmu-pmax "/usr/misc/.allegro/lib/code/")
    (:cmu-sparc  "/usr/misc/.allegro/lib/code/")
    (T NIL)))

(defvar Garnet-KR-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/kr/"))
    (:test "/afs/cs/user/dzg/garnet/kr/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/kr/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/kr/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/kr/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/kr/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/kr/")
    (T (error "No version for KR"))))
(defvar Garnet-KR-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/kr/"))
    (:test "/afs/cs/user/dzg/garnet/kr/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/kr/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/kr/")
    (T (error "No version for KR"))))

(defvar Garnet-Opal-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/opal/"))
    (:test "/afs/cs/user/ecp/garnet/opal/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/opal/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/opal/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/opal/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/opal/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/opal/")
    (T (error "No version for Opal"))))
(defvar Garnet-Opal-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/opal/"))
    (:test "/afs/cs/user/ecp/garnet/opal/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/opal/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/opal/")
    (T (error "No version for Opal"))))

(defvar Garnet-Inter-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/inter/"))
    (:test "/afs/cs/user/bam/garnet/inter/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/inter/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/inter/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/inter/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/inter/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/inter/")
    (T (error "No version for Inter"))))
(defvar Garnet-Inter-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/inter/"))
    (:test "/afs/cs/user/bam/garnet/inter/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/inter/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/inter/")
    (T (error "No version for Inter"))))

(defvar Garnet-Aggregadgets-PathName 
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/aggregadgets/"))
    (:test "/afs/cs/user/ecp/garnet/aggregadgets/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/aggregadgets/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/aggregadgets/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/aggregadgets/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/aggregadgets/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/aggregadgets/")
    (T (error "No version for Aggregadgets"))))
(defvar Garnet-Aggregadgets-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/aggregadgets/"))
    (:test "/afs/cs/user/ecp/garnet/aggregadgets/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/aggregadgets/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/aggregadgets/")
    (T (error "No version for Aggregadgets"))))

(defvar Garnet-Gadgets-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/gadgets/"))
    (:test "/afs/cs/user/preddy/garnet/gadgets")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/gadgets/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/gadgets/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/gadgets/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/gadgets/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/gadgets/")
    (T (error "No version for Gadgets"))))
(defvar Garnet-Gadgets-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/gadgets/"))
    (:test "/afs/cs/user/preddy/garnet/gadgets/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/gadgets/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/gadgets/")
    (T (error "No version for Gadgets"))))

(defvar Garnet-Debug-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/debug/"))
    (:test "/afs/cs/user/ecp/garnet/debug/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/debug/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/debug/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/debug/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/debug/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/debug/")
    (T (error "No version for Debug"))))
(defvar Garnet-Debug-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/debug/"))
    (:test "/afs/cs/user/ecp/garnet/debug/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/debug/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/debug/")
    (T (error "No version for Debug"))))

(defvar Garnet-Demos-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/demos/"))
    (:test "/afs/cs/user/oh/garnet/demos/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/demos/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/demos/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/demos/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/demos/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/demos/")
    (T (error "No version for Demos"))))
(defvar Garnet-Demos-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/demos/"))
    (:test "/afs/cs/user/oh/garnet/demos/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/demos/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/demos/")
    (T (error "No version for Demos"))))

(defvar Garnet-Lapidary-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/lapidary/"))
    (:test "/afs/cs/user/bvz/garnet/lapidary/")
    (:rt-test "/afs/cs/project/garnet/rt-bin/lapidary/")
    (:sparc-test "/afs/cs/user/bvz/garnet/lapidary/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/lapidary/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/lapidary/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/lapidary/")
    (T (error "No version for Lapidary"))))
(defvar Garnet-Lapidary-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/lapidary/"))
    (:test "/afs/cs/user/bvz/garnet/lapidary/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/lapidary/")
    ((:rt-test :sparc-test :cmu-pmax :cmu :cmu-sparc)
     "/afs/cs/user/bvz/garnet/src/lapidary/")
    (T (error "No version for Lapidary"))))

(defvar Garnet-Gilt-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "bin/gilt/"))
    (:test "/afs/cs/user/bam/garnet/gilt/")
    (:rt-test "/afs/cs/project/garnet/test/rt-bin/gilt/")
    (:sparc-test "/afs/cs/project/garnet/test/sparc-bin/gilt/")
    (:cmu-pmax "/afs/cs/project/garnet/pmax-bin/gilt/")
    (:cmu  "/afs/cs/project/garnet/rt-bin/gilt/")
    (:cmu-sparc   "/afs/cs/project/garnet/sparc-bin/gilt/")
    (T (error "No version for Gilt"))))
(defvar Garnet-Gilt-Src
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "src/gilt/"))
    (:test "/afs/cs/user/bam/garnet/gilt/")
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/src/gilt/")
    ((:rt-test :sparc-test) "/afs/cs/project/garnet/test/src/gilt/")
    (T (error "No version for Gilt"))))

;; Directory used for cursors and bitmaps
(defvar Garnet-Bitmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/bitmaps/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/lib/bitmaps/")
    ((:test :rt-test :sparc-test) "/afs/cs/project/garnet/test/lib/bitmaps/")
    (T (error "No version for bitmap"))))

;; Directory used for bitmaps and things needed by Gilt
(defvar Garnet-Gilt-Bitmap-PathName
  (case Garnet-Version
    (:external (concatenate 'string Your-Garnet-Pathname "lib/gilt/"))
    ((:cmu :cmu-sparc :cmu-pmax) "/afs/cs/project/garnet/lib/gilt/")
    ((:test :rt-test :sparc-test) "/afs/cs/project/garnet/test/lib/gilt/")
    (T (error "No version for Gilt bitmaps"))))

;;;----------------------------------------------------------

;;; When compiling, the binaries will be in the same directories as the
;;; source files, so make all the path names be the same
;;;
;;; After compilation is finished, the user should move all the binaries
;;; into their own directories, as specified the the pathnames above.

(when (and (boundp '*Garnet-Going-To-Compile*)
	   *Garnet-Going-To-Compile*)
  (setf Garnet-KR-Pathname Garnet-KR-Src)
  (setf Garnet-Opal-Pathname Garnet-Opal-Src)
  (setf Garnet-Inter-Pathname Garnet-Inter-Src)
  (setf Garnet-Aggregadgets-Pathname Garnet-Aggregadgets-Src)
  (setf Garnet-Gadgets-Pathname Garnet-Gadgets-Src)
  (setf Garnet-Debug-Pathname Garnet-Debug-Src)
  (setf Garnet-Demos-Pathname Garnet-Demos-Src)
  (setf Garnet-Lapidary-Pathname Garnet-Lapidary-Src)
  (setf Garnet-Gilt-Pathname Garnet-Gilt-Src)
  )

;;;----------------------------------------------------------

;;; If at cmu, then set up the search lists
#+cmu
(progn
  (unless (ext:search-list "kr:")
    (setf (ext:search-list "kr:")
	  (list Garnet-KR-PathName)))
  (unless (ext:search-list "kr-src:")
    (setf (ext:search-list "kr-src:")
	  (list Garnet-KR-Src)))

  (unless (ext:search-list "opal:")
    (setf (ext:search-list "opal:")
	  (list Garnet-Opal-PathName)))
  (unless (ext:search-list "opal-src:")
    (setf (ext:search-list "opal-src:")
	  (list Garnet-Opal-Src)))

  (unless (ext:search-list "inter:")
    (setf (ext:search-list "inter:")
	  (list Garnet-Inter-PathName)))
  (unless (ext:search-list "inter-src:")
    (setf (ext:search-list "inter-src:")
	  (list Garnet-Inter-Src)))

  (unless (ext:search-list "aggregadgets:")
    (setf (ext:search-list "aggregadgets:")
	  (list Garnet-Aggregadgets-PathName)))
  (unless (ext:search-list "aggregadgets-src:")
    (setf (ext:search-list "aggregadgets-src:")
	  (list Garnet-Aggregadgets-Src)))

  (unless (ext:search-list "gadgets:")
    (setf (ext:search-list "gadgets:")
	  (list Garnet-Gadgets-PathName)))
  (unless (ext:search-list "gadgets-src:")
    (setf (ext:search-list "gadgets-src:")
	  (list Garnet-Gadgets-Src)))

  (unless (ext:search-list "debug:")
    (setf (ext:search-list "debug:")
	  (list Garnet-Debug-PathName)))
  (unless (ext:search-list "debug-src:")
    (setf (ext:search-list "debug-src:")
	  (list Garnet-Debug-Src)))

  (unless (ext:search-list "demos:")
    (setf (ext:search-list "demos:")
	  (list Garnet-Demos-PathName)))
  (unless (ext:search-list "demos-src:")
    (setf (ext:search-list "demos-src:")
	  (list Garnet-Demos-Src)))

  (unless (ext:search-list "lapidary:")
    (setf (ext:search-list "lapidary:")
	  (list Garnet-Lapidary-PathName)))
  (unless (ext:search-list "lapidary-src:")
    (setf (ext:search-list "lapidary-src:")
	  (list Garnet-Lapidary-Src)))

  (unless (ext:search-list "gilt:")
    (setf (ext:search-list "gilt:")
	  (list Garnet-Gilt-PathName)))
  (unless (ext:search-list "gilt-src:")
    (setf (ext:search-list "gilt-src:")
	  (list Garnet-Gilt-Src)))
  )

(defparameter CLX-Loader
  (when CLX-PathName
    #+allegro (merge-pathnames "clx" CLX-Pathname)
    #+lucid (merge-pathnames "defsystem" CLX-Pathname)))

(defparameter Garnet-KR-Loader
  (merge-pathnames "kr-loader"
		   #+cmu "kr:"
		   #+(not cmu) Garnet-KR-PathName))

(defparameter Garnet-Opal-Loader
  (merge-pathnames "opal-loader"
		   #+cmu "opal:"
		   #+(not cmu) Garnet-Opal-PathName))

(defparameter Garnet-Inter-Loader
  (merge-pathnames "inter-loader"
		   #+cmu "inter:"
		   #+(not cmu) Garnet-Inter-PathName))

(defparameter Garnet-Aggregadgets-Loader
  (merge-pathnames "aggregadgets-loader"
		   #+cmu "aggregadgets:"
		   #+(not cmu) Garnet-Aggregadgets-PathName))

(defparameter Garnet-Aggregraphs-Loader
  (merge-pathnames "aggregraphs-loader"
		   #+cmu "aggregadgets:"
		   #+(not cmu) Garnet-Aggregadgets-PathName))

(defparameter Garnet-Gadgets-Loader
  (merge-pathnames "gadgets-loader"
		   #+cmu "gadgets:"
		   #+(not cmu) Garnet-Gadgets-PathName))

(defparameter Garnet-Debug-Loader
  (merge-pathnames "debug-loader"
		   #+cmu "debug:"
		   #+(not cmu) Garnet-Debug-PathName))

(defparameter Garnet-Demos-Loader
  (merge-pathnames "demos-loader"
		   #+cmu "demos:"
		   #+(not cmu) Garnet-Demos-PathName))

(defparameter Garnet-Lapidary-Loader
  (merge-pathnames "lapidary-loader"
		   #+cmu "lapidary:"
		   #+(not cmu) Garnet-Lapidary-PathName))

(defparameter Garnet-Gilt-Loader
  (merge-pathnames "gilt-loader"
		   #+cmu "gilt:"
		   #+(not cmu) Garnet-Gilt-PathName))

(defparameter Garnet-Motif-Gilt-Loader
  (merge-pathnames "motif-gilt-loader"
		   #+cmu "gilt:"
		   #+(not cmu) Garnet-Gilt-PathName))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 


(format t "...Loading Garnet ...~%")
(setf *load-verbose* t)

;;;Patches for CLX on the RT.
;;;(load "/afs/cs/project/clisp-1/chiles/archive/clx-r3/clx")
;;;(load "/afs/cs/project/clisp-1/chiles/archive/clx-r3/display")

(when load-clx-p
   (format T "~% %%%%%%% Loading CLX %%%%%%%%~%")
   (load CLX-Loader))
#+lucid
(when load-clx-p
#+lcl3.0 (funcall (find-symbol 'load-clx 'xlib) CLX-Pathname)
#-lcl3.0 (     load-clx CLX-Pathname))
#-cmu
(unless load-clx-p (format T "~%****** NOT Loading CLX *******~%"))

(if load-kr-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :kr))
	(format T "~%****** KR already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading KR %%%%%%%%~%")
          (load Garnet-KR-Loader)))
    (format T "~%****** NOT Loading KR *******~%"))

(if load-opal-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :opal))
	(format T "~%****** Opal already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Opal %%%%%%%%~%")
          (load Garnet-Opal-Loader)))
    (format T "~%****** NOT Loading Opal *******~%"))

(if load-inter-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :inter))
	(format T "~%****** Interactors already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Interactors %%%%%%%%~%")
          (load Garnet-Inter-Loader)))
    (format T "~%****** NOT Loading Interactors *******~%"))

(if load-aggregadgets-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregadgets))
	(format T "~%****** Aggregadgets already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Aggregadgets %%%%%%%%~%")
          (load Garnet-Aggregadgets-Loader)))
    (format T "~%****** NOT Loading Aggregadgets *******~%"))

(if load-aggregraphs-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :aggregraphs))
	(format T "~%****** Aggregraphs already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Aggregraphs %%%%%%%%~%")
          (load Garnet-Aggregraphs-Loader)))
    (format T "~%****** NOT Loading Aggregraphs *******
** To load aggregraph programs, execute (load Garnet-Aggregraphs-Loader)~%"))


(if load-gadgets-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :gadgets))
	(format T "~%****** Gadgets already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Gadgets %%%%%%%%~%")
          (load Garnet-Gadgets-Loader)))
    (format T "~%****** NOT Loading Gadgets *******~%"))

(if load-debug-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :debug))
	(format T "~%****** Debugging programs already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Debugging programs %%%%%%%%~%")
          (load Garnet-Debug-Loader)))
    (format T "~%****** NOT Loading DEBUG Files *******
** To load debug programs, execute (load Garnet-Debug-Loader)~%"))

(if load-demos-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :demos))
	(format T "~%****** Demos already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Demos %%%%%%%%~%")
          (load Garnet-Demos-Loader)))
    (format T "~%****** NOT Loading Demos *******
** To load Demos, execute (load Garnet-Demos-Loader)~%"))

(if load-lapidary-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :lapidary))
	(format T "~%****** Lapidary already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Lapidary %%%%%%%%~%")
          (load Garnet-Lapidary-Loader)))
    (format T "~%****** NOT Loading Lapidary *******
** To load Lapidary, execute (load Garnet-Lapidary-Loader)~%"))

(if load-gilt-p
    (if (and *dont-load-modules-twice* (get :garnet-modules :gilt))
	(format T "~%****** Gilt already loaded *******~%")
        (progn
          (format T "~% %%%%%%%% Loading Gilt %%%%%%%%~%")
          (load Garnet-Gilt-Loader)))
    (format T "~%****** NOT Loading Gilt *******
** To load Gilt, execute (load Garnet-Gilt-Loader) or
   (load Garnet-Motif-Gilt-Loader)~%"))

(defun user::Garnet-Load (filename)
  (let ((pos (position #\: filename)))
    (if pos
	(let* ((head (subseq filename 0 pos))
	       (tail (subseq filename (1+ pos)))
	       (prefix (cond
			 ((string= head "clx") CLX-PathName)
			 ((string= head "kr") Garnet-KR-PathName)
			 ((string= head "opal") Garnet-Opal-PathName)
			 ((string= head "inter") Garnet-Inter-PathName)
			 ((string= head "aggregadgets") Garnet-Aggregadgets-PathName)
			 ((string= head "gadgets") Garnet-Gadgets-PathName)
			 ((string= head "debug") Garnet-Debug-PathName)
			 ((string= head "demos") Garnet-Demos-PathName)
			 ((string= head "demo") Garnet-Demos-PathName)
			 ((string= head "lapidary") Garnet-Lapidary-PathName)
			 ((string= head "gilt") Garnet-Gilt-PathName)
			 (t (error "Bad prefix ~%" head))))
	       (finalname (merge-pathnames tail prefix)))
	  (format T "Loading ~s~%" finalname)
	  (load finalname))
	;; else no colon, load regular
	(progn
	  (format T "NO COLON, Loading ~s~%" filename)
	  (load filename)))))


(format t "~%... Garnet Load Complete ...~%")

(format t "~%... Loading Demo Files ...~%")
(load "/afs/cs/user/bvz/garnet/lapidary/demo/which-color")
(load "/afs/cs/user/bvz/garnet/lapidary/demo/checkers")

(format t "~%... Checkers Demo Loaded ...~%")
(format t "~%... Type (do-go) to start the demo ...~%")
(format t "~%... All operations use the left mouse button ...~%")

