/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SeekCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        if (argv.length != 3 && argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "channelId offset ?origin?");
        }
        int mode = 1;
        if (argv.length == 4) {
            if ("start".equals(argv[3].toString())) {
                mode = 1;
            } else if ("current".equals(argv[3].toString())) {
                mode = 2;
            } else if ("end".equals(argv[3].toString())) {
                mode = 3;
            } else {
                throw new TclException(interp, "bad origin \"" + argv[3].toString() + "\": should be start, current, or end");
            }
        }
        if ((chan = TclIO.getChannel(interp, argv[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        long offset = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        try {
            chan.seek(offset, mode);
        }
        catch (IOException e) {
            throw new TclException(interp, "error during seek on \"" + chan.getChanName() + "\": invalid argument");
        }
    }

    SeekCmd() {
    }
}

