/*
 * tkReregWin.c
 *	The following logically belongs in tkWindow.c
 */
#include "tk.h"
#include "tkInt.h"


/*
 *----------------------------------------------------------------------
 *
 * Tk_ReregWindow --
 *
 *	Re-register the interpreter for an application under a new name.
 *
 * Results:
 *	TCL_OK or TCL_ERROR.  If TCL_ERROR is returned,
 *	an error message will be left in interp->result.
 *
 * Side effects:
 *	"interp" is registered for "send" commands
 *	under "baseName".  BaseName may be extended with an instance
 *	number in the form "#2" if necessary to make it globally
 *	unique.  The TCL send command is bound to the interpreter.
 *
 *----------------------------------------------------------------------
 */

int
Tk_ReregWindow(interp, tkwin, baseName)
    Tcl_Interp *interp;		/* Interpreter associated with window */
    Tk_Window tkwin;		/* Main window to re-register */
    char *baseName;		/* Base name for application;  usually of the
				 * form "prog instance". */
{
    TkWindow *winPtr = (TkWindow *) tkwin;
    int result;
    char newName[110];
    /*
     * Deleting the "send" command has the side-effect of unregistering
     * the interpreter.
     */
    Tcl_DeleteCommand(interp, "send");
    /*
     * Register the interpreter.
     */
    strcpy(newName, baseName);
    result = Tk_RegisterInterp(interp, newName, tkwin);
    if (result != TCL_OK) {
	int i;

	for (i = 2; ; i++) {
	    sprintf(newName, "%.100s #%d", baseName, i);
	    Tcl_SetResult(interp, (char *) NULL, TCL_STATIC);
	    result = Tk_RegisterInterp(interp, newName, tkwin);
	    if (result == TCL_OK) {
		break;
	    }
	    if (i >= 100) {
		Tcl_SetResult(interp,
			"couldn't generate unique name to register application",
			TCL_STATIC);
		return TCL_ERROR;
	    }
	}
    }
    winPtr->nameUid = Tk_GetUid(newName);
    return TCL_OK;
}

