/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Package;
import tcl.lang.PkgAvail;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VersionSatisfiesResult;

class PackageCmd
implements Command {
    private static final String[] validCmds = new String[]{"forget", "ifneeded", "names", "provide", "require", "unknown", "vcompare", "versions", "vsatisfies"};
    private static final int OPT_FORGET = 0;
    private static final int OPT_IFNEEDED = 1;
    private static final int OPT_NAMES = 2;
    private static final int OPT_PROVIDE = 3;
    private static final int OPT_REQUIRE = 4;
    private static final int OPT_UNKNOWN = 5;
    private static final int OPT_VCOMPARE = 6;
    private static final int OPT_VERSIONS = 7;
    private static final int OPT_VSATISFIES = 8;

    static void pkgProvide(Interp interp, String string, String string2) throws TclException {
        PackageCmd.checkVersion(interp, string2);
        Package package_ = PackageCmd.findPackage(interp, string);
        if (package_.version == null) {
            package_.version = string2;
            return;
        }
        if (PackageCmd.compareVersions(package_.version, string2, null) != 0) {
            throw new TclException(interp, "conflicting versions provided for package \"" + string + "\": " + package_.version + ", then " + string2);
        }
    }

    static String pkgRequire(Interp interp, String string, String string2, boolean bl) throws TclException {
        StringBuffer stringBuffer;
        int n;
        Package package_;
        if (string2 == null && bl) {
            throw new TclException(interp, "conflicting arguments : version == null and exact == true");
        }
        if (string2 != null) {
            PackageCmd.checkVersion(interp, string2);
        }
        VersionSatisfiesResult versionSatisfiesResult = new VersionSatisfiesResult();
        int n2 = 1;
        while (true) {
            String string3;
            package_ = PackageCmd.findPackage(interp, string);
            if (package_.version != null) break;
            PkgAvail pkgAvail = null;
            PkgAvail pkgAvail2 = package_.avail;
            while (pkgAvail2 != null) {
                if (!(pkgAvail != null && PackageCmd.compareVersions(pkgAvail2.version, pkgAvail.version, null) <= 0 || string2 != null && ((n = PackageCmd.compareVersions(pkgAvail2.version, string2, versionSatisfiesResult)) != 0 && bl || !versionSatisfiesResult.satisfies))) {
                    pkgAvail = pkgAvail2;
                }
                pkgAvail2 = pkgAvail2.next;
            }
            if (pkgAvail != null) {
                string3 = pkgAvail.script;
                try {
                    interp.eval(string3, 1);
                }
                catch (TclException tclException) {
                    interp.addErrorInfo("\n    (\"package ifneeded\" script)");
                    throw tclException;
                }
                interp.resetResult();
                package_ = PackageCmd.findPackage(interp, string);
                break;
            }
            if (n2 > true) break;
            string3 = interp.packageUnknown;
            if (string3 != null) {
                stringBuffer = new StringBuffer();
                try {
                    Util.appendElement(interp, stringBuffer, string3);
                    Util.appendElement(interp, stringBuffer, string);
                    if (string2 == null) {
                        Util.appendElement(interp, stringBuffer, "");
                    } else {
                        Util.appendElement(interp, stringBuffer, string2);
                    }
                    if (bl) {
                        Util.appendElement(interp, stringBuffer, "-exact");
                    }
                }
                catch (TclException tclException) {
                    throw new TclRuntimeError("unexpected TclException: " + tclException);
                }
                try {
                    interp.eval(stringBuffer.toString(), 1);
                }
                catch (TclException tclException) {
                    interp.addErrorInfo("\n    (\"package unknown\" script)");
                    throw tclException;
                }
                interp.resetResult();
            }
            ++n2;
        }
        if (package_.version == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("can't find package " + string);
            if (string2 != null) {
                stringBuffer.append(" " + string2);
            }
            throw new TclException(interp, stringBuffer.toString());
        }
        if (string2 == null) {
            return package_.version;
        }
        n = PackageCmd.compareVersions(package_.version, string2, versionSatisfiesResult);
        if (versionSatisfiesResult.satisfies && !bl || n == 0) {
            return package_.version;
        }
        throw new TclException(interp, "version conflict for package \"" + string + "\": have " + package_.version + ", need " + string2);
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                int n2 = 2;
                while (n2 < tclObjectArray.length) {
                    String string;
                    Package package_;
                    TclObject tclObject = tclObjectArray[n2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    if ((package_ = (Package)interp.packageTable.get(string = tclObject.stringRep)) != null) {
                        interp.packageTable.remove(string);
                        while (package_.avail != null) {
                            PkgAvail pkgAvail = package_.avail;
                            package_.avail = pkgAvail.next;
                            pkgAvail = null;
                        }
                        package_ = null;
                    }
                    ++n2;
                }
                return;
            }
            case 1: {
                Package package_;
                if (tclObjectArray.length < 4 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "ifneeded package version ?script?");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                String string = ((TclObject)object).stringRep;
                object = tclObjectArray[3];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                String string2 = ((TclObject)object).stringRep;
                PackageCmd.checkVersion(interp, string2);
                if (tclObjectArray.length == 4) {
                    package_ = (Package)interp.packageTable.get(string);
                    if (package_ == null) {
                        return;
                    }
                } else {
                    package_ = PackageCmd.findPackage(interp, string);
                }
                PkgAvail pkgAvail = package_.avail;
                PkgAvail pkgAvail2 = null;
                while (pkgAvail != null) {
                    if (PackageCmd.compareVersions(pkgAvail.version, string2, null) == 0) {
                        if (tclObjectArray.length != 4) break;
                        object = pkgAvail.script;
                        if (object == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)object));
                        return;
                    }
                    pkgAvail2 = pkgAvail;
                    pkgAvail = pkgAvail.next;
                }
                if (tclObjectArray.length == 4) {
                    return;
                }
                if (pkgAvail == null) {
                    pkgAvail = new PkgAvail();
                    pkgAvail.version = string2;
                    if (pkgAvail2 == null) {
                        pkgAvail.next = package_.avail;
                        package_.avail = pkgAvail;
                    } else {
                        pkgAvail.next = pkgAvail2.next;
                        pkgAvail2.next = pkgAvail;
                    }
                }
                object = tclObjectArray[4];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                pkgAvail.script = ((TclObject)object).stringRep;
                return;
            }
            case 2: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "names");
                }
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    Enumeration enumeration = interp.packageTable.keys();
                    boolean bl = false;
                    while (enumeration.hasMoreElements()) {
                        bl = true;
                        String string = (String)enumeration.nextElement();
                        Package package_ = (Package)interp.packageTable.get(string);
                        if (package_.version == null && package_.avail == null) continue;
                        Util.appendElement(interp, stringBuffer, string);
                    }
                    if (bl) {
                        String string = stringBuffer.toString();
                        if (string == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance(string));
                        return;
                    }
                }
                catch (TclException tclException) {
                    throw new TclRuntimeError("unexpected TclException: " + tclException);
                }
                return;
            }
            case 3: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "provide package ?version?");
                }
                if (tclObjectArray.length == 3) {
                    Package package_;
                    Hashtable hashtable = interp.packageTable;
                    Object object = tclObjectArray[2];
                    if (((TclObject)object).stringRep == null) {
                        ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                    }
                    if ((package_ = (Package)hashtable.get(((TclObject)object).stringRep)) != null && package_.version != null) {
                        object = package_.version;
                        if (object == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)object));
                    }
                    return;
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string = tclObject.stringRep;
                tclObject = tclObjectArray[3];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                PackageCmd.pkgProvide(interp, string, tclObject.stringRep);
                return;
            }
            case 4: {
                if (tclObjectArray.length < 3 || tclObjectArray.length > 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "require ?-exact? package ?version?");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                int n3 = tclObject.stringRep.equals("-exact") ? 1 : 0;
                String string = null;
                if (tclObjectArray.length == 4 + n3) {
                    tclObject = tclObjectArray[3 + n3];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    string = tclObject.stringRep;
                } else if (tclObjectArray.length != 3 || n3 == 1) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "require ?-exact? package ?version?");
                }
                if (n3 == 1) {
                    tclObject = tclObjectArray[3];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    string = PackageCmd.pkgRequire(interp, tclObject.stringRep, string, true);
                } else {
                    tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    string = PackageCmd.pkgRequire(interp, tclObject.stringRep, string, false);
                }
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(string));
                return;
            }
            case 5: {
                if (tclObjectArray.length > 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "unknown ?command?");
                }
                if (tclObjectArray.length == 2) {
                    if (interp.packageUnknown != null) {
                        String string = interp.packageUnknown;
                        if (string == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance(string));
                        return;
                    }
                } else if (tclObjectArray.length == 3) {
                    String string;
                    interp.packageUnknown = null;
                    TclObject tclObject = tclObjectArray[2];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    if ((string = tclObject.stringRep).length() > 0) {
                        interp.packageUnknown = string;
                    }
                }
                return;
            }
            case 6: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "vcompare version1 version2");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string = tclObject.stringRep;
                tclObject = tclObjectArray[3];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string3 = tclObject.stringRep;
                PackageCmd.checkVersion(interp, string);
                PackageCmd.checkVersion(interp, string3);
                int n4 = PackageCmd.compareVersions(string, string3, null);
                interp.setResult(TclInteger.newInstance(n4));
                return;
            }
            case 7: {
                Package package_;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "versions package");
                }
                Hashtable hashtable = interp.packageTable;
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                if ((package_ = (Package)hashtable.get(((TclObject)object).stringRep)) != null) {
                    try {
                        StringBuffer stringBuffer = new StringBuffer();
                        boolean bl = false;
                        PkgAvail pkgAvail = package_.avail;
                        while (pkgAvail != null) {
                            bl = true;
                            Util.appendElement(interp, stringBuffer, pkgAvail.version);
                            pkgAvail = pkgAvail.next;
                        }
                        if (bl) {
                            object = stringBuffer.toString();
                            if (object == null) {
                                interp.resetResult();
                                return;
                            }
                            interp.setResult(TclString.newInstance((String)object));
                            return;
                        }
                    }
                    catch (TclException tclException) {
                        throw new TclRuntimeError("unexpected TclException: " + tclException);
                    }
                }
                return;
            }
            case 8: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "vsatisfies version1 version2");
                }
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string = tclObject.stringRep;
                tclObject = tclObjectArray[3];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                String string4 = tclObject.stringRep;
                PackageCmd.checkVersion(interp, string);
                PackageCmd.checkVersion(interp, string4);
                VersionSatisfiesResult versionSatisfiesResult = new VersionSatisfiesResult();
                PackageCmd.compareVersions(string, string4, versionSatisfiesResult);
                boolean bl = versionSatisfiesResult.satisfies;
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
        }
        throw new TclRuntimeError("TclIndex.get() error");
    }

    private static Package findPackage(Interp interp, String string) throws TclException {
        if (string == null || string.length() == 0) {
            throw new TclException(interp, "expected package name but got \"\"");
        }
        Package package_ = (Package)interp.packageTable.get(string);
        if (package_ == null) {
            package_ = new Package();
            interp.packageTable.put(string, package_);
        }
        return package_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkVersion(Interp interp, String string) throws TclException {
        boolean bl;
        block10: {
            block11: {
                block9: {
                    bl = true;
                    try {
                        if (string == null || string.length() == 0) {
                            string = "";
                            Object var7_3 = null;
                            if (!bl) return;
                            throw new TclException(interp, "expected version number but got \"" + string + "\"");
                        }
                        if (!Character.isDigit(string.charAt(0))) {
                            break block9;
                        }
                        int n = string.length();
                        int n2 = 1;
                        while (true) {
                            if (n2 >= n) {
                                if (string.charAt(n - 1) != '.') {
                                    return;
                                }
                                break block10;
                            }
                            char c = string.charAt(n2);
                            if (!Character.isDigit(c) && c != '.') {
                                break block11;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (!bl) throw throwable;
                        throw new TclException(interp, "expected version number but got \"" + string + "\"");
                    }
                }
                Object var7_4 = null;
                if (!bl) return;
                throw new TclException(interp, "expected version number but got \"" + string + "\"");
            }
            Object var7_5 = null;
            if (!bl) return;
            throw new TclException(interp, "expected version number but got \"" + string + "\"");
        }
        Object var7_6 = null;
        if (!bl) return;
        throw new TclException(interp, "expected version number but got \"" + string + "\"");
    }

    private static int compareVersions(String string, String string2, VersionSatisfiesResult versionSatisfiesResult) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        if (string == null || string2 == null) {
            throw new TclRuntimeError("null version in package version compare");
        }
        String[] stringArray = PackageCmd.split(string, '.');
        String[] stringArray2 = PackageCmd.split(string2, '.');
        if (stringArray.length == 0 || stringArray2.length == 0) {
            throw new TclRuntimeError("version length is 0");
        }
        int n3 = stringArray.length > stringArray2.length ? stringArray.length : stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            n2 = 0;
            n = 0;
            try {
                if (n4 < stringArray.length) {
                    n = Integer.parseInt(stringArray[n4]);
                }
                if (n4 < stringArray2.length) {
                    n2 = Integer.parseInt(stringArray2[n4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new TclRuntimeError("NumberFormatException for package versions \"" + string + "\" or \"" + string2 + "\"");
            }
            if (n != n2) break;
            bl = false;
            ++n4;
        }
        if (versionSatisfiesResult != null) {
            boolean bl2 = versionSatisfiesResult.satisfies = n == n2 || n > n2 && !bl;
        }
        if (n > n2) {
            return 1;
        }
        if (n == n2) {
            return 0;
        }
        return -1;
    }

    static String[] split(String string, char c) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 0);
        cArray[n2++] = c;
        Vector<String> vector = new Vector<String>(5);
        int n3 = 0;
        while (n3 < n2) {
            if (cArray[n3] == c) {
                if (n <= n3 - 1) {
                    vector.addElement(new String(cArray, n, n3 - n));
                }
                n = n3 + 1;
            }
            ++n3;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    PackageCmd() {
    }
}

