/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class TclClassLoader
extends ClassLoader {
    private static Hashtable classes = new Hashtable();
    private String[] classpath;
    private String[] loadpath;
    private String lastSearchedClassFile = null;
    private String lastSearchedJarFile = null;

    TclClassLoader(Interp interp, TclObject tclObject) {
        try {
            int n;
            TclObject[] tclObjectArray;
            if (tclObject != null) {
                tclObjectArray = TclList.getElements((Interp)interp, (TclObject)tclObject);
                this.classpath = new String[tclObjectArray.length];
                n = 0;
                while (n < tclObjectArray.length) {
                    this.classpath[n] = TclClassLoader.absolutePath(interp, tclObjectArray[n].toString());
                    ++n;
                }
            }
            if ((tclObjectArray = TclClassLoader.getEnvTclClasspath(interp)) != null) {
                this.loadpath = new String[tclObjectArray.length];
                n = 0;
                while (n < tclObjectArray.length) {
                    this.loadpath[n] = TclClassLoader.absolutePath(interp, tclObjectArray[n].toString());
                    ++n;
                }
            }
        }
        catch (TclException tclException) {}
    }

    private static String absolutePath(Interp interp, String string) throws TclException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            String string2 = String.valueOf(interp.getWorkingDir().toString()) + System.getProperty("file.separator") + string;
            file = new File(string2);
        }
        return file.toString();
    }

    Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(null, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {}
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            classes.put(string, clazz);
        }
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractClassFromJar(String string, String string2) throws IOException {
        byte[] byArray;
        ZipInputStream zipInputStream;
        block5: {
            byte[] byArray2;
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            try {
                ZipEntry zipEntry;
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) != null) continue;
                    byArray = null;
                    break block5;
                } while (!string2.equals(zipEntry.getName()));
                int n = this.getEntrySize(string, string2);
                byte[] byArray3 = new byte[n];
                int n2 = zipInputStream.read(byArray3);
                while (true) {
                    if (n2 == n) {
                        this.lastSearchedClassFile = string2;
                        this.lastSearchedJarFile = string;
                        byArray2 = byArray3;
                        Object var10_10 = null;
                        break;
                    }
                    n2 += zipInputStream.read(byArray3, n2, n - n2);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                zipInputStream.close();
                throw throwable;
            }
            zipInputStream.close();
            return byArray2;
        }
        Object var10_11 = null;
        zipInputStream.close();
        return byArray;
    }

    private byte[] getClassFromJar(String string, String string2) throws IOException {
        byte[] byArray = null;
        JarFilenameFilter jarFilenameFilter = new JarFilenameFilter();
        String[] stringArray = new File(string).list(jarFilenameFilter);
        int n = 0;
        while (n < stringArray.length) {
            byArray = this.extractClassFromJar(String.valueOf(string) + File.separatorChar + stringArray[n], string2);
            if (byArray != null) break;
            ++n;
        }
        return byArray;
    }

    private byte[] getClassFromPath(String[] stringArray, String string) {
        int n = 0;
        byte[] byArray = null;
        this.lastSearchedClassFile = null;
        this.lastSearchedJarFile = null;
        if (stringArray != null) {
            String string2;
            string = String.valueOf(string.replace('.', File.separatorChar)) + ".class";
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toString();
                try {
                    if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
                        byArray = this.extractClassFromJar(string2, string);
                        if (byArray != null) {
                            return byArray;
                        }
                    } else {
                        File file = new File(string2, string);
                        if (file.exists()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            byArray = new byte[fileInputStream.available()];
                            int n2 = fileInputStream.read(byArray);
                            while (n2 != byArray.length) {
                                n2 += fileInputStream.read(byArray, n2, byArray.length - n2);
                            }
                            this.lastSearchedClassFile = file.toString();
                            return byArray;
                        }
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toString();
                try {
                    byArray = this.getClassFromJar(string2, string);
                    if (byArray != null) {
                        return byArray;
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        return null;
    }

    private int getEntrySize(String string, String string2) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!string2.equals(zipEntry.getName())) continue;
            zipFile.close();
            return (int)zipEntry.getSize();
        }
        return -1;
    }

    private static TclObject[] getEnvTclClasspath(Interp interp) throws TclException {
        try {
            return TclList.getElements((Interp)interp, (TclObject)interp.getVar("env", "TCL_CLASSPATH", 1));
        }
        catch (TclException tclException) {
            interp.resetResult();
            return null;
        }
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException, SecurityException {
        Class<?> clazz = (Class<?>)classes.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        if (string.startsWith("java.") || string.startsWith("tcl.")) {
            throw new SecurityException("Java loader failed to load the class and the Tcl Java loader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.");
        }
        byte[] byArray = this.getClassFromPath(this.classpath, string);
        if (byArray == null) {
            byArray = this.getClassFromPath(this.loadpath, string);
        }
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassFormatError();
        }
        catch (ClassFormatError classFormatError) {
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(classFormatError.getMessage());
            stringBuffer.append(". ");
            if (this.lastSearchedClassFile != null) {
                stringBuffer.append(this.lastSearchedClassFile);
            } else {
                stringBuffer.append(string);
            }
            if (this.lastSearchedJarFile != null) {
                stringBuffer.append(" loaded from ");
                stringBuffer.append(this.lastSearchedJarFile);
            }
            stringBuffer.append(": class name does not match");
            stringBuffer.append(" the name defined in the classfile");
            throw new ClassFormatError(stringBuffer.toString());
        }
        if (clazz == null) {
            throw new ClassFormatError();
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        classes.put(string, clazz);
        return clazz;
    }

    void removeCache(String string) {
        classes.remove(string);
    }
}

