# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, *, address_prefixes: Optional[List[str]] = None, **kwargs):
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar sku: SKU of the application gateway resource.
    :vartype sku: ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySku
    :ivar ssl_policy: SSL policy of the application gateway resource.
    :vartype ssl_policy: ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Known values
     are: "Stopped", "Starting", "Running", and "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayOperationalState
    :ivar gateway_ip_configurations: Subnets of application the gateway resource.
    :vartype gateway_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayIPConfiguration]
    :ivar authentication_certificates: Authentication certificates of the application gateway
     resource.
    :vartype authentication_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayAuthenticationCertificate]
    :ivar ssl_certificates: SSL certificates of the application gateway resource.
    :vartype ssl_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCertificate]
    :ivar frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendIPConfiguration]
    :ivar frontend_ports: Frontend ports of the application gateway resource.
    :vartype frontend_ports:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendPort]
    :ivar probes: Probes of the application gateway resource.
    :vartype probes: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbe]
    :ivar backend_address_pools: Backend address pool of the application gateway resource.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
    :ivar backend_http_settings_collection: Backend http settings of the application gateway
     resource.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings]
    :ivar http_listeners: Http listeners of the application gateway resource.
    :vartype http_listeners:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayHttpListener]
    :ivar url_path_maps: URL path map of the application gateway resource.
    :vartype url_path_maps:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayUrlPathMap]
    :ivar request_routing_rules: Request routing rules of the application gateway resource.
    :vartype request_routing_rules:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRule]
    :ivar redirect_configurations: Redirect configurations of the application gateway resource.
    :vartype redirect_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectConfiguration]
    :ivar web_application_firewall_configuration: Web application firewall configuration.
    :vartype web_application_firewall_configuration:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :ivar resource_guid: Resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Provisioning state of the application gateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operational_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "sku": {"key": "properties.sku", "type": "ApplicationGatewaySku"},
        "ssl_policy": {"key": "properties.sslPolicy", "type": "ApplicationGatewaySslPolicy"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "gateway_ip_configurations": {
            "key": "properties.gatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "authentication_certificates": {
            "key": "properties.authenticationCertificates",
            "type": "[ApplicationGatewayAuthenticationCertificate]",
        },
        "ssl_certificates": {"key": "properties.sslCertificates", "type": "[ApplicationGatewaySslCertificate]"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[ApplicationGatewayFrontendIPConfiguration]",
        },
        "frontend_ports": {"key": "properties.frontendPorts", "type": "[ApplicationGatewayFrontendPort]"},
        "probes": {"key": "properties.probes", "type": "[ApplicationGatewayProbe]"},
        "backend_address_pools": {
            "key": "properties.backendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "backend_http_settings_collection": {
            "key": "properties.backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHttpSettings]",
        },
        "http_listeners": {"key": "properties.httpListeners", "type": "[ApplicationGatewayHttpListener]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[ApplicationGatewayUrlPathMap]"},
        "request_routing_rules": {
            "key": "properties.requestRoutingRules",
            "type": "[ApplicationGatewayRequestRoutingRule]",
        },
        "redirect_configurations": {
            "key": "properties.redirectConfigurations",
            "type": "[ApplicationGatewayRedirectConfiguration]",
        },
        "web_application_firewall_configuration": {
            "key": "properties.webApplicationFirewallConfiguration",
            "type": "ApplicationGatewayWebApplicationFirewallConfiguration",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        sku: Optional["_models.ApplicationGatewaySku"] = None,
        ssl_policy: Optional["_models.ApplicationGatewaySslPolicy"] = None,
        gateway_ip_configurations: Optional[List["_models.ApplicationGatewayIPConfiguration"]] = None,
        authentication_certificates: Optional[List["_models.ApplicationGatewayAuthenticationCertificate"]] = None,
        ssl_certificates: Optional[List["_models.ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["_models.ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["_models.ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["_models.ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["_models.ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHttpSettings"]] = None,
        http_listeners: Optional[List["_models.ApplicationGatewayHttpListener"]] = None,
        url_path_maps: Optional[List["_models.ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["_models.ApplicationGatewayRequestRoutingRule"]] = None,
        redirect_configurations: Optional[List["_models.ApplicationGatewayRedirectConfiguration"]] = None,
        web_application_firewall_configuration: Optional[
            "_models.ApplicationGatewayWebApplicationFirewallConfiguration"
        ] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword sku: SKU of the application gateway resource.
        :paramtype sku: ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySku
        :keyword ssl_policy: SSL policy of the application gateway resource.
        :paramtype ssl_policy: ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicy
        :keyword gateway_ip_configurations: Subnets of application the gateway resource.
        :paramtype gateway_ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayIPConfiguration]
        :keyword authentication_certificates: Authentication certificates of the application gateway
         resource.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayAuthenticationCertificate]
        :keyword ssl_certificates: SSL certificates of the application gateway resource.
        :paramtype ssl_certificates:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCertificate]
        :keyword frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendIPConfiguration]
        :keyword frontend_ports: Frontend ports of the application gateway resource.
        :paramtype frontend_ports:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFrontendPort]
        :keyword probes: Probes of the application gateway resource.
        :paramtype probes: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbe]
        :keyword backend_address_pools: Backend address pool of the application gateway resource.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
        :keyword backend_http_settings_collection: Backend http settings of the application gateway
         resource.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings]
        :keyword http_listeners: Http listeners of the application gateway resource.
        :paramtype http_listeners:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayHttpListener]
        :keyword url_path_maps: URL path map of the application gateway resource.
        :paramtype url_path_maps:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayUrlPathMap]
        :keyword request_routing_rules: Request routing rules of the application gateway resource.
        :paramtype request_routing_rules:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRule]
        :keyword redirect_configurations: Redirect configurations of the application gateway resource.
        :paramtype redirect_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectConfiguration]
        :keyword web_application_firewall_configuration: Web application firewall configuration.
        :paramtype web_application_firewall_configuration:
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
        :keyword resource_guid: Resource GUID property of the application gateway resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: Provisioning state of the application gateway resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar provisioning_state: Provisioning state of the authentication certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword data: Certificate public data.
        :paramtype data: str
        :keyword provisioning_state: Provisioning state of the authentication certificate resource.
         Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.provisioning_state = provisioning_state


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar predefined_policies: List of available Ssl predefined policy.
    :vartype predefined_policies: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and
     "AppGwSslPolicy20170401S".
    :vartype default_policy: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
    :ivar available_cipher_suites: List of available Ssl cipher suites.
    :vartype available_cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :ivar available_protocols: List of available Ssl protocols.
    :vartype available_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "predefined_policies": {"key": "properties.predefinedPolicies", "type": "[SubResource]"},
        "default_policy": {"key": "properties.defaultPolicy", "type": "str"},
        "available_cipher_suites": {"key": "properties.availableCipherSuites", "type": "[str]"},
        "available_protocols": {"key": "properties.availableProtocols", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        predefined_policies: Optional[List["_models.SubResource"]] = None,
        default_policy: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        available_cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        available_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword predefined_policies: List of available Ssl predefined policy.
        :paramtype predefined_policies: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        :keyword default_policy: Name of the Ssl predefined policy applied by default to application
         gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and
         "AppGwSslPolicy20170401S".
        :paramtype default_policy: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
        :keyword available_cipher_suites: List of available Ssl cipher suites.
        :paramtype available_cipher_suites: list[str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
        :keyword available_protocols: List of available Ssl protocols.
        :paramtype available_protocols: list[str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols


class ApplicationGatewayAvailableSslPredefinedPolicies(_serialization.Model):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :ivar value: List of available Ssl predefined policy.
    :vartype value:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPredefinedPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewaySslPredefinedPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationGatewaySslPredefinedPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of available Ssl predefined policy.
        :paramtype value:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPredefinedPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayAvailableWafRuleSetsResult(_serialization.Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :ivar value: The list of application gateway rule sets.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayFirewallRuleSet]"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplicationGatewayFirewallRuleSet"]] = None, **kwargs):
        """
        :keyword value: The list of application gateway rule sets.
        :paramtype value:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleSet]
        """
        super().__init__(**kwargs)
        self.value = value


class ApplicationGatewayBackendAddress(_serialization.Model):
    """Backend address of an application gateway.

    :ivar fqdn: Fully qualified domain name (FQDN).
    :vartype fqdn: str
    :ivar ip_address: IP address.
    :vartype ip_address: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_address: Optional[str] = None, **kwargs):
        """
        :keyword fqdn: Fully qualified domain name (FQDN).
        :paramtype fqdn: str
        :keyword ip_address: IP address.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource that is unique within a resource group. This name can be used to access
     the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :ivar backend_addresses: Backend addresses.
    :vartype backend_addresses:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: Provisioning state of the backend address pool resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "backend_addresses": {"key": "properties.backendAddresses", "type": "[ApplicationGatewayBackendAddress]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        backend_ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        backend_addresses: Optional[List["_models.ApplicationGatewayBackendAddress"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Resource that is unique within a resource group. This name can be used to access
         the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword backend_ip_configurations: Collection of references to IPs defined in network
         interfaces.
        :paramtype backend_ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
        :keyword backend_addresses: Backend addresses.
        :paramtype backend_addresses:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddress]
        :keyword provisioning_state: Provisioning state of the backend address pool resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendHealth(_serialization.Model):
    """List of ApplicationGatewayBackendHealthPool resources.

    :ivar backend_address_pools:
    :vartype backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        "backend_address_pools": {"key": "backendAddressPools", "type": "[ApplicationGatewayBackendHealthPool]"},
    }

    def __init__(
        self, *, backend_address_pools: Optional[List["_models.ApplicationGatewayBackendHealthPool"]] = None, **kwargs
    ):
        """
        :keyword backend_address_pools:
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthPool]
        """
        super().__init__(**kwargs)
        self.backend_address_pools = backend_address_pools


class ApplicationGatewayBackendHealthHttpSettings(_serialization.Model):
    """Application gateway BackendHealthHttp settings.

    :ivar backend_http_settings: Reference of an ApplicationGatewayBackendHttpSettings resource.
    :vartype backend_http_settings:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings
    :ivar servers: List of ApplicationGatewayBackendHealthServer resources.
    :vartype servers:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        "backend_http_settings": {"key": "backendHttpSettings", "type": "ApplicationGatewayBackendHttpSettings"},
        "servers": {"key": "servers", "type": "[ApplicationGatewayBackendHealthServer]"},
    }

    def __init__(
        self,
        *,
        backend_http_settings: Optional["_models.ApplicationGatewayBackendHttpSettings"] = None,
        servers: Optional[List["_models.ApplicationGatewayBackendHealthServer"]] = None,
        **kwargs
    ):
        """
        :keyword backend_http_settings: Reference of an ApplicationGatewayBackendHttpSettings resource.
        :paramtype backend_http_settings:
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHttpSettings
        :keyword servers: List of ApplicationGatewayBackendHealthServer resources.
        :paramtype servers:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServer]
        """
        super().__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers


class ApplicationGatewayBackendHealthPool(_serialization.Model):
    """Application gateway BackendHealth pool.

    :ivar backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool
    :ivar backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_http_settings_collection": {
            "key": "backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHealthHttpSettings]",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHealthHttpSettings"]] = None,
        **kwargs
    ):
        """
        :keyword backend_address_pool: Reference of an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool
        :keyword backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
         resources.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthHttpSettings]
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection


class ApplicationGatewayBackendHealthServer(_serialization.Model):
    """Application gateway backendhealth http settings.

    :ivar address: IP address or FQDN of backend server.
    :vartype address: str
    :ivar ip_configuration: Reference of IP configuration of backend server.
    :vartype ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration
    :ivar health: Health of backend server. Known values are: "Unknown", "Up", "Down", "Partial",
     and "Draining".
    :vartype health: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServerHealth
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "ip_configuration": {"key": "ipConfiguration", "type": "NetworkInterfaceIPConfiguration"},
        "health": {"key": "health", "type": "str"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        health: Optional[Union[str, "_models.ApplicationGatewayBackendHealthServerHealth"]] = None,
        **kwargs
    ):
        """
        :keyword address: IP address or FQDN of backend server.
        :paramtype address: str
        :keyword ip_configuration: Reference of IP configuration of backend server.
        :paramtype ip_configuration:
         ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration
        :keyword health: Health of backend server. Known values are: "Unknown", "Up", "Down",
         "Partial", and "Draining".
        :paramtype health: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendHealthServerHealth
        """
        super().__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health


class ApplicationGatewayBackendHttpSettings(SubResource):  # pylint: disable=too-many-instance-attributes
    """Backend address pool settings of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: Port.
    :vartype port: int
    :ivar protocol: Protocol. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :ivar cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and "Disabled".
    :vartype cookie_based_affinity: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayCookieBasedAffinity
    :ivar request_timeout: Request timeout in seconds. Application Gateway will fail the request if
     response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype request_timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar authentication_certificates: Array of references to application gateway authentication
     certificates.
    :vartype authentication_certificates: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar connection_draining: Connection draining of the backend http settings resource.
    :vartype connection_draining:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayConnectionDraining
    :ivar host_name: Host header to be sent to the backend servers.
    :vartype host_name: str
    :ivar pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :vartype pick_host_name_from_backend_address: bool
    :ivar affinity_cookie_name: Cookie name to use for the affinity cookie.
    :vartype affinity_cookie_name: str
    :ivar probe_enabled: Whether the probe is enabled. Default value is false.
    :vartype probe_enabled: bool
    :ivar path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :vartype path: str
    :ivar provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "cookie_based_affinity": {"key": "properties.cookieBasedAffinity", "type": "str"},
        "request_timeout": {"key": "properties.requestTimeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "authentication_certificates": {"key": "properties.authenticationCertificates", "type": "[SubResource]"},
        "connection_draining": {"key": "properties.connectionDraining", "type": "ApplicationGatewayConnectionDraining"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "pick_host_name_from_backend_address": {"key": "properties.pickHostNameFromBackendAddress", "type": "bool"},
        "affinity_cookie_name": {"key": "properties.affinityCookieName", "type": "str"},
        "probe_enabled": {"key": "properties.probeEnabled", "type": "bool"},
        "path": {"key": "properties.path", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "_models.ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        authentication_certificates: Optional[List["_models.SubResource"]] = None,
        connection_draining: Optional["_models.ApplicationGatewayConnectionDraining"] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        affinity_cookie_name: Optional[str] = None,
        probe_enabled: Optional[bool] = None,
        path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword port: Port.
        :paramtype port: int
        :keyword protocol: Protocol. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
        :keyword cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and
         "Disabled".
        :paramtype cookie_based_affinity: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayCookieBasedAffinity
        :keyword request_timeout: Request timeout in seconds. Application Gateway will fail the request
         if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype request_timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword authentication_certificates: Array of references to application gateway authentication
         certificates.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        :keyword connection_draining: Connection draining of the backend http settings resource.
        :paramtype connection_draining:
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayConnectionDraining
        :keyword host_name: Host header to be sent to the backend servers.
        :paramtype host_name: str
        :keyword pick_host_name_from_backend_address: Whether to pick host header should be picked from
         the host name of the backend server. Default value is false.
        :paramtype pick_host_name_from_backend_address: bool
        :keyword affinity_cookie_name: Cookie name to use for the affinity cookie.
        :paramtype affinity_cookie_name: str
        :keyword probe_enabled: Whether the probe is enabled. Default value is false.
        :paramtype probe_enabled: bool
        :keyword path: Path which should be used as a prefix for all HTTP requests. Null means no path
         will be prefixed. Default value is null.
        :paramtype path: str
        :keyword provisioning_state: Provisioning state of the backend http settings resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.provisioning_state = provisioning_state


class ApplicationGatewayConnectionDraining(_serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Whether connection draining is enabled or not. Required.
    :vartype enabled: bool
    :ivar drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
     values are from 1 second to 3600 seconds. Required.
    :vartype drain_timeout_in_sec: int
    """

    _validation = {
        "enabled": {"required": True},
        "drain_timeout_in_sec": {"required": True, "maximum": 3600, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "drain_timeout_in_sec": {"key": "drainTimeoutInSec", "type": "int"},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs):
        """
        :keyword enabled: Whether connection draining is enabled or not. Required.
        :paramtype enabled: bool
        :keyword drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
         values are from 1 second to 3600 seconds. Required.
        :paramtype drain_timeout_in_sec: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec


class ApplicationGatewayFirewallDisabledRuleGroup(_serialization.Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: The name of the rule group that will be disabled. Required.
    :vartype rule_group_name: str
    :ivar rules: The list of rules that will be disabled. If null, all rules of the rule group will
     be disabled.
    :vartype rules: list[int]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[int]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[List[int]] = None, **kwargs):
        """
        :keyword rule_group_name: The name of the rule group that will be disabled. Required.
        :paramtype rule_group_name: str
        :keyword rules: The list of rules that will be disabled. If null, all rules of the rule group
         will be disabled.
        :paramtype rules: list[int]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ApplicationGatewayFirewallRule(_serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_id: The identifier of the web application firewall rule. Required.
    :vartype rule_id: int
    :ivar description: The description of the web application firewall rule.
    :vartype description: str
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "int"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, rule_id: int, description: Optional[str] = None, **kwargs):
        """
        :keyword rule_id: The identifier of the web application firewall rule. Required.
        :paramtype rule_id: int
        :keyword description: The description of the web application firewall rule.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.description = description


class ApplicationGatewayFirewallRuleGroup(_serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_group_name: The name of the web application firewall rule group. Required.
    :vartype rule_group_name: str
    :ivar description: The description of the web application firewall rule group.
    :vartype description: str
    :ivar rules: The rules of the web application firewall rule group. Required.
    :vartype rules: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        "rule_group_name": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[ApplicationGatewayFirewallRule]"},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: List["_models.ApplicationGatewayFirewallRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword rule_group_name: The name of the web application firewall rule group. Required.
        :paramtype rule_group_name: str
        :keyword description: The description of the web application firewall rule group.
        :paramtype description: str
        :keyword rules: The rules of the web application firewall rule group. Required.
        :paramtype rules: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRule]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application firewall rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: The type of the web application firewall rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: The rule groups of the web application firewall rule set.
    :vartype rule_groups:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rule_set_type": {"key": "properties.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[ApplicationGatewayFirewallRuleGroup]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[str] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        rule_groups: Optional[List["_models.ApplicationGatewayFirewallRuleGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword provisioning_state: The provisioning state of the web application firewall rule set.
        :paramtype provisioning_state: str
        :keyword rule_set_type: The type of the web application firewall rule set.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type.
        :paramtype rule_set_version: str
        :keyword rule_groups: The rule groups of the web application firewall rule set.
        :paramtype rule_groups:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallRuleGroup]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = provisioning_state
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: PrivateIP allocation method. Known values are: "Static" and
     "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar subnet: Reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Provisioning state of the public IP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: PrivateIP allocation method. Known values are: "Static"
         and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword subnet: Reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword provisioning_state: Provisioning state of the public IP resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: Frontend port.
    :vartype port: int
    :ivar provisioning_state: Provisioning state of the frontend port resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword port: Frontend port.
        :paramtype port: int
        :keyword provisioning_state: Provisioning state of the frontend port resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.port = port
        self.provisioning_state = provisioning_state


class ApplicationGatewayHttpListener(SubResource):  # pylint: disable=too-many-instance-attributes
    """Http listener of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar protocol: Protocol. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :ivar host_name: Host name of HTTP listener.
    :vartype host_name: str
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :vartype require_server_name_indication: bool
    :ivar provisioning_state: Provisioning state of the HTTP listener resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "require_server_name_indication": {"key": "properties.requireServerNameIndication", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword protocol: Protocol. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
        :keyword host_name: Host name of HTTP listener.
        :paramtype host_name: str
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword require_server_name_indication: Applicable only if protocol is https. Enables SNI for
         multi-hosting.
        :paramtype require_server_name_indication: bool
        :keyword provisioning_state: Provisioning state of the HTTP listener resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = provisioning_state


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Provisioning state of the application gateway subnet resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword subnet: Reference of the subnet resource. A subnet from where application gateway gets
         its private address.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword provisioning_state: Provisioning state of the application gateway subnet resource.
         Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.subnet = subnet
        self.provisioning_state = provisioning_state


class ApplicationGatewayListResult(_serialization.Model):
    """Response for ListApplicationGateways API service call.

    :ivar value: List of an application gateways in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGateway]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ApplicationGateway"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of an application gateways in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGateway]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar paths: Path rules of URL path map.
    :vartype paths: list[str]
    :ivar backend_address_pool: Backend address pool resource of URL path map path rule.
    :vartype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of URL path map path rule.
    :vartype backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of URL path map path rule.
    :vartype redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "paths": {"key": "properties.paths", "type": "[str]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword paths: Path rules of URL path map.
        :paramtype paths: list[str]
        :keyword backend_address_pool: Backend address pool resource of URL path map path rule.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of URL path map path rule.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of URL path map path rule.
        :paramtype redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword provisioning_state: Path rule of URL path map resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbe(SubResource):  # pylint: disable=too-many-instance-attributes
    """Probe of the application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar protocol: Protocol. Known values are: "Http" and "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :vartype path: str
    :ivar interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :vartype interval: int
    :ivar timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :vartype unhealthy_threshold: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :vartype min_servers: int
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match:
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host": {"key": "properties.host", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
        "interval": {"key": "properties.interval", "type": "int"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "unhealthy_threshold": {"key": "properties.unhealthyThreshold", "type": "int"},
        "pick_host_name_from_backend_http_settings": {
            "key": "properties.pickHostNameFromBackendHttpSettings",
            "type": "bool",
        },
        "min_servers": {"key": "properties.minServers", "type": "int"},
        "match": {"key": "properties.match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        min_servers: Optional[int] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword protocol: Protocol. Known values are: "Http" and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
        :paramtype path: str
        :keyword interval: The probing interval in seconds. This is the time interval between two
         consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :paramtype interval: int
        :keyword timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword unhealthy_threshold: The probe retry count. Backend server is marked down after
         consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
         to 20.
        :paramtype unhealthy_threshold: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword min_servers: Minimum number of servers that are always marked healthy. Default value
         is 0.
        :paramtype min_servers: int
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match:
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword provisioning_state: Provisioning state of the backend http settings resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbeHealthResponseMatch(_serialization.Model):
    """Application gateway probe health response match.

    :ivar body: Body that must be contained in the health response. Default value is empty.
    :vartype body: str
    :ivar status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :vartype status_codes: list[str]
    """

    _attribute_map = {
        "body": {"key": "body", "type": "str"},
        "status_codes": {"key": "statusCodes", "type": "[str]"},
    }

    def __init__(self, *, body: Optional[str] = None, status_codes: Optional[List[str]] = None, **kwargs):
        """
        :keyword body: Body that must be contained in the health response. Default value is empty.
        :paramtype body: str
        :keyword status_codes: Allowed ranges of healthy status codes. Default range of healthy status
         codes is 200-399.
        :paramtype status_codes: list[str]
        """
        super().__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes


class ApplicationGatewayRedirectConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Redirect configuration of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar redirect_type: Supported http redirection types - Permanent, Temporary, Found, SeeOther.
     Known values are: "Permanent", "Found", "SeeOther", and "Temporary".
    :vartype redirect_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectType
    :ivar target_listener: Reference to a listener to redirect the request to.
    :vartype target_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar target_url: Url to redirect the request to.
    :vartype target_url: str
    :ivar include_path: Include path in the redirected url.
    :vartype include_path: bool
    :ivar include_query_string: Include query string in the redirected url.
    :vartype include_query_string: bool
    :ivar request_routing_rules: Request routing specifying redirect configuration.
    :vartype request_routing_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar url_path_maps: Url path maps specifying default redirect configuration.
    :vartype url_path_maps: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar path_rules: Path rules specifying redirect configuration.
    :vartype path_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "redirect_type": {"key": "properties.redirectType", "type": "str"},
        "target_listener": {"key": "properties.targetListener", "type": "SubResource"},
        "target_url": {"key": "properties.targetUrl", "type": "str"},
        "include_path": {"key": "properties.includePath", "type": "bool"},
        "include_query_string": {"key": "properties.includeQueryString", "type": "bool"},
        "request_routing_rules": {"key": "properties.requestRoutingRules", "type": "[SubResource]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[SubResource]"},
        "path_rules": {"key": "properties.pathRules", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        redirect_type: Optional[Union[str, "_models.ApplicationGatewayRedirectType"]] = None,
        target_listener: Optional["_models.SubResource"] = None,
        target_url: Optional[str] = None,
        include_path: Optional[bool] = None,
        include_query_string: Optional[bool] = None,
        request_routing_rules: Optional[List["_models.SubResource"]] = None,
        url_path_maps: Optional[List["_models.SubResource"]] = None,
        path_rules: Optional[List["_models.SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword redirect_type: Supported http redirection types - Permanent, Temporary, Found,
         SeeOther. Known values are: "Permanent", "Found", "SeeOther", and "Temporary".
        :paramtype redirect_type: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRedirectType
        :keyword target_listener: Reference to a listener to redirect the request to.
        :paramtype target_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword target_url: Url to redirect the request to.
        :paramtype target_url: str
        :keyword include_path: Include path in the redirected url.
        :paramtype include_path: bool
        :keyword include_query_string: Include query string in the redirected url.
        :paramtype include_query_string: bool
        :keyword request_routing_rules: Request routing specifying redirect configuration.
        :paramtype request_routing_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        :keyword url_path_maps: Url path maps specifying default redirect configuration.
        :paramtype url_path_maps: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        :keyword path_rules: Path rules specifying redirect configuration.
        :paramtype path_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules


class ApplicationGatewayRequestRoutingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Request routing rule of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRuleType
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar backend_http_settings: Frontend port resource of the application gateway.
    :vartype backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar http_listener: Http listener resource of the application gateway.
    :vartype http_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar url_path_map: URL path map resource of the application gateway.
    :vartype url_path_map: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of the application gateway.
    :vartype redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Provisioning state of the request routing rule resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "http_listener": {"key": "properties.httpListener", "type": "SubResource"},
        "url_path_map": {"key": "properties.urlPathMap", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        http_listener: Optional["_models.SubResource"] = None,
        url_path_map: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayRequestRoutingRuleType
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword backend_http_settings: Frontend port resource of the application gateway.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword http_listener: Http listener resource of the application gateway.
        :paramtype http_listener: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword url_path_map: URL path map resource of the application gateway.
        :paramtype url_path_map: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of the application gateway.
        :paramtype redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword provisioning_state: Provisioning state of the request routing rule resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.rule_type = rule_type
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = provisioning_state


class ApplicationGatewaySku(_serialization.Model):
    """SKU of an application gateway.

    :ivar name: Name of an application gateway SKU. Known values are: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", and "WAF_Large".
    :vartype name: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Known values are: "Standard" and "WAF".
    :vartype tier: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayTier
    :ivar capacity: Capacity (instance count) of an application gateway.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Name of an application gateway SKU. Known values are: "Standard_Small",
         "Standard_Medium", "Standard_Large", "WAF_Medium", and "WAF_Large".
        :paramtype name: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySkuName
        :keyword tier: Tier of an application gateway. Known values are: "Standard" and "WAF".
        :paramtype tier: str or ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayTier
        :keyword capacity: Capacity (instance count) of an application gateway.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :vartype data: str
    :ivar password: Password for the pfx file specified in data. Only applicable in PUT request.
    :vartype password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :ivar provisioning_state: Provisioning state of the SSL certificate resource Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :paramtype data: str
        :keyword password: Password for the pfx file specified in data. Only applicable in PUT request.
        :paramtype password: str
        :keyword public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
         data. Only applicable in GET request.
        :paramtype public_cert_data: str
        :keyword provisioning_state: Provisioning state of the SSL certificate resource Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.data = data
        self.password = password
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state


class ApplicationGatewaySslPolicy(_serialization.Model):
    """Application Gateway Ssl policy.

    :ivar disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :vartype disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
    :ivar policy_type: Type of Ssl Policy. Known values are: "Predefined" and "Custom".
    :vartype policy_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyType
    :ivar policy_name: Name of Ssl predefined policy. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", and "AppGwSslPolicy20170401S".
    :vartype policy_name: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "disabled_ssl_protocols": {"key": "disabledSslProtocols", "type": "[str]"},
        "policy_type": {"key": "policyType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "cipher_suites": {"key": "cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        disabled_ssl_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        policy_type: Optional[Union[str, "_models.ApplicationGatewaySslPolicyType"]] = None,
        policy_name: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :paramtype disabled_ssl_protocols: list[str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol]
        :keyword policy_type: Type of Ssl Policy. Known values are: "Predefined" and "Custom".
        :paramtype policy_type: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyType
        :keyword policy_name: Name of Ssl predefined policy. Known values are:
         "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", and "AppGwSslPolicy20170401S".
        :paramtype policy_name: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslPolicyName
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order to application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
        """
        super().__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of Ssl predefined policy.
    :vartype name: str
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cipher_suites": {"key": "properties.cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "properties.minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of Ssl predefined policy.
        :paramtype name: str
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order for application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", and "TLSv1_2".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewaySslProtocol
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar default_backend_address_pool: Default backend address pool resource of URL path map.
    :vartype default_backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar default_backend_http_settings: Default backend http settings resource of URL path map.
    :vartype default_backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar default_redirect_configuration: Default redirect configuration resource of URL path map.
    :vartype default_redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar path_rules: Path rule of URL path map resource.
    :vartype path_rules: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_backend_address_pool": {"key": "properties.defaultBackendAddressPool", "type": "SubResource"},
        "default_backend_http_settings": {"key": "properties.defaultBackendHttpSettings", "type": "SubResource"},
        "default_redirect_configuration": {"key": "properties.defaultRedirectConfiguration", "type": "SubResource"},
        "path_rules": {"key": "properties.pathRules", "type": "[ApplicationGatewayPathRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        type: Optional[str] = None,
        default_backend_address_pool: Optional["_models.SubResource"] = None,
        default_backend_http_settings: Optional["_models.SubResource"] = None,
        default_redirect_configuration: Optional["_models.SubResource"] = None,
        path_rules: Optional[List["_models.ApplicationGatewayPathRule"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword default_backend_address_pool: Default backend address pool resource of URL path map.
        :paramtype default_backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword default_backend_http_settings: Default backend http settings resource of URL path map.
        :paramtype default_backend_http_settings: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword default_redirect_configuration: Default redirect configuration resource of URL path
         map.
        :paramtype default_redirect_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword path_rules: Path rule of URL path map resource.
        :paramtype path_rules: list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayPathRule]
        :keyword provisioning_state: Provisioning state of the backend http settings resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.type = type
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_redirect_configuration = default_redirect_configuration
        self.path_rules = path_rules
        self.provisioning_state = provisioning_state


class ApplicationGatewayWebApplicationFirewallConfiguration(_serialization.Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Whether the web application firewall is enabled or not. Required.
    :vartype enabled: bool
    :ivar firewall_mode: Web application firewall mode. Required. Known values are: "Detection" and
     "Prevention".
    :vartype firewall_mode: str or
     ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallMode
    :ivar rule_set_type: The type of the web application firewall rule set. Possible values are:
     'OWASP'. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the rule set type. Required.
    :vartype rule_set_version: str
    :ivar disabled_rule_groups: The disabled rule groups.
    :vartype disabled_rule_groups:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    """

    _validation = {
        "enabled": {"required": True},
        "firewall_mode": {"required": True},
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "firewall_mode": {"key": "firewallMode", "type": "str"},
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "disabled_rule_groups": {"key": "disabledRuleGroups", "type": "[ApplicationGatewayFirewallDisabledRuleGroup]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        firewall_mode: Union[str, "_models.ApplicationGatewayFirewallMode"],
        rule_set_type: str,
        rule_set_version: str,
        disabled_rule_groups: Optional[List["_models.ApplicationGatewayFirewallDisabledRuleGroup"]] = None,
        **kwargs
    ):
        """
        :keyword enabled: Whether the web application firewall is enabled or not. Required.
        :paramtype enabled: bool
        :keyword firewall_mode: Web application firewall mode. Required. Known values are: "Detection"
         and "Prevention".
        :paramtype firewall_mode: str or
         ~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallMode
        :keyword rule_set_type: The type of the web application firewall rule set. Possible values are:
         'OWASP'. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the rule set type. Required.
        :paramtype rule_set_version: str
        :keyword disabled_rule_groups: The disabled rule groups.
        :paramtype disabled_rule_groups:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups


class AuthorizationListResult(_serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to an ExpressRouteCircuit.

    :ivar value: The authorizations in an ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The authorizations in an ExpressRoute Circuit.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureAsyncOperationResult(_serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response body includes the HTTP status code for the successful request. If the asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information regarding the failure.

    :ivar status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Known values are: "InProgress", "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.network.v2017_06_01.models.NetworkOperationStatus
    :ivar error:
    :vartype error: ~azure.mgmt.network.v2017_06_01.models.Error
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.NetworkOperationStatus"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs
    ):
        """
        :keyword status: Status of the Azure async operation. Possible values are: 'InProgress',
         'Succeeded', and 'Failed'. Known values are: "InProgress", "Succeeded", and "Failed".
        :paramtype status: str or ~azure.mgmt.network.v2017_06_01.models.NetworkOperationStatus
        :keyword error:
        :paramtype error: ~azure.mgmt.network.v2017_06_01.models.Error
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar backend_ip_configurations: Gets collection of references to IP addresses defined in
     network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar outbound_nat_rule: Gets outbound rules that use this backend address pool.
    :vartype outbound_nat_rule: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Get provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "backend_ip_configurations": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "outbound_nat_rule": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "outbound_nat_rule": {"key": "properties.outboundNatRule", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword provisioning_state: Get provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_nat_rule = None
        self.provisioning_state = provisioning_state


class BGPCommunity(_serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :ivar service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :vartype service_supported_region: str
    :ivar community_name: The name of the bgp community. e.g. Skype.
    :vartype community_name: str
    :ivar community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :vartype community_value: str
    :ivar community_prefixes: The prefixes that the bgp community contains.
    :vartype community_prefixes: list[str]
    :ivar is_authorized_to_use: Customer is authorized to use bgp community or not.
    :vartype is_authorized_to_use: bool
    :ivar service_group: The service group of the bgp community contains.
    :vartype service_group: str
    """

    _attribute_map = {
        "service_supported_region": {"key": "serviceSupportedRegion", "type": "str"},
        "community_name": {"key": "communityName", "type": "str"},
        "community_value": {"key": "communityValue", "type": "str"},
        "community_prefixes": {"key": "communityPrefixes", "type": "[str]"},
        "is_authorized_to_use": {"key": "isAuthorizedToUse", "type": "bool"},
        "service_group": {"key": "serviceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_supported_region: Optional[str] = None,
        community_name: Optional[str] = None,
        community_value: Optional[str] = None,
        community_prefixes: Optional[List[str]] = None,
        is_authorized_to_use: Optional[bool] = None,
        service_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service_supported_region: The region which the service support. e.g. For O365, region
         is Global.
        :paramtype service_supported_region: str
        :keyword community_name: The name of the bgp community. e.g. Skype.
        :paramtype community_name: str
        :keyword community_value: The value of the bgp community. For more information:
         https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
        :paramtype community_value: str
        :keyword community_prefixes: The prefixes that the bgp community contains.
        :paramtype community_prefixes: list[str]
        :keyword is_authorized_to_use: Customer is authorized to use bgp community or not.
        :paramtype is_authorized_to_use: bool
        :keyword service_group: The service group of the bgp community contains.
        :paramtype service_group: str
        """
        super().__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group


class BgpPeerStatus(_serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Known values are: "Unknown", "Stopped", "Idle", "Connecting",
     and "Connected".
    :vartype state: str or ~azure.mgmt.network.v2017_06_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: int
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: int
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "neighbor": {"readonly": True},
        "asn": {"readonly": True},
        "state": {"readonly": True},
        "connected_duration": {"readonly": True},
        "routes_received": {"readonly": True},
        "messages_sent": {"readonly": True},
        "messages_received": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "connected_duration": {"key": "connectedDuration", "type": "str"},
        "routes_received": {"key": "routesReceived", "type": "int"},
        "messages_sent": {"key": "messagesSent", "type": "int"},
        "messages_received": {"key": "messagesReceived", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(_serialization.Model):
    """Response for list BGP peer status API service call.

    :ivar value: List of BGP peers.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpPeerStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.BgpPeerStatus"]] = None, **kwargs):
        """
        :keyword value: List of BGP peers.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.BgpPeerStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar service_name: The name of the bgp community. e.g. Skype.
    :vartype service_name: str
    :ivar bgp_communities: Get a list of bgp communities.
    :vartype bgp_communities: list[~azure.mgmt.network.v2017_06_01.models.BGPCommunity]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "[BGPCommunity]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_name: Optional[str] = None,
        bgp_communities: Optional[List["_models.BGPCommunity"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword service_name: The name of the bgp community. e.g. Skype.
        :paramtype service_name: str
        :keyword bgp_communities: Get a list of bgp communities.
        :paramtype bgp_communities: list[~azure.mgmt.network.v2017_06_01.models.BGPCommunity]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities


class BgpServiceCommunityListResult(_serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :ivar value: A list of service community resources.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.BgpServiceCommunity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpServiceCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BgpServiceCommunity"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of service community resources.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.BgpServiceCommunity]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BgpSettings(_serialization.Model):
    """BGP settings details.

    :ivar asn: The BGP speaker's ASN.
    :vartype asn: int
    :ivar bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :vartype bgp_peering_address: str
    :ivar peer_weight: The weight added to routes learned from this BGP speaker.
    :vartype peer_weight: int
    """

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "bgp_peering_address": {"key": "bgpPeeringAddress", "type": "str"},
        "peer_weight": {"key": "peerWeight", "type": "int"},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword asn: The BGP speaker's ASN.
        :paramtype asn: int
        :keyword bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :paramtype bgp_peering_address: str
        :keyword peer_weight: The weight added to routes learned from this BGP speaker.
        :paramtype peer_weight: int
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class ConnectionResetSharedKey(_serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_length: The virtual network connection reset shared key length, should between 1 and
     128. Required.
    :vartype key_length: int
    """

    _validation = {
        "key_length": {"required": True, "maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "key_length": {"key": "keyLength", "type": "int"},
    }

    def __init__(self, *, key_length: int, **kwargs):
        """
        :keyword key_length: The virtual network connection reset shared key length, should between 1
         and 128. Required.
        :paramtype key_length: int
        """
        super().__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(_serialization.Model):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The virtual network connection shared key value. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs):
        """
        :keyword value: The virtual network connection shared key value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class ConnectivityDestination(_serialization.Model):
    """Parameters that define destination of connection.

    :ivar resource_id: The ID of the resource to which a connection attempt will be made.
    :vartype resource_id: str
    :ivar address: The IP address or URI the resource to which a connection attempt will be made.
    :vartype address: str
    :ivar port: Port on which check connectivity will be performed.
    :vartype port: int
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, address: Optional[str] = None, port: Optional[int] = None, **kwargs
    ):
        """
        :keyword resource_id: The ID of the resource to which a connection attempt will be made.
        :paramtype resource_id: str
        :keyword address: The IP address or URI the resource to which a connection attempt will be
         made.
        :paramtype address: str
        :keyword port: Port on which check connectivity will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectivityHop(_serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.v2017_06_01.models.ConnectivityIssue]
    """

    _validation = {
        "type": {"readonly": True},
        "id": {"readonly": True},
        "address": {"readonly": True},
        "resource_id": {"readonly": True},
        "next_hop_ids": {"readonly": True},
        "issues": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "next_hop_ids": {"key": "nextHopIds", "type": "[str]"},
        "issues": {"key": "issues", "type": "[ConnectivityIssue]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(_serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.v2017_06_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Known values are: "Unknown", "Connected",
     "Disconnected", and "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.v2017_06_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        "hops": {"readonly": True},
        "connection_status": {"readonly": True},
        "avg_latency_in_ms": {"readonly": True},
        "min_latency_in_ms": {"readonly": True},
        "max_latency_in_ms": {"readonly": True},
        "probes_sent": {"readonly": True},
        "probes_failed": {"readonly": True},
    }

    _attribute_map = {
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(_serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Known values are: "Local", "Inbound", and "Outbound".
    :vartype origin: str or ~azure.mgmt.network.v2017_06_01.models.Origin
    :ivar severity: The severity of the issue. Known values are: "Error" and "Warning".
    :vartype severity: str or ~azure.mgmt.network.v2017_06_01.models.Severity
    :ivar type: The type of issue. Known values are: "Unknown", "AgentStopped", "GuestFirewall",
     "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute", "PortThrottled", and
     "Platform".
    :vartype type: str or ~azure.mgmt.network.v2017_06_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        "origin": {"readonly": True},
        "severity": {"readonly": True},
        "type": {"readonly": True},
        "context": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "context": {"key": "context", "type": "[{str}]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(_serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Parameters that define the source of the connection. Required.
    :vartype source: ~azure.mgmt.network.v2017_06_01.models.ConnectivitySource
    :ivar destination: Parameters that define destination of connection. Required.
    :vartype destination: ~azure.mgmt.network.v2017_06_01.models.ConnectivityDestination
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectivitySource"},
        "destination": {"key": "destination", "type": "ConnectivityDestination"},
    }

    def __init__(
        self, *, source: "_models.ConnectivitySource", destination: "_models.ConnectivityDestination", **kwargs
    ):
        """
        :keyword source: Parameters that define the source of the connection. Required.
        :paramtype source: ~azure.mgmt.network.v2017_06_01.models.ConnectivitySource
        :keyword destination: Parameters that define destination of connection. Required.
        :paramtype destination: ~azure.mgmt.network.v2017_06_01.models.ConnectivityDestination
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination


class ConnectivitySource(_serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The ID of the resource from which a connectivity check will be initiated.
     Required.
    :vartype resource_id: str
    :ivar port: The source port from which a connectivity check will be performed.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs):
        """
        :keyword resource_id: The ID of the resource from which a connectivity check will be initiated.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port from which a connectivity check will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class DhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs):
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class DnsNameAvailabilityResult(_serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :ivar available: Domain availability (True/False).
    :vartype available: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
    }

    def __init__(self, *, available: Optional[bool] = None, **kwargs):
        """
        :keyword available: Domain availability (True/False).
        :paramtype available: bool
        """
        super().__init__(**kwargs)
        self.available = available


class EffectiveNetworkSecurityGroup(_serialization.Model):
    """Effective network security group.

    :ivar network_security_group: The ID of network security group that is applied.
    :vartype network_security_group: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar association: Associated resources.
    :vartype association:
     ~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroupAssociation
    :ivar effective_security_rules: A collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
    :ivar tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :vartype tag_map: str
    """

    _attribute_map = {
        "network_security_group": {"key": "networkSecurityGroup", "type": "SubResource"},
        "association": {"key": "association", "type": "EffectiveNetworkSecurityGroupAssociation"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
        "tag_map": {"key": "tagMap", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_security_group: Optional["_models.SubResource"] = None,
        association: Optional["_models.EffectiveNetworkSecurityGroupAssociation"] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        tag_map: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword network_security_group: The ID of network security group that is applied.
        :paramtype network_security_group: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword association: Associated resources.
        :paramtype association:
         ~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroupAssociation
        :keyword effective_security_rules: A collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
        :keyword tag_map: Mapping of tags to list of IP Addresses included within the tag.
        :paramtype tag_map: str
        """
        super().__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map


class EffectiveNetworkSecurityGroupAssociation(_serialization.Model):
    """The effective network security group association.

    :ivar subnet: The ID of the subnet if assigned.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar network_interface: The ID of the network interface if assigned.
    :vartype network_interface: ~azure.mgmt.network.v2017_06_01.models.SubResource
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "SubResource"},
        "network_interface": {"key": "networkInterface", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.SubResource"] = None,
        network_interface: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword subnet: The ID of the subnet if assigned.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword network_interface: The ID of the network interface if assigned.
        :paramtype network_interface: ~azure.mgmt.network.v2017_06_01.models.SubResource
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.network_interface = network_interface


class EffectiveNetworkSecurityGroupListResult(_serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective network security groups.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveNetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveNetworkSecurityGroup"]] = None, **kwargs):
        """
        :keyword value: A list of effective network security groups.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EffectiveNetworkSecurityRule(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Effective network security rules.

    :ivar name: The name of the security rule specified by the user (if created by the user).
    :vartype name: str
    :ivar protocol: The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp',
     and 'All'. Known values are: "Tcp", "Udp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.EffectiveSecurityRuleProtocol
    :ivar source_port_range: The source port or range.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range.
    :vartype destination_port_range: str
    :ivar source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The source address prefix.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix.
    :vartype destination_address_prefix: str
    :ivar source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :vartype destination_address_prefixes: list[str]
    :ivar expanded_source_address_prefix: The expanded source address prefix.
    :vartype expanded_source_address_prefix: list[str]
    :ivar expanded_destination_address_prefix: Expanded destination address prefix.
    :vartype expanded_destination_address_prefix: list[str]
    :ivar access: Whether network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
    :ivar priority: The priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. Possible values are: 'Inbound and Outbound'. Known
     values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_port_range": {"key": "sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "str"},
        "source_port_ranges": {"key": "sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "destinationPortRanges", "type": "[str]"},
        "source_address_prefix": {"key": "sourceAddressPrefix", "type": "str"},
        "destination_address_prefix": {"key": "destinationAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "sourceAddressPrefixes", "type": "[str]"},
        "destination_address_prefixes": {"key": "destinationAddressPrefixes", "type": "[str]"},
        "expanded_source_address_prefix": {"key": "expandedSourceAddressPrefix", "type": "[str]"},
        "expanded_destination_address_prefix": {"key": "expandedDestinationAddressPrefix", "type": "[str]"},
        "access": {"key": "access", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.EffectiveSecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        expanded_source_address_prefix: Optional[List[str]] = None,
        expanded_destination_address_prefix: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the security rule specified by the user (if created by the user).
        :paramtype name: str
        :keyword protocol: The network protocol this rule applies to. Possible values are: 'Tcp',
         'Udp', and 'All'. Known values are: "Tcp", "Udp", and "All".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2017_06_01.models.EffectiveSecurityRuleProtocol
        :keyword source_port_range: The source port or range.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range.
        :paramtype destination_port_range: str
        :keyword source_port_ranges: The source port ranges. Expected values include a single integer
         between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges. Expected values include a single
         integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype destination_port_ranges: list[str]
        :keyword source_address_prefix: The source address prefix.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix.
        :paramtype destination_address_prefix: str
        :keyword source_address_prefixes: The source address prefixes. Expected values include CIDR IP
         ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
         asterisk (*).
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefixes: The destination address prefixes. Expected values
         include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System
         Tags, and the asterisk (*).
        :paramtype destination_address_prefixes: list[str]
        :keyword expanded_source_address_prefix: The expanded source address prefix.
        :paramtype expanded_source_address_prefix: list[str]
        :keyword expanded_destination_address_prefix: Expanded destination address prefix.
        :paramtype expanded_destination_address_prefix: list[str]
        :keyword access: Whether network traffic is allowed or denied. Possible values are: 'Allow' and
         'Deny'. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
        :keyword priority: The priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. Possible values are: 'Inbound and Outbound'.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction


class EffectiveRoute(_serialization.Model):
    """Effective Route.

    :ivar name: The name of the user defined route. This is optional.
    :vartype name: str
    :ivar source: Who created the route. Possible values are: 'Unknown', 'User',
     'VirtualNetworkGateway', and 'Default'. Known values are: "Unknown", "User",
     "VirtualNetworkGateway", and "Default".
    :vartype source: str or ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteSource
    :ivar state: The value of effective route. Possible values are: 'Active' and 'Invalid'. Known
     values are: "Active" and "Invalid".
    :vartype state: str or ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteState
    :ivar address_prefix: The address prefixes of the effective routes in CIDR notation.
    :vartype address_prefix: list[str]
    :ivar next_hop_ip_address: The IP address of the next hop of the effective route.
    :vartype next_hop_ip_address: list[str]
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known values
     are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "address_prefix": {"key": "addressPrefix", "type": "[str]"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "[str]"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        source: Optional[Union[str, "_models.EffectiveRouteSource"]] = None,
        state: Optional[Union[str, "_models.EffectiveRouteState"]] = None,
        address_prefix: Optional[List[str]] = None,
        next_hop_ip_address: Optional[List[str]] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the user defined route. This is optional.
        :paramtype name: str
        :keyword source: Who created the route. Possible values are: 'Unknown', 'User',
         'VirtualNetworkGateway', and 'Default'. Known values are: "Unknown", "User",
         "VirtualNetworkGateway", and "Default".
        :paramtype source: str or ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteSource
        :keyword state: The value of effective route. Possible values are: 'Active' and 'Invalid'.
         Known values are: "Active" and "Invalid".
        :paramtype state: str or ~azure.mgmt.network.v2017_06_01.models.EffectiveRouteState
        :keyword address_prefix: The address prefixes of the effective routes in CIDR notation.
        :paramtype address_prefix: list[str]
        :keyword next_hop_ip_address: The IP address of the next hop of the effective route.
        :paramtype next_hop_ip_address: list[str]
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Possible values
         are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known
         values are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
        """
        super().__init__(**kwargs)
        self.name = name
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type


class EffectiveRouteListResult(_serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective routes.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveRoute"]] = None, **kwargs):
        """
        :keyword value: A list of effective routes.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.EffectiveRoute]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.type = None


class EndpointServicesListResult(_serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :ivar value: List of available endpoint services in a region.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.EndpointServiceResult]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EndpointServiceResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EndpointServiceResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of available endpoint services in a region.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.EndpointServiceResult]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(_serialization.Model):
    """Error.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.network.v2017_06_01.models.ErrorDetails]
    :ivar inner_error:
    :vartype inner_error: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
        "inner_error": {"key": "innerError", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.network.v2017_06_01.models.ErrorDetails]
        :keyword inner_error:
        :paramtype inner_error: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(_serialization.Model):
    """ErrorDetails.

    :ivar code:
    :vartype code: str
    :ivar target:
    :vartype target: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code:
        :paramtype code: str
        :keyword target:
        :paramtype target: str
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ExpressRouteCircuit(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU.
    :vartype sku: ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSku
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_classic_operations: Allow classic operations.
    :vartype allow_classic_operations: bool
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
     'Deprovisioning'. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
     "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ServiceProviderProvisioningState
    :ivar authorizations: The list of authorizations.
    :vartype authorizations:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitAuthorization]
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :ivar service_provider_notes: The ServiceProviderNotes.
    :vartype service_provider_notes: str
    :ivar service_provider_properties: The ServiceProviderProperties.
    :vartype service_provider_properties:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitServiceProviderProperties
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ExpressRouteCircuitSku"},
        "etag": {"key": "etag", "type": "str"},
        "allow_classic_operations": {"key": "properties.allowClassicOperations", "type": "bool"},
        "circuit_provisioning_state": {"key": "properties.circuitProvisioningState", "type": "str"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ExpressRouteCircuitAuthorization]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "service_provider_properties": {
            "key": "properties.serviceProviderProperties",
            "type": "ExpressRouteCircuitServiceProviderProperties",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ExpressRouteCircuitSku"] = None,
        allow_classic_operations: Optional[bool] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["_models.ExpressRouteCircuitServiceProviderProperties"] = None,
        provisioning_state: Optional[str] = None,
        gateway_manager_etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU.
        :paramtype sku: ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSku
        :keyword allow_classic_operations: Allow classic operations.
        :paramtype allow_classic_operations: bool
        :keyword circuit_provisioning_state: The CircuitProvisioningState state of the resource.
        :paramtype circuit_provisioning_state: str
        :keyword service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
         resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
         'Deprovisioning'. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
         "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.v2017_06_01.models.ServiceProviderProvisioningState
        :keyword authorizations: The list of authorizations.
        :paramtype authorizations:
         list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitAuthorization]
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
        :keyword service_key: The ServiceKey.
        :paramtype service_key: str
        :keyword service_provider_notes: The ServiceProviderNotes.
        :paramtype service_provider_notes: str
        :keyword service_provider_properties: The ServiceProviderProperties.
        :paramtype service_provider_properties:
         ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitServiceProviderProperties
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = None
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.provisioning_state = provisioning_state
        self.gateway_manager_etag = gateway_manager_etag


class ExpressRouteCircuitArpTable(_serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :ivar age: Age.
    :vartype age: int
    :ivar interface: Interface.
    :vartype interface: str
    :ivar ip_address: The IP address.
    :vartype ip_address: str
    :ivar mac_address: The MAC address.
    :vartype mac_address: str
    """

    _attribute_map = {
        "age": {"key": "age", "type": "int"},
        "interface": {"key": "interface", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        age: Optional[int] = None,
        interface: Optional[str] = None,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword age: Age.
        :paramtype age: int
        :keyword interface: Interface.
        :paramtype interface: str
        :keyword ip_address: The IP address.
        :paramtype ip_address: str
        :keyword mac_address: The MAC address.
        :paramtype mac_address: str
        """
        super().__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
     'InUse'. Known values are: "Available" and "InUse".
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.v2017_06_01.models.AuthorizationUseStatus
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "_models.AuthorizationUseStatus"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
         'InUse'. Known values are: "Available" and "InUse".
        :paramtype authorization_use_status: str or
         ~azure.mgmt.network.v2017_06_01.models.AuthorizationUseStatus
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitListResult(_serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :ivar value: A list of ExpressRouteCircuits in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuit]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuit]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteCircuit"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of ExpressRouteCircuits in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuit]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
     'AzurePrivatePeering', and 'MicrosoftPeering'. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringType
    :ivar state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known values
     are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
    :ivar stats: Gets peering stats.
    :vartype stats: ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitStats
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Gets whether the provider or the customer last modified the peering.
    :vartype last_modified_by: str
    :ivar route_filter: The reference of the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "stats": {"key": "properties.stats", "type": "ExpressRouteCircuitStats"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "route_filter": {"key": "properties.routeFilter", "type": "RouteFilter"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRouteCircuitPeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRouteCircuitPeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["_models.ExpressRouteCircuitStats"] = None,
        provisioning_state: Optional[str] = None,
        gateway_manager_etag: Optional[str] = None,
        last_modified_by: Optional[str] = None,
        route_filter: Optional["_models.RouteFilter"] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
         'AzurePrivatePeering', and 'MicrosoftPeering'. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or
         ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringType
        :keyword state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known
         values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
        :keyword azure_asn: The Azure ASN.
        :paramtype azure_asn: int
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword primary_azure_port: The primary port.
        :paramtype primary_azure_port: str
        :keyword secondary_azure_port: The secondary port.
        :paramtype secondary_azure_port: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
        :keyword stats: Gets peering stats.
        :paramtype stats: ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitStats
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword last_modified_by: Gets whether the provider or the customer last modified the peering.
        :paramtype last_modified_by: str
        :keyword route_filter: The reference of the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config:
         ~azure.mgmt.network.v2017_06_01.models.Ipv6ExpressRouteCircuitPeeringConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = provisioning_state
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = last_modified_by
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config


class ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Specifies the peering configuration.

    :ivar advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :vartype advertised_public_prefixes: list[str]
    :ivar advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :vartype advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
     Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Known
     values are: "NotConfigured", "Configuring", "Configured", and "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :ivar legacy_mode: The legacy mode of the peering.
    :vartype legacy_mode: int
    :ivar customer_asn: The CustomerASN of the peering.
    :vartype customer_asn: int
    :ivar routing_registry_name: The RoutingRegistryName of the configuration.
    :vartype routing_registry_name: str
    """

    _attribute_map = {
        "advertised_public_prefixes": {"key": "advertisedPublicPrefixes", "type": "[str]"},
        "advertised_communities": {"key": "advertisedCommunities", "type": "[str]"},
        "advertised_public_prefixes_state": {"key": "advertisedPublicPrefixesState", "type": "str"},
        "legacy_mode": {"key": "legacyMode", "type": "int"},
        "customer_asn": {"key": "customerASN", "type": "int"},
        "routing_registry_name": {"key": "routingRegistryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_communities: Optional[List[str]] = None,
        advertised_public_prefixes_state: Optional[
            Union[str, "_models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]
        ] = None,
        legacy_mode: Optional[int] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
        :paramtype advertised_public_prefixes: list[str]
        :keyword advertised_communities: The communities of bgp peering. Specified for microsoft
         peering.
        :paramtype advertised_communities: list[str]
        :keyword advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
         Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Known
         values are: "NotConfigured", "Configuring", "Configured", and "ValidationNeeded".
        :paramtype advertised_public_prefixes_state: str or
         ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
        :keyword legacy_mode: The legacy mode of the peering.
        :paramtype legacy_mode: int
        :keyword customer_asn: The CustomerASN of the peering.
        :paramtype customer_asn: int
        :keyword routing_registry_name: The RoutingRegistryName of the configuration.
        :paramtype routing_registry_name: str
        """
        super().__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state = advertised_public_prefixes_state
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringListResult(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCircuit.

    :ivar value: The peerings in an express route circuit.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The peerings in an express route circuit.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitRoutesTable(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar network: network.
    :vartype network: str
    :ivar next_hop: nextHop.
    :vartype next_hop: str
    :ivar loc_prf: locPrf.
    :vartype loc_prf: str
    :ivar weight: weight.
    :vartype weight: int
    :ivar path: path.
    :vartype path: str
    """

    _attribute_map = {
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "loc_prf": {"key": "locPrf", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        network: Optional[str] = None,
        next_hop: Optional[str] = None,
        loc_prf: Optional[str] = None,
        weight: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword network: network.
        :paramtype network: str
        :keyword next_hop: nextHop.
        :paramtype next_hop: str
        :keyword loc_prf: locPrf.
        :paramtype loc_prf: str
        :keyword weight: weight.
        :paramtype weight: int
        :keyword path: path.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path


class ExpressRouteCircuitRoutesTableSummary(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: Neighbor.
    :vartype neighbor: str
    :ivar v: BGP version number spoken to the neighbor.
    :vartype v: int
    :ivar as_property: Autonomous system number.
    :vartype as_property: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :vartype state_pfx_rcd: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "v": {"key": "v", "type": "int"},
        "as_property": {"key": "as", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_pfx_rcd": {"key": "statePfxRcd", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        v: Optional[int] = None,
        as_property: Optional[int] = None,
        up_down: Optional[str] = None,
        state_pfx_rcd: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword neighbor: Neighbor.
        :paramtype neighbor: str
        :keyword v: BGP version number spoken to the neighbor.
        :paramtype v: int
        :keyword as_property: Autonomous system number.
        :paramtype as_property: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
         been received from a neighbor or peer group.
        :paramtype state_pfx_rcd: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd


class ExpressRouteCircuitsArpTableListResult(_serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :ivar value: Gets list of the ARP table.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitArpTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitArpTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets list of the ARP table.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitArpTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(_serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :ivar service_provider_name: The serviceProviderName.
    :vartype service_provider_name: str
    :ivar peering_location: The peering location.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The BandwidthInMbps.
    :vartype bandwidth_in_mbps: int
    """

    _attribute_map = {
        "service_provider_name": {"key": "serviceProviderName", "type": "str"},
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword service_provider_name: The serviceProviderName.
        :paramtype service_provider_name: str
        :keyword peering_location: The peering location.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The BandwidthInMbps.
        :paramtype bandwidth_in_mbps: int
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(_serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Known values
     are: "Standard", "Premium", and "Transport".
    :vartype tier: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuTier
    :ivar family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
     Known values are: "UnlimitedData" and "MeteredData".
    :vartype family: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "_models.ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Known values
         are: "Standard", "Premium", and "Transport".
        :paramtype tier: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuTier
        :keyword family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
         Known values are: "UnlimitedData" and "MeteredData".
        :paramtype family: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitSkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: The list of routes table.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of routes table.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsRoutesTableSummaryListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: A list of the routes table.
    :vartype value:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTableSummary"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitRoutesTableSummary]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(_serialization.Model):
    """Contains stats associated with the peering.

    :ivar primarybytes_in: Gets BytesIn of the peering.
    :vartype primarybytes_in: int
    :ivar primarybytes_out: Gets BytesOut of the peering.
    :vartype primarybytes_out: int
    :ivar secondarybytes_in: Gets BytesIn of the peering.
    :vartype secondarybytes_in: int
    :ivar secondarybytes_out: Gets BytesOut of the peering.
    :vartype secondarybytes_out: int
    """

    _attribute_map = {
        "primarybytes_in": {"key": "primarybytesIn", "type": "int"},
        "primarybytes_out": {"key": "primarybytesOut", "type": "int"},
        "secondarybytes_in": {"key": "secondarybytesIn", "type": "int"},
        "secondarybytes_out": {"key": "secondarybytesOut", "type": "int"},
    }

    def __init__(
        self,
        *,
        primarybytes_in: Optional[int] = None,
        primarybytes_out: Optional[int] = None,
        secondarybytes_in: Optional[int] = None,
        secondarybytes_out: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword primarybytes_in: Gets BytesIn of the peering.
        :paramtype primarybytes_in: int
        :keyword primarybytes_out: Gets BytesOut of the peering.
        :paramtype primarybytes_out: int
        :keyword secondarybytes_in: Gets BytesIn of the peering.
        :paramtype secondarybytes_in: int
        :keyword secondarybytes_out: Gets BytesOut of the peering.
        :paramtype secondarybytes_out: int
        """
        super().__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_locations: Get a list of peering locations.
    :vartype peering_locations: list[str]
    :ivar bandwidths_offered: Gets bandwidths offered.
    :vartype bandwidths_offered:
     list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: Gets the provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
        "bandwidths_offered": {
            "key": "properties.bandwidthsOffered",
            "type": "[ExpressRouteServiceProviderBandwidthsOffered]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["_models.ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_locations: Get a list of peering locations.
        :paramtype peering_locations: list[str]
        :keyword bandwidths_offered: Gets bandwidths offered.
        :paramtype bandwidths_offered:
         list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteServiceProviderBandwidthsOffered]
        :keyword provisioning_state: Gets the provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = provisioning_state


class ExpressRouteServiceProviderBandwidthsOffered(_serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :ivar offer_name: The OfferName.
    :vartype offer_name: str
    :ivar value_in_mbps: The ValueInMbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs):
        """
        :keyword offer_name: The OfferName.
        :paramtype offer_name: str
        :keyword value_in_mbps: The ValueInMbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(_serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :ivar value: A list of ExpressRouteResourceProvider resources.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteServiceProvider]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of ExpressRouteResourceProvider resources.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteServiceProvider]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FlowLogInformation(_serialization.Model):
    """Information on the configuration of flow log.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The ID of the resource to configure for flow logging. Required.
    :vartype target_resource_id: str
    :ivar storage_id: ID of the storage account which is used to store the flow log. Required.
    :vartype storage_id: str
    :ivar enabled: Flag to enable/disable flow logging. Required.
    :vartype enabled: bool
    :ivar retention_policy: Parameters that define the retention policy for flow log.
    :vartype retention_policy: ~azure.mgmt.network.v2017_06_01.models.RetentionPolicyParameters
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicyParameters"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        enabled: bool,
        retention_policy: Optional["_models.RetentionPolicyParameters"] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The ID of the resource to configure for flow logging. Required.
        :paramtype target_resource_id: str
        :keyword storage_id: ID of the storage account which is used to store the flow log. Required.
        :paramtype storage_id: str
        :keyword enabled: Flag to enable/disable flow logging. Required.
        :paramtype enabled: bool
        :keyword retention_policy: Parameters that define the retention policy for flow log.
        :paramtype retention_policy: ~azure.mgmt.network.v2017_06_01.models.RetentionPolicyParameters
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.enabled = enabled
        self.retention_policy = retention_policy


class FlowLogStatusParameters(_serialization.Model):
    """Parameters that define a resource to query flow log status.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource where getting the flow logging status. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: The target resource where getting the flow logging status.
         Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class FrontendIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
    :vartype outbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The Private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :ivar public_ip_address: The reference of the Public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "inbound_nat_rules": {"readonly": True},
        "inbound_nat_pools": {"readonly": True},
        "outbound_nat_rules": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[SubResource]"},
        "outbound_nat_rules": {"key": "properties.outboundNatRules", "type": "[SubResource]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The Private IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
        :keyword public_ip_address: The reference of the Public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.zones = zones
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_nat_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class GatewayRoute(_serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "network": {"readonly": True},
        "next_hop": {"readonly": True},
        "source_peer": {"readonly": True},
        "origin": {"readonly": True},
        "as_path": {"readonly": True},
        "weight": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "source_peer": {"key": "sourcePeer", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(_serialization.Model):
    """List of virtual network gateway routes.

    :ivar value: List of gateway routes.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.GatewayRoute]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayRoute]"},
    }

    def __init__(self, *, value: Optional[List["_models.GatewayRoute"]] = None, **kwargs):
        """
        :keyword value: List of gateway routes.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.GatewayRoute]
        """
        super().__init__(**kwargs)
        self.value = value


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :vartype frontend_port_range_end: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or
         'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
        :keyword frontend_port_range_start: The first port number in the range of external ports that
         will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
         range between 1 and 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The last port number in the range of external ports that will
         be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
         between 1 and 65535.
        :paramtype frontend_port_range_end: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.provisioning_state = provisioning_state


class InboundNatRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration
    :ivar protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "backend_ip_configuration": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_ip_configuration": {
            "key": "properties.backendIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or
         'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for the internal endpoint. Acceptable values range from 1
         to 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class InboundNatRuleListResult(_serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inbound nat rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundNatRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InboundNatRule"]] = None, **kwargs):
        """
        :keyword value: A list of inbound nat rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IPAddressAvailabilityResult(_serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :ivar available: Private IP address availability.
    :vartype available: bool
    :ivar available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :vartype available_ip_addresses: list[str]
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
        "available_ip_addresses": {"key": "availableIPAddresses", "type": "[str]"},
    }

    def __init__(
        self, *, available: Optional[bool] = None, available_ip_addresses: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword available: Private IP address availability.
        :paramtype available: bool
        :keyword available_ip_addresses: Contains other available private IP addresses if the asked for
         address is taken.
        :paramtype available_ip_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses


class IPConfiguration(SubResource):
    """IP configuration.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP allocation method. Possible values are
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP allocation method. Possible values are
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class IpsecPolicy(_serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :ivar sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) lifetime in seconds for a site to site VPN tunnel. Required.
    :vartype sa_life_time_seconds: int
    :ivar sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) payload size in KB for a site to site VPN tunnel. Required.
    :vartype sa_data_size_kilobytes: int
    :ivar ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
     are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
     "GCMAES256".
    :vartype ipsec_encryption: str or ~azure.mgmt.network.v2017_06_01.models.IpsecEncryption
    :ivar ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values are:
     "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
    :vartype ipsec_integrity: str or ~azure.mgmt.network.v2017_06_01.models.IpsecIntegrity
    :ivar ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values are:
     "DES", "DES3", "AES128", "AES192", and "AES256".
    :vartype ike_encryption: str or ~azure.mgmt.network.v2017_06_01.models.IkeEncryption
    :ivar ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
     "MD5", "SHA1", "SHA256", and "SHA384".
    :vartype ike_integrity: str or ~azure.mgmt.network.v2017_06_01.models.IkeIntegrity
    :ivar dh_group: The DH Groups used in IKE Phase 1 for initial SA. Required. Known values are:
     "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
     "DHGroup24".
    :vartype dh_group: str or ~azure.mgmt.network.v2017_06_01.models.DhGroup
    :ivar pfs_group: The DH Groups used in IKE Phase 2 for new child SA. Required. Known values
     are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", and "PFS24".
    :vartype pfs_group: str or ~azure.mgmt.network.v2017_06_01.models.PfsGroup
    """

    _validation = {
        "sa_life_time_seconds": {"required": True},
        "sa_data_size_kilobytes": {"required": True},
        "ipsec_encryption": {"required": True},
        "ipsec_integrity": {"required": True},
        "ike_encryption": {"required": True},
        "ike_integrity": {"required": True},
        "dh_group": {"required": True},
        "pfs_group": {"required": True},
    }

    _attribute_map = {
        "sa_life_time_seconds": {"key": "saLifeTimeSeconds", "type": "int"},
        "sa_data_size_kilobytes": {"key": "saDataSizeKilobytes", "type": "int"},
        "ipsec_encryption": {"key": "ipsecEncryption", "type": "str"},
        "ipsec_integrity": {"key": "ipsecIntegrity", "type": "str"},
        "ike_encryption": {"key": "ikeEncryption", "type": "str"},
        "ike_integrity": {"key": "ikeIntegrity", "type": "str"},
        "dh_group": {"key": "dhGroup", "type": "str"},
        "pfs_group": {"key": "pfsGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "_models.IpsecEncryption"],
        ipsec_integrity: Union[str, "_models.IpsecIntegrity"],
        ike_encryption: Union[str, "_models.IkeEncryption"],
        ike_integrity: Union[str, "_models.IkeIntegrity"],
        dh_group: Union[str, "_models.DhGroup"],
        pfs_group: Union[str, "_models.PfsGroup"],
        **kwargs
    ):
        """
        :keyword sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase
         2 SA) lifetime in seconds for a site to site VPN tunnel. Required.
        :paramtype sa_life_time_seconds: int
        :keyword sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or
         Phase 2 SA) payload size in KB for a site to site VPN tunnel. Required.
        :paramtype sa_data_size_kilobytes: int
        :keyword ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
         are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
         "GCMAES256".
        :paramtype ipsec_encryption: str or ~azure.mgmt.network.v2017_06_01.models.IpsecEncryption
        :keyword ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values
         are: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
        :paramtype ipsec_integrity: str or ~azure.mgmt.network.v2017_06_01.models.IpsecIntegrity
        :keyword ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values
         are: "DES", "DES3", "AES128", "AES192", and "AES256".
        :paramtype ike_encryption: str or ~azure.mgmt.network.v2017_06_01.models.IkeEncryption
        :keyword ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
         "MD5", "SHA1", "SHA256", and "SHA384".
        :paramtype ike_integrity: str or ~azure.mgmt.network.v2017_06_01.models.IkeIntegrity
        :keyword dh_group: The DH Groups used in IKE Phase 1 for initial SA. Required. Known values
         are: "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
         "DHGroup24".
        :paramtype dh_group: str or ~azure.mgmt.network.v2017_06_01.models.DhGroup
        :keyword pfs_group: The DH Groups used in IKE Phase 2 for new child SA. Required. Known values
         are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", and "PFS24".
        :paramtype pfs_group: str or ~azure.mgmt.network.v2017_06_01.models.PfsGroup
        """
        super().__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class Ipv6ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Contains IPv6 peering config.

    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
    :ivar route_filter: The reference of the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
    :ivar state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known values
     are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        "primary_peer_address_prefix": {"key": "primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "secondaryPeerAddressPrefix", "type": "str"},
        "microsoft_peering_config": {"key": "microsoftPeeringConfig", "type": "ExpressRouteCircuitPeeringConfig"},
        "route_filter": {"key": "routeFilter", "type": "RouteFilter"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        route_filter: Optional["_models.RouteFilter"] = None,
        state: Optional[Union[str, "_models.ExpressRouteCircuitPeeringState"]] = None,
        **kwargs
    ):
        """
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringConfig
        :keyword route_filter: The reference of the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.v2017_06_01.models.RouteFilter
        :keyword state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known
         values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeeringState
        """
        super().__init__(**kwargs)
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.microsoft_peering_config = microsoft_peering_config
        self.route_filter = route_filter
        self.state = state


class LoadBalancer(Resource):  # pylint: disable=too-many-instance-attributes
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.FrontendIPConfiguration]
    :ivar backend_address_pools: Collection of backend address pools used by a load balancer.
    :vartype backend_address_pools: list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
    :ivar load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancingRule]
    :ivar probes: Collection of probe objects used in the load balancer.
    :vartype probes: list[~azure.mgmt.network.v2017_06_01.models.Probe]
    :ivar inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
    :ivar inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2017_06_01.models.InboundNatPool]
    :ivar outbound_nat_rules: The outbound NAT rules.
    :vartype outbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.OutboundNatRule]
    :ivar resource_guid: The resource GUID property of the load balancer resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[FrontendIPConfiguration]",
        },
        "backend_address_pools": {"key": "properties.backendAddressPools", "type": "[BackendAddressPool]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[LoadBalancingRule]"},
        "probes": {"key": "properties.probes", "type": "[Probe]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[InboundNatRule]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[InboundNatPool]"},
        "outbound_nat_rules": {"key": "properties.outboundNatRules", "type": "[OutboundNatRule]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        frontend_ip_configurations: Optional[List["_models.FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["_models.LoadBalancingRule"]] = None,
        probes: Optional[List["_models.Probe"]] = None,
        inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["_models.InboundNatPool"]] = None,
        outbound_nat_rules: Optional[List["_models.OutboundNatRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configurations: Object representing the frontend IPs to be used for the
         load balancer.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.FrontendIPConfiguration]
        :keyword backend_address_pools: Collection of backend address pools used by a load balancer.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
        :keyword load_balancing_rules: Object collection representing the load balancing rules Gets the
         provisioning.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancingRule]
        :keyword probes: Collection of probe objects used in the load balancer.
        :paramtype probes: list[~azure.mgmt.network.v2017_06_01.models.Probe]
        :keyword inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
         inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
         pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
         associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
         reference individual inbound NAT rules.
        :paramtype inbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
        :keyword inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
         port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
         each NIC associated with the Load Balancer using an external port from this range. Defining an
         Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
         Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
         individual virtual machines cannot reference an inbound NAT pool. They have to reference
         individual inbound NAT rules.
        :paramtype inbound_nat_pools: list[~azure.mgmt.network.v2017_06_01.models.InboundNatPool]
        :keyword outbound_nat_rules: The outbound NAT rules.
        :paramtype outbound_nat_rules: list[~azure.mgmt.network.v2017_06_01.models.OutboundNatRule]
        :keyword resource_guid: The resource GUID property of the load balancer resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LoadBalancerBackendAddressPoolListResult(_serialization.Model):
    """Response for ListBackendAddressPool API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of backend address pools in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackendAddressPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.BackendAddressPool"]] = None, **kwargs):
        """
        :keyword value: A list of backend address pools in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerFrontendIPConfigurationListResult(_serialization.Model):
    """Response for ListFrontendIPConfiguration API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of frontend IP configurations in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.FrontendIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FrontendIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FrontendIPConfiguration"]] = None, **kwargs):
        """
        :keyword value: A list of frontend IP configurations in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.FrontendIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerListResult(_serialization.Model):
    """Response for ListLoadBalancers API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs):
        """
        :keyword value: A list of load balancers in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerLoadBalancingRuleListResult(_serialization.Model):
    """Response for ListLoadBalancingRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancing rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancingRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancingRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancingRule"]] = None, **kwargs):
        """
        :keyword value: A list of load balancing rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancingRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancerProbeListResult(_serialization.Model):
    """Response for ListProbe API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of probes in a load balancer.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.Probe]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Probe]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Probe"]] = None, **kwargs):
        """
        :keyword value: A list of probes in a load balancer.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.Probe]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class LoadBalancingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancing rule for a load balancer.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar probe: The reference of the load balancer probe used by the load balancing rule.
    :vartype probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar protocol: The transport protocol for the external endpoint. Possible values are 'Udp' or
     'Tcp'. Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
    :ivar load_distribution: The load distribution policy for this rule. Possible values are
     'Default', 'SourceIP', and 'SourceIPProtocol'. Known values are: "Default", "SourceIP", and
     "SourceIPProtocol".
    :vartype load_distribution: str or ~azure.mgmt.network.v2017_06_01.models.LoadDistribution
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "load_distribution": {"key": "properties.loadDistribution", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        probe: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "_models.LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword probe: The reference of the load balancer probe used by the load balancing rule.
        :paramtype probe: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword protocol: The transport protocol for the external endpoint. Possible values are 'Udp'
         or 'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.TransportProtocol
        :keyword load_distribution: The load distribution policy for this rule. Possible values are
         'Default', 'SourceIP', and 'SourceIPProtocol'. Known values are: "Default", "SourceIP", and
         "SourceIPProtocol".
        :paramtype load_distribution: str or ~azure.mgmt.network.v2017_06_01.models.LoadDistribution
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class LocalNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar local_network_address_space: Local network site address space.
    :vartype local_network_address_space: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :ivar gateway_ip_address: IP address of local network gateway.
    :vartype gateway_ip_address: str
    :ivar bgp_settings: Local network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the LocalNetworkGateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the LocalNetworkGateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "local_network_address_space": {"key": "properties.localNetworkAddressSpace", "type": "AddressSpace"},
        "gateway_ip_address": {"key": "properties.gatewayIpAddress", "type": "str"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        local_network_address_space: Optional["_models.AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword local_network_address_space: Local network site address space.
        :paramtype local_network_address_space: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
        :keyword gateway_ip_address: IP address of local network gateway.
        :paramtype gateway_ip_address: str
        :keyword bgp_settings: Local network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
        :keyword resource_guid: The resource GUID property of the LocalNetworkGateway resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = None


class LocalNetworkGatewayListResult(_serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of local network gateways that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LocalNetworkGateway"]] = None, **kwargs):
        """
        :keyword value: A list of local network gateways that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.LocalNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterface(Resource):  # pylint: disable=too-many-instance-attributes
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_machine: The reference of a virtual machine.
    :vartype virtual_machine: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
    :ivar ip_configurations: A list of IPConfigurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :ivar dns_settings: The DNS settings in network interface.
    :vartype dns_settings: ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Gets whether this is a primary network interface on a virtual machine.
    :vartype primary: bool
    :ivar enable_accelerated_networking: If the network interface is accelerated networking
     enabled.
    :vartype enable_accelerated_networking: bool
    :ivar enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :vartype enable_ip_forwarding: bool
    :ivar resource_guid: The resource GUID property of the network interface resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_machine": {"key": "properties.virtualMachine", "type": "SubResource"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[NetworkInterfaceIPConfiguration]"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "NetworkInterfaceDnsSettings"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        virtual_machine: Optional["_models.SubResource"] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        dns_settings: Optional["_models.NetworkInterfaceDnsSettings"] = None,
        mac_address: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword virtual_machine: The reference of a virtual machine.
        :paramtype virtual_machine: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
        :keyword ip_configurations: A list of IPConfigurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
        :keyword dns_settings: The DNS settings in network interface.
        :paramtype dns_settings: ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceDnsSettings
        :keyword mac_address: The MAC address of the network interface.
        :paramtype mac_address: str
        :keyword primary: Gets whether this is a primary network interface on a virtual machine.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: If the network interface is accelerated networking
         enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
         interface.
        :paramtype enable_ip_forwarding: bool
        :keyword resource_guid: The resource GUID property of the network interface resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.virtual_machine = virtual_machine
        self.network_security_group = network_security_group
        self.ip_configurations = ip_configurations
        self.dns_settings = dns_settings
        self.mac_address = mac_address
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_ip_forwarding = enable_ip_forwarding
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkInterfaceAssociation(_serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs):
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class NetworkInterfaceDnsSettings(_serialization.Model):
    """DNS settings of a network interface.

    :ivar dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :vartype dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :ivar internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :vartype internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in
     the same virtual network.
    :vartype internal_fqdn: str
    :ivar internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry
     is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the
     VM name with the value of internalDomainNameSuffix.
    :vartype internal_domain_name_suffix: str
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "applied_dns_servers": {"key": "appliedDnsServers", "type": "[str]"},
        "internal_dns_name_label": {"key": "internalDnsNameLabel", "type": "str"},
        "internal_fqdn": {"key": "internalFqdn", "type": "str"},
        "internal_domain_name_suffix": {"key": "internalDomainNameSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        applied_dns_servers: Optional[List[str]] = None,
        internal_dns_name_label: Optional[str] = None,
        internal_fqdn: Optional[str] = None,
        internal_domain_name_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to
         azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it
         must be the only value in dnsServers collection.
        :paramtype dns_servers: list[str]
        :keyword applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
         this list will have the union of all DNS servers from all NICs that are part of the
         Availability Set. This property is what is configured on each of those VMs.
        :paramtype applied_dns_servers: list[str]
        :keyword internal_dns_name_label: Relative DNS name for this NIC used for internal
         communications between VMs in the same virtual network.
        :paramtype internal_dns_name_label: str
        :keyword internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
         in the same virtual network.
        :paramtype internal_fqdn: str
        :keyword internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS
         entry is created for the primary NIC of the VM. This DNS name can be constructed by
         concatenating the VM name with the value of internalDomainNameSuffix.
        :paramtype internal_domain_name_suffix: str
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn
        self.internal_domain_name_suffix = internal_domain_name_suffix


class NetworkInterfaceIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """IPConfiguration in a network interface.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar application_gateway_backend_address_pools: The reference of
     ApplicationGatewayBackendAddressPool resource.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
    :ivar load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
    :ivar load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :vartype load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
    :ivar private_ip_address: Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Defines how a private IP address is assigned. Possible
     values are: 'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar private_ip_address_version: Available from Api-Version 2016-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.v2017_06_01.models.IPVersion
    :ivar subnet: Subnet bound to the IP configuration.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
    :ivar primary: Gets whether this is a primary customer address on the network interface.
    :vartype primary: bool
    :ivar public_ip_address: Public IP address bound to the IP configuration.
    :vartype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the network interface IP configuration.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[BackendAddressPool]",
        },
        "load_balancer_inbound_nat_rules": {
            "key": "properties.loadBalancerInboundNatRules",
            "type": "[InboundNatRule]",
        },
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        application_gateway_backend_address_pools: Optional[
            List["_models.ApplicationGatewayBackendAddressPool"]
        ] = None,
        load_balancer_backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword application_gateway_backend_address_pools: The reference of
         ApplicationGatewayBackendAddressPool resource.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.network.v2017_06_01.models.ApplicationGatewayBackendAddressPool]
        :keyword load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
         resource.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.network.v2017_06_01.models.BackendAddressPool]
        :keyword load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :paramtype load_balancer_inbound_nat_rules:
         list[~azure.mgmt.network.v2017_06_01.models.InboundNatRule]
        :keyword private_ip_address: Private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: Defines how a private IP address is assigned. Possible
         values are: 'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword private_ip_address_version: Available from Api-Version 2016-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.v2017_06_01.models.IPVersion
        :keyword subnet: Subnet bound to the IP configuration.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.Subnet
        :keyword primary: Gets whether this is a primary customer address on the network interface.
        :paramtype primary: bool
        :keyword public_ip_address: Public IP address bound to the IP configuration.
        :paramtype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddress
        :keyword provisioning_state: The provisioning state of the network interface IP configuration.
         Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class NetworkInterfaceIPConfigurationListResult(_serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ip configurations.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaceIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None, **kwargs):
        """
        :keyword value: A list of ip configurations.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceListResult(_serialization.Model):
    """Response for the ListNetworkInterface API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of network interfaces in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterface"]] = None, **kwargs):
        """
        :keyword value: A list of network interfaces in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterfaceLoadBalancerListResult(_serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs):
        """
        :keyword value: A list of load balancers.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkSecurityGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar security_rules: A collection of security rules of the network security group.
    :vartype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network security group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.v2017_06_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the network security group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "subnets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "security_rules": {"key": "properties.securityRules", "type": "[SecurityRule]"},
        "default_security_rules": {"key": "properties.defaultSecurityRules", "type": "[SecurityRule]"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        security_rules: Optional[List["_models.SecurityRule"]] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword security_rules: A collection of security rules of the network security group.
        :paramtype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        :keyword default_security_rules: The default security rules of network security group.
        :paramtype default_security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        :keyword resource_guid: The resource GUID property of the network security group resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = None
        self.subnets = None
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkSecurityGroupListResult(_serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :ivar value: A list of NetworkSecurityGroup resources.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkSecurityGroup"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of NetworkSecurityGroup resources.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.provisioning_state = None


class NetworkWatcherListResult(_serialization.Model):
    """List of network watcher resources.

    :ivar value:
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkWatcher]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkWatcher]"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkWatcher"]] = None, **kwargs):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.NetworkWatcher]
        """
        super().__init__(**kwargs)
        self.value = value


class NextHopParameters(_serialization.Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The resource identifier of the target resource against which the
     action is to be performed. Required.
    :vartype target_resource_id: str
    :ivar source_ip_address: The source IP address. Required.
    :vartype source_ip_address: str
    :ivar destination_ip_address: The destination IP address. Required.
    :vartype destination_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of the nics, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "source_ip_address": {"required": True},
        "destination_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "source_ip_address": {"key": "sourceIPAddress", "type": "str"},
        "destination_ip_address": {"key": "destinationIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        source_ip_address: str,
        destination_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The resource identifier of the target resource against which the
         action is to be performed. Required.
        :paramtype target_resource_id: str
        :keyword source_ip_address: The source IP address. Required.
        :paramtype source_ip_address: str
        :keyword destination_ip_address: The destination IP address. Required.
        :paramtype destination_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of the nics, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.source_ip_address = source_ip_address
        self.destination_ip_address = destination_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class NextHopResult(_serialization.Model):
    """The information about next hop from the specified VM.

    :ivar next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
     "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.NextHopType
    :ivar next_hop_ip_address: Next hop IP Address.
    :vartype next_hop_ip_address: str
    :ivar route_table_id: The resource identifier for the route table associated with the route
     being returned. If the route being returned does not correspond to any user created routes then
     this field will be the string 'System Route'.
    :vartype route_table_id: str
    """

    _attribute_map = {
        "next_hop_type": {"key": "nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "str"},
        "route_table_id": {"key": "routeTableId", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_hop_type: Optional[Union[str, "_models.NextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        route_table_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
         "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.NextHopType
        :keyword next_hop_ip_address: Next hop IP Address.
        :paramtype next_hop_ip_address: str
        :keyword route_table_id: The resource identifier for the route table associated with the route
         being returned. If the route being returned does not correspond to any user created routes then
         this field will be the string 'System Route'.
        :paramtype route_table_id: str
        """
        super().__init__(**kwargs)
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.route_table_id = route_table_id


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :vartype allocated_outbound_ports: int
    :ivar frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :vartype frontend_ip_configurations: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "allocated_outbound_ports": {"key": "properties.allocatedOutboundPorts", "type": "int"},
        "frontend_ip_configurations": {"key": "properties.frontendIPConfigurations", "type": "[SubResource]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["_models.SubResource"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :paramtype allocated_outbound_ports: int
        :keyword frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :paramtype frontend_ip_configurations: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
        :keyword backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = provisioning_state


class PacketCapture(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :ivar filters:
    :vartype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "properties.target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
        :keyword filters:
        :paramtype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
        """
        super().__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureFilter(_serialization.Model):
    """Filter that is applied to packet capture request. Multiple filters can be applied.

    :ivar protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.PcProtocol
    :ivar local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype local_ip_address: str
    :ivar remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype remote_ip_address: str
    :ivar local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype local_port: str
    :ivar remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype remote_port: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Union[str, "_models.PcProtocol"] = "Any",
        local_ip_address: Optional[str] = None,
        remote_ip_address: Optional[str] = None,
        local_port: Optional[str] = None,
        remote_port: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.PcProtocol
        :keyword local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
         address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
         Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
         supported. Default = null.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for
         single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple
         entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not
         currently supported. Default = null.
        :paramtype remote_ip_address: str
        :keyword local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
         for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
         ranges with multiple entries not currently supported. Default = null.
        :paramtype local_port: str
        :keyword remote_port: Remote port to be filtered on. Notation: "80" for single port
         entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently
         supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :paramtype remote_port: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.local_port = local_port
        self.remote_port = remote_port


class PacketCaptureListResult(_serialization.Model):
    """List of packet capture sessions.

    :ivar value: Information about packet capture sessions.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCaptureResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCaptureResult"]] = None, **kwargs):
        """
        :keyword value: Information about packet capture sessions.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureResult]
        """
        super().__init__(**kwargs)
        self.value = value


class PacketCaptureParameters(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :ivar filters:
    :vartype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
        :keyword filters:
        :paramtype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
        """
        super().__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureQueryStatusResult(_serialization.Model):
    """Status of packet capture session.

    :ivar name: The name of the packet capture resource.
    :vartype name: str
    :ivar id: The ID of the packet capture resource.
    :vartype id: str
    :ivar capture_start_time: The start time of the packet capture session.
    :vartype capture_start_time: ~datetime.datetime
    :ivar packet_capture_status: The status of the packet capture session. Known values are:
     "NotStarted", "Running", "Stopped", "Error", and "Unknown".
    :vartype packet_capture_status: str or ~azure.mgmt.network.v2017_06_01.models.PcStatus
    :ivar stop_reason: The reason the current packet capture session was stopped.
    :vartype stop_reason: str
    :ivar packet_capture_error: List of errors of packet capture session.
    :vartype packet_capture_error: list[str or ~azure.mgmt.network.v2017_06_01.models.PcError]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "capture_start_time": {"key": "captureStartTime", "type": "iso-8601"},
        "packet_capture_status": {"key": "packetCaptureStatus", "type": "str"},
        "stop_reason": {"key": "stopReason", "type": "str"},
        "packet_capture_error": {"key": "packetCaptureError", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        capture_start_time: Optional[datetime.datetime] = None,
        packet_capture_status: Optional[Union[str, "_models.PcStatus"]] = None,
        stop_reason: Optional[str] = None,
        packet_capture_error: Optional[List[Union[str, "_models.PcError"]]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the packet capture resource.
        :paramtype name: str
        :keyword id: The ID of the packet capture resource.
        :paramtype id: str
        :keyword capture_start_time: The start time of the packet capture session.
        :paramtype capture_start_time: ~datetime.datetime
        :keyword packet_capture_status: The status of the packet capture session. Known values are:
         "NotStarted", "Running", "Stopped", "Error", and "Unknown".
        :paramtype packet_capture_status: str or ~azure.mgmt.network.v2017_06_01.models.PcStatus
        :keyword stop_reason: The reason the current packet capture session was stopped.
        :paramtype stop_reason: str
        :keyword packet_capture_error: List of errors of packet capture session.
        :paramtype packet_capture_error: list[str or ~azure.mgmt.network.v2017_06_01.models.PcError]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.capture_start_time = capture_start_time
        self.packet_capture_status = packet_capture_status
        self.stop_reason = stop_reason
        self.packet_capture_error = packet_capture_error


class PacketCaptureResult(_serialization.Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :ivar etag:
    :vartype etag: str
    :ivar target: The ID of the targeted resource, only VM is currently supported.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session.
    :vartype storage_location: ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :ivar filters:
    :vartype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "target": {"key": "properties.target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        etag: str = "A unique read-only string that changes whenever the resource is updated.",
        target: Optional[str] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        storage_location: Optional["_models.PacketCaptureStorageLocation"] = None,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs
    ):
        """
        :keyword etag:
        :paramtype etag: str
        :keyword target: The ID of the targeted resource, only VM is currently supported.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
        :paramtype storage_location:
         ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
        :keyword filters:
        :paramtype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
        :keyword provisioning_state: The provisioning state of the packet capture session. Known values
         are: "Succeeded", "Updating", "Deleting", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = etag
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.provisioning_state = provisioning_state


class PacketCaptureResultProperties(PacketCaptureParameters):
    """Describes the properties of a packet capture session.

    All required parameters must be populated in order to send to Azure.

    :ivar target: The ID of the targeted resource, only VM is currently supported. Required.
    :vartype target: str
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: Describes the storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
    :ivar filters:
    :vartype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
    """

    _validation = {
        "target": {"required": True},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs
    ):
        """
        :keyword target: The ID of the targeted resource, only VM is currently supported. Required.
        :paramtype target: str
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: Describes the storage location for a packet capture session.
         Required.
        :paramtype storage_location:
         ~azure.mgmt.network.v2017_06_01.models.PacketCaptureStorageLocation
        :keyword filters:
        :paramtype filters: list[~azure.mgmt.network.v2017_06_01.models.PacketCaptureFilter]
        :keyword provisioning_state: The provisioning state of the packet capture session. Known values
         are: "Succeeded", "Updating", "Deleting", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.network.v2017_06_01.models.ProvisioningState
        """
        super().__init__(
            target=target,
            bytes_to_capture_per_packet=bytes_to_capture_per_packet,
            total_bytes_per_session=total_bytes_per_session,
            time_limit_in_seconds=time_limit_in_seconds,
            storage_location=storage_location,
            filters=filters,
            **kwargs
        )
        self.provisioning_state = provisioning_state


class PacketCaptureStorageLocation(_serialization.Model):
    """Describes the storage location for a packet capture session.

    :ivar storage_id: The ID of the storage account to save the packet capture session. Required if
     no local file path is provided.
    :vartype storage_id: str
    :ivar storage_path: The URI of the storage path to save the packet capture. Must be a
     well-formed URI describing the location to save the packet capture.
    :vartype storage_path: str
    :ivar file_path: A valid local path on the targeting VM. Must include the name of the capture
     file (*.cap). For linux virtual machine it must start with /var/captures. Required if no
     storage ID is provided, otherwise optional.
    :vartype file_path: str
    """

    _attribute_map = {
        "storage_id": {"key": "storageId", "type": "str"},
        "storage_path": {"key": "storagePath", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_id: Optional[str] = None,
        storage_path: Optional[str] = None,
        file_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_id: The ID of the storage account to save the packet capture session. Required
         if no local file path is provided.
        :paramtype storage_id: str
        :keyword storage_path: The URI of the storage path to save the packet capture. Must be a
         well-formed URI describing the location to save the packet capture.
        :paramtype storage_path: str
        :keyword file_path: A valid local path on the targeting VM. Must include the name of the
         capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if
         no storage ID is provided, otherwise optional.
        :paramtype file_path: str
        """
        super().__init__(**kwargs)
        self.storage_id = storage_id
        self.storage_path = storage_path
        self.file_path = file_path


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
        :keyword peerings: A collection of references to express route circuit peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.type = None
        self.tags = tags
        self.rules = rules
        self.peerings = peerings
        self.provisioning_state = None


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Known values are:
     "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'.
     "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.v2017_06_01.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Known values
         are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'.
         "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.v2017_06_01.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.tags = tags
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None


class Probe(SubResource):
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2017_06_01.models.SubResource]
    :ivar protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp'
     is specified, a received ACK is required for the probe to be successful. If 'Http' is
     specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     Known values are: "Http" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ProbeProtocol
    :ivar port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :vartype port: int
    :ivar interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :vartype interval_in_seconds: int
    :ivar number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :vartype number_of_probes: int
    :ivar request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :vartype request_path: str
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "load_balancing_rules": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "interval_in_seconds": {"key": "properties.intervalInSeconds", "type": "int"},
        "number_of_probes": {"key": "properties.numberOfProbes", "type": "int"},
        "request_path": {"key": "properties.requestPath", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        number_of_probes: Optional[int] = None,
        request_path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If
         'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is
         specified, a 200 OK response from the specifies URI is required for the probe to be successful.
         Known values are: "Http" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.ProbeProtocol
        :keyword port: The port for communicating the probe. Possible values range from 1 to 65535,
         inclusive.
        :paramtype port: int
        :keyword interval_in_seconds: The interval, in seconds, for how frequently to probe the
         endpoint for health status. Typically, the interval is slightly less than half the allocated
         timeout period (in seconds) which allows two full probes before taking the instance out of
         rotation. The default value is 15, the minimum value is 5.
        :paramtype interval_in_seconds: int
        :keyword number_of_probes: The number of probes where if no response, will result in stopping
         further traffic from being delivered to the endpoint. This values allows endpoints to be taken
         out of rotation faster or slower than the typical times used in Azure.
        :paramtype number_of_probes: int
        :keyword request_path: The URI used for requesting health status from the VM. Path is required
         if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        :paramtype request_path: str
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancing_rules = None
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = provisioning_state


class PublicIPAddress(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar public_ip_allocation_method: The public IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar public_ip_address_version: The public IP address version. Possible values are: 'IPv4' and
     'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.network.v2017_06_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP address.
    :vartype ip_configuration: ~azure.mgmt.network.v2017_06_01.models.IPConfiguration
    :ivar dns_settings: The FQDN of the DNS record associated with the public IP address.
    :vartype dns_settings: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddressDnsSettings
    :ivar ip_address: The IP address associated with the public IP address resource.
    :vartype ip_address: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the PublicIP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "ip_configuration": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "public_ip_allocation_method": {"key": "properties.publicIPAllocationMethod", "type": "str"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "ip_configuration": {"key": "properties.ipConfiguration", "type": "IPConfiguration"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "PublicIPAddressDnsSettings"},
        "ip_address": {"key": "properties.ipAddress", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        zones: Optional[List[str]] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        dns_settings: Optional["_models.PublicIPAddressDnsSettings"] = None,
        ip_address: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword public_ip_allocation_method: The public IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype public_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword public_ip_address_version: The public IP address version. Possible values are: 'IPv4'
         and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.network.v2017_06_01.models.IPVersion
        :keyword dns_settings: The FQDN of the DNS record associated with the public IP address.
        :paramtype dns_settings: ~azure.mgmt.network.v2017_06_01.models.PublicIPAddressDnsSettings
        :keyword ip_address: The IP address associated with the public IP address resource.
        :paramtype ip_address: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword resource_guid: The resource GUID property of the public IP resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the PublicIP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.zones = zones
        self.public_ip_allocation_method = public_ip_allocation_method
        self.public_ip_address_version = public_ip_address_version
        self.ip_configuration = None
        self.dns_settings = dns_settings
        self.ip_address = ip_address
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class PublicIPAddressDnsSettings(_serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :ivar domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
     name label and the regionalized DNS zone make up the fully qualified domain name associated
     with the public IP address. If a domain name label is specified, an A DNS record is created for
     the public IP in the Microsoft Azure DNS system.
    :vartype domain_name_label: str
    :ivar fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the
     public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :vartype fqdn: str
    :ivar reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name
     that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record
     is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :vartype reverse_fqdn: str
    """

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "reverse_fqdn": {"key": "reverseFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
         name label and the regionalized DNS zone make up the fully qualified domain name associated
         with the public IP address. If a domain name label is specified, an A DNS record is created for
         the public IP in the Microsoft Azure DNS system.
        :paramtype domain_name_label: str
        :keyword fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with
         the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :paramtype fqdn: str
        :keyword reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain
         name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS
         record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :paramtype reverse_fqdn: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressListResult(_serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :ivar value: A list of public IP addresses that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.PublicIPAddress]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicIPAddress]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PublicIPAddress"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of public IP addresses that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.PublicIPAddress]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QueryTroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource ID to query the troubleshooting result. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: The target resource ID to query the troubleshooting result.
         Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar linked_resource_type: Resource type of the linked resource.
    :vartype linked_resource_type: str
    :ivar link: Link to the external resource.
    :vartype link: str
    :ivar provisioning_state: Provisioning state of the ResourceNavigationLink resource.
    :vartype provisioning_state: str
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "linked_resource_type": {"key": "properties.linkedResourceType", "type": "str"},
        "link": {"key": "properties.link", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        linked_resource_type: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword linked_resource_type: Resource type of the linked resource.
        :paramtype linked_resource_type: str
        :keyword link: Link to the external resource.
        :paramtype link: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None


class RetentionPolicyParameters(_serialization.Model):
    """Parameters that define the retention policy for flow log.

    :ivar days: Number of days to retain flow log records.
    :vartype days: int
    :ivar enabled: Flag to enable/disable retention.
    :vartype enabled: bool
    """

    _attribute_map = {
        "days": {"key": "days", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, days: int = 0, enabled: bool = False, **kwargs):
        """
        :keyword days: Number of days to retain flow log records.
        :paramtype days: int
        :keyword enabled: Flag to enable/disable retention.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.days = days
        self.enabled = enabled


class Route(SubResource):
    """Route resource.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known values
     are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "next_hop_type": {"key": "properties.nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "properties.nextHopIpAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The destination CIDR to which the route applies.
        :paramtype address_prefix: str
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Possible values
         are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known
         values are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2017_06_01.models.RouteNextHopType
        :keyword next_hop_ip_address: The IP address packets should be forwarded to. Next hop values
         are only allowed in routes where the next hop type is VirtualAppliance.
        :paramtype next_hop_ip_address: str
        :keyword provisioning_state: The provisioning state of the resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = provisioning_state


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
        :keyword peerings: A collection of references to express route circuit peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2017_06_01.models.ExpressRouteCircuitPeering]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.rules = rules
        self.peerings = peerings
        self.provisioning_state = None


class RouteFilterListResult(_serialization.Model):
    """Response for the ListRouteFilters API service call.

    :ivar value: Gets a list of route filters in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.RouteFilter]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilter"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a list of route filters in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.RouteFilter]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Known values are:
     "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'.
     "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.v2017_06_01.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', 'Succeeded' and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword access: The access type of the rule. Valid values are: 'Allow', 'Deny'. Known values
         are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'.
         "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.v2017_06_01.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.etag = None
        self.tags = tags
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None


class RouteFilterRuleListResult(_serialization.Model):
    """Response for the ListRouteFilterRules API service call.

    :ivar value: Gets a list of RouteFilterRules in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilterRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilterRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a list of RouteFilterRules in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.RouteFilterRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteListResult(_serialization.Model):
    """Response for the ListRoute API service call.

    :ivar value: Gets a list of routes in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.Route]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Route]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Route"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: Gets a list of routes in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.Route]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.network.v2017_06_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "subnets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[Route]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        routes: Optional[List["_models.Route"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword routes: Collection of routes contained within a route table.
        :paramtype routes: list[~azure.mgmt.network.v2017_06_01.models.Route]
        :keyword provisioning_state: The provisioning state of the resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.routes = routes
        self.subnets = None
        self.provisioning_state = provisioning_state


class RouteTableListResult(_serialization.Model):
    """Response for the ListRouteTable API service call.

    :ivar value: Gets a list of route tables in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.RouteTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteTable"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a list of route tables in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.RouteTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityGroupNetworkInterface(_serialization.Model):
    """Network interface and all its associated security rules.

    :ivar id: ID of the network interface.
    :vartype id: str
    :ivar security_rule_associations: All security rules associated with the network interface.
    :vartype security_rule_associations:
     ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rule_associations": {"key": "securityRuleAssociations", "type": "SecurityRuleAssociations"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        security_rule_associations: Optional["_models.SecurityRuleAssociations"] = None,
        **kwargs
    ):
        """
        :keyword id: ID of the network interface.
        :paramtype id: str
        :keyword security_rule_associations: All security rules associated with the network interface.
        :paramtype security_rule_associations:
         ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAssociations
        """
        super().__init__(**kwargs)
        self.id = id
        self.security_rule_associations = security_rule_associations


class SecurityGroupViewParameters(_serialization.Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: ID of the target VM. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs):
        """
        :keyword target_resource_id: ID of the target VM. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id


class SecurityGroupViewResult(_serialization.Model):
    """The information about security rules applied to the specified VM.

    :ivar network_interfaces: List of network interfaces on the specified VM.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2017_06_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SecurityGroupNetworkInterface]"},
    }

    def __init__(self, *, network_interfaces: Optional[List["_models.SecurityGroupNetworkInterface"]] = None, **kwargs):
        """
        :keyword network_interfaces: List of network interfaces on the specified VM.
        :paramtype network_interfaces:
         list[~azure.mgmt.network.v2017_06_01.models.SecurityGroupNetworkInterface]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces


class SecurityRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Network security rule.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
     '*'. Known values are: "Tcp", "Udp", and "*".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleProtocol
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefix: The destination address prefix. CIDR or destination IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: The network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
    :ivar priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Known values
     are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "source_port_range": {"key": "properties.sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "properties.destinationPortRange", "type": "str"},
        "source_address_prefix": {"key": "properties.sourceAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "properties.sourceAddressPrefixes", "type": "[str]"},
        "destination_address_prefix": {"key": "properties.destinationAddressPrefix", "type": "str"},
        "destination_address_prefixes": {"key": "properties.destinationAddressPrefixes", "type": "[str]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefix: Optional[str] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
         '*'. Known values are: "Tcp", "Udp", and "*".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleProtocol
        :keyword source_port_range: The source port or range. Integer or range between 0 and 65535.
         Asterisk '*' can also be used to match all ports.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range. Integer or range between 0 and
         65535. Asterisk '*' can also be used to match all ports.
        :paramtype destination_port_range: str
        :keyword source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
         match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
         can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :paramtype source_address_prefix: str
        :keyword source_address_prefixes: The CIDR or source IP ranges.
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefix: The destination address prefix. CIDR or destination IP
         range. Asterisk '*' can also be used to match all source IPs. Default tags such as
         'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :paramtype destination_address_prefix: str
        :keyword destination_address_prefixes: The destination address prefixes. CIDR or destination IP
         ranges.
        :paramtype destination_address_prefixes: list[str]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: The network traffic is allowed or denied. Possible values are: 'Allow' and
         'Deny'. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleAccess
        :keyword priority: The priority of the rule. The value can be between 100 and 4096. The
         priority number must be unique for each rule in the collection. The lower the priority number,
         the higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. The direction specifies if rule will be
         evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Known
         values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2017_06_01.models.SecurityRuleDirection
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefix = destination_address_prefix
        self.destination_address_prefixes = destination_address_prefixes
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = provisioning_state


class SecurityRuleAssociations(_serialization.Model):
    """All security rules associated with the network interface.

    :ivar network_interface_association: Network interface and its custom security rules.
    :vartype network_interface_association:
     ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceAssociation
    :ivar subnet_association: Network interface and its custom security rules.
    :vartype subnet_association: ~azure.mgmt.network.v2017_06_01.models.SubnetAssociation
    :ivar default_security_rules: Collection of default security rules of the network security
     group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :ivar effective_security_rules: Collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        "network_interface_association": {"key": "networkInterfaceAssociation", "type": "NetworkInterfaceAssociation"},
        "subnet_association": {"key": "subnetAssociation", "type": "SubnetAssociation"},
        "default_security_rules": {"key": "defaultSecurityRules", "type": "[SecurityRule]"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
    }

    def __init__(
        self,
        *,
        network_interface_association: Optional["_models.NetworkInterfaceAssociation"] = None,
        subnet_association: Optional["_models.SubnetAssociation"] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        **kwargs
    ):
        """
        :keyword network_interface_association: Network interface and its custom security rules.
        :paramtype network_interface_association:
         ~azure.mgmt.network.v2017_06_01.models.NetworkInterfaceAssociation
        :keyword subnet_association: Network interface and its custom security rules.
        :paramtype subnet_association: ~azure.mgmt.network.v2017_06_01.models.SubnetAssociation
        :keyword default_security_rules: Collection of default security rules of the network security
         group.
        :paramtype default_security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        :keyword effective_security_rules: Collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.v2017_06_01.models.EffectiveNetworkSecurityRule]
        """
        super().__init__(**kwargs)
        self.network_interface_association = network_interface_association
        self.subnet_association = subnet_association
        self.default_security_rules = default_security_rules
        self.effective_security_rules = effective_security_rules


class SecurityRuleListResult(_serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a network security group.

    :ivar value: The security rules in a network security group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecurityRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The security rules in a network security group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceEndpointPropertiesFormat(_serialization.Model):
    """The service endpoint properties.

    :ivar service: The type of the endpoint service.
    :vartype service: str
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    :ivar provisioning_state: The provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "service": {"key": "service", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        service: Optional[str] = None,
        locations: Optional[List[str]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword service: The type of the endpoint service.
        :paramtype service: str
        :keyword locations: A list of locations.
        :paramtype locations: list[str]
        :keyword provisioning_state: The provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(**kwargs)
        self.service = service
        self.locations = locations
        self.provisioning_state = provisioning_state


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The address prefix for the subnet.
    :vartype address_prefix: str
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
    :ivar route_table: The reference of the RouteTable resource.
    :vartype route_table: ~azure.mgmt.network.v2017_06_01.models.RouteTable
    :ivar service_endpoints: An array of service endpoints.
    :vartype service_endpoints:
     list[~azure.mgmt.network.v2017_06_01.models.ServiceEndpointPropertiesFormat]
    :ivar ip_configurations: Gets an array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.v2017_06_01.models.IPConfiguration]
    :ivar resource_navigation_links: Gets an array of references to the external resources using
     subnet.
    :vartype resource_navigation_links:
     list[~azure.mgmt.network.v2017_06_01.models.ResourceNavigationLink]
    :ivar provisioning_state: The provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _validation = {
        "ip_configurations": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "route_table": {"key": "properties.routeTable", "type": "RouteTable"},
        "service_endpoints": {"key": "properties.serviceEndpoints", "type": "[ServiceEndpointPropertiesFormat]"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfiguration]"},
        "resource_navigation_links": {"key": "properties.resourceNavigationLinks", "type": "[ResourceNavigationLink]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        route_table: Optional["_models.RouteTable"] = None,
        service_endpoints: Optional[List["_models.ServiceEndpointPropertiesFormat"]] = None,
        resource_navigation_links: Optional[List["_models.ResourceNavigationLink"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The address prefix for the subnet.
        :paramtype address_prefix: str
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2017_06_01.models.NetworkSecurityGroup
        :keyword route_table: The reference of the RouteTable resource.
        :paramtype route_table: ~azure.mgmt.network.v2017_06_01.models.RouteTable
        :keyword service_endpoints: An array of service endpoints.
        :paramtype service_endpoints:
         list[~azure.mgmt.network.v2017_06_01.models.ServiceEndpointPropertiesFormat]
        :keyword resource_navigation_links: Gets an array of references to the external resources using
         subnet.
        :paramtype resource_navigation_links:
         list[~azure.mgmt.network.v2017_06_01.models.ResourceNavigationLink]
        :keyword provisioning_state: The provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.service_endpoints = service_endpoints
        self.ip_configurations = None
        self.resource_navigation_links = resource_navigation_links
        self.provisioning_state = provisioning_state


class SubnetAssociation(_serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs):
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.v2017_06_01.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class SubnetListResult(_serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network.

    :ivar value: The subnets in a virtual network.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Subnet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Subnet"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The subnets in a virtual network.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Topology(_serialization.Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially created for the resource
     group.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: ~datetime.datetime
    :ivar resources:
    :vartype resources: list[~azure.mgmt.network.v2017_06_01.models.TopologyResource]
    """

    _validation = {
        "id": {"readonly": True},
        "created_date_time": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "resources": {"key": "resources", "type": "[TopologyResource]"},
    }

    def __init__(self, *, resources: Optional[List["_models.TopologyResource"]] = None, **kwargs):
        """
        :keyword resources:
        :paramtype resources: list[~azure.mgmt.network.v2017_06_01.models.TopologyResource]
        """
        super().__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = resources


class TopologyAssociation(_serialization.Model):
    """Resources that have an association with the parent resource.

    :ivar name: The name of the resource that is associated with the parent resource.
    :vartype name: str
    :ivar resource_id: The ID of the resource that is associated with the parent resource.
    :vartype resource_id: str
    :ivar association_type: The association type of the child resource to the parent resource.
     Known values are: "Associated" and "Contains".
    :vartype association_type: str or ~azure.mgmt.network.v2017_06_01.models.AssociationType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "association_type": {"key": "associationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        resource_id: Optional[str] = None,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the resource that is associated with the parent resource.
        :paramtype name: str
        :keyword resource_id: The ID of the resource that is associated with the parent resource.
        :paramtype resource_id: str
        :keyword association_type: The association type of the child resource to the parent resource.
         Known values are: "Associated" and "Contains".
        :paramtype association_type: str or ~azure.mgmt.network.v2017_06_01.models.AssociationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.association_type = association_type


class TopologyParameters(_serialization.Model):
    """Parameters that define the representation of topology.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_group_name: The name of the target resource group to perform topology on.
     Required.
    :vartype target_resource_group_name: str
    """

    _validation = {
        "target_resource_group_name": {"required": True},
    }

    _attribute_map = {
        "target_resource_group_name": {"key": "targetResourceGroupName", "type": "str"},
    }

    def __init__(self, *, target_resource_group_name: str, **kwargs):
        """
        :keyword target_resource_group_name: The name of the target resource group to perform topology
         on. Required.
        :paramtype target_resource_group_name: str
        """
        super().__init__(**kwargs)
        self.target_resource_group_name = target_resource_group_name


class TopologyResource(_serialization.Model):
    """The network resource topology information for the given resource group.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar id: ID of the resource.
    :vartype id: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar associations: Holds the associations the resource has with other resources in the
     resource group.
    :vartype associations: list[~azure.mgmt.network.v2017_06_01.models.TopologyAssociation]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "associations": {"key": "associations", "type": "[TopologyAssociation]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        associations: Optional[List["_models.TopologyAssociation"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword id: ID of the resource.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword associations: Holds the associations the resource has with other resources in the
         resource group.
        :paramtype associations: list[~azure.mgmt.network.v2017_06_01.models.TopologyAssociation]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.location = location
        self.associations = associations


class TroubleshootingDetails(_serialization.Model):
    """Information gained from troubleshooting of specified resource.

    :ivar id: The id of the get troubleshoot operation.
    :vartype id: str
    :ivar reason_type: Reason type of failure.
    :vartype reason_type: str
    :ivar summary: A summary of troubleshooting.
    :vartype summary: str
    :ivar detail: Details on troubleshooting results.
    :vartype detail: str
    :ivar recommended_actions: List of recommended actions.
    :vartype recommended_actions:
     list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "reason_type": {"key": "reasonType", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
        "recommended_actions": {"key": "recommendedActions", "type": "[TroubleshootingRecommendedActions]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        reason_type: Optional[str] = None,
        summary: Optional[str] = None,
        detail: Optional[str] = None,
        recommended_actions: Optional[List["_models.TroubleshootingRecommendedActions"]] = None,
        **kwargs
    ):
        """
        :keyword id: The id of the get troubleshoot operation.
        :paramtype id: str
        :keyword reason_type: Reason type of failure.
        :paramtype reason_type: str
        :keyword summary: A summary of troubleshooting.
        :paramtype summary: str
        :keyword detail: Details on troubleshooting results.
        :paramtype detail: str
        :keyword recommended_actions: List of recommended actions.
        :paramtype recommended_actions:
         list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingRecommendedActions]
        """
        super().__init__(**kwargs)
        self.id = id
        self.reason_type = reason_type
        self.summary = summary
        self.detail = detail
        self.recommended_actions = recommended_actions


class TroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The target resource to troubleshoot. Required.
    :vartype target_resource_id: str
    :ivar storage_id: The ID for the storage account to save the troubleshoot result. Required.
    :vartype storage_id: str
    :ivar storage_path: The path to the blob to save the troubleshoot result in. Required.
    :vartype storage_path: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "storage_path": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "storage_path": {"key": "properties.storagePath", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, storage_id: str, storage_path: str, **kwargs):
        """
        :keyword target_resource_id: The target resource to troubleshoot. Required.
        :paramtype target_resource_id: str
        :keyword storage_id: The ID for the storage account to save the troubleshoot result. Required.
        :paramtype storage_id: str
        :keyword storage_path: The path to the blob to save the troubleshoot result in. Required.
        :paramtype storage_path: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.storage_path = storage_path


class TroubleshootingRecommendedActions(_serialization.Model):
    """Recommended actions based on discovered issues.

    :ivar action_id: ID of the recommended action.
    :vartype action_id: str
    :ivar action_text: Description of recommended actions.
    :vartype action_text: str
    :ivar action_uri: The uri linking to a documentation for the recommended troubleshooting
     actions.
    :vartype action_uri: str
    :ivar action_uri_text: The information from the URI for the recommended troubleshooting
     actions.
    :vartype action_uri_text: str
    """

    _attribute_map = {
        "action_id": {"key": "actionId", "type": "str"},
        "action_text": {"key": "actionText", "type": "str"},
        "action_uri": {"key": "actionUri", "type": "str"},
        "action_uri_text": {"key": "actionUriText", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_id: Optional[str] = None,
        action_text: Optional[str] = None,
        action_uri: Optional[str] = None,
        action_uri_text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_id: ID of the recommended action.
        :paramtype action_id: str
        :keyword action_text: Description of recommended actions.
        :paramtype action_text: str
        :keyword action_uri: The uri linking to a documentation for the recommended troubleshooting
         actions.
        :paramtype action_uri: str
        :keyword action_uri_text: The information from the URI for the recommended troubleshooting
         actions.
        :paramtype action_uri_text: str
        """
        super().__init__(**kwargs)
        self.action_id = action_id
        self.action_text = action_text
        self.action_uri = action_uri
        self.action_uri_text = action_uri_text


class TroubleshootingResult(_serialization.Model):
    """Troubleshooting information gained from specified resource.

    :ivar start_time: The start time of the troubleshooting.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the troubleshooting.
    :vartype end_time: ~datetime.datetime
    :ivar code: The result code of the troubleshooting.
    :vartype code: str
    :ivar results: Information from troubleshooting.
    :vartype results: list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "code": {"key": "code", "type": "str"},
        "results": {"key": "results", "type": "[TroubleshootingDetails]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        results: Optional[List["_models.TroubleshootingDetails"]] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time of the troubleshooting.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the troubleshooting.
        :paramtype end_time: ~datetime.datetime
        :keyword code: The result code of the troubleshooting.
        :paramtype code: str
        :keyword results: Information from troubleshooting.
        :paramtype results: list[~azure.mgmt.network.v2017_06_01.models.TroubleshootingDetails]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.results = results


class TunnelConnectionHealth(_serialization.Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar last_connection_established_utc_time: The time at which connection was established in Utc
     format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        "tunnel": {"readonly": True},
        "connection_status": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "last_connection_established_utc_time": {"readonly": True},
    }

    _attribute_map = {
        "tunnel": {"key": "tunnel", "type": "str"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "ingress_bytes_transferred": {"key": "ingressBytesTransferred", "type": "int"},
        "egress_bytes_transferred": {"key": "egressBytesTransferred", "type": "int"},
        "last_connection_established_utc_time": {"key": "lastConnectionEstablishedUtcTime", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class Usage(_serialization.Model):
    """Describes network resource usage.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of measurement. Required. "Count"
    :vartype unit: str or ~azure.mgmt.network.v2017_06_01.models.UsageUnit
    :ivar current_value: The current value of the usage. Required.
    :vartype current_value: int
    :ivar limit: The limit of usage. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.network.v2017_06_01.models.UsageName
    """

    _validation = {
        "unit": {"required": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "_models.UsageUnit"],
        current_value: int,
        limit: int,
        name: "_models.UsageName",
        **kwargs
    ):
        """
        :keyword unit: An enum describing the unit of measurement. Required. "Count"
        :paramtype unit: str or ~azure.mgmt.network.v2017_06_01.models.UsageUnit
        :keyword current_value: The current value of the usage. Required.
        :paramtype current_value: int
        :keyword limit: The limit of usage. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.network.v2017_06_01.models.UsageName
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(_serialization.Model):
    """The list usages operation response.

    :ivar value: The list network resource usages.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list network resource usages.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VerificationIPFlowParameters(_serialization.Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: The ID of the target resource to perform next-hop on. Required.
    :vartype target_resource_id: str
    :ivar direction: The direction of the packet represented as a 5-tuple. Required. Known values
     are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2017_06_01.models.Direction
    :ivar protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.network.v2017_06_01.models.Protocol
    :ivar local_port: The local port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype local_port: str
    :ivar remote_port: The remote port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype remote_port: str
    :ivar local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype local_ip_address: str
    :ivar remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype remote_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of them, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "direction": {"required": True},
        "protocol": {"required": True},
        "local_port": {"required": True},
        "remote_port": {"required": True},
        "local_ip_address": {"required": True},
        "remote_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        direction: Union[str, "_models.Direction"],
        protocol: Union[str, "_models.Protocol"],
        local_port: str,
        remote_port: str,
        local_ip_address: str,
        remote_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_resource_id: The ID of the target resource to perform next-hop on. Required.
        :paramtype target_resource_id: str
        :keyword direction: The direction of the packet represented as a 5-tuple. Required. Known
         values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2017_06_01.models.Direction
        :keyword protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
        :paramtype protocol: str or ~azure.mgmt.network.v2017_06_01.models.Protocol
        :keyword local_port: The local port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype local_port: str
        :keyword remote_port: The remote port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype remote_port: str
        :keyword local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype remote_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of them, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.direction = direction
        self.protocol = protocol
        self.local_port = local_port
        self.remote_port = remote_port
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class VerificationIPFlowResult(_serialization.Model):
    """Results of IP flow verification on the target resource.

    :ivar access: Indicates whether the traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
    :ivar rule_name: Name of the rule. If input is not matched against any security rule, it is not
     displayed.
    :vartype rule_name: str
    """

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
    }

    def __init__(
        self, *, access: Optional[Union[str, "_models.Access"]] = None, rule_name: Optional[str] = None, **kwargs
    ):
        """
        :keyword access: Indicates whether the traffic is allowed or denied. Known values are: "Allow"
         and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2017_06_01.models.Access
        :keyword rule_name: Name of the rule. If input is not matched against any security rule, it is
         not displayed.
        :paramtype rule_name: str
        """
        super().__init__(**kwargs)
        self.access = access
        self.rule_name = rule_name


class VirtualNetwork(Resource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :vartype address_space: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :ivar dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :vartype dhcp_options: ~azure.mgmt.network.v2017_06_01.models.DhcpOptions
    :ivar subnets: A list of subnets in a Virtual Network.
    :vartype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
    :ivar virtual_network_peerings: A list of peerings in a Virtual Network.
    :vartype virtual_network_peerings:
     list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeering]
    :ivar resource_guid: The resourceGuid property of the Virtual Network resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the PublicIP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "address_space": {"key": "properties.addressSpace", "type": "AddressSpace"},
        "dhcp_options": {"key": "properties.dhcpOptions", "type": "DhcpOptions"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "virtual_network_peerings": {"key": "properties.virtualNetworkPeerings", "type": "[VirtualNetworkPeering]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        address_space: Optional["_models.AddressSpace"] = None,
        dhcp_options: Optional["_models.DhcpOptions"] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        virtual_network_peerings: Optional[List["_models.VirtualNetworkPeering"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_space: The AddressSpace that contains an array of IP address ranges that can
         be used by subnets.
        :paramtype address_space: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
        :keyword dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
         deployed in the virtual network.
        :paramtype dhcp_options: ~azure.mgmt.network.v2017_06_01.models.DhcpOptions
        :keyword subnets: A list of subnets in a Virtual Network.
        :paramtype subnets: list[~azure.mgmt.network.v2017_06_01.models.Subnet]
        :keyword virtual_network_peerings: A list of peerings in a Virtual Network.
        :paramtype virtual_network_peerings:
         list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeering]
        :keyword resource_guid: The resourceGuid property of the Virtual Network resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the PublicIP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.virtual_network_peerings = virtual_network_peerings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkConnectionGatewayReference(_serialization.Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class VirtualNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: IP configurations for virtual network gateway.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayIPConfiguration]
    :ivar gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
     'ExpressRoute'. Known values are: "Vpn" and "ExpressRoute".
    :vartype gateway_type: str or ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayType
    :ivar vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
     and 'RouteBased'. Known values are: "PolicyBased" and "RouteBased".
    :vartype vpn_type: str or ~azure.mgmt.network.v2017_06_01.models.VpnType
    :ivar enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :vartype enable_bgp: bool
    :ivar active: ActiveActive flag.
    :vartype active: bool
    :ivar gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :vartype gateway_default_site: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :vartype sku: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySku
    :ivar vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :vartype vpn_client_configuration:
     ~azure.mgmt.network.v2017_06_01.models.VpnClientConfiguration
    :ivar bgp_settings: Virtual network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualNetworkGatewayIPConfiguration]"},
        "gateway_type": {"key": "properties.gatewayType", "type": "str"},
        "vpn_type": {"key": "properties.vpnType", "type": "str"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "active": {"key": "properties.activeActive", "type": "bool"},
        "gateway_default_site": {"key": "properties.gatewayDefaultSite", "type": "SubResource"},
        "sku": {"key": "properties.sku", "type": "VirtualNetworkGatewaySku"},
        "vpn_client_configuration": {"key": "properties.vpnClientConfiguration", "type": "VpnClientConfiguration"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["_models.VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "_models.VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "_models.VpnType"]] = None,
        enable_bgp: Optional[bool] = None,
        active: Optional[bool] = None,
        gateway_default_site: Optional["_models.SubResource"] = None,
        sku: Optional["_models.VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["_models.VpnClientConfiguration"] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword ip_configurations: IP configurations for virtual network gateway.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayIPConfiguration]
        :keyword gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
         'ExpressRoute'. Known values are: "Vpn" and "ExpressRoute".
        :paramtype gateway_type: str or
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayType
        :keyword vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
         and 'RouteBased'. Known values are: "PolicyBased" and "RouteBased".
        :paramtype vpn_type: str or ~azure.mgmt.network.v2017_06_01.models.VpnType
        :keyword enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :paramtype enable_bgp: bool
        :keyword active: ActiveActive flag.
        :paramtype active: bool
        :keyword gateway_default_site: The reference of the LocalNetworkGateway resource which
         represents local network site having default routes. Assign Null value in case of removing
         existing default site setting.
        :paramtype gateway_default_site: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
         selected for Virtual network gateway.
        :paramtype sku: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySku
        :keyword vpn_client_configuration: The reference of the VpnClientConfiguration resource which
         represents the P2S VpnClient configurations.
        :paramtype vpn_client_configuration:
         ~azure.mgmt.network.v2017_06_01.models.VpnClientConfiguration
        :keyword bgp_settings: Virtual network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2017_06_01.models.BgpSettings
        :keyword resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.enable_bgp = enable_bgp
        self.active = active
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2: ~azure.mgmt.network.v2017_06_01.models.LocalNetworkGateway
    :ivar connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Known values are: "Unknown",
     "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2017_06_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
    :ivar resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {"key": "properties.virtualNetworkGateway1", "type": "VirtualNetworkGateway"},
        "virtual_network_gateway2": {"key": "properties.virtualNetworkGateway2", "type": "VirtualNetworkGateway"},
        "local_network_gateway2": {"key": "properties.localNetworkGateway2", "type": "LocalNetworkGateway"},
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkGateway",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["_models.LocalNetworkGateway"] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2: ~azure.mgmt.network.v2017_06_01.models.LocalNetworkGateway
        :keyword connection_type: Gateway connection type. Possible values are:
         'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
        :keyword resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
         resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnectionListEntity(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2:
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
    :ivar connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Known values are: "Unknown",
     "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2017_06_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
    :ivar resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {
            "key": "properties.virtualNetworkGateway1",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "virtual_network_gateway2": {
            "key": "properties.virtualNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "local_network_gateway2": {
            "key": "properties.localNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkConnectionGatewayReference",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        local_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        resource_guid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2:
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkConnectionGatewayReference
        :keyword connection_type: Gateway connection type. Possible values are:
         'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionType
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.v2017_06_01.models.IpsecPolicy]
        :keyword resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
         resource.
        :paramtype resource_guid: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.resource_guid = resource_guid
        self.provisioning_state = None


class VirtualNetworkGatewayConnectionListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGatewayConnection"]] = None, **kwargs):
        """
        :keyword value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
         resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_allocation_method: The private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_allocation_method: The private IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2017_06_01.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2017_06_01.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None


class VirtualNetworkGatewayListConnectionsResult(_serialization.Model):
    """Response for the VirtualNetworkGatewayListConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value:
     list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionListEntity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnectionListEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGatewayConnectionListEntity"]] = None, **kwargs):
        """
        :keyword value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
         resource group.
        :paramtype value:
         list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewayConnectionListEntity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewayListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGateway"]] = None, **kwargs):
        """
        :keyword value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkGatewaySku(_serialization.Model):
    """VirtualNetworkGatewaySku details.

    :ivar name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", and "VpnGw3".
    :vartype name: str or ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuName
    :ivar tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", and "VpnGw3".
    :vartype tier: str or ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.VirtualNetworkGatewaySkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", and "VpnGw3".
        :paramtype name: str or ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuName
        :keyword tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", and "VpnGw3".
        :paramtype tier: str or ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkGatewaySkuTier
        :keyword capacity: The capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class VirtualNetworkListResult(_serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :ivar value: Gets a list of VirtualNetwork resources in a resource group.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a list of VirtualNetwork resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetwork]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkListUsageResult(_serialization.Model):
    """Response for the virtual networks GetUsage API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: VirtualNetwork usage stats.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkUsage]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class VirtualNetworkPeering(SubResource):
    """Peerings in a virtual network resource.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_virtual_network_access: Whether the VMs in the linked virtual network space would
     be able to access all the VMs in local Virtual network space.
    :vartype allow_virtual_network_access: bool
    :ivar allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the remote virtual
     network will be allowed/disallowed.
    :vartype allow_forwarded_traffic: bool
    :ivar allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :vartype allow_gateway_transit: bool
    :ivar use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :vartype use_remote_gateways: bool
    :ivar remote_virtual_network: The reference of the remote virtual network.
    :vartype remote_virtual_network: ~azure.mgmt.network.v2017_06_01.models.SubResource
    :ivar peering_state: The status of the virtual network peering. Possible values are
     'Initiated', 'Connected', and 'Disconnected'. Known values are: "Initiated", "Connected", and
     "Disconnected".
    :vartype peering_state: str or
     ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeeringState
    :ivar provisioning_state: The provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "allow_virtual_network_access": {"key": "properties.allowVirtualNetworkAccess", "type": "bool"},
        "allow_forwarded_traffic": {"key": "properties.allowForwardedTraffic", "type": "bool"},
        "allow_gateway_transit": {"key": "properties.allowGatewayTransit", "type": "bool"},
        "use_remote_gateways": {"key": "properties.useRemoteGateways", "type": "bool"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "peering_state": {"key": "properties.peeringState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allow_virtual_network_access: Optional[bool] = None,
        allow_forwarded_traffic: Optional[bool] = None,
        allow_gateway_transit: Optional[bool] = None,
        use_remote_gateways: Optional[bool] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        peering_state: Optional[Union[str, "_models.VirtualNetworkPeeringState"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allow_virtual_network_access: Whether the VMs in the linked virtual network space
         would be able to access all the VMs in local Virtual network space.
        :paramtype allow_virtual_network_access: bool
        :keyword allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the remote
         virtual network will be allowed/disallowed.
        :paramtype allow_forwarded_traffic: bool
        :keyword allow_gateway_transit: If gateway links can be used in remote virtual networking to
         link to this virtual network.
        :paramtype allow_gateway_transit: bool
        :keyword use_remote_gateways: If remote gateways can be used on this virtual network. If the
         flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network
         will use gateways of remote virtual network for transit. Only one peering can have this flag
         set to true. This flag cannot be set if virtual network already has a gateway.
        :paramtype use_remote_gateways: bool
        :keyword remote_virtual_network: The reference of the remote virtual network.
        :paramtype remote_virtual_network: ~azure.mgmt.network.v2017_06_01.models.SubResource
        :keyword peering_state: The status of the virtual network peering. Possible values are
         'Initiated', 'Connected', and 'Disconnected'. Known values are: "Initiated", "Connected", and
         "Disconnected".
        :paramtype peering_state: str or
         ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeeringState
        :keyword provisioning_state: The provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.remote_virtual_network = remote_virtual_network
        self.peering_state = peering_state
        self.provisioning_state = provisioning_state


class VirtualNetworkPeeringListResult(_serialization.Model):
    """Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual network.

    :ivar value: The peerings in a virtual network.
    :vartype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The peerings in a virtual network.
        :paramtype value: list[~azure.mgmt.network.v2017_06_01.models.VirtualNetworkPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkUsage(_serialization.Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name: ~azure.mgmt.network.v2017_06_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        "current_value": {"readonly": True},
        "id": {"readonly": True},
        "limit": {"readonly": True},
        "name": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "limit": {"key": "limit", "type": "float"},
        "name": {"key": "name", "type": "VirtualNetworkUsageName"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(_serialization.Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        "localized_value": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "localized_value": {"key": "localizedValue", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VpnClientConfiguration(_serialization.Model):
    """VpnClientConfiguration for P2S client.

    :ivar vpn_client_address_pool: The reference of the address space resource which represents
     Address space for P2S VpnClient.
    :vartype vpn_client_address_pool: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
    :ivar vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
    :vartype vpn_client_root_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.VpnClientRootCertificate]
    :ivar vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
    :vartype vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2017_06_01.models.VpnClientRevokedCertificate]
    :ivar vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
    :vartype vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2017_06_01.models.VpnClientProtocol]
    :ivar radius_server_address: The radius server address property of the VirtualNetworkGateway
     resource for vpn client connection.
    :vartype radius_server_address: str
    :ivar radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
     for vpn client connection.
    :vartype radius_server_secret: str
    """

    _attribute_map = {
        "vpn_client_address_pool": {"key": "vpnClientAddressPool", "type": "AddressSpace"},
        "vpn_client_root_certificates": {"key": "vpnClientRootCertificates", "type": "[VpnClientRootCertificate]"},
        "vpn_client_revoked_certificates": {
            "key": "vpnClientRevokedCertificates",
            "type": "[VpnClientRevokedCertificate]",
        },
        "vpn_client_protocols": {"key": "vpnClientProtocols", "type": "[str]"},
        "radius_server_address": {"key": "radiusServerAddress", "type": "str"},
        "radius_server_secret": {"key": "radiusServerSecret", "type": "str"},
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["_models.AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["_models.VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["_models.VpnClientRevokedCertificate"]] = None,
        vpn_client_protocols: Optional[List[Union[str, "_models.VpnClientProtocol"]]] = None,
        radius_server_address: Optional[str] = None,
        radius_server_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword vpn_client_address_pool: The reference of the address space resource which represents
         Address space for P2S VpnClient.
        :paramtype vpn_client_address_pool: ~azure.mgmt.network.v2017_06_01.models.AddressSpace
        :keyword vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        :paramtype vpn_client_root_certificates:
         list[~azure.mgmt.network.v2017_06_01.models.VpnClientRootCertificate]
        :keyword vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
         gateway.
        :paramtype vpn_client_revoked_certificates:
         list[~azure.mgmt.network.v2017_06_01.models.VpnClientRevokedCertificate]
        :keyword vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
        :paramtype vpn_client_protocols: list[str or
         ~azure.mgmt.network.v2017_06_01.models.VpnClientProtocol]
        :keyword radius_server_address: The radius server address property of the VirtualNetworkGateway
         resource for vpn client connection.
        :paramtype radius_server_address: str
        :keyword radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
         for vpn client connection.
        :paramtype radius_server_secret: str
        """
        super().__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates
        self.vpn_client_protocols = vpn_client_protocols
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret


class VpnClientParameters(_serialization.Model):
    """Vpn Client Parameters for package generation.

    :ivar processor_architecture: VPN client Processor Architecture. Possible values are: 'AMD64'
     and 'X86'. Known values are: "Amd64" and "X86".
    :vartype processor_architecture: str or
     ~azure.mgmt.network.v2017_06_01.models.ProcessorArchitecture
    :ivar authentication_method: VPN client Authentication Method. Possible values are: 'EAPTLS'
     and 'EAPMSCHAPv2'. Known values are: "EAPTLS" and "EAPMSCHAPv2".
    :vartype authentication_method: str or
     ~azure.mgmt.network.v2017_06_01.models.AuthenticationMethod
    :ivar radius_server_auth_certificate: The public certificate data for the radius server
     authentication certificate as a Base-64 encoded string. Required only if external radius
     authentication has been configured with EAPTLS authentication.
    :vartype radius_server_auth_certificate: str
    :ivar client_root_certificates: A list of client root certificates public certificate data
     encoded as Base-64 strings. Optional parameter for external radius based authentication with
     EAPTLS.
    :vartype client_root_certificates: list[str]
    """

    _attribute_map = {
        "processor_architecture": {"key": "processorArchitecture", "type": "str"},
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
        "radius_server_auth_certificate": {"key": "radiusServerAuthCertificate", "type": "str"},
        "client_root_certificates": {"key": "clientRootCertificates", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        processor_architecture: Optional[Union[str, "_models.ProcessorArchitecture"]] = None,
        authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None,
        radius_server_auth_certificate: Optional[str] = None,
        client_root_certificates: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword processor_architecture: VPN client Processor Architecture. Possible values are:
         'AMD64' and 'X86'. Known values are: "Amd64" and "X86".
        :paramtype processor_architecture: str or
         ~azure.mgmt.network.v2017_06_01.models.ProcessorArchitecture
        :keyword authentication_method: VPN client Authentication Method. Possible values are: 'EAPTLS'
         and 'EAPMSCHAPv2'. Known values are: "EAPTLS" and "EAPMSCHAPv2".
        :paramtype authentication_method: str or
         ~azure.mgmt.network.v2017_06_01.models.AuthenticationMethod
        :keyword radius_server_auth_certificate: The public certificate data for the radius server
         authentication certificate as a Base-64 encoded string. Required only if external radius
         authentication has been configured with EAPTLS authentication.
        :paramtype radius_server_auth_certificate: str
        :keyword client_root_certificates: A list of client root certificates public certificate data
         encoded as Base-64 strings. Optional parameter for external radius based authentication with
         EAPTLS.
        :paramtype client_root_certificates: list[str]
        """
        super().__init__(**kwargs)
        self.processor_architecture = processor_architecture
        self.authentication_method = authentication_method
        self.radius_server_auth_certificate = radius_server_auth_certificate
        self.client_root_certificates = client_root_certificates


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar thumbprint: The revoked VPN client certificate thumbprint.
    :vartype thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword thumbprint: The revoked VPN client certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = None


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_cert_data: The certificate public data. Required.
    :vartype public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "public_cert_data": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_cert_data: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword public_cert_data: The certificate public data. Required.
        :paramtype public_cert_data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = None
