# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AppliedReservationList(Model):
    """AppliedReservationList.

    :param value:
    :type value: list[str]
    :param next_link: Url to get the next page of reservations
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AppliedReservationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AppliedReservations(Model):
    """AppliedReservations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Identifier of the applied reservations
    :vartype id: str
    :ivar name: Name of resource
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/AppliedReservations"
    :vartype type: str
    :param reservation_order_ids:
    :type reservation_order_ids:
     ~azure.mgmt.reservations.models.AppliedReservationList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reservation_order_ids': {'key': 'properties.reservationOrderIds', 'type': 'AppliedReservationList'},
    }

    def __init__(self, **kwargs):
        super(AppliedReservations, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.reservation_order_ids = kwargs.get('reservation_order_ids', None)


class AqiSettings(Model):
    """Settings for auto quota increase.

    :param auto_quota_increase_state: If the subscription has enabled
     automatic quota increase.
    :type auto_quota_increase_state: object
    """

    _attribute_map = {
        'auto_quota_increase_state': {'key': 'autoQuotaIncreaseState', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(AqiSettings, self).__init__(**kwargs)
        self.auto_quota_increase_state = kwargs.get('auto_quota_increase_state', None)


class AutoQuotaIncreaseDetail(Model):
    """Auto Quota Increase settings.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The subscription Id.
    :vartype id: str
    :ivar name: The name of the auto quota increase.
    :vartype name: str
    :ivar type: The type of the resource
    :vartype type: str
    :param settings: Settings for automatic quota increase.
    :type settings: ~azure.mgmt.reservations.models.AqiSettings
    :param on_failure: The on failure Actions.
    :type on_failure: ~azure.mgmt.reservations.models.OnFailure
    :param on_success: The on success Actions.
    :type on_success: ~azure.mgmt.reservations.models.OnFailure
    :param support_ticket_action: The support ticket action.
    :type support_ticket_action:
     ~azure.mgmt.reservations.models.SupportRequestAction
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'settings': {'key': 'properties.settings', 'type': 'AqiSettings'},
        'on_failure': {'key': 'properties.onFailure', 'type': 'OnFailure'},
        'on_success': {'key': 'properties.onSuccess', 'type': 'OnFailure'},
        'support_ticket_action': {'key': 'properties.supportTicketAction', 'type': 'SupportRequestAction'},
    }

    def __init__(self, **kwargs):
        super(AutoQuotaIncreaseDetail, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.settings = kwargs.get('settings', None)
        self.on_failure = kwargs.get('on_failure', None)
        self.on_success = kwargs.get('on_success', None)
        self.support_ticket_action = kwargs.get('support_ticket_action', None)


class CalculatePriceResponse(Model):
    """CalculatePriceResponse.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.CalculatePriceResponseProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculatePriceResponseProperties'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponse, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CalculatePriceResponseProperties(Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft
     Partner. Used only for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that
     can be placed after calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    :param payment_schedule:
    :type payment_schedule:
     list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
        'payment_schedule': {'key': 'paymentSchedule', 'type': '[PaymentDetail]'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.is_billing_partner_managed = kwargs.get('is_billing_partner_managed', None)
        self.reservation_order_id = kwargs.get('reservation_order_id', None)
        self.sku_title = kwargs.get('sku_title', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.payment_schedule = kwargs.get('payment_schedule', None)


class CalculatePriceResponsePropertiesBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponsePropertiesBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class CalculatePriceResponsePropertiesPricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponsePropertiesPricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class Catalog(Model):
    """Catalog.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU
    :vartype name: str
    :param billing_plans: The billing plan options available for this SKU.
    :type billing_plans: dict[str, list[str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan]]
    :ivar terms: Available reservation terms for this resource
    :vartype terms: list[str or
     ~azure.mgmt.reservations.models.ReservationTerm]
    :ivar locations:
    :vartype locations: list[str]
    :ivar sku_properties:
    :vartype sku_properties: list[~azure.mgmt.reservations.models.SkuProperty]
    :ivar restrictions:
    :vartype restrictions:
     list[~azure.mgmt.reservations.models.SkuRestriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'terms': {'readonly': True},
        'locations': {'readonly': True},
        'sku_properties': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'billing_plans': {'key': 'billingPlans', 'type': '{[str]}'},
        'terms': {'key': 'terms', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'sku_properties': {'key': 'skuProperties', 'type': '[SkuProperty]'},
        'restrictions': {'key': 'restrictions', 'type': '[SkuRestriction]'},
    }

    def __init__(self, **kwargs):
        super(Catalog, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.billing_plans = kwargs.get('billing_plans', None)
        self.terms = None
        self.locations = None
        self.sku_properties = None
        self.restrictions = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CreateGenericQuotaRequestParameters(Model):
    """Quota change requests information.

    :param value: Quota change requests.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
    }

    def __init__(self, **kwargs):
        super(CreateGenericQuotaRequestParameters, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CurrentQuotaLimit(Model):
    """Quota limits.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param limit: The quota limit.
    :type limit: int
    :ivar current_value: The current resource usages information.
    :vartype current_value: int
    :param unit:  The units of the limit, such as - Count, Bytes, etc. Use the
     unit field provided in the Get quota response.
    :type unit: str
    :param name: Name of the resource provide by the resource Provider. Please
     use this name property for quotaRequests.
    :type name: ~azure.mgmt.reservations.models.CurrentQuotaLimitBaseName
    :param resource_type: The Resource Type Name.
    :type resource_type: object
    :ivar quota_period: The quota period over which the usage values are
     summarized, such as - P1D (Per one day), PT1M (Per one minute), PT1S (Per
     one second). This parameter is optional because, for some resources like
     compute, the period doesn’t matter.
    :vartype quota_period: str
    :param properties: Additional properties for the specific resource
     provider.
    :type properties: object
    :ivar provisioning_state: The quota request status.
    :vartype provisioning_state: object
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'quotaInformation.limit', 'type': 'int'},
        'current_value': {'key': 'quotaInformation.currentValue', 'type': 'int'},
        'unit': {'key': 'quotaInformation.unit', 'type': 'str'},
        'name': {'key': 'quotaInformation.name', 'type': 'CurrentQuotaLimitBaseName'},
        'resource_type': {'key': 'quotaInformation.resourceType', 'type': 'object'},
        'quota_period': {'key': 'quotaInformation.quotaPeriod', 'type': 'str'},
        'properties': {'key': 'quotaInformation.properties', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CurrentQuotaLimit, self).__init__(**kwargs)
        self.limit = kwargs.get('limit', None)
        self.current_value = None
        self.unit = kwargs.get('unit', None)
        self.name = kwargs.get('name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.quota_period = None
        self.properties = kwargs.get('properties', None)
        self.provisioning_state = None
        self.message = None


class CurrentQuotaLimitBase(Model):
    """Quota limits.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param limit: The quota limit.
    :type limit: int
    :ivar current_value: The current resource usages information.
    :vartype current_value: int
    :param unit:  The units of the limit, such as - Count, Bytes, etc. Use the
     unit field provided in the Get quota response.
    :type unit: str
    :param name: Name of the resource provide by the resource Provider. Please
     use this name property for quotaRequests.
    :type name: ~azure.mgmt.reservations.models.CurrentQuotaLimitBaseName
    :param resource_type: The Resource Type Name.
    :type resource_type: object
    :ivar quota_period: The quota period over which the usage values are
     summarized, such as - P1D (Per one day), PT1M (Per one minute), PT1S (Per
     one second). This parameter is optional because, for some resources like
     compute, the period doesn’t matter.
    :vartype quota_period: str
    :param properties: Additional properties for the specific resource
     provider.
    :type properties: object
    """

    _validation = {
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'CurrentQuotaLimitBaseName'},
        'resource_type': {'key': 'resourceType', 'type': 'object'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(CurrentQuotaLimitBase, self).__init__(**kwargs)
        self.limit = kwargs.get('limit', None)
        self.current_value = None
        self.unit = kwargs.get('unit', None)
        self.name = kwargs.get('name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.quota_period = None
        self.properties = kwargs.get('properties', None)


class CurrentQuotaLimitBaseName(Model):
    """Name of the resource provide by the resource Provider. Please use this name
    property for quotaRequests.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: Resource name.
    :type value: str
    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CurrentQuotaLimitBaseName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = None


class EmailAction(Model):
    """Email Action.

    :param email_address: The email address for the action.
    :type email_address: str
    """

    _attribute_map = {
        'email_address': {'key': 'emailAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EmailAction, self).__init__(**kwargs)
        self.email_address = kwargs.get('email_address', None)


class EmailActions(Model):
    """The email actions.

    :param value: The list of actions based on the success or failure of
     automatic quota increase action.
    :type value: list[~azure.mgmt.reservations.models.EmailAction]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EmailAction]'},
    }

    def __init__(self, **kwargs):
        super(EmailActions, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Error(Model):
    """Error.

    :param error:
    :type error: ~azure.mgmt.reservations.models.ExtendedErrorInfo
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorException(HttpOperationError):
    """Server responsed with exception of type: 'Error'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorException, self).__init__(deserialize, response, 'Error', *args)


class ExceptionResponse(Model):
    """The api error.

    :param error: The api error details.
    :type error: ~azure.mgmt.reservations.models.ServiceError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ServiceError'},
    }

    def __init__(self, **kwargs):
        super(ExceptionResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExceptionResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ExceptionResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ExceptionResponseException, self).__init__(deserialize, response, 'ExceptionResponse', *args)


class ExtendedErrorInfo(Model):
    """ExtendedErrorInfo.

    :param code: Possible values include: 'NotSpecified',
     'InternalServerError', 'ServerTimeout', 'AuthorizationFailed',
     'BadRequest', 'ClientCertificateThumbprintNotSet',
     'InvalidRequestContent', 'OperationFailed', 'HttpMethodNotSupported',
     'InvalidRequestUri', 'MissingTenantId', 'InvalidTenantId',
     'InvalidReservationOrderId', 'InvalidReservationId',
     'ReservationIdNotInReservationOrder', 'ReservationOrderNotFound',
     'InvalidSubscriptionId', 'InvalidAccessToken', 'InvalidLocationId',
     'UnauthenticatedRequestsThrottled', 'InvalidHealthCheckType', 'Forbidden',
     'BillingScopeIdCannotBeChanged',
     'AppliedScopesNotAssociatedWithCommerceAccount',
     'PatchValuesSameAsExisting', 'RoleAssignmentCreationFailed',
     'ReservationOrderCreationFailed', 'ReservationOrderNotEnabled',
     'CapacityUpdateScopesFailed', 'UnsupportedReservationTerm',
     'ReservationOrderIdAlreadyExists', 'RiskCheckFailed', 'CreateQuoteFailed',
     'ActivateQuoteFailed', 'NonsupportedAccountId',
     'PaymentInstrumentNotFound', 'MissingAppliedScopesForSingle',
     'NoValidReservationsToReRate', 'ReRateOnlyAllowedForEA',
     'OperationCannotBePerformedInCurrentState',
     'InvalidSingleAppliedScopesCount', 'InvalidFulfillmentRequestParameters',
     'NotSupportedCountry', 'InvalidRefundQuantity', 'PurchaseError',
     'BillingCustomerInputError', 'BillingPaymentInstrumentSoftError',
     'BillingPaymentInstrumentHardError', 'BillingTransientError',
     'BillingError', 'FulfillmentConfigurationError',
     'FulfillmentOutOfStockError', 'FulfillmentTransientError',
     'FulfillmentError', 'CalculatePriceFailed'
    :type code: str or ~azure.mgmt.reservations.models.ErrorResponseCode
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExtendedStatusInfo(Model):
    """ExtendedStatusInfo.

    :param status_code: Possible values include: 'None', 'Pending', 'Active',
     'PurchaseError', 'PaymentInstrumentError', 'Split', 'Merged', 'Expired',
     'Succeeded'
    :type status_code: str or
     ~azure.mgmt.reservations.models.ReservationStatusCode
    :param message: The message giving detailed information about the status
     code.
    :type message: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtendedStatusInfo, self).__init__(**kwargs)
        self.status_code = kwargs.get('status_code', None)
        self.message = kwargs.get('message', None)


class MergeRequest(Model):
    """MergeRequest.

    :param sources: Format of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type sources: list[str]
    """

    _attribute_map = {
        'sources': {'key': 'properties.sources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MergeRequest, self).__init__(**kwargs)
        self.sources = kwargs.get('sources', None)


class OnFailure(Model):
    """The actions for auto quota increase.

    :param email_actions: The email actions for auto quota increase.
    :type email_actions: ~azure.mgmt.reservations.models.OnFailureEmailActions
    :param phone_actions: The phone actions for auto quota increase.
    :type phone_actions: ~azure.mgmt.reservations.models.OnFailurePhoneActions
    """

    _attribute_map = {
        'email_actions': {'key': 'emailActions', 'type': 'OnFailureEmailActions'},
        'phone_actions': {'key': 'phoneActions', 'type': 'OnFailurePhoneActions'},
    }

    def __init__(self, **kwargs):
        super(OnFailure, self).__init__(**kwargs)
        self.email_actions = kwargs.get('email_actions', None)
        self.phone_actions = kwargs.get('phone_actions', None)


class OnFailureEmailActions(Model):
    """The email actions for auto quota increase.

    :param value: The list of email actions.
    :type value: list[~azure.mgmt.reservations.models.EmailAction]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EmailAction]'},
    }

    def __init__(self, **kwargs):
        super(OnFailureEmailActions, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class OnFailurePhoneActions(Model):
    """The phone actions for auto quota increase.

    :param value: The list of phone actions.
    :type value: list[~azure.mgmt.reservations.models.PhoneAction]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PhoneAction]'},
    }

    def __init__(self, **kwargs):
        super(OnFailurePhoneActions, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class OperationDisplay(Model):
    """OperationDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationResponse(Model):
    """OperationResponse.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.reservations.models.OperationDisplay
    :param origin:
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationResponse, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)


class Patch(Model):
    """Patch.

    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param name: Name of the Reservation
    :type name: str
    :param renew:
    :type renew: bool
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.PatchPropertiesRenewProperties
    """

    _attribute_map = {
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'instance_flexibility': {'key': 'properties.instanceFlexibility', 'type': 'str'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'renew_properties': {'key': 'properties.renewProperties', 'type': 'PatchPropertiesRenewProperties'},
    }

    def __init__(self, **kwargs):
        super(Patch, self).__init__(**kwargs)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.name = kwargs.get('name', None)
        self.renew = kwargs.get('renew', None)
        self.renew_properties = kwargs.get('renew_properties', None)


class PatchPropertiesRenewProperties(Model):
    """PatchPropertiesRenewProperties.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
    }

    def __init__(self, **kwargs):
        super(PatchPropertiesRenewProperties, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)


class PaymentDetail(Model):
    """Information about payment related to a reservation order.

    :param due_date: Date when the payment needs to be done.
    :type due_date: date
    :param payment_date: Date when the transaction is completed. Is null when
     it is scheduled.
    :type payment_date: date
    :param pricing_currency_total: Amount in pricing currency. Tax not
     included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_currency_total: Amount charged in Billing currency. Tax not
     included. Is null for future payments
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_account: Shows the Account that is charged for this
     payment.
    :type billing_account: str
    :param status: Possible values include: 'Succeeded', 'Failed',
     'Scheduled', 'Cancelled'
    :type status: str or ~azure.mgmt.reservations.models.PaymentStatus
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    """

    _attribute_map = {
        'due_date': {'key': 'dueDate', 'type': 'date'},
        'payment_date': {'key': 'paymentDate', 'type': 'date'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'billing_account': {'key': 'billingAccount', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
    }

    def __init__(self, **kwargs):
        super(PaymentDetail, self).__init__(**kwargs)
        self.due_date = kwargs.get('due_date', None)
        self.payment_date = kwargs.get('payment_date', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.billing_account = kwargs.get('billing_account', None)
        self.status = kwargs.get('status', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)


class PhoneAction(Model):
    """Phone Action.

    :param phone_number: The phone number for the action.
    :type phone_number: str
    :param preferred_channel: The preferred communication channel.
    :type preferred_channel: object
    """

    _attribute_map = {
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
        'preferred_channel': {'key': 'preferredChannel', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(PhoneAction, self).__init__(**kwargs)
        self.phone_number = kwargs.get('phone_number', None)
        self.preferred_channel = kwargs.get('preferred_channel', None)


class Price(Model):
    """Price.

    :param currency_code: The ISO 4217 3-letter currency code for the currency
     used by this purchase record.
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Price, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class Properties(Model):
    """Properties.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.SubscriptionScopeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SubscriptionScopeProperties'},
    }

    def __init__(self, **kwargs):
        super(Properties, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class PurchaseRequest(Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id:
    :type billing_scope_id: str
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param quantity:
    :type quantity: int
    :param display_name: Friendly name of the Reservation
    :type display_name: str
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param renew:
    :type renew: bool
    :param reserved_resource_properties: Properties specific to each reserved
     resource type. Not required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.location = kwargs.get('location', None)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.term = kwargs.get('term', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.quantity = kwargs.get('quantity', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.renew = kwargs.get('renew', None)
        self.reserved_resource_properties = kwargs.get('reserved_resource_properties', None)


class PurchaseRequestPropertiesReservedResourceProperties(Model):
    """Properties specific to each reserved resource type. Not required if not
    applicable.

    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    """

    _attribute_map = {
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PurchaseRequestPropertiesReservedResourceProperties, self).__init__(**kwargs)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)


class QuotaLimitsResponse(Model):
    """Quota limits request response.

    :param value: List of Quota limits with the quota request status.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimit]
    :param next_link: The uri to fetch the next page of quota limits. When
     there are no more pages, this is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QuotaLimitsResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class QuotaRequestDetails(Model):
    """The details of the quota Request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request Id.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The quota request submit time. The date
     conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the
     ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    :ivar type: Type of resource. "Microsoft.Capacity/ServiceLimits"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'properties.value', 'type': '[SubRequest]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QuotaRequestDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.request_submit_time = None
        self.value = kwargs.get('value', None)
        self.type = None


class QuotaRequestOneResourceSubmitResponse(Model):
    """Quota submit request response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request Id.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/ServiceLimits"
    :vartype type: str
    :ivar provisioning_state: The quota request status.
    :vartype provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The quota request submit time. The date
     conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the
     ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param limit: The quota limit.
    :type limit: int
    :ivar current_value: The current resource usages information.
    :vartype current_value: int
    :param unit:  The units of the limit, such as - Count, Bytes, etc. Use the
     unit field provided in the Get quota response.
    :type unit: str
    :param name1: Name of the resource provide by the resource Provider.
     Please use this name property for quotaRequests.
    :type name1: ~azure.mgmt.reservations.models.CurrentQuotaLimitBaseName
    :param resource_type: The Resource Type Name.
    :type resource_type: object
    :ivar quota_period: The quota period over which the usage values are
     summarized, such as - P1D (Per one day), PT1M (Per one minute), PT1S (Per
     one second). This parameter is optional because, for some resources like
     compute, the period doesn’t matter.
    :vartype quota_period: str
    :param properties: Additional properties for the specific resource
     provider.
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'limit': {'key': 'properties.properties.limit', 'type': 'int'},
        'current_value': {'key': 'properties.properties.currentValue', 'type': 'int'},
        'unit': {'key': 'properties.properties.unit', 'type': 'str'},
        'name1': {'key': 'properties.properties.name', 'type': 'CurrentQuotaLimitBaseName'},
        'resource_type': {'key': 'properties.properties.resourceType', 'type': 'object'},
        'quota_period': {'key': 'properties.properties.quotaPeriod', 'type': 'str'},
        'properties': {'key': 'properties.properties.properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(QuotaRequestOneResourceSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.request_submit_time = None
        self.limit = kwargs.get('limit', None)
        self.current_value = None
        self.unit = kwargs.get('unit', None)
        self.name1 = kwargs.get('name1', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.quota_period = None
        self.properties = kwargs.get('properties', None)


class QuotaRequestProperties(Model):
    """The details of quota request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The quota request submit time. The date
     conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the
     ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'object'},
        'message': {'key': 'message', 'type': 'str'},
        'request_submit_time': {'key': 'requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': '[SubRequest]'},
    }

    def __init__(self, **kwargs):
        super(QuotaRequestProperties, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.request_submit_time = None
        self.value = kwargs.get('value', None)


class QuotaRequestSubmitResponse(Model):
    """Quota submit request response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request Id.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :param properties: The quota request details.
    :type properties: ~azure.mgmt.reservations.models.QuotaRequestProperties
    :ivar type: Type of resource. "Microsoft.Capacity/serviceLimits"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'QuotaRequestProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QuotaRequestSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = kwargs.get('properties', None)
        self.type = None


class QuotaRequestSubmitResponse201(Model):
    """The quota request submit response with request id.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request id. Please use the requestId to check the
     request status.
    :vartype id: str
    :ivar name: The operation Id
    :vartype name: str
    :ivar type: The resource type
    :vartype type: str
    :ivar provisioning_state: The quota request status.
    :vartype provisioning_state: object
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QuotaRequestSubmitResponse201, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None


class RenewPropertiesResponse(Model):
    """RenewPropertiesResponse.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included. This is
     locked price 30 days before expiry.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponsePricingCurrencyTotal
    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency for renewal purchase. Tax is not
     included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponseBillingCurrencyTotal
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'RenewPropertiesResponsePricingCurrencyTotal'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'RenewPropertiesResponseBillingCurrencyTotal'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponse, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)


class RenewPropertiesResponseBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency for renewal purchase. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponseBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class RenewPropertiesResponsePricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included. This is locked price 30 days before
    expiry.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponsePricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class ReservationMergeProperties(Model):
    """ReservationMergeProperties.

    :param merge_destination: Reservation Resource Id Created due to the
     merge. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_destination: str
    :param merge_sources: Resource Ids of the Source Reservation's merged to
     form this Reservation. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_sources: list[str]
    """

    _attribute_map = {
        'merge_destination': {'key': 'mergeDestination', 'type': 'str'},
        'merge_sources': {'key': 'mergeSources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ReservationMergeProperties, self).__init__(**kwargs)
        self.merge_destination = kwargs.get('merge_destination', None)
        self.merge_sources = kwargs.get('merge_sources', None)


class ReservationOrderBillingPlanInformation(Model):
    """Information describing the type of billing plan for this reservation.

    :param pricing_currency_total: Amount of money to be paid for the Order.
     Tax is not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param start_date: Date when the billing plan has started.
    :type start_date: date
    :param next_payment_due_date: For recurring billing plans, indicates the
     date when next payment will be processed. Null when total is paid off.
    :type next_payment_due_date: date
    :param transactions:
    :type transactions: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'start_date': {'key': 'startDate', 'type': 'date'},
        'next_payment_due_date': {'key': 'nextPaymentDueDate', 'type': 'date'},
        'transactions': {'key': 'transactions', 'type': '[PaymentDetail]'},
    }

    def __init__(self, **kwargs):
        super(ReservationOrderBillingPlanInformation, self).__init__(**kwargs)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.start_date = kwargs.get('start_date', None)
        self.next_payment_due_date = kwargs.get('next_payment_due_date', None)
        self.transactions = kwargs.get('transactions', None)


class ReservationOrderResponse(Model):
    """ReservationOrderResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param display_name: Friendly name for user to easily identified the
     reservation.
    :type display_name: str
    :param request_date_time: This is the DateTime when the reservation was
     initially requested for purchase.
    :type request_date_time: datetime
    :param created_date_time: This is the DateTime when the reservation was
     created.
    :type created_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param original_quantity:
    :type original_quantity: int
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param plan_information:
    :type plan_information:
     ~azure.mgmt.reservations.models.ReservationOrderBillingPlanInformation
    :param reservations:
    :type reservations:
     list[~azure.mgmt.reservations.models.ReservationResponse]
    :ivar type: Type of resource. "Microsoft.Capacity/reservations"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'request_date_time': {'key': 'properties.requestDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'properties.expiryDate', 'type': 'date'},
        'original_quantity': {'key': 'properties.originalQuantity', 'type': 'int'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'plan_information': {'key': 'properties.planInformation', 'type': 'ReservationOrderBillingPlanInformation'},
        'reservations': {'key': 'properties.reservations', 'type': '[ReservationResponse]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationOrderResponse, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.display_name = kwargs.get('display_name', None)
        self.request_date_time = kwargs.get('request_date_time', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.expiry_date = kwargs.get('expiry_date', None)
        self.original_quantity = kwargs.get('original_quantity', None)
        self.term = kwargs.get('term', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.plan_information = kwargs.get('plan_information', None)
        self.reservations = kwargs.get('reservations', None)
        self.type = None


class ReservationProperties(Model):
    """ReservationProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param display_name: Friendly name for user to easily identify the
     reservation
    :type display_name: str
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param quantity:
    :type quantity: int
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param effective_date_time: DateTime of the Reservation starting when this
     version is effective from.
    :type effective_date_time: datetime
    :ivar last_updated_date_time: DateTime of the last time the Reservation
     was updated.
    :vartype last_updated_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param sku_description: Description of the SKU in english.
    :type sku_description: str
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param split_properties:
    :type split_properties:
     ~azure.mgmt.reservations.models.ReservationSplitProperties
    :param merge_properties:
    :type merge_properties:
     ~azure.mgmt.reservations.models.ReservationMergeProperties
    :param billing_scope_id:
    :type billing_scope_id: str
    :param renew:
    :type renew: bool
    :param renew_source: Reservation Id of the reservation from which this
     reservation is renewed. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_source: str
    :param renew_destination: Reservation Id of the reservation which is
     purchased because of renew. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_destination: str
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.RenewPropertiesResponse
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    """

    _validation = {
        'last_updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'reserved_resource_type': {'key': 'reservedResourceType', 'type': 'str'},
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'applied_scope_type': {'key': 'appliedScopeType', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'effective_date_time': {'key': 'effectiveDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'expiryDate', 'type': 'date'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
        'billing_plan': {'key': 'billingPlan', 'type': 'str'},
        'split_properties': {'key': 'splitProperties', 'type': 'ReservationSplitProperties'},
        'merge_properties': {'key': 'mergeProperties', 'type': 'ReservationMergeProperties'},
        'billing_scope_id': {'key': 'billingScopeId', 'type': 'str'},
        'renew': {'key': 'renew', 'type': 'bool'},
        'renew_source': {'key': 'renewSource', 'type': 'str'},
        'renew_destination': {'key': 'renewDestination', 'type': 'str'},
        'renew_properties': {'key': 'renewProperties', 'type': 'RenewPropertiesResponse'},
        'term': {'key': 'term', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationProperties, self).__init__(**kwargs)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.quantity = kwargs.get('quantity', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.effective_date_time = kwargs.get('effective_date_time', None)
        self.last_updated_date_time = None
        self.expiry_date = kwargs.get('expiry_date', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.split_properties = kwargs.get('split_properties', None)
        self.merge_properties = kwargs.get('merge_properties', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.renew = kwargs.get('renew', None)
        self.renew_source = kwargs.get('renew_source', None)
        self.renew_destination = kwargs.get('renew_destination', None)
        self.renew_properties = kwargs.get('renew_properties', None)
        self.term = kwargs.get('term', None)


class ReservationResponse(Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource.
     "Microsoft.Capacity/reservationOrders/reservations"
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.sku = kwargs.get('sku', None)
        self.properties = kwargs.get('properties', None)
        self.type = None


class ReservationSplitProperties(Model):
    """ReservationSplitProperties.

    :param split_destinations: List of destination Resource Id that are
     created due to split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_destinations: list[str]
    :param split_source: Resource Id of the Reservation from which this is
     split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_source: str
    """

    _attribute_map = {
        'split_destinations': {'key': 'splitDestinations', 'type': '[str]'},
        'split_source': {'key': 'splitSource', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationSplitProperties, self).__init__(**kwargs)
        self.split_destinations = kwargs.get('split_destinations', None)
        self.split_source = kwargs.get('split_source', None)


class ScopeProperties(Model):
    """ScopeProperties.

    :param scope:
    :type scope: str
    :param valid:
    :type valid: bool
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ScopeProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.valid = kwargs.get('valid', None)


class ServiceError(Model):
    """The api error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :ivar details: The list of error details.
    :vartype details: list[~azure.mgmt.reservations.models.ServiceErrorDetail]
    """

    _validation = {
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ServiceErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(ServiceError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = None


class ServiceErrorDetail(Model):
    """The error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class SkuName(Model):
    """SkuName.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class SkuProperty(Model):
    """SkuProperty.

    :param name: An invariant to describe the feature.
    :type name: str
    :param value: An invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuProperty, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SkuRestriction(Model):
    """SkuRestriction.

    :param type: The type of restrictions.
    :type type: str
    :param values: The value of restrictions. If the restriction type is set
     to location. This would be different locations where the SKU is
     restricted.
    :type values: list[str]
    :param reason_code: The reason for restriction.
    :type reason_code: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuRestriction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.values = kwargs.get('values', None)
        self.reason_code = kwargs.get('reason_code', None)


class SplitRequest(Model):
    """SplitRequest.

    :param quantities: List of the quantities in the new reservations to
     create.
    :type quantities: list[int]
    :param reservation_id: Resource id of the reservation to be split. Format
     of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type reservation_id: str
    """

    _attribute_map = {
        'quantities': {'key': 'properties.quantities', 'type': '[int]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SplitRequest, self).__init__(**kwargs)
        self.quantities = kwargs.get('quantities', None)
        self.reservation_id = kwargs.get('reservation_id', None)


class SubRequest(Model):
    """The sub-request submitted with the quota request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The Resource limit.
    :vartype limit: int
    :param name: The Resource name.
    :type name: ~azure.mgmt.reservations.models.SubRequestName
    :ivar resource_type: Resource type for which the quota check was made.
    :vartype resource_type: str
    :param unit:  The units of the limit, such as - Count, Bytes, etc. Use the
     unit field provided in the Get quota response.
    :type unit: str
    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar sub_request_id: Sub request id for individual request.
    :vartype sub_request_id: str
    """

    _validation = {
        'limit': {'readonly': True},
        'resource_type': {'readonly': True},
        'message': {'readonly': True},
        'sub_request_id': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'SubRequestName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'object'},
        'message': {'key': 'message', 'type': 'str'},
        'sub_request_id': {'key': 'subRequestId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubRequest, self).__init__(**kwargs)
        self.limit = None
        self.name = kwargs.get('name', None)
        self.resource_type = None
        self.unit = kwargs.get('unit', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.sub_request_id = None


class SubRequestName(Model):
    """The Resource name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar localized_value: Resource display name.
    :vartype localized_value: str
    :ivar value: Resource name.
    :vartype value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubRequestName, self).__init__(**kwargs)
        self.localized_value = None
        self.value = None


class SubscriptionScopeProperties(Model):
    """SubscriptionScopeProperties.

    :param scopes:
    :type scopes: list[~azure.mgmt.reservations.models.ScopeProperties]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[ScopeProperties]'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionScopeProperties, self).__init__(**kwargs)
        self.scopes = kwargs.get('scopes', None)


class SupportRequestAction(Model):
    """The SupportRequest action.

    :param auto_quota_increase_state: Is support request action enabled.
    :type auto_quota_increase_state: object
    :param severity: The support request severity.
    :type severity: object
    :param first_name: The first name of the recipient.
    :type first_name: str
    :param last_name: The last name of the recipient.
    :type last_name: str
    :param country: The country of the recipient.
    :type country: str
    :param phone_number: The phone number of the recipient.
    :type phone_number: str
    :param primary_email_address: The primary email addresses of the
     recipients.
    :type primary_email_address: str
    :param support_language: The support language.
    :type support_language: str
    :param preferred_contact_method: The preferred communication channel.
    :type preferred_contact_method: object
    :param alternate_email_addresses: The alternate email address of the
     recipient.
    :type alternate_email_addresses: list[str]
    """

    _attribute_map = {
        'auto_quota_increase_state': {'key': 'autoQuotaIncreaseState', 'type': 'object'},
        'severity': {'key': 'severity', 'type': 'object'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
        'primary_email_address': {'key': 'primaryEmailAddress', 'type': 'str'},
        'support_language': {'key': 'supportLanguage', 'type': 'str'},
        'preferred_contact_method': {'key': 'preferredContactMethod', 'type': 'object'},
        'alternate_email_addresses': {'key': 'alternateEmailAddresses', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SupportRequestAction, self).__init__(**kwargs)
        self.auto_quota_increase_state = kwargs.get('auto_quota_increase_state', None)
        self.severity = kwargs.get('severity', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.country = kwargs.get('country', None)
        self.phone_number = kwargs.get('phone_number', None)
        self.primary_email_address = kwargs.get('primary_email_address', None)
        self.support_language = kwargs.get('support_language', None)
        self.preferred_contact_method = kwargs.get('preferred_contact_method', None)
        self.alternate_email_addresses = kwargs.get('alternate_email_addresses', None)
