/*
 * Copyright 2002-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.test.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Test annotation to indicate whether or not the transaction for the annotated
 * test method should be <em>rolled back</em> after the test method has
 * completed. If {@code true}, the transaction will be rolled back;
 * otherwise, the transaction will be committed.
 *
 * @author Sam Brannen
 * @since 2.5
 */
@Target( { ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Rollback {

	/**
	 * <p>
	 * Whether or not the transaction for the annotated method should be rolled
	 * back after the method has completed.
	 * </p>
	 */
	boolean value() default true;

}
