# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorFieldContract(Model):
    """Error Field contract.

    :param code: Property level error code.
    :type code: str
    :param message: Human-readable representation of property-level error.
    :type message: str
    :param target: Property name.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class Resource(Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name
     should be assigned within properties field.
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param kind: The kind of workbook. Choices are user and shared. Possible
     values include: 'user', 'shared'
    :type kind: str or
     ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Workbook(Resource):
    """An Application Insights workbook definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name
     should be assigned within properties field.
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param kind: The kind of workbook. Choices are user and shared. Possible
     values include: 'user', 'shared'
    :type kind: str or
     ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param display_name: Required. The user-defined name (display name) of the
     workbook.
    :type display_name: str
    :param serialized_data: Required. Configuration of this particular
     workbook. Configuration data is a string containing valid JSON
    :type serialized_data: str
    :ivar time_modified: Date and time in UTC of the last modification that
     was made to this workbook definition.
    :vartype time_modified: str
    :param category: Required. Workbook category, as defined by the user at
     creation time.
    :type category: str
    :param version: Workbook version
    :type version: str
    :param workbook_tags: A list of 0 or more tags that are associated with
     this workbook definition
    :type workbook_tags: list[str]
    :param user_id: Required. Unique user id of the specific user that owns
     this workbook.
    :type user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'display_name': {'required': True},
        'serialized_data': {'required': True},
        'time_modified': {'readonly': True},
        'category': {'required': True},
        'user_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'workbook_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Workbook, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.time_modified = None
        self.category = kwargs.get('category', None)
        self.version = kwargs.get('version', None)
        self.workbook_tags = kwargs.get('workbook_tags', None)
        self.user_id = kwargs.get('user_id', None)


class WorkbookError(Model):
    """Error message body that will indicate why the operation failed.

    :param code: Service-defined error code. This code serves as a sub-status
     for the HTTP error code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of
     validation error.
    :type details:
     list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(self, **kwargs):
        super(WorkbookError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class WorkbookErrorException(HttpOperationError):
    """Server responsed with exception of type: 'WorkbookError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(WorkbookErrorException, self).__init__(deserialize, response, 'WorkbookError', *args)


class WorkbookUpdateParameters(Model):
    """The parameters that can be provided when updating workbook properties
    properties.

    :param kind: The kind of workbook. Choices are user and shared. Possible
     values include: 'user', 'shared'
    :type kind: str or
     ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param display_name: The user-defined name (display name) of the workbook.
    :type display_name: str
    :param serialized_data: Configuration of this particular workbook.
     Configuration data is a string containing valid JSON
    :type serialized_data: str
    :param category: Workbook category, as defined by the user at creation
     time.
    :type category: str
    :param tags1: A list of 0 or more tags that are associated with this
     workbook definition
    :type tags1: list[str]
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags1': {'key': 'properties.tags', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(WorkbookUpdateParameters, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.tags = kwargs.get('tags', None)
        self.display_name = kwargs.get('display_name', None)
        self.serialized_data = kwargs.get('serialized_data', None)
        self.category = kwargs.get('category', None)
        self.tags1 = kwargs.get('tags1', None)
