# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._model_base import SdkJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import JobRouterAdministrationClientMixinABC, JobRouterClientMixinABC, prep_if_match, prep_if_none_match

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_job_router_administration_upsert_distribution_policy_request(  # pylint: disable=name-too-long
    distribution_policy_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/distributionPolicies/{distributionPolicyId}"
    path_format_arguments = {
        "distributionPolicyId": _SERIALIZER.url("distribution_policy_id", distribution_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_get_distribution_policy_request(  # pylint: disable=name-too-long
    distribution_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/distributionPolicies/{distributionPolicyId}"
    path_format_arguments = {
        "distributionPolicyId": _SERIALIZER.url("distribution_policy_id", distribution_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_list_distribution_policies_request(  # pylint: disable=name-too-long
    *, maxpagesize: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/distributionPolicies"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_delete_distribution_policy_request(  # pylint: disable=name-too-long
    distribution_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/distributionPolicies/{distributionPolicyId}"
    path_format_arguments = {
        "distributionPolicyId": _SERIALIZER.url("distribution_policy_id", distribution_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_administration_upsert_classification_policy_request(  # pylint: disable=name-too-long
    classification_policy_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/classificationPolicies/{classificationPolicyId}"
    path_format_arguments = {
        "classificationPolicyId": _SERIALIZER.url("classification_policy_id", classification_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_get_classification_policy_request(  # pylint: disable=name-too-long
    classification_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/classificationPolicies/{classificationPolicyId}"
    path_format_arguments = {
        "classificationPolicyId": _SERIALIZER.url("classification_policy_id", classification_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_list_classification_policies_request(  # pylint: disable=name-too-long
    *, maxpagesize: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/classificationPolicies"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_delete_classification_policy_request(  # pylint: disable=name-too-long
    classification_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/classificationPolicies/{classificationPolicyId}"
    path_format_arguments = {
        "classificationPolicyId": _SERIALIZER.url("classification_policy_id", classification_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_administration_upsert_exception_policy_request(  # pylint: disable=name-too-long
    exception_policy_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/exceptionPolicies/{exceptionPolicyId}"
    path_format_arguments = {
        "exceptionPolicyId": _SERIALIZER.url("exception_policy_id", exception_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_get_exception_policy_request(  # pylint: disable=name-too-long
    exception_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/exceptionPolicies/{exceptionPolicyId}"
    path_format_arguments = {
        "exceptionPolicyId": _SERIALIZER.url("exception_policy_id", exception_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_list_exception_policies_request(  # pylint: disable=name-too-long
    *, maxpagesize: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/exceptionPolicies"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_delete_exception_policy_request(  # pylint: disable=name-too-long
    exception_policy_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/exceptionPolicies/{exceptionPolicyId}"
    path_format_arguments = {
        "exceptionPolicyId": _SERIALIZER.url("exception_policy_id", exception_policy_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_administration_upsert_queue_request(  # pylint: disable=name-too-long
    queue_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/queues/{queueId}"
    path_format_arguments = {
        "queueId": _SERIALIZER.url("queue_id", queue_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_get_queue_request(  # pylint: disable=name-too-long
    queue_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/queues/{queueId}"
    path_format_arguments = {
        "queueId": _SERIALIZER.url("queue_id", queue_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_list_queues_request(  # pylint: disable=name-too-long
    *, maxpagesize: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/queues"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_administration_delete_queue_request(  # pylint: disable=name-too-long
    queue_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/queues/{queueId}"
    path_format_arguments = {
        "queueId": _SERIALIZER.url("queue_id", queue_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_upsert_job_request(
    job_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_get_job_request(job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_delete_job_request(job_id: str, **kwargs: Any) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_reclassify_job_request(job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}:reclassify"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_cancel_job_request(job_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}:cancel"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_complete_job_request(job_id: str, assignment_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}/assignments/{assignmentId}:complete"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "assignmentId": _SERIALIZER.url("assignment_id", assignment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_close_job_request(job_id: str, assignment_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}/assignments/{assignmentId}:close"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "assignmentId": _SERIALIZER.url("assignment_id", assignment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_list_jobs_request(
    *,
    maxpagesize: Optional[int] = None,
    status: Optional[Union[str, _models.RouterJobStatusSelector]] = None,
    queue_id: Optional[str] = None,
    channel_id: Optional[str] = None,
    classification_policy_id: Optional[str] = None,
    scheduled_before: Optional[datetime.datetime] = None,
    scheduled_after: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")
    if status is not None:
        _params["status"] = _SERIALIZER.query("status", status, "str")
    if queue_id is not None:
        _params["queueId"] = _SERIALIZER.query("queue_id", queue_id, "str")
    if channel_id is not None:
        _params["channelId"] = _SERIALIZER.query("channel_id", channel_id, "str")
    if classification_policy_id is not None:
        _params["classificationPolicyId"] = _SERIALIZER.query(
            "classification_policy_id", classification_policy_id, "str"
        )
    if scheduled_before is not None:
        _params["scheduledBefore"] = _SERIALIZER.query("scheduled_before", scheduled_before, "iso-8601")
    if scheduled_after is not None:
        _params["scheduledAfter"] = _SERIALIZER.query("scheduled_after", scheduled_after, "iso-8601")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_get_queue_position_request(  # pylint: disable=name-too-long
    job_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}/position"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_unassign_job_request(job_id: str, assignment_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/jobs/{jobId}/assignments/{assignmentId}:unassign"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "assignmentId": _SERIALIZER.url("assignment_id", assignment_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_accept_job_offer_request(  # pylint: disable=name-too-long
    worker_id: str, offer_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/workers/{workerId}/offers/{offerId}:accept"
    path_format_arguments = {
        "workerId": _SERIALIZER.url("worker_id", worker_id, "str"),
        "offerId": _SERIALIZER.url("offer_id", offer_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_decline_job_offer_request(  # pylint: disable=name-too-long
    worker_id: str, offer_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/workers/{workerId}/offers/{offerId}:decline"
    path_format_arguments = {
        "workerId": _SERIALIZER.url("worker_id", worker_id, "str"),
        "offerId": _SERIALIZER.url("offer_id", offer_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_get_queue_statistics_request(  # pylint: disable=name-too-long
    queue_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/queues/{queueId}/statistics"
    path_format_arguments = {
        "queueId": _SERIALIZER.url("queue_id", queue_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_upsert_worker_request(
    worker_id: str,
    *,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/workers/{workerId}"
    path_format_arguments = {
        "workerId": _SERIALIZER.url("worker_id", worker_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_get_worker_request(worker_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/workers/{workerId}"
    path_format_arguments = {
        "workerId": _SERIALIZER.url("worker_id", worker_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_job_router_delete_worker_request(worker_id: str, **kwargs: Any) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    # Construct URL
    _url = "/routing/workers/{workerId}"
    path_format_arguments = {
        "workerId": _SERIALIZER.url("worker_id", worker_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_job_router_list_workers_request(
    *,
    maxpagesize: Optional[int] = None,
    state: Optional[Union[str, _models.RouterWorkerStateSelector]] = None,
    channel_id: Optional[str] = None,
    queue_id: Optional[str] = None,
    has_capacity: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-01-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/routing/workers"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")
    if state is not None:
        _params["state"] = _SERIALIZER.query("state", state, "str")
    if channel_id is not None:
        _params["channelId"] = _SERIALIZER.query("channel_id", channel_id, "str")
    if queue_id is not None:
        _params["queueId"] = _SERIALIZER.query("queue_id", queue_id, "str")
    if has_capacity is not None:
        _params["hasCapacity"] = _SERIALIZER.query("has_capacity", has_capacity, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class JobRouterAdministrationClientOperationsMixin(  # pylint: disable=name-too-long
    JobRouterAdministrationClientMixinABC
):
    @overload
    def upsert_distribution_policy(
        self,
        distribution_policy_id: str,
        resource: _models.DistributionPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.DistributionPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.DistributionPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: DistributionPolicy. The DistributionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """

    @overload
    def upsert_distribution_policy(
        self,
        distribution_policy_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.DistributionPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: DistributionPolicy. The DistributionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """

    @overload
    def upsert_distribution_policy(
        self,
        distribution_policy_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.DistributionPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: DistributionPolicy. The DistributionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """

    @distributed_trace
    def upsert_distribution_policy(
        self,
        distribution_policy_id: str,
        resource: Union[_models.DistributionPolicy, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.DistributionPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :param resource: The resource instance. Is one of the following types: DistributionPolicy,
         JSON, IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.DistributionPolicy or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: DistributionPolicy. The DistributionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DistributionPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_administration_upsert_distribution_policy_request(
            distribution_policy_id=distribution_policy_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.DistributionPolicy, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.DistributionPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_distribution_policy(self, distribution_policy_id: str, **kwargs: Any) -> _models.DistributionPolicy:
        # pylint: disable=line-too-long
        """Retrieves an existing distribution policy by Id.

        Retrieves an existing distribution policy by Id.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :return: DistributionPolicy. The DistributionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DistributionPolicy] = kwargs.pop("cls", None)

        _request = build_job_router_administration_get_distribution_policy_request(
            distribution_policy_id=distribution_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DistributionPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_distribution_policies(self, **kwargs: Any) -> ItemPaged["_models.DistributionPolicy"]:
        # pylint: disable=line-too-long
        """Retrieves existing distribution policies.

        Retrieves existing distribution policies.

        :return: An iterator like instance of DistributionPolicy
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.DistributionPolicy]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "bestWorker":
                distribution_mode = {
                    "kind": "bestWorker",
                    "bypassSelectors": bool,  # Optional. If set to true, then router will match
                      workers to jobs even if they don't match label selectors. Warning: You may get
                      workers that are not qualified for a job they are matched with if you set this
                      variable to true. This flag is intended more for temporary usage. By default, set
                      to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "batchSize": 0,  # Optional. Set batch size when
                          'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. If false, will sort scores by
                          ascending order. By default, set to true.
                        "isBatchScoringEnabled": bool,  # Optional. If set to true, will
                          score workers in batches, and the parameter name of the worker labels will be
                          sent as ``workers``. By default, set to false and the parameter name for the
                          worker labels will be sent as ``worker``. Note: If enabled, use 'batchSize'
                          to set batch size.
                        "scoringParameters": [
                            "str"  # Optional. List of extra parameters from a job that
                              will be sent as part of the payload to scoring rule. If not set, a job's
                              labels (sent in the payload as ``job``"" ) and a job's worker selectors
                              (sent in the payload as ``selectors``"" ) are added to the payload of the
                              scoring rule by default. Note: Worker labels are always sent with scoring
                              payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a distribution policy. Required.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. Friendly name of this policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. Number of seconds after which
                      any offers created under this policy will be expired.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.DistributionPolicy]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_administration_list_distribution_policies_request(
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DistributionPolicy], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_distribution_policy(  # pylint: disable=inconsistent-return-statements
        self, distribution_policy_id: str, **kwargs: Any
    ) -> None:
        """Delete a distribution policy by Id.

        Delete a distribution policy by Id.

        :param distribution_policy_id: Id of a distribution policy. Required.
        :type distribution_policy_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_administration_delete_distribution_policy_request(
            distribution_policy_id=distribution_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def upsert_classification_policy(
        self,
        classification_policy_id: str,
        resource: _models.ClassificationPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ClassificationPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.ClassificationPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ClassificationPolicy. The ClassificationPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """

    @overload
    def upsert_classification_policy(
        self,
        classification_policy_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ClassificationPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ClassificationPolicy. The ClassificationPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """

    @overload
    def upsert_classification_policy(
        self,
        classification_policy_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ClassificationPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ClassificationPolicy. The ClassificationPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """

    @distributed_trace
    def upsert_classification_policy(
        self,
        classification_policy_id: str,
        resource: Union[_models.ClassificationPolicy, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ClassificationPolicy:
        # pylint: disable=line-too-long
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :param resource: The resource instance. Is one of the following types: ClassificationPolicy,
         JSON, IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.ClassificationPolicy or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ClassificationPolicy. The ClassificationPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ClassificationPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_administration_upsert_classification_policy_request(
            classification_policy_id=classification_policy_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.ClassificationPolicy, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.ClassificationPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_classification_policy(self, classification_policy_id: str, **kwargs: Any) -> _models.ClassificationPolicy:
        # pylint: disable=line-too-long
        """Retrieves an existing classification policy by Id.

        Retrieves an existing classification policy by Id.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :return: ClassificationPolicy. The ClassificationPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ClassificationPolicy] = kwargs.pop("cls", None)

        _request = build_job_router_administration_get_classification_policy_request(
            classification_policy_id=classification_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ClassificationPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_classification_policies(self, **kwargs: Any) -> ItemPaged["_models.ClassificationPolicy"]:
        # pylint: disable=line-too-long
        """Retrieves existing classification policies.

        Retrieves existing classification policies.

        :return: An iterator like instance of ClassificationPolicy
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.ClassificationPolicy]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "directMap":
                router_rule = {
                    "kind": "directMap"
                }

                # JSON input template for discriminator value "expression":
                router_rule = {
                    "expression": "str",  # An expression to evaluate. Should contain return
                      statement with calculated values. Required.
                    "kind": "expression",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "function":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "function",
                    "credential": {
                        "appKey": "str",  # Optional. Access key scoped to a Azure Function
                          app. This key grants access to all functions under the app.
                        "clientId": "str",  # Optional. Client id, when AppKey is provided In
                          context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. Access key scoped to a particular
                          function.
                    }
                }

                # JSON input template for discriminator value "static":
                router_rule = {
                    "kind": "static",
                    "value": {}  # Optional. The static value this rule always returns. Values
                      must be primitive values - number, string, boolean.
                }

                # JSON input template for discriminator value "webhook":
                router_rule = {
                    "kind": "webhook",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a classification policy. Required.
                    "fallbackQueueId": "str",  # Optional. Id of a fallback queue to select if
                      queue selector attachments doesn't find a match.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectorAttachments": [
                        queue_selector_attachment
                    ],
                    "workerSelectorAttachments": [
                        worker_selector_attachment
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.ClassificationPolicy]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_administration_list_classification_policies_request(
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ClassificationPolicy], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_classification_policy(  # pylint: disable=inconsistent-return-statements
        self, classification_policy_id: str, **kwargs: Any
    ) -> None:
        """Delete a classification policy by Id.

        Delete a classification policy by Id.

        :param classification_policy_id: Id of a classification policy. Required.
        :type classification_policy_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_administration_delete_classification_policy_request(
            classification_policy_id=classification_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def upsert_exception_policy(
        self,
        exception_policy_id: str,
        resource: _models.ExceptionPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.ExceptionPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ExceptionPolicy. The ExceptionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """

    @overload
    def upsert_exception_policy(
        self,
        exception_policy_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ExceptionPolicy. The ExceptionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """

    @overload
    def upsert_exception_policy(
        self,
        exception_policy_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ExceptionPolicy. The ExceptionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """

    @distributed_trace
    def upsert_exception_policy(
        self,
        exception_policy_id: str,
        resource: Union[_models.ExceptionPolicy, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :param resource: The resource instance. Is one of the following types: ExceptionPolicy, JSON,
         IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.ExceptionPolicy or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: ExceptionPolicy. The ExceptionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExceptionPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_administration_upsert_exception_policy_request(
            exception_policy_id=exception_policy_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.ExceptionPolicy, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.ExceptionPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_exception_policy(self, exception_policy_id: str, **kwargs: Any) -> _models.ExceptionPolicy:
        """Retrieves an existing exception policy by Id.

        Retrieves an existing exception policy by Id.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :return: ExceptionPolicy. The ExceptionPolicy is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ExceptionPolicy] = kwargs.pop("cls", None)

        _request = build_job_router_administration_get_exception_policy_request(
            exception_policy_id=exception_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ExceptionPolicy, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_exception_policies(self, **kwargs: Any) -> ItemPaged["_models.ExceptionPolicy"]:
        """Retrieves existing exception policies.

        Retrieves existing exception policies.

        :return: An iterator like instance of ExceptionPolicy
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.ExceptionPolicy]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of an exception policy. Required.
                    "exceptionRules": [
                        {
                            "actions": [
                                exception_action
                            ],
                            "id": "str",  # Id of an exception rule. Required.
                            "trigger": exception_trigger
                        }
                    ],
                    "name": "str"  # Optional. Friendly name of this policy.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.ExceptionPolicy]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_administration_list_exception_policies_request(
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ExceptionPolicy], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_exception_policy(  # pylint: disable=inconsistent-return-statements
        self, exception_policy_id: str, **kwargs: Any
    ) -> None:
        """Deletes a exception policy by Id.

        Deletes a exception policy by Id.

        :param exception_policy_id: Id of an exception policy. Required.
        :type exception_policy_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_administration_delete_exception_policy_request(
            exception_policy_id=exception_policy_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def upsert_queue(
        self,
        queue_id: str,
        resource: _models.RouterQueue,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterQueue:
        # pylint: disable=line-too-long
        """Creates or updates a queue.

        Creates or updates a queue.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.RouterQueue
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterQueue. The RouterQueue is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """

    @overload
    def upsert_queue(
        self,
        queue_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterQueue:
        # pylint: disable=line-too-long
        """Creates or updates a queue.

        Creates or updates a queue.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterQueue. The RouterQueue is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """

    @overload
    def upsert_queue(
        self,
        queue_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterQueue:
        # pylint: disable=line-too-long
        """Creates or updates a queue.

        Creates or updates a queue.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterQueue. The RouterQueue is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """

    @distributed_trace
    def upsert_queue(
        self,
        queue_id: str,
        resource: Union[_models.RouterQueue, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterQueue:
        # pylint: disable=line-too-long
        """Creates or updates a queue.

        Creates or updates a queue.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :param resource: The resource instance. Is one of the following types: RouterQueue, JSON,
         IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.RouterQueue or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterQueue. The RouterQueue is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterQueue] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_administration_upsert_queue_request(
            queue_id=queue_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterQueue, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterQueue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_queue(self, queue_id: str, **kwargs: Any) -> _models.RouterQueue:
        # pylint: disable=line-too-long
        """Retrieves an existing queue by Id.

        Retrieves an existing queue by Id.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :return: RouterQueue. The RouterQueue is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterQueue] = kwargs.pop("cls", None)

        _request = build_job_router_administration_get_queue_request(
            queue_id=queue_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RouterQueue, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_queues(self, **kwargs: Any) -> ItemPaged["_models.RouterQueue"]:
        # pylint: disable=line-too-long
        """Retrieves existing queues.

        Retrieves existing queues.

        :return: An iterator like instance of RouterQueue
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.RouterQueue]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a queue. Required.
                    "distributionPolicyId": "str",  # Optional. Id of a distribution policy that
                      will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. Id of an exception policy that
                      determines various job escalation rules.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "name": "str"  # Optional. Friendly name of this queue.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.RouterQueue]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_administration_list_queues_request(
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.RouterQueue], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_queue(self, queue_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a queue by Id.

        Deletes a queue by Id.

        :param queue_id: Id of a queue. Required.
        :type queue_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_administration_delete_queue_request(
            queue_id=queue_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class JobRouterClientOperationsMixin(JobRouterClientMixinABC):
    @overload
    def upsert_job(
        self,
        job_id: str,
        resource: _models.RouterJob,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterJob:
        # pylint: disable=line-too-long
        """Creates or updates a router job.

        Creates or updates a router job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.RouterJob
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterJob. The RouterJob is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @overload
    def upsert_job(
        self,
        job_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterJob:
        # pylint: disable=line-too-long
        """Creates or updates a router job.

        Creates or updates a router job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterJob. The RouterJob is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @overload
    def upsert_job(
        self,
        job_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterJob:
        # pylint: disable=line-too-long
        """Creates or updates a router job.

        Creates or updates a router job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterJob. The RouterJob is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @distributed_trace
    def upsert_job(
        self,
        job_id: str,
        resource: Union[_models.RouterJob, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterJob:
        # pylint: disable=line-too-long
        """Creates or updates a router job.

        Creates or updates a router job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param resource: The resource instance. Is one of the following types: RouterJob, JSON,
         IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.RouterJob or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterJob. The RouterJob is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterJob] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_upsert_job_request(
            job_id=job_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterJob, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterJob, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_job(self, job_id: str, **kwargs: Any) -> _models.RouterJob:
        # pylint: disable=line-too-long
        """Retrieves an existing job by Id.

        Retrieves an existing job by Id.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :return: RouterJob. The RouterJob is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterJob] = kwargs.pop("cls", None)

        _request = build_job_router_get_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RouterJob, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_job(self, job_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a job and all of its traces.

        Deletes a job and all of its traces.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_delete_job_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def _reclassify_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        options: Optional[_models._models.ReclassifyJobOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.ReclassifyJobResult: ...

    @overload
    def _reclassify_job(  # pylint: disable=protected-access
        self, job_id: str, options: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.ReclassifyJobResult: ...

    @overload
    def _reclassify_job(  # pylint: disable=protected-access
        self, job_id: str, options: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.ReclassifyJobResult: ...

    @distributed_trace
    def _reclassify_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        options: Optional[Union[_models._models.ReclassifyJobOptions, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models._models.ReclassifyJobResult:
        """Reclassify a job.

        Reclassify a job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param options: Request object for reclassifying a job. Is one of the following types:
         ReclassifyJobOptions, JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.ReclassifyJobOptions or JSON or IO[bytes]
        :return: ReclassifyJobResult. The ReclassifyJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.ReclassifyJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {}
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models._models.ReclassifyJobResult] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_reclassify_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.ReclassifyJobResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _cancel_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        options: Optional[_models.CancelJobOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CancelJobResult: ...

    @overload
    def _cancel_job(  # pylint: disable=protected-access
        self, job_id: str, options: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.CancelJobResult: ...

    @overload
    def _cancel_job(  # pylint: disable=protected-access
        self, job_id: str, options: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.CancelJobResult: ...

    @distributed_trace
    def _cancel_job(  # pylint: disable=protected-access
        self, job_id: str, options: Optional[Union[_models.CancelJobOptions, JSON, IO[bytes]]] = None, **kwargs: Any
    ) -> _models._models.CancelJobResult:
        # pylint: disable=line-too-long
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param options: Request model for cancelling job. Is one of the following types:
         CancelJobOptions, JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.CancelJobOptions or JSON or IO[bytes]
        :return: CancelJobResult. The CancelJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.CancelJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "dispositionCode": "str",  # Optional. Indicates the outcome of a job,
                      populate this field with your own custom values. If not provided, default value
                      of "Cancelled" is set.
                    "note": "str"  # Optional. A note that will be appended to a job's Notes
                      collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models._models.CancelJobResult] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_cancel_job_request(
            job_id=job_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.CancelJobResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _complete_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[_models.CompleteJobOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CompleteJobResult: ...

    @overload
    def _complete_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CompleteJobResult: ...

    @overload
    def _complete_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CompleteJobResult: ...

    @distributed_trace
    def _complete_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[Union[_models.CompleteJobOptions, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models._models.CompleteJobResult:
        """Completes an assigned job.

        Completes an assigned job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request model for completing job. Is one of the following types:
         CompleteJobOptions, JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.CompleteJobOptions or JSON or IO[bytes]
        :return: CompleteJobResult. The CompleteJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.CompleteJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "note": "str"  # Optional. A note that will be appended to a job's Notes
                      collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models._models.CompleteJobResult] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_complete_job_request(
            job_id=job_id,
            assignment_id=assignment_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.CompleteJobResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _close_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[_models.CloseJobOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CloseJobResult: ...

    @overload
    def _close_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CloseJobResult: ...

    @overload
    def _close_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.CloseJobResult: ...

    @distributed_trace
    def _close_job(  # pylint: disable=protected-access
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[Union[_models.CloseJobOptions, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models._models.CloseJobResult:
        # pylint: disable=line-too-long
        """Closes a completed job.

        Closes a completed job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request model for closing job. Is one of the following types: CloseJobOptions,
         JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.CloseJobOptions or JSON or IO[bytes]
        :return: CloseJobResult. The CloseJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.CloseJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "closeAt": "2020-02-20 00:00:00",  # Optional. If not provided, worker
                      capacity is released immediately along with a JobClosedEvent notification. If
                      provided, worker capacity is released along with a JobClosedEvent notification at
                      a future time in UTC.
                    "dispositionCode": "str",  # Optional. Indicates the outcome of a job,
                      populate this field with your own custom values.
                    "note": "str"  # Optional. A note that will be appended to a job's Notes
                      collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models._models.CloseJobResult] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_close_job_request(
            job_id=job_id,
            assignment_id=assignment_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.CloseJobResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_jobs(
        self,
        *,
        status: Optional[Union[str, _models.RouterJobStatusSelector]] = None,
        queue_id: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        scheduled_before: Optional[datetime.datetime] = None,
        scheduled_after: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.RouterJob"]:
        # pylint: disable=line-too-long
        """Retrieves list of jobs based on filter parameters.

        Retrieves list of jobs based on filter parameters.

        :keyword status: If specified, filter jobs by status. Known values are: "all",
         "pendingClassification", "queued", "assigned", "completed", "closed", "cancelled",
         "classificationFailed", "created", "pendingSchedule", "scheduled", "scheduleFailed",
         "waitingForActivation", and "active". Default value is None.
        :paramtype status: str or ~azure.communication.jobrouter.models.RouterJobStatusSelector
        :keyword queue_id: If specified, filter jobs by queue. Default value is None.
        :paramtype queue_id: str
        :keyword channel_id: If specified, filter jobs by channel. Default value is None.
        :paramtype channel_id: str
        :keyword classification_policy_id: If specified, filter jobs by classificationPolicy. Default
         value is None.
        :paramtype classification_policy_id: str
        :keyword scheduled_before: If specified, filter on jobs that was scheduled before or at given
         timestamp. Range: (-Inf, scheduledBefore]. Default value is None.
        :paramtype scheduled_before: ~datetime.datetime
        :keyword scheduled_after: If specified, filter on jobs that was scheduled at or after given
         value. Range: [scheduledAfter, +Inf). Default value is None.
        :paramtype scheduled_after: ~datetime.datetime
        :return: An iterator like instance of RouterJob
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.RouterJob]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "queueAndMatch":
                job_matching_mode = {
                    "kind": "queueAndMatch"
                }

                # JSON input template for discriminator value "scheduleAndSuspend":
                job_matching_mode = {
                    "kind": "scheduleAndSuspend",
                    "scheduleAt": "2020-02-20 00:00:00"  # Requested schedule time. Required.
                }

                # JSON input template for discriminator value "suspend":
                job_matching_mode = {
                    "kind": "suspend"
                }

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a job. Required.
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # Timestamp when the
                              job was assigned to a worker in UTC. Required.
                            "assignmentId": "str",  # Id of a job assignment. Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. Id of the Worker assigned to
                              the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. Id of a classification policy
                      used for classifying this job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. Timestamp a job was queued
                      in UTC.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "matchingMode": job_matching_mode,
                    "notes": [
                        {
                            "message": "str",  # The message contained in the note.
                              Required.
                            "addedAt": "2020-02-20 00:00:00"  # Optional. The time at
                              which the note was added in UTC. If not provided, will default to the
                              current time.
                        }
                    ],
                    "priority": 0,  # Optional. Priority of this job.
                    "queueId": "str",  # Optional. Id of a queue that this job is queued to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the worker selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
                              "greaterThan", and "greaterThanOrEqual".
                            "expedite": bool,  # Optional. Pushes a job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. Status of the worker selector.
                              Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator. Values must be primitive
                              values - number, string, boolean.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.RouterJob]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_list_jobs_request(
                    maxpagesize=maxpagesize,
                    status=status,
                    queue_id=queue_id,
                    channel_id=channel_id,
                    classification_policy_id=classification_policy_id,
                    scheduled_before=scheduled_before,
                    scheduled_after=scheduled_after,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.RouterJob], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_queue_position(self, job_id: str, **kwargs: Any) -> _models.RouterJobPositionDetails:
        """Gets a job's position details.

        Gets a job's position details.

        :param job_id: Id of the job. Required.
        :type job_id: str
        :return: RouterJobPositionDetails. The RouterJobPositionDetails is compatible with
         MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterJobPositionDetails
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "estimatedWaitTimeMinutes": 0.0,  # Estimated wait time of the job rounded up
                      to the nearest minute. Required.
                    "jobId": "str",  # Id of the job these details are about. Required.
                    "position": 0,  # Position of the job in question within that queue.
                      Required.
                    "queueId": "str",  # Id of the queue this job is enqueued in. Required.
                    "queueLength": 0  # Length of the queue: total number of enqueued jobs.
                      Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterJobPositionDetails] = kwargs.pop("cls", None)

        _request = build_job_router_get_queue_position_request(
            job_id=job_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RouterJobPositionDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def unassign_job(
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[_models.UnassignJobOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        # pylint: disable=line-too-long
        """Unassign a job.

        Unassign a job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request body for unassign route. Default value is None.
        :type options: ~azure.communication.jobrouter.models.UnassignJobOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnassignJobResult. The UnassignJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "suspendMatching": bool  # Optional. If SuspendMatching is true, then a job
                      is not queued for re-matching with a worker.
                }

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # Id of an unassigned job. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """

    @overload
    def unassign_job(
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        """Unassign a job.

        Unassign a job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request body for unassign route. Default value is None.
        :type options: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnassignJobResult. The UnassignJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # Id of an unassigned job. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """

    @overload
    def unassign_job(
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        """Unassign a job.

        Unassign a job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request body for unassign route. Default value is None.
        :type options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnassignJobResult. The UnassignJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # Id of an unassigned job. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """

    @distributed_trace
    def unassign_job(
        self,
        job_id: str,
        assignment_id: str,
        options: Optional[Union[_models.UnassignJobOptions, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        # pylint: disable=line-too-long
        """Unassign a job.

        Unassign a job.

        :param job_id: Id of a job. Required.
        :type job_id: str
        :param assignment_id: Id of a job assignment. Required.
        :type assignment_id: str
        :param options: Request body for unassign route. Is one of the following types:
         UnassignJobOptions, JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.UnassignJobOptions or JSON or IO[bytes]
        :return: UnassignJobResult. The UnassignJobResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "suspendMatching": bool  # Optional. If SuspendMatching is true, then a job
                      is not queued for re-matching with a worker.
                }

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # Id of an unassigned job. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.UnassignJobResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_unassign_job_request(
            job_id=job_id,
            assignment_id=assignment_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UnassignJobResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def accept_job_offer(self, worker_id: str, offer_id: str, **kwargs: Any) -> _models.AcceptJobOfferResult:
        """Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param offer_id: Id of an offer. Required.
        :type offer_id: str
        :return: AcceptJobOfferResult. The AcceptJobOfferResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.AcceptJobOfferResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignmentId": "str",  # Id of job assignment that assigns a worker that has
                      accepted an offer to a job. Required.
                    "jobId": "str",  # Id of the job assigned. Required.
                    "workerId": "str"  # Id of the worker that has been assigned this job.
                      Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcceptJobOfferResult] = kwargs.pop("cls", None)

        _request = build_job_router_accept_job_offer_request(
            worker_id=worker_id,
            offer_id=offer_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AcceptJobOfferResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _decline_job_offer(  # pylint: disable=protected-access
        self,
        worker_id: str,
        offer_id: str,
        options: Optional[_models.DeclineJobOfferOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.DeclineJobOfferResult: ...

    @overload
    def _decline_job_offer(  # pylint: disable=protected-access
        self,
        worker_id: str,
        offer_id: str,
        options: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.DeclineJobOfferResult: ...

    @overload
    def _decline_job_offer(  # pylint: disable=protected-access
        self,
        worker_id: str,
        offer_id: str,
        options: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.DeclineJobOfferResult: ...

    @distributed_trace
    def _decline_job_offer(  # pylint: disable=protected-access
        self,
        worker_id: str,
        offer_id: str,
        options: Optional[Union[_models.DeclineJobOfferOptions, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models._models.DeclineJobOfferResult:
        # pylint: disable=line-too-long
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param offer_id: Id of an offer. Required.
        :type offer_id: str
        :param options: Request model for declining offer. Is one of the following types:
         DeclineJobOfferOptions, JSON, IO[bytes] Default value is None.
        :type options: ~azure.communication.jobrouter.models.DeclineJobOfferOptions or JSON or
         IO[bytes]
        :return: DeclineJobOfferResult. The DeclineJobOfferResult is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.DeclineJobOfferResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "retryOfferAt": "2020-02-20 00:00:00"  # Optional. If the RetryOfferAt is not
                      provided, then this job will not be offered again to the worker who declined this
                      job unless the worker is de-registered and re-registered.  If a RetryOfferAt time
                      is provided, then the job will be re-matched to eligible workers at the retry
                      time in UTC.  The worker that declined the job will also be eligible for the job
                      at that time.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models._models.DeclineJobOfferResult] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        content_type = content_type or "application/json"
        _content = None
        if isinstance(options, (IOBase, bytes)):
            _content = options
        else:
            if options is not None:
                _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_job_router_decline_job_offer_request(
            worker_id=worker_id,
            offer_id=offer_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.DeclineJobOfferResult, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_queue_statistics(self, queue_id: str, **kwargs: Any) -> _models.RouterQueueStatistics:
        # pylint: disable=line-too-long
        """Retrieves a queue's statistics.

        Retrieves a queue's statistics.

        :param queue_id: Id of the queue to retrieve statistics. Required.
        :type queue_id: str
        :return: RouterQueueStatistics. The RouterQueueStatistics is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterQueueStatistics
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "length": 0,  # Length of the queue: total number of enqueued jobs. Required.
                    "queueId": "str",  # Id of the queue these details are about. Required.
                    "estimatedWaitTimeMinutes": {
                        "str": 0.0  # Optional. The estimated wait time of this queue rounded
                          up to the nearest minute, grouped by job priority.
                    },
                    "longestJobWaitTimeMinutes": 0.0  # Optional. The wait time of the job that
                      has been enqueued in this queue for the longest.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterQueueStatistics] = kwargs.pop("cls", None)

        _request = build_job_router_get_queue_statistics_request(
            queue_id=queue_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RouterQueueStatistics, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def upsert_worker(
        self,
        worker_id: str,
        resource: _models.RouterWorker,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterWorker:
        # pylint: disable=line-too-long
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param resource: The resource instance. Required.
        :type resource: ~azure.communication.jobrouter.models.RouterWorker
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterWorker. The RouterWorker is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @overload
    def upsert_worker(
        self,
        worker_id: str,
        resource: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterWorker:
        # pylint: disable=line-too-long
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param resource: The resource instance. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterWorker. The RouterWorker is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @overload
    def upsert_worker(
        self,
        worker_id: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterWorker:
        # pylint: disable=line-too-long
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param resource: The resource instance. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterWorker. The RouterWorker is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """

    @distributed_trace
    def upsert_worker(
        self,
        worker_id: str,
        resource: Union[_models.RouterWorker, JSON, IO[bytes]],
        *,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.RouterWorker:
        # pylint: disable=line-too-long
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :param resource: The resource instance. Is one of the following types: RouterWorker, JSON,
         IO[bytes] Required.
        :type resource: ~azure.communication.jobrouter.models.RouterWorker or JSON or IO[bytes]
        :keyword if_unmodified_since: The request should only proceed if the entity was not modified
         after this time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: RouterWorker. The RouterWorker is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }

                # response body for status code(s): 201, 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterWorker] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_job_router_upsert_worker_request(
            worker_id=worker_id,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterWorker, response.json())

        if response.status_code == 201:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

            if _stream:
                deserialized = response.iter_bytes()
            else:
                deserialized = _deserialize(_models.RouterWorker, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_worker(self, worker_id: str, **kwargs: Any) -> _models.RouterWorker:
        # pylint: disable=line-too-long
        """Retrieves an existing worker by Id.

        Retrieves an existing worker by Id.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :return: RouterWorker. The RouterWorker is compatible with MutableMapping
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterWorker] = kwargs.pop("cls", None)

        _request = build_job_router_get_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.RouterWorker, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_worker(self, worker_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a worker and all of its traces.

        Deletes a worker and all of its traces.

        :param worker_id: Id of a worker. Required.
        :type worker_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_job_router_delete_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    # https://github.com/Azure/autorest.python/issues/2262
    @distributed_trace
    def list_workers(
        self,
        *,
        state: Optional[Union[str, _models.RouterWorkerStateSelector]] = None,
        channel_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        has_capacity: Optional[bool] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.RouterWorker"]:
        # pylint: disable=line-too-long
        """Retrieves existing workers.

        Retrieves existing workers.

        :keyword state: If specified, select workers by worker state. Known values are: "active",
         "draining", "inactive", and "all". Default value is None.
        :paramtype state: str or ~azure.communication.jobrouter.models.RouterWorkerStateSelector
        :keyword channel_id: If specified, select workers who have a channel configuration with this
         channel. Default value is None.
        :paramtype channel_id: str
        :keyword queue_id: If specified, select workers who are assigned to this queue. Default value
         is None.
        :paramtype queue_id: str
        :keyword has_capacity: If set to true, select only workers who have capacity for the channel
         specified by ``channelId`` or for any channel if ``channelId`` not specified. If set to false,
         then will return all workers including workers without any capacity for jobs. Defaults to
         false. Default value is None.
        :paramtype has_capacity: bool
        :return: An iterator like instance of RouterWorker
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.jobrouter.models.RouterWorker]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # The entity tag for this resource. Required.
                    "id": "str",  # Id of a worker. Required.
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # Id of the job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "capacity": 0,  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                    "channels": [
                        {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "channelId": "str",  # Id of a channel. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    ],
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions. Values must be
                          primitive values - number, string, boolean.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "maxConcurrentOffers": 0,  # Optional. If this is set, the worker will only
                      receive up to this many new offers at a time.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # Id of the job. Required.
                            "offerId": "str",  # Id of an offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. Timestamp
                              when the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. Timestamp
                              when the offer was created in UTC.
                        }
                    ],
                    "queues": [
                        "str"  # Optional. Collection of queue(s) that this worker can
                          receive work from.
                    ],
                    "state": "str",  # Optional. Current state of a worker. Known values are:
                      "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker. Values must be primitive values - number, string, boolean.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.RouterWorker]] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_job_router_list_workers_request(
                    maxpagesize=maxpagesize,
                    state=state,
                    channel_id=channel_id,
                    queue_id=queue_id,
                    has_capacity=has_capacity,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.RouterWorker], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                if _stream:
                    response.read()  # Load the body in memory and close the socket
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
