/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class ElementNameValuePair {
    private int nameIdx;
    private ElementValue value;
    private ConstantPool cpool;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getNameString()) + "=" + this.value.toString());
        return sb.toString();
    }

    public ElementNameValuePair(int idx, ElementValue value, ConstantPool cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.nameIdx, (byte)1);
        return c.getBytes();
    }

    public final ElementValue getValue() {
        return this.value;
    }

    public String toShortString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return result.toString();
    }
}

