/*
**	Defines for Ensoniq Mirage
**	All defines marked '$' apply to both MASOS & the "normal" OS/
**	All other defines apply only to MASOS.
*/
#define d define
#d MIR_SBPP	256		/* Mirage sample bytes per page */
#d MIR_SNPP	2*MIR_SBPP	/* Mirage sample nybbles per page */

#d ID_ENSONIQ	0x0F		/*$ Ensoniq manufacturer MIDI id # */
#d ID_MIRAGE	0x01		/*$ Ensoniq code for the Mirage */

/* System Exclusive format numbers */
#d MIR_SXW_LOWER	  0x00	/*$ used in defines marked '%' and elsewhere */
#d MIR_SXW_UPPER	  0x10	/*$ used in formats marked '%' and elsewhere */
#d MIR_SXF_CC		0x01	/*$ command code (front panel buttons, cf) */
#d MIR_CC_END		  0x7F	/*$    command end code */
#d MIR_SXF_REQ_PROG	0x03	/*$ % (lower or upper) program dump request */
#d MIR_SXF_DAT_PROG	0x05	/*$ % (lower or upper) program dump data */
#d MIR_SXF_REQ_CPAR	0x00	/* Mirage config. param dump request */
#d MIR_SXF_DAT_CPAR	0x02	/* Mirage config. param dump data */
#d MIR_SXF_REQ_WAVE	0x04	/*$ wavesample dump request */
#d MIR_SXF_DAT_WAVE	0x06	/*$ wavesample dump data */
#d MIR_SXF_PROG		0x07	/* front panel program change */
#d MIR_SXF_WAVE		0x08	/* front panel wavesample change */
#d MIR_SXF_WACK		0x09	/*$ wavesample dump checksum is good */
#d MIR_SXF_WNAK		0x0A	/*$ wavesample dump checksum is bad */
#d MIR_SXF_REQ_AWAVE	0x0B	/* wavesample dump absolute request */
#d MIR_SXF_DAT_AWAVE	0x0C	/* wavesample dump absolute data */
#d MIR_SXF_PPAR		0x0D	/* program parameter change */
#d MIR_SXF_WPAR		0x0E	/* wavesample parameter change */
#d MIR_SXF_WSFUNC	0x0F	/* wavesample manipulation function */
#d MIR_WSFUNC_COPY	  0x00	/*    % copy source to destination */
#d MIR_WSFUNC_SCALE	  0x01	/*    % scale source */
#d MIR_WSFUNC_ADD	  0x02	/*    % destination = destination + source */
#d MIR_WSFUNC_INVERT	  0x03	/*    % invert source */
#d MIR_WSFUNC_REVERSE	  0x04	/*    % reverse source */
#d MIR_WSFUNC_REPL	  0x05	/*    % replicate source page */
#d MIR_WSFUNC_LROT	  0x06	/*    % left rotate current wavesample */
#d MIR_WSFUNC_RROT	  0x07	/*    % right rotate current wavesample */
#d MIR_PROG_LEN		4	/* length of prog change mesg */
#d MIR_WAVE_LEN		4	/* length of wavesample change mesg */
#d MIR_WACK_LEN		3	/* length of wavesample checksum ack mesg */
#d MIR_WNAK_LEN		3	/* length of wavesample checksum nak mesg */
#d MIR_PPAR_LEN		7	/* length of prog param change mesg */
#d MIR_WPAR_LEN		7	/* length of wavesample param change mesg */

/*$ Mirage front panel buttons */
#d MIRBUT_PROG		0x00
#d MIRBUT_0		0x00
#d MIRBUT_1		0x01
#d MIRBUT_2		0x02
#d MIRBUT_3		0x03
#d MIRBUT_4		0x04
#d MIRBUT_5		0x05
#d MIRBUT_6		0x06
#d MIRBUT_7		0x07
#d MIRBUT_8		0x08
#d MIRBUT_9		0x09
#d MIRBUT_ENTER		0x0A
#d MIRBUT_START		0x0A
#d MIRBUT_CANCEL	0x0B
#d MIRBUT_STOP		0x0B
#d MIRBUT_PARAM		0x0C
#d MIRBUT_VALUE		0x0D
#d MIRBUT_ON		0x0E
#d MIRBUT_UP		0x0E
#d MIRBUT_OFF		0x0F
#d MIRBUT_DOWN		0x0F
#d MIRBUT_LOADUPPER	0x10
#d MIRBUT_LOADLOWER	0x11
#d MIRBUT_SAMPLEUPPER	0x12
#d MIRBUT_SAMPLELOWER	0x13
#d MIRBUT_RECSEQ	0x14
#d MIRBUT_PLAYSEQ	0x15
#d MIRBUT_LOADSEQ	0x16
#d MIRBUT_SAVESEQ	0x17
#d MIRBUT_MAX		0x17

/*$ Mirage parameter display formats */
#d MP_BOOL	1		/* 'of' or 'on' */
#d MP_DEC	2		/* decimal */
#d MP_HEX	3		/* hexadecimal */

/*$ Mirage parameter types */
#d MP_UNUSED	0		/* the default if nothing specified */
#d MP_PROG	MIR_SXF_PPAR	/* program, sends this when changed */
#d MP_WAVE	MIR_SXF_WPAR	/* wavesample, sends this when changed */
#d MP_WSEL	MIR_SXF_WAVE	/* sample select, sends this when changed */
#d MP_ACT	99		/* action sequence, not a stored value */

#d bYte	unsigned char

struct	mirpstr	{		/* Mirage parameter characteristics */
	char	*pname;		/* parameter name */
	char	*punit;		/* "octaves", "bytes", etc. */
	bYte	ptype;		/* MP_ACT, MP_PROG, MP_WAVE, MP_GLOB, */
	bYte	pfmt;		/* display format, MP_BOOL, MP_DEC, MP_HEX, */
	bYte	pbase;		/* 0, or 1, based numbers */
	bYte	pfact;		/* mult. factor for storage, 1, 2, */
	bYte	lolim;		/* lowest value */
	bYte	hilim;		/* highest value */
};
#undef	bYte

extern	char	*Mir_cdn[];	/* Mirage configuration dump names */
extern	char	*Mir_ppbn[];	/* Mirage program parameter block names */
extern	char	*Mir_wcbn[];	/* Mirage wavesample control block names */
extern	char	*Mir_but[];	/* Mirage button names */
extern	struct	mirpstr	Masos_par[];	/* parameters for MASOS */

#undef d
