/*
// Abstract:
//	HELP---On-line Help
//
//	The On-line Help module provides access to interactive help.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	25 October 1990
//
// History:
// V01-001	Derek S. Nickel		25-OCY-1990
//	Original.
//
*/

#include <stdio.h>

#include "help.h"
#include "pager.h"

#define HELP(txt) pager(0); printf(txt); printf("\n");

/***********************************************************************
	output_help
***********************************************************************/

void output_help(void)
{
	HELP("Voyager Commands:");
	HELP("  CA addr text");
	HELP("  CAD addr");
	HELP("  CC addr text");
	HELP("  CCD addr");
	HELP("  CL addr");
	HELP("  DUMP [addr]");
	HELP("  DA [addr]");
	HELP("  DH [addr]");
	HELP("  DT [addr]");
	HELP("  EXAMINE HASH_TABLE addr lib-no");
	HELP("  EXAMINE LINK_TABLE addr lib-no");
	HELP("  EXAMINE MESSAGE_TABLE addr lib-no");
	HELP("  EXAMINE SHORT_LIBRARY addr");
	HELP("  EXIT");
	HELP("  FIND addr:addr partial-comment");
	HELP("  HEADER [addr]");
	HELP("  HELP");
	HELP("  LIST addr:addr");
	HELP("  LOAD port module");
	HELP("  MERGE port filename");
	HELP("  SEARCH addr:addr hex-string");
	HELP("  SEARCH addr:addr 'hex-string");
	HELP("  SEARCH addr:addr ENTRY");
	HELP("  SEARCH addr:addr PREFIX");
	HELP("  SET LIMIT number");
	HELP("  SET MODE FOLLOW");
	HELP("  SET MODE NOFOLLOW");
	HELP("  SET MODE INFO");
	HELP("  SET MODE NOINFO");
	HELP("  SET MODE PAGE");
	HELP("  SET MODE NOPAGE");
	HELP("  SET MODE PROMPT");
	HELP("  SET MODE NOPROMPT");
	HELP("  SHOW LIMIT");
	HELP("  SHOW MODES");
	HELP("  SHOW PORTS");
	HELP("  SHOW VERSION");
	HELP("  SORT port");
	HELP("  UNASSEMBLE [addr]");
	HELP("  UNCONTINUE [addr]");
	HELP("  UNLOAD port");
	HELP("  UNTHREAD [addr]");
	HELP("  U [addr]");
	HELP("  UA [addr]");
	HELP("  UT [addr]");
}
