/*
// Abstract:
//	VMAIN---Voyager Mainline
//
//	The Voyager Mainline module provides access to the various
//	Voyager routiens via a Command Line Interface.
//
// Author:
//	Derek S. Nickel
//
// Creation date:
//	25 October 1990
//
// History:
// V01-001	Derek S. Nickel		25-OCT-1990
//	Original.
//
*/

#include "commands.h"
#include "ports.h"

int main(int argc, char *argv[])
{
	int done;
	int port_no;

	/*
	// Load port 0 with main ROM.
	*/

	open_port(0,"HP48");

	/*
	// Execute commands until done.
	*/

	do {
		done = parse_command();
	} while (!done);

	/*
	// Close all ports.
	*/

	for (port_no = 0; port_no <= 2; port_no++)
		close_port(port_no);

	return 0;
}
