PROJ = VOYAGER
PROJFILE = VOYAGER.MAK
DEBUG = 1

CC  = cl
CFLAGS_G  = /AL /W3 /G2 /BATCH
CFLAGS_D  = /qc /Od /Zi /Zr /Gi$(PROJ).mdt
CFLAGS_R  = /Ot
ASM  = masm
AFLAGS_G  = /Mx /T
AFLAGS_D  = /Zi
PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
LINKER	= link
ILINK  = ilink
LRF  = echo > NUL
BIND  = bind
RC  = rc
IMPLIB	= implib
LFLAGS_G  = /NOI /ST:4096  /BATCH
LFLAGS_D  = /CO /INC /F /PACKC
LFLAGS_R  = /E /F /PACKC
MAPFILE_D  = NUL
MAPFILE_R  = NUL

OBJS  = VOYAGER.obj COMMANDS.obj DUMP.obj FIND.obj HELP.obj INDEX.obj\
	INSTRUCT.obj LIST.obj MEMORY.obj MODES.obj OBJECTS.obj PAGER.obj\
	PORTS.obj SEARCH.obj TA.obj TREE.obj
SBRS  = VOYAGER.sbr COMMANDS.sbr DUMP.sbr FIND.sbr HELP.sbr INDEX.sbr\
	INSTRUCT.sbr LIST.sbr MEMORY.sbr MODES.sbr OBJECTS.sbr PAGER.sbr\
	PORTS.sbr SEARCH.sbr TA.sbr TREE.sbr

all: $(PROJ).exe

.SUFFIXES: .c .obj .sbr

VOYAGER.obj : VOYAGER.C commands.h ports.h

VOYAGER.sbr : VOYAGER.C commands.h ports.h

COMMANDS.obj : COMMANDS.C D:\C600\INCLUDE\malloc.h D:\C600\INCLUDE\stdio.h\
	D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\string.h commands.h dump.h\
	find.h list.h memory.h modes.h objects.h pager.h ports.h search.h\
	version.h voyager.h index.h

COMMANDS.sbr : COMMANDS.C D:\C600\INCLUDE\malloc.h D:\C600\INCLUDE\stdio.h\
	D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\string.h commands.h dump.h\
	find.h list.h memory.h modes.h objects.h pager.h ports.h search.h\
	version.h voyager.h index.h

DUMP.obj : DUMP.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\string.h\
	D:\C600\INCLUDE\stdio.h D:\C600\INCLUDE\stdlib.h dump.h memory.h\
	modes.h pager.h voyager.h index.h

DUMP.sbr : DUMP.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\string.h\
	D:\C600\INCLUDE\stdio.h D:\C600\INCLUDE\stdlib.h dump.h memory.h\
	modes.h pager.h voyager.h index.h

FIND.obj : FIND.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h find.h index.h memory.h\
	pager.h tree.h D:\C600\INCLUDE\stdio.h voyager.h

FIND.sbr : FIND.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h find.h index.h memory.h\
	pager.h tree.h D:\C600\INCLUDE\stdio.h voyager.h

HELP.obj : HELP.C D:\C600\INCLUDE\stdio.h help.h pager.h

HELP.sbr : HELP.C D:\C600\INCLUDE\stdio.h help.h pager.h

INDEX.obj : INDEX.C D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\stdio.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h\
	D:\C600\INCLUDE\sys\types.h D:\C600\INCLUDE\sys\stat.h index.h\
	memory.h modes.h tree.h voyager.h

INDEX.sbr : INDEX.C D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\stdio.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h\
	D:\C600\INCLUDE\sys\types.h D:\C600\INCLUDE\sys\stat.h index.h\
	memory.h modes.h tree.h voyager.h

INSTRUCT.obj : INSTRUCT.C D:\C600\INCLUDE\string.h D:\C600\INCLUDE\ctype.h\
	modes.h pager.h memory.h index.h instruct.h D:\C600\INCLUDE\stdlib.h\
	voyager.h D:\C600\INCLUDE\stdio.h

INSTRUCT.sbr : INSTRUCT.C D:\C600\INCLUDE\string.h D:\C600\INCLUDE\ctype.h\
	modes.h pager.h memory.h index.h instruct.h D:\C600\INCLUDE\stdlib.h\
	voyager.h D:\C600\INCLUDE\stdio.h

LIST.obj : LIST.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h list.h index.h memory.h\
	pager.h tree.h D:\C600\INCLUDE\stdio.h voyager.h

LIST.sbr : LIST.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h list.h index.h memory.h\
	pager.h tree.h D:\C600\INCLUDE\stdio.h voyager.h

MEMORY.obj : MEMORY.C D:\C600\INCLUDE\string.h D:\C600\INCLUDE\stdlib.h\
	index.h memory.h pager.h instruct.h D:\C600\INCLUDE\stdio.h voyager.h

MEMORY.sbr : MEMORY.C D:\C600\INCLUDE\string.h D:\C600\INCLUDE\stdlib.h\
	index.h memory.h pager.h instruct.h D:\C600\INCLUDE\stdio.h voyager.h

MODES.obj : MODES.C modes.h

MODES.sbr : MODES.C modes.h

OBJECTS.obj : OBJECTS.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\io.h\
	D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\string.h memory.h modes.h\
	objects.h pager.h index.h instruct.h voyager.h D:\C600\INCLUDE\stdio.h

OBJECTS.sbr : OBJECTS.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\io.h\
	D:\C600\INCLUDE\stdlib.h D:\C600\INCLUDE\string.h memory.h modes.h\
	objects.h pager.h index.h instruct.h voyager.h D:\C600\INCLUDE\stdio.h

PAGER.obj : PAGER.C D:\C600\INCLUDE\conio.h D:\C600\INCLUDE\stdio.h pager.h\
	modes.h

PAGER.sbr : PAGER.C D:\C600\INCLUDE\conio.h D:\C600\INCLUDE\stdio.h pager.h\
	modes.h

PORTS.obj : PORTS.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h D:\C600\INCLUDE\time.h\
	memory.h index.h modes.h ports.h voyager.h D:\C600\INCLUDE\stdio.h

PORTS.sbr : PORTS.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h D:\C600\INCLUDE\time.h\
	memory.h index.h modes.h ports.h voyager.h D:\C600\INCLUDE\stdio.h

SEARCH.obj : SEARCH.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h memory.h modes.h pager.h\
	voyager.h index.h D:\C600\INCLUDE\stdio.h

SEARCH.sbr : SEARCH.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h memory.h modes.h pager.h\
	voyager.h index.h D:\C600\INCLUDE\stdio.h

TA.obj : TA.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h memory.h commands.h\
	modes.h objects.h instruct.h ports.h voyager.h index.h\
	D:\C600\INCLUDE\stdio.h

TA.sbr : TA.C D:\C600\INCLUDE\ctype.h D:\C600\INCLUDE\stdlib.h\
	D:\C600\INCLUDE\string.h D:\C600\INCLUDE\io.h memory.h commands.h\
	modes.h objects.h instruct.h ports.h voyager.h index.h\
	D:\C600\INCLUDE\stdio.h

TREE.obj : TREE.C D:\C600\INCLUDE\stddef.h D:\C600\INCLUDE\stdio.h

TREE.sbr : TREE.C D:\C600\INCLUDE\stddef.h D:\C600\INCLUDE\stdio.h


$(PROJ).bsc : $(SBRS)
	$(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(OBJS)
!IF $(DEBUG)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
	$(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
	$(LINKER) @$(PROJ).lrf
!ENDIF


.c.obj :
!IF $(DEBUG)
	$(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
	$(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.c.sbr :
!IF $(DEBUG)
	$(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
	$(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF


run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
	CV $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
