/*
 * Decompiled with CFR 0.152.
 */
import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class AdvRoom {
    private String MARKER = "-----";
    private boolean visitedFlag;
    private int roomNumber;
    private ArrayList objects = new ArrayList();
    private AdvMotionTableEntry singleTable;
    private ArrayList MotionArrayList = new ArrayList();
    private AdvMotionTableEntry[] MotionTables;
    private String[] longDescriptionArray;
    private BufferedReader rd;
    private String shortDescription;

    public int getRoomNumber() {
        return this.roomNumber;
    }

    public String getName() {
        return this.shortDescription;
    }

    public String[] getDescription() {
        return this.longDescriptionArray;
    }

    public void addObject(AdvObject obj) {
        this.objects.add(obj);
    }

    public void removeObject(AdvObject obj) {
        this.objects.remove(obj);
    }

    public boolean containsObject(AdvObject obj) {
        return this.objects.contains(obj);
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public AdvObject getObject(int index) {
        return (AdvObject)this.objects.get(index);
    }

    public void setVisited(boolean flag) {
        this.visitedFlag = flag;
    }

    public boolean hasBeenVisited() {
        return this.visitedFlag;
    }

    public AdvMotionTableEntry[] getMotionTable() {
        return this.MotionTables;
    }

    public boolean readFromFile(BufferedReader rd) {
        try {
            String line;
            do {
                if ((line = rd.readLine()) != null) continue;
                return false;
            } while (line.length() <= 0);
            this.roomNumber = Integer.parseInt(line);
            this.shortDescription = "";
            do {
                if ((line = rd.readLine()) != null) continue;
                return false;
            } while (line.length() <= 0);
            this.shortDescription = String.valueOf(this.shortDescription) + line;
            ArrayList<String> longDescription = new ArrayList<String>();
            while (!(line = rd.readLine()).equals(this.MARKER)) {
                longDescription.add(line);
            }
            this.transferToArray(longDescription);
            while ((line = rd.readLine()) != null && line.length() != 0) {
                this.readExits(line);
            }
            this.MotionTables = new AdvMotionTableEntry[this.MotionArrayList.size()];
            int i = 0;
            while (i < this.MotionArrayList.size()) {
                this.MotionTables[i] = (AdvMotionTableEntry)this.MotionArrayList.get(i);
                ++i;
            }
            return true;
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("Illegal question number");
        }
    }

    private void readExits(String line) {
        int destinationRoom;
        int space = line.indexOf(" ");
        String direction = line.substring(0, space);
        int slash = line.indexOf("/");
        String key = null;
        if (slash == -1) {
            destinationRoom = Integer.parseInt(line.substring(space).trim());
        } else {
            destinationRoom = Integer.parseInt(line.substring(space, slash).trim());
            key = line.substring(slash + 1);
        }
        this.singleTable = new AdvMotionTableEntry(direction, destinationRoom, key);
        this.MotionArrayList.add(this.singleTable);
    }

    private void transferToArray(ArrayList longdescript) {
        this.longDescriptionArray = new String[longdescript.size()];
        int i = 0;
        while (i < longdescript.size()) {
            this.longDescriptionArray[i] = (String)longdescript.get(i);
            ++i;
        }
    }
}

