/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;

public class GPolygon
extends GObject
implements GFillable,
GScalable {
    private static final double EPSILON = 1.0E-5;
    private double cx;
    private double cy;
    private double xScale;
    private double yScale;
    private double rotation;
    private ArrayList vertexList;
    private boolean cacheValid;
    private boolean complete;
    private Polygon poly;
    private Object lock;
    private boolean isFilled;
    private Color fillColor;

    public GPolygon() {
        this(0.0, 0.0);
    }

    public GPolygon(double x, double y) {
        this.clear();
        this.lock = new Object();
        this.setLocation(x, y);
    }

    public GPolygon(GPoint[] points) {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < points.length) {
                this.vertexList.add(new GPoint(points[i].getX(), points[i].getY()));
                ++i;
            }
        }
        this.markAsComplete();
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.lock = new Object();
        this.setLocation(0.0, 0.0);
    }

    public void addVertex(double x, double y) {
        if (this.complete) {
            throw new ErrorException("You can't add vertices to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.vertexList.add(new GPoint(x, y));
            this.cx = x;
            this.cy = y;
        }
    }

    public void addEdge(double dx, double dy) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.cx += dx;
            this.cy += dy;
            this.vertexList.add(new GPoint(this.cx, this.cy));
        }
    }

    public final void addPolarEdge(double r, double theta) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.cx += r * GMath.cosDegrees(theta);
            this.cy -= r * GMath.sinDegrees(theta);
            this.vertexList.add(new GPoint(this.cx, this.cy));
        }
    }

    public void scale(double sx, double sy) {
        this.xScale *= sx;
        this.yScale *= sy;
        this.repaint();
    }

    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    public void rotate(double theta) {
        this.rotation += theta;
        this.repaint();
    }

    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public GRectangle getBounds() {
        int nPoints = this.vertexList.size();
        if (nPoints == 0) {
            return new GRectangle();
        }
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        Object object = this.lock;
        synchronized (object) {
            double x0 = this.getX();
            double y0 = this.getY();
            double sinTheta = GMath.sinDegrees(this.rotation);
            double cosTheta = GMath.cosDegrees(this.rotation);
            boolean first = true;
            int i = 0;
            while (i < this.vertexList.size()) {
                GPoint vertex = (GPoint)this.vertexList.get(i);
                double x = x0 + this.xScale * (cosTheta * vertex.getX() - sinTheta * vertex.getY());
                double y = y0 + this.yScale * (sinTheta * vertex.getX() + cosTheta * vertex.getY());
                if (first) {
                    xMin = x;
                    xMax = x;
                    yMin = y;
                    yMax = y;
                    first = false;
                } else {
                    xMin = Math.min(xMin, x);
                    xMax = Math.max(xMax, x);
                    yMin = Math.min(yMin, y);
                    yMax = Math.max(yMax, y);
                }
                ++i;
            }
        }
        return new GRectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public boolean contains(double x, double y) {
        return this.getPolygon().contains(GMath.round(x), GMath.round(y));
    }

    public void paint(Graphics g) {
        if (this.vertexList.size() == 0) {
            return;
        }
        Polygon p = this.getPolygon();
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(this.getColor());
        }
        g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void recenter() {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        boolean first = true;
        int i = 0;
        while (i < this.vertexList.size()) {
            GPoint vertex = (GPoint)this.vertexList.get(i);
            if (first) {
                xMin = vertex.getX();
                xMax = vertex.getX();
                yMin = vertex.getY();
                yMax = vertex.getY();
                first = false;
            } else {
                xMin = Math.min(xMin, vertex.getX());
                xMax = Math.max(xMax, vertex.getX());
                yMin = Math.min(yMin, vertex.getY());
                yMax = Math.max(yMax, vertex.getX());
            }
            ++i;
        }
        double xc = (xMin + xMax) / 2.0;
        double yc = (yMin + yMax) / 2.0;
        int i2 = 0;
        while (i2 < this.vertexList.size()) {
            GPoint vertex = (GPoint)this.vertexList.get(i2);
            vertex.translate(-xc, -yc);
            ++i2;
        }
        this.cacheValid = false;
    }

    public Object clone() {
        try {
            Object clone = super.clone();
            ((GPolygon)clone).copyVertexList();
            return clone;
        }
        catch (Exception CloneNotSupportedException) {
            throw new ErrorException("Impossible exception");
        }
    }

    protected void repaint() {
        this.cacheValid = false;
        super.repaint();
    }

    protected Polygon getPolygon() {
        if (this.cacheValid) {
            return this.poly;
        }
        Object object = this.lock;
        synchronized (object) {
            double x0 = this.getX();
            double y0 = this.getY();
            double sinTheta = GMath.sinDegrees(this.rotation);
            double cosTheta = GMath.cosDegrees(this.rotation);
            this.poly = new Polygon();
            int i = 0;
            while (i < this.vertexList.size()) {
                GPoint vertex = (GPoint)this.vertexList.get(i);
                double x = x0 + this.xScale * (cosTheta * vertex.getX() - sinTheta * vertex.getY());
                double y = y0 + this.yScale * (sinTheta * vertex.getX() + cosTheta * vertex.getY());
                this.poly.addPoint(GMath.round(x), GMath.round(y));
                ++i;
            }
            this.cacheValid = true;
            return this.poly;
        }
    }

    protected void markAsComplete() {
        this.complete = true;
    }

    protected void clear() {
        if (this.complete) {
            throw new ErrorException("You can't clear a GPolygon that has been marked as complete.");
        }
        this.vertexList = new ArrayList();
        this.cx = 0.0;
        this.cy = 0.0;
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.cacheValid = false;
    }

    private void copyVertexList() {
        ArrayList newList = new ArrayList();
        int i = 0;
        while (i < this.vertexList.size()) {
            newList.add(this.vertexList.get(i));
            ++i;
        }
        this.vertexList = newList;
    }
}

