/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private boolean exceptionOnError;
    private double minValue;
    private double maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private IODialog dialog;

    public DoubleField() {
        this("", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double value) {
        this("" + value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double low, double high) {
        this("", low, high);
    }

    public DoubleField(double value, double low, double high) {
        this("" + value, low, high);
    }

    private DoubleField(String str, double low, double high) {
        this.setBackground(Color.white);
        this.setHorizontalAlignment(4);
        this.minValue = low;
        this.maxValue = high;
        this.setText(str);
        this.exceptionOnError = false;
    }

    public double getValue() {
        double value;
        block7: {
            String text = this.getText();
            String msg = null;
            value = 0.0;
            try {
                value = Double.valueOf(text.trim());
                if (value >= this.minValue && value <= this.maxValue) break block7;
                msg = "Value is outside the specified range";
            }
            catch (NumberFormatException ex) {
                msg = "Illegal numeric format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(msg);
            }
            String prompt = "Enter a number";
            if (this.minValue != Double.NEGATIVE_INFINITY) {
                prompt = this.maxValue != Double.POSITIVE_INFINITY ? String.valueOf(prompt) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(prompt) + " greater than " + this.minValue;
            } else if (this.maxValue != Double.POSITIVE_INFINITY) {
                prompt = String.valueOf(prompt) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            value = this.dialog.readDouble(prompt, this.minValue, this.maxValue);
        }
        this.setValue(value);
        return value;
    }

    public void setValue(double d) {
        String str = "" + d;
        if (this.formatter != null) {
            str = this.formatter.format(d);
        }
        this.setText(str);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String format) {
        this.formatString = format;
        this.formatter = format == null ? null : new DecimalFormat(format);
        try {
            this.setValue(Double.valueOf(this.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(60, size.width), Math.max(22, size.height));
    }
}

