/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GCanvas;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.program.GObjectProgram;
import acm.program.GProgramListener;
import acm.program.Program;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;

public abstract class GraphicsProgram
extends Program {
    private static final int BORDER_PIXELS = 4;
    private GCanvas gc;
    private GProgramListener listener = new GProgramListener(this);

    protected GraphicsProgram() {
        this.gc = this.createGCanvas();
        this.gc.addMouseListener(this.listener);
        this.add((Component)this.gc, "Center");
        this.validate();
    }

    public void run() {
    }

    public void init() {
    }

    public GCanvas getGCanvas() {
        return this.gc;
    }

    public int getWidth() {
        return this.gc.getWidth();
    }

    public int getHeight() {
        return this.gc.getHeight();
    }

    public void add(GObject gobj) {
        this.gc.add(gobj);
    }

    public final void add(GObject gobj, double x, double y) {
        this.add(gobj);
        gobj.setLocation(x, y);
    }

    public final void add(GObject gobj, GPoint pt) {
        this.add(gobj);
        gobj.setLocation(pt);
    }

    public void remove(GObject gobj) {
        this.gc.remove(gobj);
    }

    public void removeAll() {
        this.gc.removeAll();
    }

    public int getElementCount() {
        return this.gc.getElementCount();
    }

    public GObject getElement(int index) {
        return this.gc.getElement(index);
    }

    public GObject getElementAt(double x, double y) {
        return this.gc.getElementAt(x, y);
    }

    public final GObject getElementAt(GPoint pt) {
        return this.getElementAt(pt.getX(), pt.getY());
    }

    public Iterator iterator() {
        return this.gc.iterator();
    }

    public Iterator iterator(int direction) {
        return this.gc.iterator(direction);
    }

    public void addMouseListeners() {
        this.gc.addMouseListener(this);
        this.gc.addMouseMotionListener(this);
    }

    public void waitForClick() {
        GraphicsProgram graphicsProgram = this;
        synchronized (graphicsProgram) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void repaint() {
        this.gc.repaint();
        super.repaint();
    }

    public void removeAllComponents() {
        super.removeAll();
    }

    public static void startGraphicsProgram(GObject gobj, String[] args) {
        GObjectProgram program = new GObjectProgram();
        program.setStartupObject(gobj);
        program.start(args);
    }

    protected GCanvas createGCanvas() {
        return new GCanvas();
    }

    protected void startHook() {
    }

    protected void endHook() {
        this.gc.repaint();
    }

    protected boolean isStarted() {
        if (this.gc == null || !super.isStarted()) {
            return false;
        }
        Dimension size = this.gc.getSize();
        return size != null && size.width != 0 && size.height != 0;
    }
}

