package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/
 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class KeyWallet implements KeyWalletInterface , Serializable
{
    //private List<String> store = new ArrayList<String>();
    private HashMap<String,Integer> store = new HashMap<String,Integer>();
    private Story story;
    
    public KeyWallet(Story s)
    {
        this.story = s;
    }
    
    public void cleanUp()
    {
        this.store.clear();
    }
    
    private int getKeyValue(String k)
    {
        if (k.indexOf("*")!=-1)
        {
            return new Integer(k.split("\\*")[1]);
            
        } else
        {
            return 1;
        }
   }
   
    private String getKeyName(String k)
    {
        if (k.indexOf("*")!=-1)
        {
            return k.split("\\*")[0];
        } else
        {
            return k;
        }
   }
    
    public boolean add(String keyName)
    {
       if (this.has(this.getKeyName(keyName))){
            this.store.put(this.getKeyName(keyName),
            this.store.get(this.getKeyName(keyName))+this.getKeyValue(keyName));
            
       } else {
           this.store.put(this.getKeyName(keyName),this.getKeyValue(keyName)); 
       }
       
       return true;
    }
 
    
    public boolean has(String keyName)
    {
        
    	keyName = keyName.replace("&", ActionPinPoint.mappoint+"");
    	
        if (this.store.containsKey(this.getKeyName(keyName))
            && this.store.get(this.getKeyName(keyName))>=this.getKeyValue(keyName))
            {
                return true;
            } else  {
                return false;
            }
            
    }
    
    public boolean drop(String keyName)
    {
        if (this.has(this.getKeyName(keyName))){
            this.store.put(this.getKeyName(keyName),
            this.store.get(this.getKeyName(keyName))-this.getKeyValue(keyName));
            return true;
        } else {
            return false;
        }
    }

    public void dropAll(String name)
    {
        this.store.remove(name);
    }
    
    public Integer getQuantity(String s)
    {
        return this.store.get(s);
    }
    
    public int getTimeKey()
    {
        return this.story.getSystemKeyGenerator().getTimeKey();
    }

}
