package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/
 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class LockFactory
{
    private Unlockable product;
    private StoryFactory parent;
    private Stack<String> stack = new Stack<String>();
    
    public void setParent(StoryFactory s)
    {
        this.parent = s;
    }
    
    public Unlockable make(String s){
        
        //filter { }
        s = s.replace("{","").replace("}","").replaceAll(" ","");
        int j;
        
        //check for negativity
        boolean n;
        if (s.indexOf("!")==0){
            n = true;
            s = s.substring(1);
        } else {
            n = false;
        }
             
        //It's a slot!        
        if (s.indexOf("$")==0)
        {
            s = s.substring(1);
            product = new Slot();
            product.setCode(s);
        
        } else if (s.equals("<<")) {
                   
            j = this.parent.getCurrentLine();  
            product = new ExtendedLock();
            product.setCode("LIN"+j);
            this.stack.push("LIN"+j);
        
        } else if (s.equals(">>")) {    
            
            product = new ExtendedLock();
            //dont set the code, this is a closing lock..
            j = this.parent.getCurrentLine();  
            this.parent.getStory().setLabel(this.stack.pop(),j+1);
            
        } else if (s.indexOf("TIME")==0) {
        
            s = s.substring(4);
            product = new TimerLock();
            product.setCode(s);
        
        } else if (s.equals("OR")) {
        
            product = new ORLock();
         
        } else {
        
            product = new Lock();
            product.setCode(s);
        
            
        }
        this.product.setNegative(n);
        return this.product;
    }
}
