package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
; 

public class toolbox 
{
    public static void say(String str)
    {
        System.out.println(str);
    }
    
    public static String ask()
    {
        String inp = "";
        try{
            InputStreamReader ISR = new InputStreamReader(System.in);
            BufferedReader STDIN = new BufferedReader(ISR);
            System.out.print(">");
            inp = STDIN.readLine();
        }
        catch(Exception e)
        {
        }
        
        return inp;
    }
	
	public static String rot13(String arg) {
        String s = arg;
		String n = "";
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if       (c >= 'a' && c <= 'm') c += 13;
            else if  (c >= 'n' && c <= 'z') c -= 13;
            else if  (c >= 'A' && c <= 'M') c += 13;
            else if  (c >= 'A' && c <= 'Z') c -= 13;
            n += c;
        }
        return n;
	}
    
    
    public static boolean toFile(String fname, String contents){
        FileOutputStream f;     
        try
        {  f = new FileOutputStream (fname);
            new PrintStream(f).println(contents);
            f.close(); return true;     
        }
        catch (IOException e)
        {
            System.out.println("[toolbox.toFile] ERROR :"+e);
            return false;
        }
    }   
    
    public static boolean serialize(String fname, Serializable o)
    {
        try{
            FileOutputStream fs = new FileOutputStream(fname);
            ObjectOutputStream os = new ObjectOutputStream(fs);
            os.writeObject(o);
            os.close();
            return true;
        }
        catch(Exception e)
        {
            e.printStackTrace();
            return false;
        }
    }
    
    
    
    public static String fromFile(String fname){
    
        StringBuffer content = new StringBuffer("");
    
        try{
            
            FileReader freader = new FileReader(fname);
            BufferedReader buff = new BufferedReader(freader);
            
            boolean firstline = true;
            String line = "";
            while (line!=null){
                if (!firstline) content.append(line+"\n"); else firstline=false;
                line=buff.readLine();
                
            }
            buff.close();
            freader.close();
        }
        catch(IOException e){
            System.out.println("[toolbox.fromFile] ERROR :"+e);
        }
        
        return content.toString();

    }
    
    public static Object deserialize(String fname)
    {
        try{
            FileInputStream fs = new FileInputStream(fname);
            ObjectInputStream os = new ObjectInputStream(fs);
            Object obj = os.readObject();
            os.close();
            return obj;
        }
        catch(Exception e)
        {
            e.printStackTrace();
            return new Object();
        }
    }
    
    

    public static String implode(char glue,String[] arr){
        String output = ""; 
        for (int i=0; i<arr.length; i++){
            if (i==0){
             output+=arr[i];        
            }
            else
            {
             output+=glue+arr[i];
            }
        }   
        return output;
    }

    public static void makeArrayListFromArray(String[] arr, ArrayList<String> arrlist)
    {
        for(String s: arr)
        {
            arrlist.add(s);
        }
       
        
    }
    
    public static void speak(String text)
    {
        try{
            Runtime.getRuntime().exec("say "+text);
        }
        catch(Exception e){
                    System.out.println("Speech not supported on this system.");
                    System.exit(0);
        }
        
    }
    
    public static void exec(String text)
    {
        try{
            Runtime.getRuntime().exec(text);
        }
        catch(Exception e){
                    System.out.println("RUNTIME ERROR.");
                    System.exit(0);
        }
        
    }
    
    
    
    
    public static String[] regex(String text,String pattern)
    {
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(text);
            boolean b = false;
            b = m.find();
            
            if (b){
             String[] groups = new String[m.groupCount()+1];
             for(int j = 0; j <= m.groupCount(); j++)
             {
                 groups[j] = m.group(j);
             }
             return groups;
            } else {
                 String[] groups = new String[0];
                 return groups;
            }
            
            

    }
    
    public static String ucfirst(String str)
    {
    	return str.substring(0,1).toUpperCase() + str.substring(1);
    }

}
