import "story/shrine"

function gargoyle()
	clearText()
	if not metGargoyle then
		text [[You approach the door to open it, but it has no handle. When you reach out to push on it, a nasal voice emerges from the mouth of the gargoyle looming over your right:]]

		image "gargoyle"

		metGargoyle = true
	else
		image "gargoyle"

		text [[The $(gargoyleName) turns its head.]]
	end

	text [["Present your pass, please!"]]

	jump "gargoyle_hub"
end


function gargoyle_hub()
	choice("Look at the $(gargoyleName).", "gargoyle_look")
	choiceOnce([["What are you?"]], "gargoyle_whatAreYou")
	choice([["What's beyond the door? What are you guarding?"]], "gargoyle_guarding")
	choiceOnce([["You can talk, too?! First birds and now rocks?"]], "gargoyle_youCanTalk")
	if haveGargoylePass then
		choiceOnce([[Present your pass.]], "gargoyle_givePass")
	end
	choice([[Return to the archway hall.]], "archway")
end

function gargoyle_look()
	text [[The $(gargoyleName) is made out of sandstone, cut into angled segments which allow it to move its neck and mouth, twisting about in much the same way that a pair of millstones rotate against each other. It does not move quite like a living animal, but the quartz cabochons under its alarming brow are bright with what appears to be intelligence.]]

	jump "gargoyle_hub"
end

function gargoyle_whatAreYou()
	text [["I am the guard at this entrance. Present your pass, please."]]

	text [["No, I mean, what sort of creature are you? Some sort of…" You think for a moment. "Enchanted carving?"]]

	text [[The gargoyle regards you. ]]

	text [[You continue: "Like that story of the sculptor who was so skilled that his sculptures came to life. You know?"]]

	text [["I do not know. Present your pass, please!"]]

	if not visited "gargoyle_important" and not visited "gargoyle_notImportant" then
		choice("Surely it must know what it is! Interrogate!", "gargoyle_interrogate")
		choice("Stop hassling it. It has a job to do.", "gargoyle_hub")
	end
end

function gargoyle_interrogate()
	text [["Were you brought to life by an enchanter? Or are you a machine?" You squint up your eyes and attempt to stare the gargoyle in its cabochons.]]

	text [["I am not alive and I am not a machine. I am a gargoyle," the gargoyle replies. "I open the door to let in those who present their pass, and close it to keep out those who do not present their pass. I ask people to present their passes. And also I wait quietly during the times when nobody wants to open or close the door. Those are the only things I do."]]

	choice("Wait! Then there is a contradiction! Prove it wrong with your knowledge of art!", "gargoyle_grotesque")
	choice("Stop hassling it. It has a job to do.", "gargoyle_hub")

end

function gargoyle_grotesque()
	text [[Something you were shown in one of your grandfather's books flashes into your mind in pedantic clarity. Now you are irritated.]]

	text [["Do you spout water through your mouth to keep it away from the wall?"]]

	text [["No," the gargoyle says.]]

	text [["The definition of a gargoyle says that you must! So you cannot be a gargoyle! You are a *grotesque!*"]]

	text [[The dratted liar that is *not* a gargoyle rotates the discs in its neck back and forth in confusion.]]

	text [["That is ridiculous," it says. "I do not lie. I ask for passes to get past the door." In a slightly wounded voice, it asks, "is it important that I am a grotesque, and not a gargoyle?"]]

	choice("It is extremely important!", "gargoyle_important")
	choice("It doesn't matter.", "gargoyle_notImportant")
end

function gargoyle_important()
	text [["Yes," you tell it. "I understand you weren't aware of the distinction, but words mean things, and we mustn't let standards slip."]]

	text [[Chided, the stone monster lowers its head. It is a grotesque now.]]
	gargoyleName = "grotesque"

	jump "gargoyle_hub"
end

function gargoyle_notImportant()
	text [["No," you tell it, "you can be a gargoyle if you like."]]

	text [[You give it a tender pat on the snout. The gargoyle does not respond.]]

	jump "gargoyle_hub"
end

function gargoyle_guarding()
	text [["This place," the $(gargoyleName) says with evident pride, "is the most important in the whole of the city. The shrine beyond is a beacon to every true citizen. And it can only be visited by those with the appropriate pass!"]]

	choice([["What pass do you mean? Where would I find one?"]], "gargoyle_whatPass")
end

function gargoyle_whatPass()
	text [["A pass can only be issued to a True Citizen by the city authority, in order to allow entry to the Queen's shrine. All who wish to behold it must present their pass. That is the law!"]]

	choice([["Why would a shrine need a pass to reach it? Don't you want everyone to be able to go there?"]], "gargoyle_askAboutShrine")
end

function gargoyle_youCanTalk()
	text [[The $(gargoyleName) considers this.]]

	text [["Present your pass, please," it decides.]]

	jump "gargoyle_hub"
end

function gargoyle_askAboutShrine()
	askedAboutShrine = true

	text [["I do not know. Knowing is not a part of my purpose."]]
	jump "gargoyle_hub"
end

function gargoyle_givePass()
	text [[You hold up your pass. "Excuse me! I have a pass! From Milpreve! Look!" You wave the pass in front of the $(gargoyleName)'s face.]]

	text [[The $(gargoyleName) tilts its head from side to side, following its motion exactly with its cabochon eyes. Then, unexpectedly, its mouth snaps shut around your fingers.]]

	text [["Ow! - "]]

	text [[You pull your hand away without resistance. As you do so, you become aware of a strange grinding sound emanating from the $(gargoyleName)'s neck.]]

	choice([["Did you just… eat my pass?"]], "gargoyle_eatPass")
end

function gargoyle_eatPass()
	text [[There is a peculiar sound that reminds you of a gulp. Then the $(gargoyleName) opens its mouth again.]]

	text [["No," it says, "I do not eat. I am a $(gargoyleName)." It makes a deep clank that you think is probably a burp.]]

	text [[The door is open.]]

	choice([[Visit the shrine.]], "shrine")
	--choice([[Return to the archway hall.]], "archway")
end
