#include <adv3.h>
#include <en_us.h>

#include <storyguide.h>


emma: Person
    'emma/you'
    'Emma'
    @lawnWest
    "Emma has long shiny black hair and dark blue eyes and she laughs a lot.
    She looks like she got dressed up for your visit, because she's wearing 
    a dress with this blue lacy stuff across the front, like a beauty queen
    sash or something. Or maybe she wears clothes like that every day, 
    because her parents are kind of rich. They own the company that your 
    mum works for.<.p>
    Emma was the one who wanted to play this game, so she got to be It
    first. That means she goes to hide, and you're supposed to count to 50
    and then go to find her. Right now she's <<reportActivity(true)>>,
    <<emma.isIn(bushNearCubby) ? 'hiding' : 'looking for a place to hide'>>. "
    isProperName = true
    globalParamName = 'emma'
    specialDesc = "Emma is <<reportActivity(true)>>. "
    
    /* 
     *   The PC knows about Emma, and can thus discuss her with the other 
     *   characters.
     */
    isKnown = true
    
    /* 
     *   Only include Emma in grouped messages, e.g. "X and Y are here", if 
     *   she is hiding in the bush.
     */
    actorListWith()
    {
        if (isIn(bushNearCubby) && bushNearCubby.contents.length > 1)
        {
            /* get the group for the posture */
            local group = location.listWithActorIn(posture);

            /* 
             *   if we have a group, return a list containing the group;
             *   otherwise return an empty list 
             */
            return (group == nil ? [] : [group]);
        }
        else
        {
            return [];
        }
    }
    
    /* 
     *   her "first" action - so she won't be described as doing something 
     *   incongruous if/when the player sees her
     */
    lastAction = static LookAction.createActionInstance()
    
    /* 
     *   If Emma is standing in the same place as the PC, change the report of
     *   what she's doing. Because her description adds the information that
     *   she's looking for a place to hide, saying she's "just standing here"
     *   isn't really accurate and sounds odd.
     */
    reportActivity(sayLoc)
    {
        /* special case - if Emma is hanging around the PC's location */
        if (!lastActionWasInteresting() && location == gPlayerChar.location)
        {
            "<<posture.participle>> around";
            return;
        }
        
        /* all other reports remain the same */
        inherited(sayLoc);
    }
    
    /* Does Emma know everyone else is playing Hide and Seek? */
    knowsEveryoneIsPlayingHnS = nil
    
    /* 
     *   list of things for Emma to say to chivy a slow player during the 
     *   prologue
     */
    impatientList: EventList
    { 
        [
            {: "Come on, hurry up and close your eyes! " },
            {: "Stop messing about. It'll be lunch time soon! " },
            {: "Don't waste time, just close your eyes! " },
            &veryImpatient,
            &tooImpatient
        ]
        
        /* 
         *   When Emma gets too impatient, she will give you one last 
         *   chance. If you say yes but don't close your eyes immediately 
         *   they will play without you.
         */
        veryImpatient() 
        {
            "Do you want to play or not? ";
            emma.setConvNode('last-chance');
        }
        
        /* The player has dithered too long, and they play without her. */
        tooImpatient() 
        {
            "Fine! We'll play without you, then. ";
            endGame('You have been left out');
        }
    }
    
    /* if the player is cheating, report Emma hiding */
    enterHidingSpot(hs)
    {
        if (eyes.isOpen)
        {
            "As <<gPlayerChar.hasCounted ? 'you' : yvonne.theName + ' and ' +
              tiana.theName>> finish counting, Emma wriggles under a bush behind
            the cubby house. ";
        }
        
        inherited(hs);
    }
    
    /* If you attack Emma, the story ends. */
    dobjFor(Attack)
    {
        action()
        {
            inherited();
            "You hit out at Emma, who is too surprised to dodge. She shrieks 
            for help and tries to push you away. Yvonne yells at you and 
            {the Tiana/she} starts crying and the grownups appear from 
            nowhere and pull you away. Emma wails, <q>I wasn't
            doing anything, just <<emma.isIn(bushNearCubby) ? 'hiding' : 
              'looking for a hiding spot'>> because we were playing Sardines,
            and she just hit me for no reason! I was really scared, it was like 
            she was crazy!</q> So the grownups hug her and make a big fuss, and 
            Mum drags you off to the car before you can do any more damage. ";
            endGame('You are in big trouble');
        }
    }
    
    
    dobjFor(Hug)
    {
        action()
        {
            "Emma accepts your hug, and even gives you a limp sort of a hug
            in return. ";
        }
    }
;



/* Emma's response to being asked about Hide and Seek during the prologue. */
+ AskTellTopic @tHnS
    "Why would you want to play Hide and Seek? This game is heaps better 
    than Hide and Seek. Just close your eyes and count to 50. You'll see,
    it's the funnest game ever. "
;


/* Emma's response to being asked about Hide and Seek while counting. */
++ AltTopic
    "<q>Can't we play Hide and Seek instead?</q><.p>
    Emma says, <q>No! This game is heaps more fun, it's my favourite game.
    Don't be a spoilsport.</q> "
    
    isActive = (gCurrStoryPoint not in (prologue, playingHnS))
;


/* 
 *   Asking Emma to play Hide and Seek. She will only agree if everyone else 
 *   is playing; otherwise she's too proud to play someone else's game.
 */
++ AltTopic, StopEventList
    [
        new function()
        {
            playingHnS.invitationToPlay();
            
            "Emma stares at you. <q>No! I don't want to play your silly
            game. If you don't want to play with us, then me and Yvonne
            will just play our own game.</q><.p>
            Yvonne opens her mouth as if she's about to say something
            and then closes it again. ";
        },
        
        'You already asked her to play, and she said she and Yvonne didn\'t
        want to and they\'d just play their own game. '
    ]
    
    isActive = (gCurrStoryPoint == playingHnS)
;


++ AltTopic
    topicResponse()
    {
        "<q>We're all going to play Hide and Seek,</q> you say. <q>Do
        you want to play too?</q><.p>
        <<emma.knowsEveryoneIsPlayingHnS ? '' : '<q>You\'re all going to play? 
          What, even Yvonne?</q> You nod.'>>
        Emma stares at you for a moment and then bursts out,
        <q>No! I don't want to play your silly game. I want to play
        <i>my</i> game! You're all mean spoilsports, and I don't want
        to play with any of you, ever!</q> Emma turns her back on you, 
        but not before you see something shining in the corner of her 
        eye.<.p>
        <q>Sure?</q><.p>
        <q>Go away!</q><.p>
        <q>Okay, fine.</q> You start to walk away.<.p>
        <q>Wait!</q> Emma comes running after you. <q>I guess... I 
        could play maybe a bit of Hide and Seek with you?</q><.p>
        <q>Okay,</q> you say. There's a pause.<.p>
        Emma asks timidly, <q>So --- who's going to count?</q><.p>
        <q><<gPlayerChar.roleInHnS == roleCounting ? 'I am' : 
          '{The tiana/she} is'>>,</q> you say, and wait for Emma's
        response.<.p>
        Emma just nods. ";
        
        endGame('You have changed the game');
    }
    
    isActive = (yvonne.isPlayingHnS)
;


/* 
 *   Response to being asked about the game during the prologue, once the 
 *   early conversation nodes are out of the way.
 */
+ AskTellTopic @tGame
    "I already explained it to you! "
;

++ AltTopic, StopEventList
    [
        '<q>I don\'t think I want to play this game,</q> you say, <q>it\'s weird. 
        Can\'t we play something else instead?</q><.p>
        <q>No!</q> Emma says. <q>This is my favourite game.</q> ',
        'There\'s no point in arguing. Emma really likes this game. '
    ]
    isActive = (gCurrStoryPoint not in (prologue, playingHnS))
;

++ AltTopic
    topicResponse()
    {
        replaceAction(AskAbout, emma, tHnS);
    }
    isActive = (gCurrStoryPoint == playingHnS)
;


/* 
 *   Emma's conversation nodes: these are all at the beginning of the game 
 *   and appear to come from the narrator, not a character in the game, but 
 *   it later becomes clear that it was Emma speaking.
 */
+ understandRules: ConvNode 'understand-rules';

++ iUnderstand: YesTopic
    topicResponse = "Okay then, close your eyes. 
        <.convnode waiting-for-eyes-closed> "
;

++ dontUnderstand: NoTopic
    "It's really easy! You count to 50. I hide --- but not in the house or the 
    shed, because they're out of bounds. When you finish counting, you go and 
    look for me. If you find me, you have to get into the hiding spot 
    with me and wait to be found. If everyone else gets in the hiding spot 
    before you, you lose. Okay? <.convnode understand-now> "
;

/* asking about the game is the same as saying no */
++ AskTellTopic @tGame
    topicResponse = delegated dontUnderstand
;


+ understandNow: ConvNode 'understand-now';

++ YesTopic
    topicResponse() 
    {
        delegated iUnderstand();
    }
;

++ NoTopic
    topicResponse = "Never mind, you'll get the hang of it. Just close your 
        eyes. <.convnode waiting-for-eyes-closed> "
;


+ waitingForEyesClosed: ConvNode
    'waiting-for-eyes-closed'
    isSticky = true
;

++ YesTopic
    topicResponse = "Just <i>do</i> it then! "
;

++ dontUnderstand2: NoTopic
    topicResponse = delegated(dontWantToPlay)
;

/* asking about the game is the same as saying no */
++ AskTellTopic @tGame
    topicResponse = delegated(dontUnderstand2)
;


+ lastChance: ConvNode 'last-chance';

++ YesTopic
    topicResponse = "Well, if you don't close your eyes <i>right now</i>, we're 
        going to play without you. ";
;

++ dontWantToPlay: NoTopic
    topicResponse()
    {
        "Fine! We'll play without you, then. ";
        endGame('You have not lost');
    }
;



/* 
 *   ConvNode for when Emma asks to play Hide and Seek with the rest of you. 
 *   No matter what the response is, the game ends here. 
 */
+ emmaCanPlayHnS: ConvNode
    'Emma\'s can-I-play-HnS question'
;


++ YesTopic
    topicResponse()
    {
        "After a moment, you say, <q>Okay then. We'll all play. It'll be more
        fun with more people anyway.</q><.p>
        Emma says, <q>Can I be the one who ---</q> and then catches herself.
        Yvonne is frowning at her. <q>I mean, who's going to count and who's
        going to hide?</q> she says.<.p>
        <q><<gPlayerChar.roleInHnS == roleCounting ? 'I\'m' : 'Tiana\'s'>>
        going to count,</q> you say, and wait for Emma's response.<.p>
        Emma just nods. ";
        
        endGame('You have changed the game');
    }
;


++ NoTopic
    topicResponse()
    {
        "<q>No,</q> you say firmly. <q>You keep bossing everyone else around
        and being mean to people, and we don't want to play with you. This
        is our game.</q><.p>
        Emma stares at you for a moment, her lip quivering, then turns and 
        runs back to the house.<.p> ";
        
        playingHnS.playingWithYvonne();
    }
;


++ AskTellTopic @emma
    topicResponse()
    {
        "<q>Only if you stop being so bossy and mean to people,</q> you say
        firmly. <q>Otherwise, we don't want to play with you.</q><.p>
        Emma looks at Yvonne, but Yvonne says nothing. Taking a deep breath,
        she says, <q>Okay, I won't be bossy any more. Can I play?</q><.p>
        You nod. There's a pause.<.p>
        Emma hesitates and then asks, <q> So who's going to count and who's
        going to hide?</q><.p>
        <q><<gPlayerChar.roleInHnS == roleCounting ? 'I\'m' : 'Tiana\'s'>>
        going to count,</q> you say, and wait for Emma's response.<.p>
        Emma just nods. ";
        
        endGame('You have changed the game');
    }
;



/* 
 *   Emma's actions during the "counting" scene. If the player peeks, she 
 *   will be able to see these and find out where Emma hides.
 *
 *   I want her to hide at the very last minute, so even if the player only 
 *   opens her eyes just before the others finish counting she'll still see 
 *   where Emma hides. She has to have something to do every turn between 
 *   the count starting and the count finishing, which takes six turns, so 
 *   she needs to do three turns' worth of dithering to fill the time.
 */
+ AgendaItem
    storyPoint = counting
    agendaOrder = 1
    exec()
    {
        "Emma heads southwest, towards the big tree. ";
        getActor.silentlyGoTo(underTree);
    }
;

+ AgendaItem
    storyPoint = counting
    agendaOrder = 2
    exec()
    {
        "Emma changes her mind and comes back this way. ";
        getActor.silentlyGoTo(lawnWest);
    }
;

+ AgendaItem
    storyPoint = counting
    agendaOrder = 3
    exec()
    {
        "Emma glances towards you. You shut your eyes quickly, but when you
        open them again she doesn't seem to have noticed you. ";
    }
;

+ AgendaItem
    storyPoint = counting
    agendaOrder = 4
    exec()
    {
        "Emma moves off towards the eastern end of the lawn. ";
        getActor.silentlyGoTo(lawnEast);
    }
;

+ AgendaItem
    storyPoint = counting
    agendaOrder = 5
    exec()
    {
        "Emma goes northeast, towards the cubby house. ";
        getActor.silentlyGoTo(cubbyArea);
    }
;

+ AgendaItem
    storyPoint = counting
    agendaOrder = 6
    exec()
    {
        emma.enterHidingSpot(bushNearCubby);
    }
;



/* 
 *   Emma's reactions.
 *
 *   Most of these only apply during the counting scene, if the player is 
 *   cheating, since Emma isn't around to observe things the rest of the 
 *   time. (Well, in the prologue she is, but the player isn't allowed to do 
 *   much except say yes or no in the prologue.)
 */

/* 
 *   If the PC tries to wander about during counting, Emma notices she is 
 *   cheating and confronts her.
 */
+ BeforeAction
    actor = gPlayerChar
    action = [TravelAction, JumpAction, FollowAction]
    condition = (counting.active_)
    
    react()
    {
        "Your movement catches Emma's eye, and she turns quickly.
        <q>Hey! What are you doing?</q> she demands. <q>I'm supposed to
        be hiding, not you!</q><.p>
        The other two look up and stare at you, confused.<.p>
        <q>She was wandering around instead of counting,</q> Emma
        explains. She turns back to you. <q>If you didn't understand the 
        rules, or you didn't want to play, you could've just said 
        so.</q><.p>
        <<yvonne.isCheating ? 'Yvonne says,' : 'Yvonne scowls at you and
            says,'>> <q>She isn't even trying to play the game properly.
        Let's just play without her --- come on.</q> ";
        endGame('You have been left out');
    }
;


/* 
 *   If the PC tries to talk to someone while cheating during the counting 
 *   scene, it draws Emma's attention and Emma notices she is cheating.
 */
+ caughtOutByTalking: BeforeAction
    action = [ConvIAction, TalkToAction, TopicTAction, YellAction]
    condition = (counting.active_ && gPlayerChar.isCheating)
    
    react()
    {
        "The sound of your voice catches Emma's attention.
        <q>Hey!</q> she says, <q>you're peeking!</q><.p>
        The other two look up. <<yvonne.isCheating ? 'Yvonne flushes and
            says quickly, <q>No I wasn\'t!</q>' : 'Yvonne grins
                nastily.'>><.p>
        <q><<yvonne.isCheating ? 'Not you, her.</q> Emma points to you. <q>'
          : ''>>I saw you, you had your eyes open!</q> Emma says. 
        <q>Cheat!</q><.p>
        Yvonne joins in: <q>Cheat! Cheat!</q> {The tiana/she} looks down at 
        her feet and says nothing.<.p>
        <q>We don't play with cheaters,</q> Yvonne announces. <q>Come on,
        Emma, let's have a proper game without her.</q> ";
        endGame('You got caught');
    }
;



/* 
 *   Dobbing on Yvonne after you find out she's cheating ends the game.
 *
 *   This should really be a conversation topic, but I'm too lazy to edit 
 *   the talking-while-counting-and-cheating reaction to allow specific 
 *   kinds of conversation. It ends the game, so it's not like I'm screwing 
 *   up the world model by doing it this way.
 */
+ BeforeAction
    actor = gPlayerChar
    action = [TellAboutAction, AskAboutAction]
    condition = (counting.active_ && 
                 gPlayerChar.isCheating && !yvonne.isCheating && 
                 gTopic.getBestMatch is in (yvonne, tCheating))
    
    /* runs before the default "talking during counting" reaction */
    priority = 150
    
    react()
    {
        "<q>Yvonne is cheating, I saw her!</q><.p>
        <q>I wasn't!</q> Yvonne flushes and raises her voice. <q>Emma, I
        wasn't!</q><.p>
        <q>I <i>saw</i> her with her eyes open!</q> you retort. <q>She's 
        just a liar and a cheat!</q><.p>
        Emma hesitates, not knowing who to believe. It's {the tiana/she}
        who spots the problem with your accusation.<.p>
        <q>How come you know Yvonne was cheating?</q> she demands.
        <q>Either you made it up, or you were cheating too.</q><.p>
        Yvonne jumps at this. <q>She <i>was</i> cheating! I just happened
        to open my eyes for a tiny moment, and she was looking at me.</q>
        She gives Emma a puppy-dog look. <q>That's all that happened,
        true!</q>
        <.p>
        <q>That's not true, you---</q> you begin, but Emma cuts you off.
        <.p>
        <q>Shut up! Both of you! Why can't you just play properly? I hate
        you both and I'll never play with you again, ever!</q> She bursts
        into tears and runs away into the house. {The tiana/she} hesitates
        a moment and then follows her, leaving you and Yvonne scowling at
        each other. ";
        endGame('You and Yvonne got caught');
    }
;


/* 
 *   If the PC tries to talk to someone who's already hiding, Emma shushes 
 *   her and beckons her to hide.
 */
+ BeforeAction
    action = [ConvIAction, TalkToAction, TopicTAction, YellAction, GiveToAction,
        ShowToAction]
    
    /* is the PC trying to talk to someone in the bush? */
    condition()
    {
        /* 
         *   This applies if either the issuing actor or the target actor is 
         *   the PC.
         */
        if (gActor != gPlayerChar && gIssuingActor != gPlayerChar)
            return nil;
        
        /* 
         *   This doesn't apply if trying to ask someone to play Hide and Seek.
         *   Unless Tiana is already in the bush, in which case it's too late
         *   for Hide and Seek playing.
         */
        if (gTopic && gTopic.getBestMatch() is in (tHnS, tGame) &&
            !tiana.isIn(bushNearCubby))
            return nil;
        
        /* for give/show, the target NPC is the indirect object */
        if (gActionIn(GiveTo, ShowTo) && gIobj && 
            gIobj.isIn(bushNearCubby))
            return true;
        
        /* 
         *   for other commands, the target NPC is the direct object or the 
         *   default interlocutor
         */
        if (gDobj && gDobj.isIn(bushNearCubby))
            return true;
        else if (gDobj && gDobj.ofKind(Person))
            /* 
             *   if the direct object is a person but she isn't in the bush, 
             *   this reaction doesn't apply
             */
            return nil;
        
        if (gActor != gPlayerChar)
        {
            if (gActor.isIn(bushNearCubby))
            {
                return true;
            }
            else
            {
                return nil;
            }
        }
        
        if (gPlayerChar.getDefaultInterlocutor && 
            gPlayerChar.getDefaultInterlocutor.isIn(bushNearCubby))
            return true;
        
        return nil;
    }
    
    stopAction = true
    
    react()
    {
        "You start to speak, but ";
        if (yvonne.isIn(bushNearCubby) && tiana.isIn(bushNearCubby))
        {
            searching.loseGame();
        }
        else
        {
            "Emma shushes you and beckons for you to hide. ";
        }
    }
;



/* 
 *   If you try to hide with Emma when she knows you're playing Hide and 
 *   Seek, she stops you.
 */
+ BeforeAction
    actor = gPlayerChar
    action = HideInAction
    dobj = bushNearCubby
    condition = (emma.knowsEveryoneIsPlayingHnS)
    
    stopAction = true
    
    react()
    {
        "Emma scowls at you. <q>If you don't want to play with me, go 
        find your own hiding spot!</q> ";
    }
;



/* Emma's Unperson */
emmaUnperson: Unperson
    linkedPerson = emma
    
    /* 
     *   If the player doesn't know where Emma is hiding, say so. I wanted this
     *   to redirect to the SEARCH ROOM advice about how to search, but it turns
     *   out that would be too much bother (because that code prints the info
     *   directly and this method needs to return a string instead) and I don't
     *   care enough.
     */
    notHereMsg()
    {
        if (gActor.knowsWhereEmmaIs)
        {
            return inherited();
        }
        else
        {
            local msg = 'You don\'t know where Emma is hiding, and you can\'t
                see her anywhere at the moment. ';
            
            if (!gActor.isPlayingHnS)
                msg += 'Better keep searching. ';
            
            return msg;
        }
    }
    
    /* 
     *   If the player tries to search for Emma when she isn't visible, try
     *   offering advice about how to look for her. The Room class already has
     *   code to do this, so just redirect the action.
     */
    dobjFor(SearchFor)
    {
        verify() {}
        
        action()
        {
            replaceAction(Search, gActor.getOutermostRoom());
        }
    }
;
