/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.Font;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.SubWindow;
import org.zmpp.swingui.Viewport;

public class BottomWindow
extends SubWindow {
    private boolean isBuffered;
    private boolean isPaged;
    private int verticalTextPixelsPrinted;
    private int currentX;
    private int currentY;
    private int lineHeight;

    public BottomWindow(Viewport viewport) {
        super(viewport, "BOTTOM");
        this.setBufferMode(true);
        this.setPagingEnabled(true);
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    public void setPagingEnabled(boolean bl) {
        this.isPaged = bl;
    }

    public boolean isPagingEnabled() {
        return this.isPaged;
    }

    public void setBufferMode(boolean bl) {
        this.isBuffered = bl;
    }

    private void scrollIfNeeded() {
        int n = this.getCanvas().getFontDescent(this.getFont());
        int n2 = this.getCanvas().getFontHeight(this.getFont());
        this.clipToCurrentBounds();
        while (this.getCurrentY() > this.getTop() + this.getHeight() - n) {
            this.getCanvas().scrollUp(this.getBackgroundColor(), this.getFont(), this.getTop(), this.getHeight());
            this.getCursor().setLine(this.getCursor().getLine() - 1);
            this.currentY -= n2;
        }
    }

    public void resetCursorToHome() {
        this.getCursor().setPosition(this.getAvailableLines(), 1);
        this.currentY = this.getTop() + this.getHeight() - this.getCanvas().getFontDescent(this.getFont());
    }

    private int getAvailableLines() {
        int n = this.getCanvas().getFontDescent(this.getFont());
        int n2 = this.getCanvas().getFontHeight(this.getFont());
        return (this.getHeight() - n) / n2;
    }

    private void handlePaging() {
        if (this.isPaged && this.pageMinusOneLinePrinted()) {
            this.doMeMore();
        }
    }

    private boolean pageMinusOneLinePrinted() {
        return this.verticalTextPixelsPrinted + this.getCanvas().getFontDescent(this.getFont()) + this.getCanvas().getFontHeight(this.getFont()) >= this.getHeight();
    }

    private void doMeMore() {
        this.printLineNonPaged("\n<MORE> (Press key to continue)", this.getTextBackground(), this.getTextColor());
        this.getScreen().redraw();
        this.getEditor().setInputMode(true);
        this.getEditor().nextZsciiChar();
        this.resetCursorToHome();
        this.eraseLine();
        this.getEditor().setInputMode(false);
        this.resetPager();
    }

    protected void sizeUpdated() {
    }

    protected void newline() {
        super.newline();
        this.scrollIfNeeded();
        this.currentX = 0;
        this.verticalTextPixelsPrinted += this.lineHeight;
        this.currentY += this.lineHeight;
        this.lineHeight = 0;
    }

    protected void printLine(String string, Color color, Color color2) {
        this.handlePaging();
        this.scrollIfNeeded();
        super.printLine(string, color, color2);
        this.currentX += this.getCanvas().getStringWidth(this.getFont(), string);
        this.lineHeight = Math.max(this.lineHeight, this.getCanvas().getFontHeight(this.getFont()));
    }

    private void printLineNonPaged(String string, Color color, Color color2) {
        this.scrollIfNeeded();
        super.printLine(string, color, color2);
        this.currentX += this.getCanvas().getStringWidth(this.getFont(), string);
        this.lineHeight = Math.max(this.lineHeight, this.getCanvas().getFontHeight(this.getFont()));
    }

    public void resetPager() {
        this.verticalTextPixelsPrinted = 0;
    }

    protected int getCurrentX() {
        return this.currentX;
    }

    protected int getCurrentY() {
        return this.currentY;
    }

    public void backspace(char c) {
        super.backspace(c);
        this.currentX -= this.getCanvas().getCharWidth(this.getFont(), c);
        if (this.currentX < 0) {
            this.currentX = 0;
        }
    }

    public void updateCursorCoordinates() {
        Canvas canvas = this.getCanvas();
        Font font = this.getFont();
        int n = this.getCursor().getLine();
        int n2 = this.getCursor().getColumn();
        this.currentX = (n2 - 1) * canvas.getCharWidth(font, '0');
        this.currentY = this.getTop() + (n - 1) * canvas.getFontHeight(font) + (canvas.getFontHeight(font) - canvas.getFontDescent(font));
    }
}

