Constant Story "SPACE STATION";
Constant Headline 
"^Inform interactive fiction -- a science fiction story^
 by David Ledgard and the Online Inform Community^
 Email: me@@64dledgard.freeserve.co.uk^
 Planetfall (c) Activision, Inc. Permission to use courtesy of Activision, Inc.^ 
 Not for commercial distribution^
 Type HELP for help^";
Constant TASKS_PROVIDED;
Constant NUMBER_TASKS = 10;
Array    task_scores -> 3 3 3 2 1 2 3 3 3 3;
Constant MAX_SCORE 23;

Constant MAX_CARRIED 10;
Constant SACK_OBJECT = Toolbox;
Constant NEXT_MEAL 2000;
Constant MAX_FOOTNOTES 7;
Constant AMUSING_PROVIDED;

Constant other   0;
Constant stuck   1;
Constant shaken  2;
Constant read    4;
Constant made    8;

Global bars_cut = 0;
Global lf_loc;
Global lf_loc_but_one;
Global lp_loc;
Global lp_loc_but_one;
Global sick;
Global sleepy;
Global hungry;
Global mt = 3157;
Global spacetime = 3010;
Global lasttime = 3009;
Global landtime;
Global launchtime = 20000;
Global eattime = 20000;
Global shaketime = 20000;
Global spaceday = 1;
Global win  = 0;
Global draw = 0;
Global lose = 0;
 
!Inform only support 16 attribute, a very small number in my humble option,
!as I find them highly useful. Properties can be used to achieve the same
!results but are more cumbersome to use. You can also use the general
!attribute all the time but this is messy and may cause unpredictable results
!if used accidentally twice on the same object.
Attribute ask_bracelet;
Attribute awake;
Attribute big;
Attribute huge;
Attribute eating;
Attribute is_bar;
Attribute is_key;
Attribute last_power;
Attribute legible;
Attribute logged_on;
Attribute power;
Attribute read7;
Attribute read_meltdown;
Attribute visited_dentist;
!Attribute 
!Attribute 
 
Serial "990412";
Release 2;

!It is good practice to replace procedures instead of altering them so than
!chances do not effect other programmes you may be working on. Basically most
!of these procedure are the same except when the NPC is present and awake it
!utters some witty remark. StatusLine converts to Inform Status Line to an
!Infocom type displaying among other things the time is chrons (only when you
!are wearing you chronometer). Others are changed to give Infocom style
!responses.
Replace DrawStatusLine; 
Replace InvSub;
Replace QuitSub;
Replace RestartSub;
Replace RestoreSub;
Replace SaveSub;
Replace ScriptOffSub;
Replace ScriptOnSub;
Replace VersionSub;
Replace YesOrNo;
Replace LanguageToInformese;

!This routine must be before the Parser Include and strips out quotes so
!TYPE "133" becomes equivalent to TYPE 133
[ LanguageToInformese i;
for (i = 2 : i < buffer->1 + 2 : i++)
{ if (buffer->i == '?' or '!') buffer->i = '.';
else if (buffer->i == '"') buffer->i = ' ';
}
];

Include "Parser";

Object LibraryMessages
with 
  before 
  [; Jump:    
       if ((Player in Couch) || (parent(Player) ofclass Class_Chair)) 
         "You'll have to get off ", (the) parent(Player), " first.";
       switch (random(3)) 
       {
         1: "You've spent too much time among the Leaping Loon-toads of
             Leonia.";
         2: "Wheeeeeee!!!";
         3: "Having fun?";
       }

     Taste:
       if (lm_o has edible) "It tastes edible."; 
       "It tastes just like ", (a) lm_o, ".";

     Disrobe: 
       if (lm_n==2) "Okay, you're no longer wearing ", (the) lm_o, ".";

     Wear: 
       if (lm_n==4) "You're now wearing ", (the) lm_o, ".";
 
     Take:
       if (lm_n==10)
       {
         switch (random(6)) 
         {
           1: "Fat chance.";
           2: "You can't be serious.";
           3: "Nice try.";
           4: "A valiant attempt.";
           5: "What a concept.";
           6: "Not bloody likely.";
         }
       }

     Examine: 
       if (lm_n==2)
       {
         switch (random(5)) 
         {
           1: "Totally ordinary looking ", (name) lm_o, ".";
           2: "There's nothing noteworthy about ", (the) lm_o, ".";
           3: "There's nothing unusual about ", (the) lm_o, ".";
           4: "There's nothing eye-catching about ", (the) lm_o, ".";
           5: "There's nothing special about ", (the) lm_o, ".";
         }
       }

     Miscellany:
       switch (lm_n)
       {
         5:
         print "^Would you like to restart the game from the beginning,
                 restore a saved game position, undo your previous move";
         if (TASKS_PROVIDED==0)
             print ", give the full score for that game";
         print ", or end this session of the 
                 game? (Type RESTART, RESTORE";
         !#IFDEF DEATH_MENTION_UNDO;
         print ", UNDO";
         !#ENDIF;
         if (TASKS_PROVIDED==0)
             print ", FULL";
         if (deadflag==2 && AMUSING_PROVIDED==0)
             print ", see some suggestions for AMUSING things to do";
         ", or QUIT.)^";

         10: "[I beg your pardon?]";
         30: "You can't see any such thing!";

         38: #ifdef DIALECT_US;
             "[I don't know that word.]";
             #ifnot;
             "[I don't know that word.]";
             #endif;
       }
  ];

Include "VerbLib";
Include "AskTellOrder";
Include "Replacement_Procs";
Include "Procs.h";
Include "Classes.h";
Include "Player.h";

Object tw_waiting "tw";
