/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref.dom2dtm;

import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.dom.DOMSource;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class DOM2DTM
extends DTMDefaultBaseIterators {
    static final boolean JJK_DEBUG = false;
    static final boolean JJK_NEWCODE = true;
    static final String NAMESPACE_DECL_NS = "http://www.w3.org/XML/1998/namespace";
    private transient Node m_pos;
    private int m_last_parent = 0;
    private int m_last_kid = -1;
    private transient Node m_root;
    boolean m_processedFirstElement = false;
    private transient boolean m_nodesAreProcessed;
    protected Vector m_nodes = new Vector();
    TreeWalker m_walker = new TreeWalker(null);

    public DOM2DTM(DTMManager mgr, DOMSource domSource, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, domSource, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
        this.m_pos = this.m_root = domSource.getNode();
        this.m_last_kid = -1;
        this.m_last_parent = -1;
        this.m_last_kid = this.addNode(this.m_root, this.m_last_parent, this.m_last_kid, -1);
        if (this.m_root.getNodeType() == 1) {
            int attrsize;
            NamedNodeMap attrs = this.m_root.getAttributes();
            int n = attrsize = attrs == null ? 0 : attrs.getLength();
            if (attrsize > 0) {
                int attrIndex = -1;
                int i = 0;
                while (i < attrsize) {
                    attrIndex = this.addNode(attrs.item(i), 0, attrIndex, -1);
                    this.m_firstch.setElementAt(-1, attrIndex);
                    ++i;
                }
                this.m_nextsib.setElementAt(-1, attrIndex);
            }
        }
        this.m_nodesAreProcessed = false;
    }

    protected int addNode(Node node, int parentIndex, int previousSibling, int forceNodeType) {
        String localName;
        String name;
        int nodeIndex = this.m_nodes.size();
        if (this.m_dtmIdent.size() == nodeIndex >>> 16) {
            try {
                if (this.m_mgr == null) {
                    throw new ClassCastException();
                }
                DTMManagerDefault mgrD = (DTMManagerDefault)this.m_mgr;
                int id = mgrD.getFirstFreeDTMID();
                mgrD.addDTM(this, id, nodeIndex);
                this.m_dtmIdent.addElement(id << 16);
            }
            catch (ClassCastException classCastException) {
                this.error(XSLMessages.createMessage(170, null));
            }
        }
        ++this.m_size;
        int type = forceNodeType == -1 ? (int)node.getNodeType() : forceNodeType;
        if (type == 2 && ((name = node.getNodeName()).startsWith("xmlns:") || name.equals("xmlns"))) {
            type = 13;
        }
        this.m_nodes.addElement(node);
        this.m_firstch.setElementAt(-2, nodeIndex);
        this.m_nextsib.setElementAt(-2, nodeIndex);
        this.m_prevsib.setElementAt(previousSibling, nodeIndex);
        this.m_parent.setElementAt(parentIndex, nodeIndex);
        if (parentIndex != -1 && type != 2 && type != 13 && this.m_firstch.elementAt(parentIndex) == -2) {
            this.m_firstch.setElementAt(nodeIndex, parentIndex);
        }
        String nsURI = node.getNamespaceURI();
        String string = localName = type == 7 ? node.getNodeName() : node.getLocalName();
        if ((type == 1 || type == 2) && localName == null) {
            localName = node.getNodeName();
        }
        ExpandedNameTable exnt = this.m_expandedNameTable;
        boolean bl = node.getLocalName() == null && (type == 1 || type == 2);
        int expandedNameID = localName != null ? exnt.getExpandedTypeID(nsURI, localName, type) : exnt.getExpandedTypeID(type);
        this.m_exptype.setElementAt(expandedNameID, nodeIndex);
        this.indexNode(expandedNameID, nodeIndex);
        if (previousSibling != -1) {
            this.m_nextsib.setElementAt(nodeIndex, previousSibling);
        }
        if (type == 13) {
            this.declareNamespaceInContext(parentIndex, nodeIndex);
        }
        return nodeIndex;
    }

    public void dispatchCharactersEvents(int nodeHandle, ContentHandler ch, boolean normalize) throws SAXException {
        if (normalize) {
            XMLString str = this.getStringValue(nodeHandle);
            str = str.fixWhiteSpace(true, true, false);
            str.dispatchCharactersEvents(ch);
        } else {
            short type = this.getNodeType(nodeHandle);
            Node node = this.getNode(nodeHandle);
            DOM2DTM.dispatchNodeData(node, ch, 0);
            if (type == 3 || type == 4) {
                while ((node = this.logicalNextDOMTextNode(node)) != null) {
                    DOM2DTM.dispatchNodeData(node, ch, 0);
                }
            }
        }
    }

    protected static void dispatchNodeData(Node node, ContentHandler ch, int depth) throws SAXException {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node child = node.getFirstChild();
                while (child != null) {
                    DOM2DTM.dispatchNodeData(child, ch, depth + 1);
                    child = child.getNextSibling();
                }
                break;
            }
            case 7: 
            case 8: {
                if (depth != 0) break;
            }
            case 2: 
            case 3: 
            case 4: {
                String str = node.getNodeValue();
                if (ch instanceof CharacterNodeHandler) {
                    ((CharacterNodeHandler)((Object)ch)).characters(node);
                    break;
                }
                ch.characters(str.toCharArray(), 0, str.length());
                break;
            }
        }
    }

    public void dispatchToEvents(int nodeHandle, ContentHandler ch) throws SAXException {
        TreeWalker treeWalker = this.m_walker;
        ContentHandler prevCH = treeWalker.getContentHandler();
        if (prevCH != null) {
            treeWalker = new TreeWalker(null);
        }
        treeWalker.setContentHandler(ch);
        try {
            Node node = this.getNode(nodeHandle);
            treeWalker.traverse(node);
        }
        finally {
            Object var6_6 = null;
            treeWalker.setContentHandler(null);
        }
    }

    public int getAttributeNode(int nodeHandle, String namespaceURI, String name) {
        short type;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if ((type = this.getNodeType(nodeHandle)) == 1) {
            int identity = this.makeNodeIdentity(nodeHandle);
            while ((identity = this.getNextNodeIdentity(identity)) != -1) {
                type = this._type(identity);
                if (type != 2 && type != 13) break;
                Node node = this.lookupNode(identity);
                String nodeuri = node.getNamespaceURI();
                if (nodeuri == null) {
                    nodeuri = "";
                }
                String nodelocalname = node.getLocalName();
                if (!nodeuri.equals(namespaceURI) || !name.equals(nodelocalname)) continue;
                return this.makeNodeHandle(identity);
            }
        }
        return -1;
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public DeclHandler getDeclHandler() {
        return null;
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        DocumentType dtd;
        Document doc = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (doc != null && (dtd = doc.getDoctype()) != null) {
            return dtd.getPublicId();
        }
        return null;
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        DocumentType dtd;
        Document doc = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (doc != null && (dtd = doc.getDoctype()) != null) {
            return dtd.getSystemId();
        }
        return null;
    }

    public int getElementById(String elementId) {
        Element elem;
        Document doc;
        Document document = doc = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (doc != null && (elem = doc.getElementById(elementId)) != null) {
            int elemHandle = this.getHandleFromNode(elem);
            if (elemHandle == -1) {
                int identity = this.m_nodes.size() - 1;
                while ((identity = this.getNextNodeIdentity(identity)) != -1) {
                    Node node = this.getNode(identity);
                    if (node != elem) continue;
                    elemHandle = this.getHandleFromNode(elem);
                    break;
                }
            }
            return elemHandle;
        }
        return -1;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    private int getHandleFromNode(Node node) {
        if (node != null) {
            int len = this.m_nodes.size();
            int i = 0;
            while (true) {
                if (i < len) {
                    if (this.m_nodes.elementAt(i) == node) {
                        return this.makeNodeHandle(i);
                    }
                    ++i;
                    continue;
                }
                boolean isMore = this.nextNode();
                len = this.m_nodes.size();
                if (!isMore && i >= len) break;
            }
        }
        return -1;
    }

    public int getHandleOfNode(Node node) {
        if (node != null && (this.m_root == node || this.m_root.getNodeType() == 9 && this.m_root == node.getOwnerDocument() || this.m_root.getNodeType() != 9 && this.m_root.getOwnerDocument() == node.getOwnerDocument())) {
            Node cursor = node;
            while (cursor != null) {
                if (cursor == this.m_root) {
                    return this.getHandleFromNode(node);
                }
                Node node2 = cursor = cursor.getNodeType() != 2 ? cursor.getParentNode() : ((Attr)cursor).getOwnerElement();
            }
        }
        return -1;
    }

    public LexicalHandler getLexicalHandler() {
        return null;
    }

    public String getLocalName(int nodeHandle) {
        int id = this.makeNodeIdentity(nodeHandle);
        if (id == -1) {
            return null;
        }
        Node newnode = (Node)this.m_nodes.elementAt(id);
        String newname = newnode.getLocalName();
        if (newname == null) {
            int index;
            String qname = newnode.getNodeName();
            newname = newnode.getNodeName().charAt(0) == '#' ? "" : ((index = qname.indexOf(58)) < 0 ? qname : qname.substring(index + 1));
        }
        return newname;
    }

    public String getNamespaceURI(int nodeHandle) {
        int id = this.makeNodeIdentity(nodeHandle);
        if (id == -1) {
            return null;
        }
        Node node = (Node)this.m_nodes.elementAt(id);
        return node.getNamespaceURI();
    }

    protected int getNextNodeIdentity(int identity) {
        if (++identity >= this.m_nodes.size() && !this.nextNode()) {
            identity = -1;
        }
        return identity;
    }

    public Node getNode(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        return (Node)this.m_nodes.elementAt(identity);
    }

    protected static void getNodeData(Node node, FastStringBuffer buf) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node child = node.getFirstChild();
                while (child != null) {
                    DOM2DTM.getNodeData(child, buf);
                    child = child.getNextSibling();
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                buf.append(node.getNodeValue());
                break;
            }
        }
    }

    public String getNodeName(int nodeHandle) {
        Node node = this.getNode(nodeHandle);
        return node.getNodeName();
    }

    public String getNodeNameX(int nodeHandle) {
        String name;
        short type = this.getNodeType(nodeHandle);
        switch (type) {
            case 13: {
                Node node = this.getNode(nodeHandle);
                name = node.getNodeName();
                if (name.startsWith("xmlns:")) {
                    name = QName.getLocalPart(name);
                    break;
                }
                if (!name.equals("xmlns")) break;
                name = "";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                Node node = this.getNode(nodeHandle);
                name = node.getNodeName();
                break;
            }
            default: {
                name = "";
            }
        }
        return name;
    }

    public String getNodeValue(int nodeHandle) {
        int type = this._exptype(this.makeNodeIdentity(nodeHandle));
        int n = type = type != -1 ? (int)ExpandedNameTable.getType(type) : -1;
        if (type != 3 && type != 4) {
            return this.getNode(nodeHandle).getNodeValue();
        }
        Node node = this.getNode(nodeHandle);
        Node n2 = this.logicalNextDOMTextNode(node);
        if (n2 == null) {
            return node.getNodeValue();
        }
        FastStringBuffer buf = StringBufferPool.get();
        buf.append(node.getNodeValue());
        while (n2 != null) {
            buf.append(n2.getNodeValue());
            n2 = this.logicalNextDOMTextNode(n2);
        }
        String s = buf.length() > 0 ? buf.toString() : "";
        StringBufferPool.free(buf);
        return s;
    }

    protected int getNumberOfNodes() {
        return this.m_nodes.size();
    }

    public String getPrefix(int nodeHandle) {
        String prefix;
        short type = this.getNodeType(nodeHandle);
        switch (type) {
            case 13: {
                Node node = this.getNode(nodeHandle);
                String qname = node.getNodeName();
                int index = qname.indexOf(58);
                prefix = index < 0 ? "" : qname.substring(index + 1);
                break;
            }
            case 1: 
            case 2: {
                Node node = this.getNode(nodeHandle);
                String qname = node.getNodeName();
                int index = qname.indexOf(58);
                prefix = index < 0 ? "" : qname.substring(0, index);
                break;
            }
            default: {
                prefix = "";
            }
        }
        return prefix;
    }

    public SourceLocator getSourceLocatorFor(int node) {
        return null;
    }

    public XMLString getStringValue(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        Node node = this.getNode(nodeHandle);
        if (type == 1 || type == 9 || type == 11) {
            String s;
            FastStringBuffer buf = StringBufferPool.get();
            try {
                DOM2DTM.getNodeData(node, buf);
                s = buf.length() > 0 ? buf.toString() : "";
            }
            finally {
                Object var7_8 = null;
                StringBufferPool.free(buf);
            }
            return this.m_xstrf.newstr(s);
        }
        if (type == 3 || type == 4) {
            FastStringBuffer buf = StringBufferPool.get();
            while (node != null) {
                buf.append(node.getNodeValue());
                node = this.logicalNextDOMTextNode(node);
            }
            String s = buf.length() > 0 ? buf.toString() : "";
            StringBufferPool.free(buf);
            return this.m_xstrf.newstr(s);
        }
        return this.m_xstrf.newstr(node.getNodeValue());
    }

    public String getUnparsedEntityURI(String name) {
        DocumentType doctype;
        Document doc;
        String url = "";
        Document document = doc = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (doc != null && (doctype = doc.getDoctype()) != null) {
            NamedNodeMap entities = doctype.getEntities();
            if (entities == null) {
                return url;
            }
            Entity entity = (Entity)entities.getNamedItem(name);
            if (entity == null) {
                return url;
            }
            String notationName = entity.getNotationName();
            if (notationName != null && (url = entity.getSystemId()) == null) {
                url = entity.getPublicId();
            }
        }
        return url;
    }

    public boolean isAttributeSpecified(int attributeHandle) {
        short type = this.getNodeType(attributeHandle);
        if (type == 2) {
            Attr attr = (Attr)this.getNode(attributeHandle);
            return attr.getSpecified();
        }
        return false;
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    private Node logicalNextDOMTextNode(Node n) {
        short ntype;
        Node p = n.getNextSibling();
        if (p == null) {
            n = n.getParentNode();
            while (n != null && n.getNodeType() == 5) {
                p = n.getNextSibling();
                if (p != null) break;
                n = n.getParentNode();
            }
        }
        n = p;
        while (n != null && n.getNodeType() == 5) {
            n = n.hasChildNodes() ? n.getFirstChild() : n.getNextSibling();
        }
        if (n != null && (ntype = n.getNodeType()) != 3 && ntype != 4) {
            n = null;
        }
        return n;
    }

    protected Node lookupNode(int nodeIdentity) {
        return (Node)this.m_nodes.elementAt(nodeIdentity);
    }

    public boolean needsTwoThreads() {
        return false;
    }

    protected boolean nextNode() {
        if (this.m_nodesAreProcessed) {
            return false;
        }
        Node pos = this.m_pos;
        Node next = null;
        int nexttype = -1;
        do {
            if (pos.hasChildNodes()) {
                next = pos.getFirstChild();
                if (next != null && next.getNodeType() == 10) {
                    next = next.getNextSibling();
                }
                if (pos.getNodeType() != 5) {
                    this.m_last_parent = this.m_last_kid;
                    this.m_last_kid = -1;
                    if (this.m_wsfilter != null) {
                        short wsv = this.m_wsfilter.getShouldStripSpace(this.makeNodeHandle(this.m_last_parent), this);
                        boolean shouldStrip = wsv == 3 ? this.getShouldStripWhitespace() : wsv == 2;
                        this.pushShouldStripWhitespace(shouldStrip);
                    }
                }
            } else {
                if (this.m_last_kid != -1 && this.m_firstch.elementAt(this.m_last_kid) == -2) {
                    this.m_firstch.setElementAt(-1, this.m_last_kid);
                }
                while (this.m_last_parent != -1) {
                    next = pos.getNextSibling();
                    if (next != null && next.getNodeType() == 10) {
                        next = next.getNextSibling();
                    }
                    if (next != null) break;
                    if ((pos = pos.getParentNode()) != null && pos.getNodeType() == 5) continue;
                    this.popShouldStripWhitespace();
                    if (this.m_last_kid == -1) {
                        this.m_firstch.setElementAt(-1, this.m_last_parent);
                    } else {
                        this.m_nextsib.setElementAt(-1, this.m_last_kid);
                    }
                    this.m_last_kid = this.m_last_parent;
                    this.m_last_parent = this.m_parent.elementAt(this.m_last_kid);
                }
                if (this.m_last_parent == -1) {
                    next = null;
                }
            }
            if (next != null) {
                nexttype = next.getNodeType();
            }
            if (nexttype != 5) continue;
            pos = next;
        } while (nexttype == 5);
        if (next == null) {
            this.m_nextsib.setElementAt(-1, 0);
            this.m_nodesAreProcessed = true;
            this.m_pos = null;
            return false;
        }
        boolean suppressNode = false;
        Node lastTextNode = null;
        nexttype = next.getNodeType();
        if (nexttype == 3 || nexttype == 4) {
            suppressNode = this.m_wsfilter != null && this.getShouldStripWhitespace();
            Node n = next;
            while (n != null) {
                lastTextNode = n;
                if (n.getNodeType() == 3) {
                    nexttype = 3;
                }
                suppressNode &= XMLCharacterRecognizer.isWhiteSpace(n.getNodeValue());
                n = this.logicalNextDOMTextNode(n);
            }
        } else if (nexttype == 7) {
            suppressNode = pos.getNodeName().toLowerCase().equals("xml");
        }
        if (!suppressNode) {
            int nextindex;
            this.m_last_kid = nextindex = this.addNode(next, this.m_last_parent, this.m_last_kid, nexttype);
            if (nexttype == 1) {
                int attrsize;
                int attrIndex = -1;
                NamedNodeMap attrs = next.getAttributes();
                int n = attrsize = attrs == null ? 0 : attrs.getLength();
                if (attrsize > 0) {
                    int i = 0;
                    while (i < attrsize) {
                        attrIndex = this.addNode(attrs.item(i), nextindex, attrIndex, -1);
                        this.m_firstch.setElementAt(-1, attrIndex);
                        if (!this.m_processedFirstElement && "xmlns:xml".equals(attrs.item(i).getNodeName())) {
                            this.m_processedFirstElement = true;
                        }
                        ++i;
                    }
                }
                if (!this.m_processedFirstElement) {
                    attrIndex = this.addNode(new DOM2DTMdefaultNamespaceDeclarationNode((Element)next, "xml", NAMESPACE_DECL_NS, this.makeNodeHandle((attrIndex == -1 ? nextindex : attrIndex) + 1)), nextindex, attrIndex, -1);
                    this.m_firstch.setElementAt(-1, attrIndex);
                    this.m_processedFirstElement = true;
                }
                if (attrIndex != -1) {
                    this.m_nextsib.setElementAt(-1, attrIndex);
                }
            }
        }
        if (nexttype == 3 || nexttype == 4) {
            next = lastTextNode;
        }
        this.m_pos = next;
        return true;
    }

    public void setIncrementalSAXSource(IncrementalSAXSource source) {
    }

    public void setProperty(String property, Object value) {
    }

    public static interface CharacterNodeHandler {
        public void characters(Node var1) throws SAXException;
    }
}

