/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import org.apache.xml.utils.StringToStringTable;

public class StringToStringTableVector {
    private int m_blocksize;
    private StringToStringTable[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToStringTableVector() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new StringToStringTable[this.m_blocksize];
    }

    public StringToStringTableVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new StringToStringTable[blocksize];
    }

    public final void addElement(StringToStringTable value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            StringToStringTable[] newMap = new StringToStringTable[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final boolean contains(StringToStringTable s) {
        int i = 0;
        while (i < this.m_firstFree) {
            if (this.m_map[i].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean containsKey(String key) {
        int i = this.m_firstFree - 1;
        while (i >= 0) {
            if (this.m_map[i].get(key) != null) {
                return true;
            }
            --i;
        }
        return false;
    }

    public final StringToStringTable elementAt(int i) {
        return this.m_map[i];
    }

    public final String get(String key) {
        int i = this.m_firstFree - 1;
        while (i >= 0) {
            String nsuri = this.m_map[i].get(key);
            if (nsuri != null) {
                return nsuri;
            }
            --i;
        }
        return null;
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final void removeLastElem() {
        if (this.m_firstFree > 0) {
            this.m_map[this.m_firstFree] = null;
            --this.m_firstFree;
        }
    }

    public final int size() {
        return this.m_firstFree;
    }
}

