//=====================================================================================================
//
//=====================================================================================================

//=====================================================================================================
#ifndef __FLASHWINDOWCONTROL_INCLUDED_9C53B31_2B63_4f94_8DF9_FCC1F620494__
    #define __FLASHWINDOWCONTROL_INCLUDED_9C53B31_2B63_4f94_8DF9_FCC1F620494__
//=====================================================================================================

//=====================================================================================================
// Includes

#include <oleauto.h>
#include <pshpack4.h>

//=====================================================================================================
#ifdef __cplusplus
extern "C" {
#endif
//=====================================================================================================

//=====================================================================================================
// Flash control class name

#define WC_FLASHA                               "FlashPlayerControl"
#define WC_FLASHW                               L"FlashPlayerControl"

#ifdef UNICODE
    #define WC_FLASH                                WC_FLASHW
#else
    #define WC_FLASH                                WC_FLASHA
#endif // UNICODE

//=====================================================================================================
// Flash Control messages

#define FPCM_FIRST           (WM_USER + 0x1000)      // Flash Control messages

typedef struct SFPCQueryInterface
{
    // [in]
    // Identifier of the requested interface
    IID iid;
    // [in]
    // Receives the interface pointer requested in iid
    void* pvObject;
    // [out]
    HRESULT hr;

} SFPCQueryInterface;

#define FPCM_QUERYINTERFACE                     (FPCM_FIRST + 1)

typedef struct SFPCPutMovieFromMemory
{
    // [in]
    LPVOID lpData;
    // [in]
    DWORD dwSize;

} SFPCPutMovieFromMemory;

#define FPCM_PUTMOVIEFROMMEMORY                 (FPCM_FIRST + 2)

typedef struct SFPCLoadMovieFromMemory
{
	// [in] layer
	int layer;

    // [in]
    LPVOID lpData;
    // [in]
    DWORD dwSize;

} SFPCLoadMovieFromMemory;

#define FPCM_LOADMOVIEFROMMEMORY                (FPCM_FIRST + 3)

//================================================================================
//

#define FPCM_GET_FRAME_BITMAP                (FPCM_FIRST + 4)

typedef struct SFPCGetFrameBitmap
{
    // [out]
    HBITMAP hBitmap;

} SFPCGetFrameBitmap;

//================================================================================

//================================================================================

typedef struct SFPCPutStandartMenu
{
	// [in]
	VARIANT_BOOL StandartMenu;

} SFPCPutStandartMenu;

#define FPCM_PUT_STANDART_MENU		(FPCM_FIRST + 5)

typedef struct SFPCGetStandartMenu
{
	// [out]
	VARIANT_BOOL StandartMenu;

} SFPCGetStandartMenu;

#define FPCM_GET_STANDART_MENU		(FPCM_FIRST + 6)

//================================================================================

#include "messages.inl"

//=====================================================================================================
// Flash Control notifications

#define FPCN_FIRST                              (FPCM_FIRST - 1)

//=====================================================================================================
// 

struct SFPCLoadExternalResourceA
{    
    NMHDR hdr;
    
    // [in] RelativePath
    LPCSTR lpszRelativePath;
    // [in]
    LPSTREAM lpStream;
};

struct SFPCLoadExternalResourceW
{    
    NMHDR hdr;
    
    // [in] RelativePath
    LPCWSTR lpszRelativePath;
    // [in]
    LPSTREAM lpStream;
};

#ifdef UNICODE
    #define SFPCLoadExternalResource                            SFPCLoadExternalResourceW
#else
    #define SFPCLoadExternalResource                            SFPCLoadExternalResourceA
#endif // UNICODE

#define FPCN_LOADEXTERNALRESOURCEA              (FPCN_FIRST - 2)
#define FPCN_LOADEXTERNALRESOURCEW              (FPCN_FIRST - 3)

#ifdef UNICODE
    #define FPCN_LOADEXTERNALRESOURCE                           FPCN_LOADEXTERNALRESOURCEW
#else
    #define FPCN_LOADEXTERNALRESOURCE                           FPCN_LOADEXTERNALRESOURCEA
#endif // UNICODE

//=====================================================================================================

#include "notification_messages.inl"

#include "functions_decl.inl"

//=====================================================================================================
// Functions

// FlashPlayerControl Window Class registration: using a registered flash
BOOL WINAPI RegisterFlashWindowClass();
// FlashPlayerControl Window Class registration: using a provided swflash.ocx/flash.ocx
BOOL WINAPI RegisterFlashWindowClassEx(LPVOID lpFlashOCXCodeData, DWORD dwSizeOfFlashOCXCode);

// FlashPlayerControl Window Class unregistration
void WINAPI UnregisterFlashWindowClass();

// Get installed flash version
DWORD WINAPI GetInstalledFlashVersion();
// Get using flash version
DWORD WINAPI GetUsingFlashVersion();

// Turn on/off flash sounds
void WINAPI FPCSetAudioEnabled(BOOL bEnable);
BOOL WINAPI FPCGetAudioEnabled();

//
BOOL WINAPI FPCIsTransparentAvailable();

//
BOOL WINAPI FPCIsFlashInstalled();

//
typedef HRESULT (WINAPI *PLOADEXTERNALRESOURCEHANDLER)(LPCSTR lpszURL, IStream** ppStream);
void WINAPI FPCSetGlobalOnLoadExternalResourceHandler(PLOADEXTERNALRESOURCEHANDLER pHandler);

//
BOOL WINAPI FPCLoadMovieFromMemory(HWND hwndFlashPlayerControl, int layer, LPVOID lpData, DWORD dwSize);
BOOL WINAPI FPCPutMovieFromMemory(HWND hwndFlashPlayerControl, LPVOID lpData, DWORD dwSize);


BOOL WINAPI FPCLoadMovieFromResourceA(HWND hwndFlashPlayerControl, int layer, HINSTANCE hInstance, LPCSTR lpName, LPCSTR lpType);
BOOL WINAPI FPCLoadMovieFromResourceW(HWND hwndFlashPlayerControl, int layer, HINSTANCE hInstance, LPCWSTR lpName, LPCWSTR lpType);

#ifdef UNICODE
    #define FPCLoadMovieFromResource FPCLoadMovieFromResourceW
#else
    #define FPCLoadMovieFromResource FPCLoadMovieFromResourceA
#endif // UNICODE


BOOL WINAPI FPCPutMovieFromResourceA(HWND hwndFlashPlayerControl, HINSTANCE hInstance, LPCSTR lpName, LPCSTR lpType);
BOOL WINAPI FPCPutMovieFromResourceW(HWND hwndFlashPlayerControl, HINSTANCE hInstance, LPCWSTR lpName, LPCWSTR lpType);

#ifdef UNICODE
    #define FPCPutMovieFromResource FPCPutMovieFromResourceW
#else
    #define FPCPutMovieFromResource FPCPutMovieFromResourceA
#endif // UNICODE


// Set events listener
typedef void (WINAPI *PFLASHPLAYERCONTROLEVENTLISTENER)(HWND hwndFlashPlayerControl, LPARAM lParam, NMHDR* pNMHDR);
BOOL WINAPI FPCSetEventListener(HWND hwndFlashPlayerControl, PFLASHPLAYERCONTROLEVENTLISTENER pListener, LPARAM lParam);

// Internals
// Don't use

//
HMODULE WINAPI FPC_Internal_GetFlashOCXHandle();

//=====================================================================================================
#ifdef __cplusplus
}
#endif
//=====================================================================================================

//=====================================================================================================
// Includes

#include <poppack.h>

//=====================================================================================================
#endif // !__FLASHWINDOWCONTROL_INCLUDED_9C53B31_2B63_4f94_8DF9_FCC1F620494__
//=====================================================================================================
