// Sample1_SWF_And_FLV_PlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample1_SWF_And_FLV_Player.h"
#include "Sample1_SWF_And_FLV_PlayerDlg.h"
#include ".\sample1_swf_and_flv_playerdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CSample1_SWF_And_FLV_PlayerDlg dialog

static CString g_strFLVPath;
static HRESULT WINAPI GlobalOnLoadExternalResourceHandler(LPCSTR lpszURL, IStream** ppStream);

CSample1_SWF_And_FLV_PlayerDlg::CSample1_SWF_And_FLV_PlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSample1_SWF_And_FLV_PlayerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSample1_SWF_And_FLV_PlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CSample1_SWF_And_FLV_PlayerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_CHECK_STANDARD_MENU, OnBnClickedCheckStandardMenu)
	ON_BN_CLICKED(IDC_CHECK_SOUNDS, OnBnClickedCheckSounds)
	ON_BN_CLICKED(ID_PLAY_SWF_FROM_FILE, OnBnClickedPlaySWFFromFile)
	ON_BN_CLICKED(ID_PLAY_FLV_FROM_FILE, OnBnClickedPlayFLVFromFile)
	ON_BN_CLICKED(ID_SITE, OnBnClickedSite)
	ON_BN_CLICKED(ID_ORDER, OnBnClickedOrder)
END_MESSAGE_MAP()


// CSample1_SWF_And_FLV_PlayerDlg message handlers

BOOL CSample1_SWF_And_FLV_PlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// FlashPlayerControl creating
	// NOTE: CALL RegisterFlashWindowClass() or RegisterFlashWindowClassEx() before creating!
	// See InitInstance() implementation
	{
		RECT rc;
		GetDlgItem(IDC_STATIC_FPC_PLACE)->GetWindowRect(&rc);
		ScreenToClient(&rc);

		m_hwndFlashPlayerControl = 
			CreateWindow(WC_FLASH, 
						 NULL, 
						 WS_CHILD | WS_VISIBLE, 
						 rc.left, 
						 rc.top, 
						 rc.right - rc.left, 
						 rc.bottom - rc.top, 
						 m_hWnd, 
						 NULL, 
						 NULL, 
						 NULL);
	}

	// Loading movie from file
	{
		TCHAR lpszMoviePath[_MAX_PATH + 1] = { 0 };
		GetModuleFileName(NULL, lpszMoviePath, _MAX_PATH);
		
		for (int nIndex = lstrlen(lpszMoviePath) - 1; nIndex >= 0; nIndex--)
			if (_T('\\') == lpszMoviePath[nIndex])
			{
				lpszMoviePath[nIndex] = 0;
				break;
			}
		lstrcat(lpszMoviePath, _T("\\movie.swf"));

		SFPCPutMovie FPCPutMovie;
		FPCPutMovie.lpszBuffer = lpszMoviePath;
		::SendMessage(m_hwndFlashPlayerControl, FPCM_PUT_MOVIE, 0, (LPARAM)&FPCPutMovie);
	}

	CheckDlgButton(IDC_CHECK_SOUNDS, BST_CHECKED);

	FPCSetGlobalOnLoadExternalResourceHandler(&GlobalOnLoadExternalResourceHandler);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSample1_SWF_And_FLV_PlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSample1_SWF_And_FLV_PlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSample1_SWF_And_FLV_PlayerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedCheckStandardMenu()
{
	SFPCPutStandartMenu FPCPutStandartMenu;
	FPCPutStandartMenu.StandartMenu = IsDlgButtonChecked(IDC_CHECK_STANDARD_MENU);
	::SendMessage(m_hwndFlashPlayerControl, FPCM_PUT_STANDART_MENU, 0, (LPARAM)&FPCPutStandartMenu);
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedCheckSounds()
{
	if (IsDlgButtonChecked(IDC_CHECK_SOUNDS))
		FPCSetAudioEnabled(TRUE);
	else
		FPCSetAudioEnabled(FALSE);
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedPlaySWFFromFile()
{
    CFileDialog dlg(TRUE, 
                    _T("swf"), 
                    _T(""), 
                    0, 
                    _T("Flash movie files (*.swf)|*.swf|All Files (*.*)|*.*||"), 
                    this, 
                    0);

    if (IDOK == dlg.DoModal())
    {
        //
        CString strFlashMoviePath = dlg.GetPathName();

        //
        TCHAR lpszFlashMoviePath[MAX_PATH + 1] = { 0 };
        lstrcpy(lpszFlashMoviePath, strFlashMoviePath);

        //
        SFPCPutMovie SFPCPutMovie;
        SFPCPutMovie.lpszBuffer = lpszFlashMoviePath;
        ::SendMessage(m_hwndFlashPlayerControl, FPCM_PUT_MOVIE, 0, (LPARAM)&SFPCPutMovie);
    }
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedPlayFLVFromFile()
{
    CFileDialog dlg(TRUE, 
                    _T("flv"), 
                    _T(""), 
                    0, 
                    _T("Flash video files (*.flv)|*.flv|All Files (*.*)|*.*||"), 
                    this, 
                    0);

    if (IDOK == dlg.DoModal())
	{
        //
        g_strFLVPath = dlg.GetPathName();

        //
		FPCPutMovieFromResource(m_hwndFlashPlayerControl, 0, _T("FLVPlayer"), _T("SWF"));
    }
}

HRESULT WINAPI GlobalOnLoadExternalResourceHandler(LPCSTR lpszURL, IStream** ppStream)
{
	HRESULT hr = E_FAIL;

	if (0 == lstrcmpiA(lpszURL, "http://FLV/FlashVideo.flv"))
	{
		IStream* pMemStream = NULL;
		CreateStreamOnHGlobal(NULL, TRUE, &pMemStream);
		
		HANDLE hFile = CreateFile(g_strFLVPath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);

		if (INVALID_HANDLE_VALUE != hFile)
		{
			const DWORD nBufferSize = 1024 * 1024;
			BYTE* pBuffer = new BYTE[nBufferSize];
			DWORD dwNumberOfBytesRead;
			ULONG nWritten;

			while (true)
			{
				BOOL bRes = ReadFile(hFile, pBuffer, nBufferSize, &dwNumberOfBytesRead, NULL);

				if (!bRes || 0 == dwNumberOfBytesRead)
					break;

				pMemStream->Write(pBuffer, dwNumberOfBytesRead, &nWritten);
			}

			delete[] pBuffer;

			CloseHandle(hFile);

			LARGE_INTEGER liZero = { 0 };
			ULARGE_INTEGER ulNewPosition;
			pMemStream->Seek(liZero, STREAM_SEEK_SET, &ulNewPosition);

			*ppStream = pMemStream;
			hr = S_OK;
		}
	}

	return hr;
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedSite()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/"), NULL, NULL, SW_SHOW);
}

void CSample1_SWF_And_FLV_PlayerDlg::OnBnClickedOrder()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/order.html"), NULL, NULL, SW_SHOW);
}
