VERSION 5.00
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmOLEDnD2iG 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "OLE Drag-n-drop: Dragging Files into iGrid"
   ClientHeight    =   4020
   ClientLeft      =   945
   ClientTop       =   3435
   ClientWidth     =   6945
   Icon            =   "OLEDnD2iG.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4020
   ScaleWidth      =   6945
   Begin iGrid250_75B4A91C.iGrid grd 
      Height          =   2715
      Left            =   120
      TabIndex        =   0
      Top             =   1200
      Width           =   6735
      _ExtentX        =   11880
      _ExtentY        =   4789
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   $"OLEDnD2iG.frx":0442
      Height          =   435
      Index           =   1
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   6675
   End
   Begin VB.Label Label1 
      Caption         =   "This is a simple dialog that can be used to copy several files from different folders to another folder at once."
      Height          =   435
      Index           =   0
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   6675
   End
End
Attribute VB_Name = "frmOLEDnD2iG"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim m_bIAmTheSource As Boolean

Private Sub Form_Load()
   With grd
      .Redraw = False
      
      .OLEDropMode = vbOLEDropManual
      .Editable = False
      
      .AddCol sKey:="filename", sHeader:="Filename"
      
      .Redraw = True
   End With
   
   frmOLEDnD2Xl.Show
End Sub

Private Sub grd_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
   Dim vFN
   
   If Data.GetFormat(vbCFFiles) Then
      grd.Redraw = False
      
      For Each vFN In Data.Files
         grd.AddRow
         grd.CellValue(grd.RowCount, "filename") = vFN
      Next vFN
      
      grd.AutoWidthCol "filename"
      
      grd.Redraw = True
   End If
End Sub

Private Sub grd_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single, State As Integer)
   If Data.GetFormat(vbCFFiles) And Not m_bIAmTheSource Then
      'If the data is in the proper format, _
       inform the source of the action to be taken
      Effect = vbDropEffectCopy And Effect
   Else
      'If the data is not desired format, no drop
      Effect = vbDropEffectNone
   End If
End Sub

Private Sub grd_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal y As Single, ByVal lRow As Long, ByVal lCol As Long)
   ' Initiate an OLE drag operation only
   ' if the left button is pressed and
   ' the mouse pointer is over a cell
   If Button = vbLeftButton And lRow > 0 And lCol > 0 Then
      If grd.RowCount > 0 Then
         m_bIAmTheSource = True
         grd.OLEDrag
      End If
   End If
End Sub

Private Sub grd_OLEStartDrag(Data As DataObject, AllowedEffects As Long)
   Dim i As Long

   Data.SetData , vbCFFiles
   
   For i = 1 To grd.RowCount
      Data.Files.Add grd.CellValue(i, "filename")
   Next
   
   AllowedEffects = vbDropEffectCopy
End Sub

Private Sub grd_OLECompleteDrag(Effect As Long)
   ' ignoring dropping in the same grid
   If Effect <> vbDropEffectNone Then
      grd.Clear bRemoveCols:=False
      m_bIAmTheSource = False
   End If
End Sub
