Attribute VB_Name = "modErrorHandler"
Option Explicit

Public Sub ErrorHandler(sDescription As String, lNumber As Long, _
                        sSource As String, sProcedure As String, _
                        Optional bTerminate As Boolean)

    'We don't want our error handler erroring
    On Error Resume Next

    'To build the complete error string
    Dim sErrorMessage As String

    'Holds the machine name
    Dim sMachineName As String

    'We need a remote object to get the path to the error log
    Dim oRemote As clsRemote
    Set oRemote = New clsRemote

    '"built-in" method for getting computer name
    sMachineName = Environ$("COMPUTERNAME")
    
    'Holds remote error file path
    Dim sRemoteFile As String

    'Next free file number
    Dim lFreeFile As Long

    'Clear the error object
    Err.Clear

    'Force a close of all open files
    Reset

    'Get next free file number
    lFreeFile = FreeFile

    'Build the error log entry
    sErrorMessage = Now & ", "
    sErrorMessage = sErrorMessage & sMachineName & ", "
    sErrorMessage = sErrorMessage & sDescription & ", "
    sErrorMessage = sErrorMessage & lNumber & ", "
    sErrorMessage = sErrorMessage & sSource & ", "
    sErrorMessage = sErrorMessage & sProcedure & ", "

    'Termination message
    Select Case bTerminate
        Case Is = True
            sErrorMessage = sErrorMessage & "Application Terminated"
        
        Case Is = False
            sErrorMessage = sErrorMessage & "Application Continued"
    End Select
    
    'Get the remote log file path
    sRemoteFile = oRemote.GetRemoteErrorPath
    
    'If nothing comes back we can't save the file
    If sRemoteFile <> "" Then
        'Open the log file for append and write the error message
        Open sRemoteFile For Append As lFreeFile
        Print #lFreeFile, sErrorMessage
        Close lFreeFile
    End If
    
    'Clean up before we (might) terminate (below)
    Set oRemote = Nothing
    
    'Terminate the program if we were told to do so
    If bTerminate = True Then
        Dim fUnload As Form
        
        'Unload all forms
        For Each fUnload In Forms
            Unload fUnload
            Set fUnload = Nothing
        Next
        
        End
    End If
End Sub
